package com.ejie.aa83b.control;


import java.io.IOException;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83bNoraService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.x38.json.MessageWriter;
import com.ejie.aa83b.webservice.client.x97.Exception_Exception;
import com.ejie.aa83b.webservice.client.x97.X97DistributionWebServiceImpl;


/**
 * Aa83b34t00Controller generated by UDA, 15-dic-2015 10:40:01.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/aa83b34t00")
public class Aa83b34t00Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b34t00Controller.class);

	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	@Autowired()
	private Aa83b35t00Service aa83b35t00Service;
	@Autowired()
	private Aa83bNoraService aa83bNoraService;
	
	private Integer totalGrid;
	@Autowired()
	private X97DistributionWebServiceImpl x97DistributionWebServiceImpl;
	
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param codsolic034
	 *            Long
	 * @return Aa83b34t00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{codsolic034}", method = RequestMethod.GET)
	public @ResponseBody()
	Aa83b34t00 get(@PathVariable() Long codsolic034) {
		Aa83b34t00 aa83b34t00 = new Aa83b34t00();
		aa83b34t00.setCodsolic034(codsolic034);
		aa83b34t00 = this.aa83b34t00Service.find(aa83b34t00);
		Aa83b34t00Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa83b34t00 por PK");
		return aa83b34t00;
	}

	
	/**
	 * @param model Model
	 * @param idSol String
	 * @param response HttpServletResponse
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/rechazarSolicitud", method = RequestMethod.GET)
	public ModelAndView rechazarSolicitud(Model model,
			@RequestParam(value = "id", required = false) String idSol,
			HttpServletResponse response) {
		Aa83b34t00 solicitud = new Aa83b34t00();
		solicitud.setCodsolic034(new Long(idSol));
		solicitud.setSituacion034("R");
		//llamada al webservice para devolverlo
		solicitud=this.aa83b34t00Service.find(solicitud);
		String sesionToken = Aa83bUtilSeguridad.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
		StringBuffer info=new StringBuffer(Aa83BConstants.SETETENTAYSIETE);
		info.append("<distribution><registryNumber>");
		info.append(solicitud.getNumreg034());
		info.append("</registryNumber><cause>");
		info.append(Aa83bUtilProperties.getProperty("solicitudRechazada"));
		info.append("</cause>");
//		info.append("<assignOffice>");
//		info.append(solicitud.getNumdel034());
//		info.append("</assignOffice>" +
		info.append("</distribution>");

		try {
			String respuesta=this.x97DistributionWebServiceImpl.rejectDistribution(sesionToken, info.toString());
			Aa83b34t00Controller.logger.info("[PUT] : respuesta ==>"+respuesta);
		} catch (Exception_Exception e) {
			Aa83b34t00Controller.logger.info("[PUT] : rechazar solicitud==>"+e.toString());
		}
		return new ModelAndView("aa83b34t00", "Aa83b34t00", solicitud);
	}

	/**
	 * @param model Model
	 * @param idSol String
	 * @param response HttpServletResponse
	 * @return ModelAndView
	 * @throws IOException e
	 */
	@RequestMapping(value = "/verSolicitud", method = RequestMethod.GET)
	public ModelAndView verSolicitud(Model model,
			@RequestParam(value = "id", required = false) String idSol,
			HttpServletResponse response) throws IOException {
		Aa83b34t00 solicitud = new Aa83b34t00();
		solicitud.setCodsolic034(Long.parseLong(idSol));
		solicitud = this.aa83b34t00Service.find(solicitud);
		
		Aa83b35t00 documento = new Aa83b35t00();
		documento.setAa83b34t00(solicitud);
		
		List<Aa83b35t00> listaDocs = this.aa83b35t00Service.findAll(documento, null);
		
		// Sacamos el Literal de Tipo de Solicitud
		if (solicitud.getTipsub034().equals(Aa83BConstants.COD_ADE)) {
			solicitud.setTipo034Acro(Aa83BConstants.COD_ADE_STR);
		}

		if (solicitud.getTipsub034().equals(Aa83BConstants.COD_ESF)) {
			solicitud.setTipo034Acro(Aa83BConstants.COD_ESF_STR);
		}

		if (solicitud.getTipsub034().equals(Aa83BConstants.COD_ARR)) {
			solicitud.setTipo034Acro(Aa83BConstants.COD_ARR_STR);
		}

	
		solicitud.setAa83b35t00s(listaDocs);
		return new ModelAndView("verSolicitud", "Aa83b34t00", solicitud);

	}


	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b34t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody ()
	List<Aa83b34t00> getAll(@ModelAttribute() Aa83b34t00 filterAa83b34t00) {
		Aa83b34t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b34t00 por filtro");
		return this.aa83b34t00Service.findAll(filterAa83b34t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00 Bean que contiene la informacion a modificar.
	 * @return Aa83b34t00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Aa83b34t00 edit(@RequestBody() Aa83b34t00 aa83b34t00) {
		Aa83b34t00 aa83b34t00Aux = this.aa83b34t00Service.update(aa83b34t00);
		Aa83b34t00Controller.logger
				.info("[PUT] : Aa83b34t00 actualizado correctamente");
		return aa83b34t00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa83b34t00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Aa83b34t00 add(@RequestBody() Aa83b34t00 aa83b34t00) {
		Aa83b34t00 aa83b34t00Aux = this.aa83b34t00Service.add(aa83b34t00);
		Aa83b34t00Controller.logger
				.info("[POST] : Aa83b34t00 insertado correctamente");
		return aa83b34t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param codsolic034
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Aa83b34t00 Bean eliminado.
	 */
	@RequestMapping(value = "/{codsolic034}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Aa83b34t00 remove(@PathVariable() Long codsolic034) {
		Aa83b34t00 aa83b34t00 = new Aa83b34t00();
		aa83b34t00.setCodsolic034(codsolic034);
		this.aa83b34t00Service.remove(aa83b34t00);
		Aa83b34t00Controller.logger
				.info("[DELETE] : Aa83b34t00 borrado correctamente");
		return aa83b34t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b34t00Controller.logger.info("[GET - View] : aa83b34t00");
		return "aa83b34t00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b34t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<Aa83b34t00> filter(
			@RequestJsonBody(param = "filter") Aa83b34t00 filterAa83b34t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		List<Aa83b34t00> responseGridPaginado = new ArrayList<Aa83b34t00>();
		List<Aa83b34t00> aa83b34t00List = new ArrayList<Aa83b34t00>();
		Aa83b34t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b34t00s");
		aa83b34t00List=this.aa83b34t00Service.findAllLike(filterAa83b34t00,
				null, false);
		int i;
		A83bProvincia a83bProvincia = new A83bProvincia();
		
		for (i=0;i<aa83b34t00List.size();i++)
		{
			Aa83b34t00 aa83b34t00=aa83b34t00List.get(i);
			a83bProvincia.setId(aa83b34t00.getCoddel034());
			// System.out.println("busco 6:: " + a83bProvincia.toString());
			a83bProvincia = this.aa83bNoraService.findProvinciasId(a83bProvincia);
			aa83b34t00.setDeleg034Es(a83bProvincia.getDs_o());
			aa83b34t00.setDeleg034Eu(a83bProvincia.getDs_o());
				
		}
		// Paginamos:
		this.totalGrid = aa83b34t00List.size();
		int total = this.totalGrid;
		if (jqGridRequestDto.getPage() != 1) {
			// Paginamos
			int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto
					.getRows());

			for (int pag = p; (pag < aa83b34t00List.size()); pag++) {
				responseGridPaginado.add(aa83b34t00List.get(pag));
			}

			// Miro si es la ultima página:
			if ((aa83b34t00List.size() - (jqGridRequestDto.getPage() * jqGridRequestDto
					.getRows())) <= 0) {

			} else {
				if (jqGridRequestDto.getPage() != 1) {
					for (int pant = 0; pant < p; pant++) {
						responseGridPaginado.add(aa83b34t00List.get(pant));
					}
				}
			}

		} else {
			responseGridPaginado = aa83b34t00List;
		}
		
		
		return new JQGridResponseDto<Aa83b34t00>(jqGridRequestDto,
				(long) (total), responseGridPaginado);
		
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa83b34t00
	 *            Aa83b34t00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b34t00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody()
	List<TableRowDto<Aa83b34t00>> search(
			@RequestJsonBody(param = "filter") Aa83b34t00 filterAa83b34t00,
			@RequestJsonBody(param = "search") Aa83b34t00 searchAa83b34t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Aa83b34t00Controller.logger
				.info("[POST - search] : Buscar Aa83b34t00s");
		return this.aa83b34t00Service.search(filterAa83b34t00,
				searchAa83b34t00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa83b34t00 filterAa83b34t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Aa83b34t00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b34t00s");
		this.aa83b34t00Service.removeMultiple(filterAa83b34t00,
				jqGridRequestDto, false);
		Aa83b34t00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b34t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<JerarquiaDto<Aa83b34t00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa83b34t00 filterAa83b34t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Aa83b34t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b34t00s jerarquia");
		return this.aa83b34t00Service.jerarquia(filterAa83b34t00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b34t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<JerarquiaDto<Aa83b34t00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa83b34t00 filterAa83b34t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Aa83b34t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b34t00s jerarquia - Hijos");
		return this.aa83b34t00Service.jerarquiaChildren(filterAa83b34t00,
				jqGridRequestDto);
	}

}
