package com.ejie.aa83b.control;


import com.ejie.aa83b.service.Aa83b06t00Service;
import com.ejie.aa83b.service.Aa83b09t00Service;
import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b31t00Service;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83bDokusiService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContextParser;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;
import com.ejie.aa83b.model.Aa83bDocumentoDokusi;

/**
 * Aa83b21t00Controller generated by UDA, 15-dic-2015 10:40:01.
 * @author UDA
 */
 
@Controller()
@RequestMapping (value = "/aa83b21t00")

public class Aa83b21t00Controller  {

	private static final Logger logger = LoggerFactory.getLogger(Aa83b21t00Controller.class);

	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;
	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	@Autowired()
	private Aa83b35t00Service aa83b35t00Service;
	@Autowired()
	private Aa83b06t00Service aa83b06t00Service;
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;
	@Autowired()
	private Aa83b31t00Service aa83b31t00Service;
	@Autowired()
	private Aa83bDokusiService aa83bDokusiService;
	@Autowired()
	private Properties appConfiguration;
	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */
	
	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
	 * 
	 * @param idAno021 Long
	 * @param id021 Integer
	 * @return Aa83b21t00 
	 *            Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idAno021}/{id021}", method = RequestMethod.GET)
	public @ResponseBody() Aa83b21t00 get(@PathVariable() Long idAno021, @PathVariable() Integer id021) {
        Aa83b21t00 aa83b21t00 = new Aa83b21t00();
		aa83b21t00.setIdAno021(idAno021);
		aa83b21t00.setId021(id021);
        aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);
        Aa83b21t00Controller.logger.info("[GET - findBy_PK] : Obtener Aa83b21t00 por PK");
        return aa83b21t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAa83b21t00 Aa83b21t00
	 *            Objeto que contiene los parametros de filtrado utilizados en
	 *            la busqueda.
	 * @return List<Aa83b21t00> 
	 *            Lista de objetos correspondientes a la busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<Aa83b21t00> getAll(@ModelAttribute() Aa83b21t00 filterAa83b21t00) {
		Aa83b21t00Controller.logger.info("[GET - find_ALL] : Obtener Aa83b21t00 por filtro");
	    return this.aa83b21t00Service.findAll(filterAa83b21t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param aa83b21t00 Aa83b21t00 
	 *            Bean que contiene la informacion a modificar.
	 * @return Aa83b21t00 
	 *            Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody() Aa83b21t00 edit(@RequestBody() Aa83b21t00 aa83b21t00) {		
        Aa83b21t00 aa83b21t00Aux = this.aa83b21t00Service.update(aa83b21t00);
		Aa83b21t00Controller.logger.info("[PUT] : Aa83b21t00 actualizado correctamente");
        return aa83b21t00Aux;
    }

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param aa83b21t00 Aa83b21t00 
	 *            Bean que contiene la informacion con la que se va a crear el
	 *            nuevo registro.
	 * @return Aa83b21t00
	 *            Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Aa83b21t00 add(@RequestBody() Aa83b21t00 aa83b21t00) {		
        Aa83b21t00 aa83b21t00Aux = this.aa83b21t00Service.add(aa83b21t00);
        Aa83b21t00Controller.logger.info("[POST] : Aa83b21t00 insertado correctamente");
    	return aa83b21t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idAno021 Long
	 * @param id021 Integer
	 *            Identificador del objeto que se desea eliminar.
	 * @return Aa83b21t00
	 *            Bean eliminado.
	 */
	@RequestMapping(value = "/{idAno021}/{id021}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody() Aa83b21t00 remove(@PathVariable() Long idAno021, @PathVariable() Integer id021) {
        Aa83b21t00 aa83b21t00 = new Aa83b21t00();
        aa83b21t00.setIdAno021(idAno021);
        aa83b21t00.setId021(id021);
        this.aa83b21t00Service.remove(aa83b21t00);
       	Aa83b21t00Controller.logger.info("[DELETE] : Aa83b21t00 borrado correctamente");
       	return aa83b21t00;
    }
    
	
	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	 /**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b21t00Controller.logger.info("[GET - View] : aa83b21t00");
		return "aa83b21t00";
	}
	 
	 /**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b21t00 Aa83b21t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b21t00>
	 *            Dto que contiene el resultado del filtrado realizado por el 
	 *            componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<Aa83b21t00> filter(
			@RequestJsonBody(param="filter") Aa83b21t00 filterAa83b21t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Aa83b21t00Controller.logger.info("[POST - filter] : Obtener Aa83b21t00s");
		return this.aa83b21t00Service.filter(filterAa83b21t00, jqGridRequestDto, false);
	}
	 
	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b21t00 Aa83b21t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param searchAa83b21t00 Aa83b21t00
	 *            Bean que contiene los parametros de busqueda a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b21t00> 
	 *            Dto que contiene el resultado de la busqueda realizada por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody() List<TableRowDto<Aa83b21t00>> search(
			@RequestJsonBody(param="filter") Aa83b21t00 filterAa83b21t00,
			@RequestJsonBody(param="search") Aa83b21t00 searchAa83b21t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Aa83b21t00Controller.logger.info("[POST - search] : Buscar Aa83b21t00s");
		return this.aa83b21t00Service.search(filterAa83b21t00, searchAa83b21t00, jqGridRequestDto, false);
	}
	
	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b21t00 Aa83b21t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String>
	 *            Lista de los identificadores de los registros eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<String> removeMultiple(
			@RequestJsonBody(param="filter") Aa83b21t00 filterAa83b21t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Aa83b21t00Controller.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b21t00s");
		this.aa83b21t00Service.removeMultiple(filterAa83b21t00, jqGridRequestDto, false);
		Aa83b21t00Controller.logger.info("All entities correctly deleted!");
		
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}
	
	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */
	
	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b21t00 Aa83b21t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b21t00>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<JerarquiaDto<Aa83b21t00>> jerarquia(
			@RequestJsonBody(param="filter") Aa83b21t00 filterAa83b21t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Aa83b21t00Controller.logger.info("[POST - jerarquia] : Obtener Aa83b21t00s jerarquia");
		return this.aa83b21t00Service.jerarquia(filterAa83b21t00, jqGridRequestDto, false);
	}
	
	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion jerarquica.
	 * 
	 * @param filterAa83b21t00 Aa83b21t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b21t00>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<JerarquiaDto<Aa83b21t00>> jerarquiaChildren(
			@RequestJsonBody(param="filter") Aa83b21t00  filterAa83b21t00 ,
			@RequestJsonBody() JQGridRequestDto  jqGridRequestDto) {
		Aa83b21t00Controller.logger.info("[POST - jerarquia] : Obtener Aa83b21t00s jerarquia - Hijos");
		return this.aa83b21t00Service.jerarquiaChildren(filterAa83b21t00, jqGridRequestDto);
	}

	/**
	 * @param tiponumSol String
	 * @param anoSol String
	 * @param id034 String
	 * @param cambioManual String
	 * @param request HttpServletRequest
	 * @param response HttpServletResponse
	 * @return HashMap<String, String>
	 * @throws Exception e
	 */
	@RequestMapping(value = "/validarSolicitud", method = RequestMethod.GET)
	public @ResponseBody()
	HashMap<String, String> validarSolicitud(
			//@RequestParam(value = "tipoSolicitud", required = true) String tipoSolicitud,
			@RequestParam(value = "tiponumSol", required = true) String tiponumSol,
			@RequestParam(value = "anoSol", required = true) String anoSol,
			@RequestParam(value = "id034", required = true) String id034,
			@RequestParam(value = "cambioManual", required = true) String cambioManual,
			HttpServletRequest request,HttpServletResponse response
			) throws Exception{
		HashMap<String, String> retorno = new HashMap<String, String>();
		Aa83b21t00 solicitud=new Aa83b21t00();	
		solicitud.setId021(Integer.parseInt(tiponumSol));
		solicitud.setIdAno021(new Long(anoSol));
		Aa83b21t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b21t00 jerarquia - Hijos");
		solicitud=this.aa83b21t00Service.validarSolicitud(solicitud);
		retorno.put("remitente", solicitud.getNombre021());
		
		if (solicitud.getNombre021()!=null)
		{
			//Cambiar el estado de tramitacion y el acceso
			Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
			// ** START ACCESO
			this.aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(
					solicitud, Aa83BConstants.ACCESOS_MODIF, "N"));
			// ** START HISTO
			Aa83b09t00 aa83b09t00 = this.aa83b09t00Service.add(aa83bSolicitudesUtil
					.guardarHistoADE(solicitud, Aa83BConstants.COD_FASE_1,
							Aa83BConstants.COD_TRAM_4, "N"));

			Aa83b34t00 aa83b34t00 = new Aa83b34t00();
			aa83b34t00.setCodsolic034(Long.parseLong(id034));
			//Si la encuentra, asocio la comunicacin a la solicitud
			//Guardamos los documentos de la 35 en la tabla de docs adjuntos de la SOL y cambiamos el contexto
			Aa83b35t00 documentos = new Aa83b35t00();
			documentos.setAa83b34t00(aa83b34t00);
			List<Aa83b35t00> listaDocs = this.aa83b35t00Service
					.findAll(documentos, null);// aki tenemos los oids
			
			//Sacamos la inform del procedimiento:
			String procedure = "";
			String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
			String idProcAdecuacion = this.appConfiguration.getProperty("procedure.adecuacion.id");
			Aa83b21t00Controller.logger.info("id procedureAdecuacion-->"+ idProcAdecuacion);
			Aa83bConsultationContextParser resParser = new Aa83bConsultationContextParser();
			Aa83bConsultationContext res;
			
			// llamada al getProcedureFac para recuperar los datos del
			// procedimiento

			try{
				procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcAdecuacion);
				Aa83b21t00Controller.logger.info("procedureAdecuacion desde validarSolicitud-->"+ procedure);
				resParser = new Aa83bConsultationContextParser(procedure);
									
				
			}catch (Exception e) {
			//	Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: EXCEPCION getProcedureFac: ="+ e.toString());
				Aa83b21t00Controller.logger.error(e.getMessage());
			}
			res = resParser.getProcedureDataAll();
					
			for (int i = 0; i < listaDocs.size(); i++) {
				Aa83b31t00 documento = new Aa83b31t00();
				documento.setOid031Papel0(((Aa83b35t00) listaDocs.get(i))
						.getOid035());
				documento.setId009HistoTram(aa83b09t00.getId009());
				documento.setId021NumSol(solicitud.getId021());
				documento.setIdAno021(solicitud.getIdAno021());
				documento.setId030TipDocSol(60);// xa saber que son nuevos

				this.aa83b31t00Service.add(documento);

				//CAMBIAMOS EL CONTEXTO DEL DOC NUEVO AL PROCESARLO
				Aa83bDocumentoDokusi documentoDokusi = new Aa83bDocumentoDokusi();
				documentoDokusi.setOid(documento.getOid031Papel0());
				// Uso la descripcion EU para pasar el numero de registro
				documentoDokusi.setDescripcionEu(solicitud.getFecha021().toString());
				String formato = Aa83BConstants.ES_PATTERN; 
				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
						.getLanguage())) {
					formato = Aa83BConstants.EU_PATTERN;
				}
				Aa83b21t00Controller.logger.info("********	LocaleContextHolder.getLocale()--> " + 	LocaleContextHolder.getLocale() );
			
				java.util.Date utilDate2 = new java.util.Date();
				Date date2 = new Date(utilDate2.getTime());
				String fechaD = (String) new SimpleDateFormat(formato).format(date2);
				documentoDokusi.setDescripcionEu(fechaD);
				// Uso la descripcion ES para pasar el numero de registro
				documentoDokusi.setDescripcionEs(solicitud.getNumReg021());
				// Cambiamos el contexto en DOKUSI del documento
				Boolean docSubido = this.aa83bDokusiService
						.tramitateDocument(documentoDokusi, res.getDocumentalSeriesId());
				Aa83b21t00Controller.logger.info("Contexto de: " + documento.getOid031Papel0() + " cambiado "
						+ docSubido);
			}
			//Cambiar el estado en la Bandeja de Entrada y guardar el cambio en la tabla 34 en caso de que se haya hecho a mano:
			if (cambioManual.equals("S"))
			{
				//Guardamos los datos en la 34 02185#HAB201631:F=1:T=4 y cambiamos el estado
				String qrcode034 = Aa83BConstants.COD_ADE_PLATEA+"#HAB"+anoSol+tiponumSol+":F=1:T=4";
				System.out.println ("QR::: "+ qrcode034);
				aa83b34t00.setQrcode034(qrcode034);
				aa83b34t00=this.aa83b34t00Service.updateQR(aa83b34t00);
			}else
			{
				aa83b34t00=this.aa83b34t00Service.updateProcesar(aa83b34t00);
			}
			
		}	
		
		return retorno;
	}
}	
