package com.ejie.aa83b.control;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

import com.ejie.aa83b.model.Aa83b12t00;
import com.ejie.aa83b.model.Aa83b19t00;
import com.ejie.aa83b.service.Aa83b19t00Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.x38.validation.ValidationManager;

/**
 * Aa83b19t00Controller generated by UDA, 23-dic-2015 11:30:13.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa83b19t00")
public class Aa83b19t00Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b19t00Controller.class);

	@Autowired
	private Aa83b19t00Service aa83b19t00Service;

	@Autowired
	private ValidationManager validationManager;
	@Autowired
	private Properties appConfiguration;
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param id019
	 *            Integer
	 * @return Aa83b19t00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id019}", method = RequestMethod.GET)
	// /{nombre019}/{apel1019}/{apel2019}/{numEmp}/{idCargo005}/{activoSn019}
	public @ResponseBody
	Aa83b19t00 get(@PathVariable Integer id019) {// , @PathVariable String
													// nombre019,
		// @PathVariable String apel1019, @PathVariable String apel2019,
		// @PathVariable String numEmp, @PathVariable Integer idCargo005,
		// @PathVariable String activoSn019
		Aa83b19t00 aa83b19t00 = new Aa83b19t00();
		aa83b19t00.setId019(id019);
		/*
		 * File f = new File("ee.doc"); MultipartFile file = (MultipartFile) f;
		 * aa83b19t00.setFile(file);
		 */
		/*
		 * aa83b19t00.setNombre019(nombre019); aa83b19t00.setApel1019(apel1019);
		 * aa83b19t00.setApel2019(apel2019); aa83b19t00.setNumEmp(numEmp);
		 * aa83b19t00.setIdCargo005(idCargo005);
		 * aa83b19t00.setActivoSn019(activoSn019);
		 */
		aa83b19t00 = this.aa83b19t00Service.find(aa83b19t00);
		Aa83b19t00Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa83b19t00 por PK");
		
		aa83b19t00.setDownloadUrl("<a onclick=\"downloadDocument('/aa83bInformesWar/aa83b19t00/download?plantilla="+aa83b19t00.getId019()
				+ "')\"><img src='"
				+ this.appConfiguration.getProperty("statics.path")
				+ "/aa83b/images/lupa.png' height='60' width='60'/></a>");
		return aa83b19t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b19t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b19t00> getAll(@ModelAttribute Aa83b19t00 filterAa83b19t00) {
		Aa83b19t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b19t00 por filtro");
		return this.aa83b19t00Service.findAll(filterAa83b19t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00 Bean que contiene la informacion a modificar.
	 * @return Aa83b19t00 Bean resultante de la modificacion.
	 * @throws IOException
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa83b19t00 edit(
			@ModelAttribute Aa83b19t00 aa83b19t00,
//			Errors errors,
//			HttpServletRequest request,
//			HttpServletResponse response,
			@RequestParam(value = "activoSn019", required = false) String activo,
			@RequestParam(value = "idCargo005", required = false) int cargo,
			@RequestParam(value = "file", required = false) MultipartFile imagen)
			throws IOException {
		aa83b19t00.setActivoSn019(activo);
		aa83b19t00.setIdCargo005(cargo);
		if (imagen != null && imagen.getSize() != 0) {
			byte[] bytes = new byte[Integer.parseInt(String.valueOf(imagen
					.getSize()))];
			bytes = imagen.getBytes();
			/*byte [] byteArr=imagen.getBytes();
			//InputStream inputStream = new ByteArrayInputStream(byteArr);
			/*BufferedImage img = ImageIO.read(new ByteArrayInputStream(byteArr));
			BufferedImage bi=new BufferedImage(100, 100, BufferedImage.TYPE_INT_RGB);
			Graphics2D g = bi.createGraphics();
			g.drawImage(img, 0, 0, 100, 100, null);
			g.dispose();	
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			ImageIO.write( bi, "jpg", baos );
			baos.flush();
			byte[] imageInByte = baos.toByteArray();
			baos.close();
			byte[] bytes = new byte[Integer.parseInt(String.valueOf(baos.size()))];
			bytes = imageInByte;//imagen.getBytes();*/
			aa83b19t00.setFirmaDigital019(bytes);
		}
		Aa83b19t00 aa83b19t00Aux = this.aa83b19t00Service.update(aa83b19t00);
		Aa83b19t00Controller.logger
				.info("[PUT] : Aa83b19t00 actualizado correctamente");
		return aa83b19t00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa83b19t00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	/*
	 * public @ResponseBody Aa83b19t00 add(@RequestBody Aa83b19t00 aa83b19t00) {
	 * Aa83b19t00 aa83b19t00Aux = this.aa83b19t00Service.add(aa83b19t00);
	 * Aa83b19t00Controller
	 * .logger.info("[POST] : Aa83b19t00 insertado correctamente"); return
	 * aa83b19t00Aux; }
	 */
	public @ResponseBody
	Aa83b19t00 add(
			@ModelAttribute Aa83b19t00 aa83b19t00,
			Errors errors,
			HttpServletRequest request,
			HttpServletResponse response,
			@RequestParam(value = "activoSn019", required = false) String activo,
			@RequestParam(value = "idCargo005", required = false) int cargo,
			@RequestParam(value = "file", required = false) MultipartFile imagen)
			throws IOException {
		// Para IE9
		if (request.getParameter("editando").equals("1")) {
			return this.edit(aa83b19t00, activo, cargo, imagen);
		} else {
			aa83b19t00.setActivoSn019(activo);
			aa83b19t00.setIdCargo005(cargo);
			if (imagen != null) {
				/*byte [] byteArr=imagen.getBytes();
				//InputStream inputStream = new ByteArrayInputStream(byteArr);
				BufferedImage img = ImageIO.read(new ByteArrayInputStream(byteArr));
				BufferedImage bi=new BufferedImage(100, 100, BufferedImage.TYPE_INT_RGB);
				Graphics2D g = bi.createGraphics();
				g.drawImage(img, 0, 0, 100, 100, null);
				g.dispose();	
				ByteArrayOutputStream baos = new ByteArrayOutputStream();
				ImageIO.write( bi, "jpg", baos );
				baos.flush();
				byte[] imageInByte = baos.toByteArray();
				baos.close();
				byte[] bytes = new byte[Integer.parseInt(String.valueOf(baos.size()))];
				bytes = imageInByte;//imagen.getBytes();
				aa83b19t00.setFirmaDigital019(bytes);*/
				byte[] bytes = new byte[Integer.parseInt(String.valueOf(imagen
						.getSize()))];
				bytes = imagen.getBytes();
				aa83b19t00.setFirmaDigital019(bytes);
			}
	
			Aa83b19t00 aa83b19t00Aux = this.aa83b19t00Service.add(aa83b19t00,
					errors);
			if (errors.hasErrors()) {
				Map<String, List<String>> errorsMap = validationManager
						.getErrorsAsMap(errors);
				ServletOutputStream servletOutputStream = response
						.getOutputStream();
				response.setStatus(406);
				response.setContentType("text/plain");
				response.setCharacterEncoding("UTF-8");
				servletOutputStream.print(validationManager.getMessageJSON(
						errorsMap, null, "error").toString());
				response.flushBuffer();
				return null;
			}
			return aa83b19t00Aux;
		}
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param id019
	 *            Integer
	 * @param nombre019
	 *            String
	 * @param apel1019
	 *            String
	 * @param apel2019
	 *            String
	 * @param numEmp
	 *            String
	 * @param idCargo005
	 *            Integer
	 * @param activoSn019
	 *            String Identificador del objeto que se desea eliminar.
	 * @return Aa83b19t00 Bean eliminado.
	 */
	@RequestMapping(value = "/{id019}", method = RequestMethod.DELETE)
	// /{nombre019}/{apel1019}/{apel2019}/{numEmp}/{idCargo005}/{activoSn019}
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa83b19t00 remove(@PathVariable Integer id019) {
		/*
		 * ,
		 * 
		 * @PathVariable String nombre019, @PathVariable String apel1019,
		 * 
		 * @PathVariable String apel2019, @PathVariable String numEmp,
		 * 
		 * @PathVariable Integer idCargo005, @PathVariable String activoSn019
		 */
		Aa83b19t00 aa83b19t00 = new Aa83b19t00();
		aa83b19t00.setId019(id019);
		/*
		 * aa83b19t00.setNombre019(nombre019); aa83b19t00.setApel1019(apel1019);
		 * aa83b19t00.setApel2019(apel2019); aa83b19t00.setNumEmp(numEmp);
		 * aa83b19t00.setIdCargo005(idCargo005);
		 * aa83b19t00.setActivoSn019(activoSn019);
		 */
		this.aa83b19t00Service.remove(aa83b19t00);
		Aa83b19t00Controller.logger
				.info("[DELETE] : Aa83b19t00 borrado correctamente");
		return aa83b19t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b19t00Controller.logger.info("[GET - View] : aa83b19t00");
		return "aa83b19t00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b19t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b19t00> filter(
			@RequestJsonBody(param = "filter") Aa83b19t00 filterAa83b19t00,
			// @RequestParam(value = "tipoSol") int cargo,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b19t00Controller.logger.info("[POST - filter] : Obtener Aa83b19t00s");
		
		if(filterAa83b19t00.getIdCargo005()==0||"0".equals(filterAa83b19t00.getIdCargo005())){
			filterAa83b19t00.setIdCargo005(null);
		}
		
		/*if ("solconcat".equals(jqGridRequestDto.getSidx())){
			jqGridRequestDto.setSidx("tipoSol||idAno||lpad(t1.ID,'15',0)");
		} else {
			if ("fecAlta".equals(jqGridRequestDto.getSidx())){
				jqGridRequestDto.setSidx("fecAltaOrd");
			}
		}*/
		
		return this.aa83b19t00Service.filter(filterAa83b19t00,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa83b19t00
	 *            Aa83b19t00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b19t00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa83b19t00>> search(
			@RequestJsonBody(param = "filter") Aa83b19t00 filterAa83b19t00,
			@RequestJsonBody(param = "search") Aa83b19t00 searchAa83b19t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b19t00Controller.logger
				.info("[POST - search] : Buscar Aa83b19t00s");
		List<TableRowDto<Aa83b19t00>> firmas = this.aa83b19t00Service.search(
				filterAa83b19t00, searchAa83b19t00, jqGridRequestDto, false);
		return firmas;
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa83b19t00 filterAa83b19t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b19t00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b19t00s");
		this.aa83b19t00Service.removeMultiple(filterAa83b19t00,
				jqGridRequestDto, false);
		Aa83b19t00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b19t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b19t00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa83b19t00 filterAa83b19t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b19t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b19t00s jerarquia");
		return this.aa83b19t00Service.jerarquia(filterAa83b19t00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b19t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b19t00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa83b19t00 filterAa83b19t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b19t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b19t00s jerarquia - Hijos");
		return this.aa83b19t00Service.jerarquiaChildren(filterAa83b19t00,
				jqGridRequestDto);
	}
	/**
	 * Descarga la plantilla
	 * 
	 * @param request
	 *            la request
	 * @param response
	 *            el response
	 * @throws SQLException
	 *             excepcion
	 * @throws IOException
	 *             excepcion
	 */
	@RequestMapping(value = "/download", method = RequestMethod.GET)
	public void download(HttpServletRequest request,
			HttpServletResponse response
		) throws SQLException, IOException {
		String plantilla = request.getParameter("plantilla");
		Aa83b19t00 aa83b19t00= new Aa83b19t00();
		aa83b19t00.setId019(Integer.parseInt(plantilla));
		Aa83b19t00 result = this.aa83b19t00Service.find(aa83b19t00);
		
		response.setHeader("Set-Cookie", "fileDownload=true; path=/");
		response.setContentType("jpg");//result.getMime06()
		String nombreFichero=result.getNombre019()+""+result.getApel1019()+""+result.getApel2019();
		response.setHeader("Content-Disposition","attachment; filename="+nombreFichero);
		ServletOutputStream out = response.getOutputStream();
		response.setContentType("jpg" + "; charset=UTF-8");//result.getMime06()
		out.write(result.getFirmaDigital019());//binaryBuffer
		out.flush();
		out.close();

	}
}
