package com.ejie.aa83b.control;

import com.ejie.aa83b.service.Aa83b11t00Service;
import com.ejie.aa83b.service.Aa83b01t00Service;
import com.ejie.aa83b.service.Aa83b02t00Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa83b.model.Aa83b01t00;
import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b11t00;

/**
 * Aa83b11t00Controller generated by UDA, 23-dic-2015 11:28:51.
 * 
 * @author UDA
 */
@Controller
@RequestMapping(value = "/aa83b11t00")
public class Aa83b11t00Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b11t00Controller.class);

	@Autowired
	private Aa83b11t00Service aa83b11t00Service;

	@Autowired
	private Aa83b01t00Service aa83b01t00Service;

	@Autowired
	private Aa83b02t00Service aa83b02t00Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param id011
	 *            Integer
	 * @param id001Fase
	 *            Integer
	 * @param id002Tram
	 *            Integer
	 * @param id003TipoSol
	 *            Integer
	 * @param id025NumSol
	 *            Integer
	 * @param idAnoSol025
	 *            Long
	 * @param FActu011
	 *            Date
	 * @param usua011
	 *            String
	 * @param FRegSal011
	 *            Date
	 * @param NRegSal011
	 *            String
	 * @param FNotif011
	 *            Date
	 * @param FExpir011
	 *            Date
	 * @param FModif011
	 *            Date
	 * @param usuMod011
	 *            String
	 * @param FTram011
	 *            Date
	 * @return Aa83b11t00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id011}/{id001Fase}/{id002Tram}/{id003TipoSol}/{id025NumSol}/{idAnoSol025}/{FActu011}/{usua011}/{FRegSal011}/{NRegSal011}/{FNotif011}/{FExpir011}/{FModif011}/{usuMod011}/{FTram011}", method = RequestMethod.GET)
	public @ResponseBody
	Aa83b11t00 get(@PathVariable Integer id011,
			@PathVariable Integer id001Fase, @PathVariable Integer id002Tram,
			@PathVariable Integer id003TipoSol,
			@PathVariable Integer id025NumSol, @PathVariable Long idAnoSol025,
			@PathVariable Date FActu011, @PathVariable String usua011,
			@PathVariable Date FRegSal011, @PathVariable String NRegSal011,
			@PathVariable Date FNotif011, @PathVariable Date FExpir011,
			@PathVariable Date FModif011, @PathVariable String usuMod011,
			@PathVariable Date FTram011) {
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		aa83b11t00.setId011(id011);
		aa83b11t00.setId001Fase(id001Fase);
		aa83b11t00.setId002Tram(id002Tram);
		aa83b11t00.setId003TipoSol(id003TipoSol);
		aa83b11t00.setId025NumSol(id025NumSol);
		aa83b11t00.setIdAnoSol025(idAnoSol025);
		aa83b11t00.setfActu011(FActu011);
		aa83b11t00.setUsua011(usua011);
		aa83b11t00.setFRegSal011(FRegSal011);
		aa83b11t00.setNRegSal011(NRegSal011);
		aa83b11t00.setFNotif011(FNotif011);
		aa83b11t00.setFExpir011(FExpir011);
		aa83b11t00.setFModif011(FModif011);
		aa83b11t00.setUsuMod011(usuMod011);
		aa83b11t00.setFTram011(FTram011);
		aa83b11t00 = this.aa83b11t00Service.find(aa83b11t00);
		Aa83b11t00Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa83b11t00 por PK");
		return aa83b11t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b11t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b11t00> getAll(@ModelAttribute Aa83b11t00 filterAa83b11t00) {
		Aa83b11t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b11t00 por filtro");
		return this.aa83b11t00Service.findAll(filterAa83b11t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00 Bean que contiene la informacion a modificar.
	 * @return Aa83b11t00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa83b11t00 edit(@RequestBody Aa83b11t00 aa83b11t00) {
		Aa83b11t00 aa83b11t00Aux = this.aa83b11t00Service.update(aa83b11t00);
		Aa83b11t00Controller.logger
				.info("[PUT] : Aa83b11t00 actualizado correctamente");
		return aa83b11t00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa83b11t00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa83b11t00 add(@RequestBody Aa83b11t00 aa83b11t00) {
		Aa83b11t00 aa83b11t00Aux = this.aa83b11t00Service.add(aa83b11t00);
		Aa83b11t00Controller.logger
				.info("[POST] : Aa83b11t00 insertado correctamente");
		return aa83b11t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param id011
	 *            Integer
	 * @param id001Fase
	 *            Integer
	 * @param id002Tram
	 *            Integer
	 * @param id003TipoSol
	 *            Integer
	 * @param id025NumSol
	 *            Integer
	 * @param idAnoSol025
	 *            Long
	 * @param FActu011
	 *            Date
	 * @param usua011
	 *            String
	 * @param FRegSal011
	 *            Date
	 * @param NRegSal011
	 *            String
	 * @param FNotif011
	 *            Date
	 * @param FExpir011
	 *            Date
	 * @param FModif011
	 *            Date
	 * @param usuMod011
	 *            String
	 * @param FTram011
	 *            Date Identificador del objeto que se desea eliminar.
	 * @return Aa83b11t00 Bean eliminado.
	 */
	@RequestMapping(value = "/{id011}/{id001Fase}/{id002Tram}/{id003TipoSol}/{id025NumSol}/{idAnoSol025}/{FActu011}/{usua011}/{FRegSal011}/{NRegSal011}/{FNotif011}/{FExpir011}/{FModif011}/{usuMod011}/{FTram011}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa83b11t00 remove(@PathVariable Integer id011,
			@PathVariable Integer id001Fase, @PathVariable Integer id002Tram,
			@PathVariable Integer id003TipoSol,
			@PathVariable Integer id025NumSol, @PathVariable Long idAnoSol025,
			@PathVariable Date FActu011, @PathVariable String usua011,
			@PathVariable Date FRegSal011, @PathVariable String NRegSal011,
			@PathVariable Date FNotif011, @PathVariable Date FExpir011,
			@PathVariable Date FModif011, @PathVariable String usuMod011,
			@PathVariable Date FTram011) {
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		aa83b11t00.setId011(id011);
		aa83b11t00.setId001Fase(id001Fase);
		aa83b11t00.setId002Tram(id002Tram);
		aa83b11t00.setId003TipoSol(id003TipoSol);
		aa83b11t00.setId025NumSol(id025NumSol);
		aa83b11t00.setIdAnoSol025(idAnoSol025);
		aa83b11t00.setfActu011(FActu011);
		aa83b11t00.setUsua011(usua011);
		aa83b11t00.setFRegSal011(FRegSal011);
		aa83b11t00.setNRegSal011(NRegSal011);
		aa83b11t00.setFNotif011(FNotif011);
		aa83b11t00.setFExpir011(FExpir011);
		aa83b11t00.setFModif011(FModif011);
		aa83b11t00.setUsuMod011(usuMod011);
		aa83b11t00.setFTram011(FTram011);
		this.aa83b11t00Service.remove(aa83b11t00);
		Aa83b11t00Controller.logger
				.info("[DELETE] : Aa83b11t00 borrado correctamente");
		return aa83b11t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b11t00Controller.logger.info("[GET - View] : aa83b11t00");
		return "aa83b11t00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b11t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b11t00> filter(
			@RequestJsonBody(param = "filter") Aa83b11t00 filterAa83b11t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b11t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b11t00s");
		return this.aa83b11t00Service.filter(filterAa83b11t00,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b09t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/listaTram", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b11t00> listaTram(
			@RequestParam(value = "idSol") String idSol,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b11t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b11t00s");

		Aa83b11t00 filterAa83b11t00 = new Aa83b11t00();

		String[] trozos = idSol.split(":");
		String ano_Sol = trozos[0];
		String num_Sol = trozos[1];
		filterAa83b11t00.setIdAnoSol025(Long.parseLong(ano_Sol));
		filterAa83b11t00.setId025NumSol(Integer.parseInt(num_Sol));
		filterAa83b11t00.setId003TipoSol(1);

		JQGridResponseDto<Aa83b11t00> filterInt = this.aa83b11t00Service
				.filter(filterAa83b11t00, jqGridRequestDto, false);

		Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		List<Aa83b11t00> aa83b11t00List = new ArrayList<Aa83b11t00>();
		for (int i = 0; i < filterInt.getRows().size(); i++) {
			aa83b11t00 = (Aa83b11t00) filterInt.getRows().get(i);
			aa83b11t00 = buscarLiterales(aa83b11t00);
			aa83b11t00List.add(aa83b11t00);
		}

		JQGridResponseDto<Aa83b11t00> filterInt2 = new JQGridResponseDto<Aa83b11t00>();
		filterInt2.setRows(aa83b11t00List);
		filterInt.setRows(aa83b11t00List);
		return filterInt;
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa83b11t00
	 *            Aa83b11t00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b11t00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa83b11t00>> search(
			@RequestJsonBody(param = "filter") Aa83b11t00 filterAa83b11t00,
			@RequestJsonBody(param = "search") Aa83b11t00 searchAa83b11t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b11t00Controller.logger
				.info("[POST - search] : Buscar Aa83b11t00s");
		return this.aa83b11t00Service.search(filterAa83b11t00,
				searchAa83b11t00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa83b11t00 filterAa83b11t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b11t00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b11t00s");
		this.aa83b11t00Service.removeMultiple(filterAa83b11t00,
				jqGridRequestDto, false);
		Aa83b11t00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b11t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b11t00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa83b11t00 filterAa83b11t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b11t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b11t00s jerarquia");
		return this.aa83b11t00Service.jerarquia(filterAa83b11t00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b11t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b11t00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa83b11t00 filterAa83b11t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b11t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b11t00s jerarquia - Hijos");
		return this.aa83b11t00Service.jerarquiaChildren(filterAa83b11t00,
				jqGridRequestDto);
	}

	private Aa83b11t00 buscarLiterales(Aa83b11t00 aa83b11t00) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		// Buscamos el Litetral de Tipo de SOL:
		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		Aa83b02t00 aa83b02t00 = new Aa83b02t00();

		aa83b01t00.setId001(aa83b11t00.getId001Fase());
		aa83b01t00.setIdTipoSol(aa83b11t00.getId003TipoSol());

		Aa83b01t00 aa83b01t00Lista = aa83b01t00Service.find(aa83b01t00);
		aa83b11t00.setId001FaseStrEs(aa83b01t00Lista.getDescEs001());
		aa83b11t00.setId001FaseStrEu(aa83b01t00Lista.getDescEu001());

		aa83b02t00.setId001Fase(aa83b11t00.getId001Fase());
		aa83b02t00.setId002(aa83b11t00.getId002Tram());
		aa83b02t00.setId003TipoSol(3);

		Aa83b02t00 aa83b02t00Lista = aa83b02t00Service.find(aa83b02t00);

		aa83b11t00.setId002TramStrEs(aa83b02t00Lista.getDescEs002());
		aa83b11t00.setId002TramStrEu(aa83b02t00Lista.getDescEu002());

		return aa83b11t00;
	}

}
