package com.ejie.aa83b.control;

import com.ejie.aa83b.service.Aa83b09t00Service;
import com.ejie.aa83b.service.Aa83b01t00Service;
import com.ejie.aa83b.service.Aa83b02t00Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa83b.model.Aa83b01t00;
import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b09t00;

/**
 * Aa83b09t00Controller generated by UDA, 15-dic-2015 10:40:01.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa83b09t00")
public class Aa83b09t00Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b09t00Controller.class);

	@Autowired
	private Aa83b09t00Service aa83b09t00Service;

	@Autowired
	private Aa83b01t00Service aa83b01t00Service;

	@Autowired
	private Aa83b02t00Service aa83b02t00Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param id009
	 *            Integer
	 * @return Aa83b09t00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id009}", method = RequestMethod.GET)
	public @ResponseBody
	Aa83b09t00 get(@PathVariable Integer id009) {
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		aa83b09t00.setId009(id009);
		aa83b09t00 = this.aa83b09t00Service.find(aa83b09t00);
		Aa83b09t00Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa83b09t00 por PK");
		return aa83b09t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b09t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b09t00> getAll(@ModelAttribute Aa83b09t00 filterAa83b09t00) {
		Aa83b09t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b09t00 por filtro");
		return this.aa83b09t00Service.findAll(filterAa83b09t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00 Bean que contiene la informacion a modificar.
	 * @return Aa83b09t00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa83b09t00 edit(@RequestBody Aa83b09t00 aa83b09t00) {
		Aa83b09t00 aa83b09t00Aux = this.aa83b09t00Service.update(aa83b09t00);
		Aa83b09t00Controller.logger
				.info("[PUT] : Aa83b09t00 actualizado correctamente");
		return aa83b09t00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa83b09t00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa83b09t00 add(@RequestBody Aa83b09t00 aa83b09t00) {
		Aa83b09t00 aa83b09t00Aux = this.aa83b09t00Service.add(aa83b09t00);
		Aa83b09t00Controller.logger
				.info("[POST] : Aa83b09t00 insertado correctamente");
		return aa83b09t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param id009
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Aa83b09t00 Bean eliminado.
	 */
	@RequestMapping(value = "/{id009}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa83b09t00 remove(@PathVariable Integer id009) {
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		aa83b09t00.setId009(id009);
		this.aa83b09t00Service.remove(aa83b09t00);
		Aa83b09t00Controller.logger
				.info("[DELETE] : Aa83b09t00 borrado correctamente");
		return aa83b09t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b09t00Controller.logger.info("[GET - View] : aa83b09t00");
		return "aa83b09t00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b09t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b09t00> filter(
			@RequestJsonBody(param = "filter") Aa83b09t00 filterAa83b09t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b09t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b09t00s");
		return this.aa83b09t00Service.filter(filterAa83b09t00,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b09t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/listaTram", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b09t00> listaTram(
			@RequestParam(value = "idSol") String idSol,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b09t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b09t00s");

		Aa83b09t00 filterAa83b09t00 = new Aa83b09t00();

		String[] trozos = idSol.split(":");
		String ano_Sol = trozos[0];
		String num_Sol = trozos[1];
		filterAa83b09t00.setIdAno021(Long.parseLong(ano_Sol));
		filterAa83b09t00.setId021NumSol(Integer.parseInt(num_Sol));
		filterAa83b09t00.setId003TipoSol(3);

		JQGridResponseDto<Aa83b09t00> filterInt = this.aa83b09t00Service
				.filter(filterAa83b09t00, jqGridRequestDto, false);

		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		List<Aa83b09t00> aa83b09t00List = new ArrayList<Aa83b09t00>();
		for (int i = 0; i < filterInt.getRows().size(); i++) {
			aa83b09t00 = (Aa83b09t00) filterInt.getRows().get(i);
			aa83b09t00 = buscarLiterales(aa83b09t00);
			aa83b09t00List.add(aa83b09t00);
		}

		filterInt.setRows(aa83b09t00List);
		return filterInt;

	}

	private Aa83b09t00 buscarLiterales(Aa83b09t00 aa83b09t00) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		// Buscamos el Litetral de Tipo de SOL:
		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		Aa83b02t00 aa83b02t00 = new Aa83b02t00();

		aa83b01t00.setId001(aa83b09t00.getId001Fase());
		aa83b01t00.setIdTipoSol(aa83b09t00.getId003TipoSol());

		Aa83b01t00 aa83b01t00Lista = aa83b01t00Service.find(aa83b01t00);
		aa83b09t00.setId001FaseStrEs(aa83b01t00Lista.getDescEs001());
		aa83b09t00.setId001FaseStrEu(aa83b01t00Lista.getDescEu001());

		aa83b02t00.setId001Fase(aa83b09t00.getId001Fase());
		aa83b02t00.setId002(aa83b09t00.getId002Tram());
		aa83b02t00.setId003TipoSol(3);

		Aa83b02t00 aa83b02t00Lista = aa83b02t00Service.find(aa83b02t00);

		aa83b09t00.setId002TramStrEs(aa83b02t00Lista.getDescEs002());
		aa83b09t00.setId002TramStrEu(aa83b02t00Lista.getDescEu002());

		return aa83b09t00;
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa83b09t00
	 *            Aa83b09t00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b09t00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa83b09t00>> search(
			@RequestJsonBody(param = "filter") Aa83b09t00 filterAa83b09t00,
			@RequestJsonBody(param = "search") Aa83b09t00 searchAa83b09t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b09t00Controller.logger
				.info("[POST - search] : Buscar Aa83b09t00s");
		return this.aa83b09t00Service.search(filterAa83b09t00,
				searchAa83b09t00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa83b09t00 filterAa83b09t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b09t00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b09t00s");
		this.aa83b09t00Service.removeMultiple(filterAa83b09t00,
				jqGridRequestDto, false);
		Aa83b09t00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b09t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b09t00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa83b09t00 filterAa83b09t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b09t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b09t00s jerarquia");
		return this.aa83b09t00Service.jerarquia(filterAa83b09t00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b09t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b09t00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa83b09t00 filterAa83b09t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b09t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b09t00s jerarquia - Hijos");
		return this.aa83b09t00Service.jerarquiaChildren(filterAa83b09t00,
				jqGridRequestDto);
	}

}
