package com.ejie.aa83b.control;

import com.ejie.aa83b.service.Aa83b06t00Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa83b.model.Aa83b06t00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.model.Aa83b03t00;
import com.ejie.aa83b.service.Aa83b03t00Service;

/**
 * Aa83b06t00Controller generated by UDA, 30-dic-2015 10:26:23.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa83b06t00")
public class Aa83b06t00Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b06t00Controller.class);

	@Autowired
	private Aa83b06t00Service aa83b06t00Service;

	/** The service. */
	@Autowired()
	private Aa83b03t00Service aa83b03t00Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param id006
	 *            Integer
	 * @return Aa83b06t00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id006}", method = RequestMethod.GET)
	public @ResponseBody
	Aa83b06t00 get(@PathVariable Integer id006) {
		Aa83b06t00 aa83b06t00 = new Aa83b06t00();
		aa83b06t00.setId006(id006);
		aa83b06t00 = this.aa83b06t00Service.find(aa83b06t00);
		Aa83b06t00Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa83b06t00 por PK");
		aa83b06t00 = buscarLiterales(aa83b06t00);
		return aa83b06t00;
	}

	private Aa83b06t00 buscarLiterales(Aa83b06t00 aa83b06t00) {
		// TODO Auto-generated method stub
		// Buscamos el Litetral de Tipo de SOL:
		Aa83b03t00 aa83b03t00 = new Aa83b03t00();

		aa83b03t00.setId003(aa83b06t00.getId003TipoSol());
		List<Aa83b03t00> aa83b03t00Lista = aa83b03t00Service.findAllLike(
				aa83b03t00, null, false);

		aa83b03t00 = aa83b03t00Lista.get(0);
		aa83b06t00.setStrTipoSolEs(aa83b03t00.getDescEs003());
		aa83b06t00.setStrTipoSolEu(aa83b03t00.getDescEu003());
		aa83b06t00.setStrTipoSolCod(aa83b03t00.getTipoSol003());
		if (aa83b06t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_ALTA)) {
			aa83b06t00
					.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_ALTA_TXT_ES);
			aa83b06t00
					.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_ALTA_TXT_EU);
		}
		if (aa83b06t00.getTipoModif038()
				.equals(Aa83BConstants.ACCESOS_CONSULTA)) {
			aa83b06t00
					.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_CONSULTA_TXT_ES);
			aa83b06t00
					.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_CONSULTA_TXT_EU);
		}
		if (aa83b06t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_MODIF)) {
			aa83b06t00
					.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_MODIF_TXT_ES);
			aa83b06t00
					.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_MODIF_TXT_EU);
		}
		return aa83b06t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b06t00
	 *            Aa83b06t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b06t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b06t00> getAll(@ModelAttribute Aa83b06t00 filterAa83b06t00) {
		Aa83b06t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b06t00 por filtro");

		List<Aa83b06t00> listaIntermedia1 = this.aa83b06t00Service.findAll(
				filterAa83b06t00, null);

		List<Aa83b06t00> listaIntermedia2 = new ArrayList<Aa83b06t00>();

		for (int i = 1; i < listaIntermedia1.size(); i++) {
			Aa83b06t00 aa83b06t00 = new Aa83b06t00();
			aa83b06t00 = listaIntermedia1.get(i);
			aa83b06t00 = buscarLiterales(aa83b06t00);
			listaIntermedia2.add(aa83b06t00);
		}
		return listaIntermedia2;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b06t00
	 *            Aa83b06t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b06t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b06t00> filter(@ModelAttribute Aa83b06t00 filterAa83b06t00) {
		Aa83b06t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b06t00 por filtro");

		List<Aa83b06t00> listaIntermedia1 = this.aa83b06t00Service.findAll(
				filterAa83b06t00, null);

		List<Aa83b06t00> listaIntermedia2 = new ArrayList<Aa83b06t00>();

		for (int i = 1; i < listaIntermedia1.size(); i++) {
			Aa83b06t00 aa83b06t00 = new Aa83b06t00();
			aa83b06t00 = listaIntermedia1.get(i);
			aa83b06t00 = buscarLiterales(aa83b06t00);
			listaIntermedia2.add(aa83b06t00);
		}
		return listaIntermedia2;
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa83b06t00
	 *            Aa83b06t00 Bean que contiene la informacion a modificar.
	 * @return Aa83b06t00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa83b06t00 edit(@RequestBody Aa83b06t00 aa83b06t00) {
		Aa83b06t00 aa83b06t00Aux = this.aa83b06t00Service.update(aa83b06t00);
		Aa83b06t00Controller.logger
				.info("[PUT] : Aa83b06t00 actualizado correctamente");
		return aa83b06t00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa83b06t00
	 *            Aa83b06t00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa83b06t00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa83b06t00 add(@RequestBody Aa83b06t00 aa83b06t00) {
		Aa83b06t00 aa83b06t00Aux = this.aa83b06t00Service.add(aa83b06t00);
		Aa83b06t00Controller.logger
				.info("[POST] : Aa83b06t00 insertado correctamente");
		return aa83b06t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param id006
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Aa83b06t00 Bean eliminado.
	 */
	@RequestMapping(value = "/{id006}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa83b06t00 remove(@PathVariable Integer id006) {
		Aa83b06t00 aa83b06t00 = new Aa83b06t00();
		aa83b06t00.setId006(id006);
		this.aa83b06t00Service.remove(aa83b06t00);
		Aa83b06t00Controller.logger
				.info("[DELETE] : Aa83b06t00 borrado correctamente");
		return aa83b06t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b06t00Controller.logger.info("[GET - View] : aa83b06t00");
		return "aa83b06t00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b06t00
	 *            Aa83b06t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b06t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b06t00> filter(
			@RequestJsonBody(param = "filter") Aa83b06t00 filterAa83b06t00,
			@RequestJsonBody(param = "idSol") String idSol,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b06t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b06t00s");

		JQGridResponseDto<Aa83b06t00> filterInt = this.aa83b06t00Service
				.filter(filterAa83b06t00, jqGridRequestDto, false);

		Aa83b06t00 aa83b06t00 = new Aa83b06t00();
		List<Aa83b06t00> aa83b06t00List = new ArrayList<Aa83b06t00>();
		for (int i = 0; i < filterInt.getRows().size(); i++) {
			aa83b06t00 = (Aa83b06t00) filterInt.getRows().get(i);
			aa83b06t00 = buscarLiterales(aa83b06t00);
			aa83b06t00List.add(aa83b06t00);
		}

		JQGridResponseDto<Aa83b06t00> filterInt2 = new JQGridResponseDto<Aa83b06t00>();
		filterInt2.setRows(aa83b06t00List);
		filterInt.setRows(aa83b06t00List);
		return filterInt;
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b06t00
	 *            Aa83b06t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b06t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/listaAccs", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b06t00> listaAccs(
			@RequestParam(value = "idSol") String idSol,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b06t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b06t00s");

		Aa83b06t00 filterAa83b06t00 = new Aa83b06t00();

		String[] trozos = idSol.split(":");
		// HAB:2016:176
		String ano_Sol = trozos[0];
		String num_Sol = trozos[1];
		String url = trozos[2];

		filterAa83b06t00.setIdAno021(Long.parseLong(ano_Sol));
		filterAa83b06t00.setId021NumSol(Integer.parseInt(num_Sol));
		filterAa83b06t00.setId003TipoSol(3);

		JQGridResponseDto<Aa83b06t00> filterInt = this.aa83b06t00Service
				.filter(filterAa83b06t00, jqGridRequestDto, false);

		Aa83b06t00 aa83b06t00 = new Aa83b06t00();
		List<Aa83b06t00> aa83b06t00List = new ArrayList<Aa83b06t00>();
		for (int i = 0; i < filterInt.getRows().size(); i++) {
			aa83b06t00 = (Aa83b06t00) filterInt.getRows().get(i);
			aa83b06t00 = buscarLiterales(aa83b06t00);
			aa83b06t00List.add(aa83b06t00);
		}

		JQGridResponseDto<Aa83b06t00> filterInt2 = new JQGridResponseDto<Aa83b06t00>();
		filterInt2.setRows(aa83b06t00List);
		filterInt.setRows(aa83b06t00List);
		return filterInt;
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b06t00
	 *            Aa83b06t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa83b06t00
	 *            Aa83b06t00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b06t00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa83b06t00>> search(
			@RequestJsonBody(param = "filter") Aa83b06t00 filterAa83b06t00,
			@RequestJsonBody(param = "search") Aa83b06t00 searchAa83b06t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b06t00Controller.logger
				.info("[POST - search] : Buscar Aa83b06t00s");
		return this.aa83b06t00Service.search(filterAa83b06t00,
				searchAa83b06t00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b06t00
	 *            Aa83b06t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa83b06t00 filterAa83b06t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b06t00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b06t00s");
		this.aa83b06t00Service.removeMultiple(filterAa83b06t00,
				jqGridRequestDto, false);
		Aa83b06t00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b06t00
	 *            Aa83b06t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b06t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b06t00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa83b06t00 filterAa83b06t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b06t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b06t00s jerarquia");
		return this.aa83b06t00Service.jerarquia(filterAa83b06t00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa83b06t00
	 *            Aa83b06t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b06t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b06t00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa83b06t00 filterAa83b06t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b06t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b06t00s jerarquia - Hijos");
		return this.aa83b06t00Service.jerarquiaChildren(filterAa83b06t00,
				jqGridRequestDto);
	}

}
