package com.ejie.aa83b.control;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.service.Aa83b04t00Service;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa83b04t00Controller generated by UDA, 14-ene-2016 10:01:26.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa83b04t00")
public class Aa83b04t00Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b04t00Controller.class);

	@Autowired
	private Aa83b04t00Service aa83b04t00Service;
	@Autowired
	private Properties appConfiguration;
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param id004
	 *            Integer
	 * @return Aa83b04t00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id004}", method = RequestMethod.GET)
	public @ResponseBody
	Aa83b04t00 get(@PathVariable Integer id004) {
		Aa83b04t00 aa83b04t00 = new Aa83b04t00();
		aa83b04t00.setId004(id004);
		aa83b04t00 = this.aa83b04t00Service.find(aa83b04t00);
		Aa83b04t00Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa83b04t00 por PK");
		aa83b04t00.setDownloadUrl("<a onclick=\"downloadDocument('/aa83bInformesWar/aa83b04t00/download?plantilla="+aa83b04t00.getId004()
				+ "')\"><img src='"
				+ this.appConfiguration.getProperty("statics.path")
				+ "/aa83b/images/lupa.png' height='60' width='60'/></a>");
		return aa83b04t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b04t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b04t00> getAll(@ModelAttribute Aa83b04t00 filterAa83b04t00) {
		Aa83b04t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b04t00 por filtro");
		return this.aa83b04t00Service.findAll(filterAa83b04t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00 Bean que contiene la informacion a modificar.
	 * @return Aa83b04t00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa83b04t00 edit(
			@ModelAttribute Aa83b04t00 aa83b04t00,
//			Errors errors,
//			HttpServletRequest request,
//			HttpServletResponse response,
			@RequestParam(value = "file", required = false) MultipartFile plantilla)
			throws IOException {
	//Aa83b04t00 edit(@RequestBody Aa83b04t00 aa83b04t00,@RequestParam(value = "file", required = false) MultipartFile imagen)) {
		if (plantilla != null && plantilla.getSize() != 0 && (plantilla.getOriginalFilename().contains(".rtf") || plantilla.getOriginalFilename().contains(".RTF"))) {
			byte[] bytes = new byte[Integer.parseInt(String.valueOf(plantilla
					.getSize()))];
			bytes = plantilla.getBytes();
			aa83b04t00.setPlantilla004(bytes);
		}
		if (aa83b04t00.getTdDokusi030().equals("0")) {
			aa83b04t00.setTdDokusi030(null);
		}
		Aa83b04t00 aa83b04t00Aux = this.aa83b04t00Service.update(aa83b04t00);
		Aa83b04t00Controller.logger
				.info("[PUT] : Aa83b04t00 actualizado correctamente");
		return aa83b04t00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa83b04t00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa83b04t00 add(@ModelAttribute Aa83b04t00 aa83b04t00 ,
			//Errors errors,
			HttpServletRequest request,
			//HttpServletResponse response,
	 @RequestParam(value = "file", required = false) MultipartFile plantilla
	) throws IOException {
		// Para IE9
		if (request.getParameter("editando").equals("1")) {
			return this.edit(aa83b04t00, plantilla);
		} else {
			if (plantilla != null && plantilla.getOriginalFilename().contains(".rtf")) {
				byte[] bytes = new byte[Integer.parseInt(String.valueOf(plantilla
						.getSize()))];
				bytes = plantilla.getBytes();
				aa83b04t00.setPlantilla004(bytes);
			}
			if (aa83b04t00.getTdDokusi030().equals("0")) {
				aa83b04t00.setTdDokusi030(null);
			}
			Aa83b04t00 aa83b04t00Aux = this.aa83b04t00Service.add(aa83b04t00);
			Aa83b04t00Controller.logger
					.info("[POST] : Aa83b04t00 insertado correctamente");
			/*if (errors.hasErrors()) {
				Map<String, List<String>> errorsMap = validationManager
						.getErrorsAsMap(errors);
				ServletOutputStream servletOutputStream = response
						.getOutputStream();
				response.setStatus(406);
				response.setContentType("text/plain");
				response.setCharacterEncoding("UTF-8");
				servletOutputStream.print(validationManager.getMessageJSON(
						errorsMap, null, "error").toString());
				response.flushBuffer();
				return null;
			}*/
			return aa83b04t00Aux;
		}
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param id004
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Aa83b04t00 Bean eliminado.
	 */
	@RequestMapping(value = "/{id004}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa83b04t00 remove(@PathVariable Integer id004) {
		Aa83b04t00 aa83b04t00 = new Aa83b04t00();
		aa83b04t00.setId004(id004);
		this.aa83b04t00Service.remove(aa83b04t00);
		Aa83b04t00Controller.logger
				.info("[DELETE] : Aa83b04t00 borrado correctamente");
		
		return aa83b04t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b04t00Controller.logger.info("[GET - View] : aa83b04t00");
		return "aa83b04t00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b04t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b04t00> filter(
			@RequestJsonBody(param = "filter") Aa83b04t00 filterAa83b04t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b04t00Controller.logger.info("[POST - filter] : Obtener Aa83b04t00s");
		if (Aa83BConstants.VALOR_VACIO.equals(filterAa83b04t00.getTdDokusi030())) {
			filterAa83b04t00.setTdDokusi030(null);
		}
		if (Aa83BConstants.VALOR_VACIO.equals(filterAa83b04t00.getSdDokusi030())) {
			filterAa83b04t00.setSdDokusi030(null);
		}
		return this.aa83b04t00Service.filter(filterAa83b04t00,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa83b04t00
	 *            Aa83b04t00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b04t00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa83b04t00>> search(
			@RequestJsonBody(param = "filter") Aa83b04t00 filterAa83b04t00,
			@RequestJsonBody(param = "search") Aa83b04t00 searchAa83b04t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b04t00Controller.logger
				.info("[POST - search] : Buscar Aa83b04t00s");
		return this.aa83b04t00Service.search(filterAa83b04t00,
				searchAa83b04t00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa83b04t00 filterAa83b04t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b04t00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b04t00s");
		this.aa83b04t00Service.removeMultiple(filterAa83b04t00,
				jqGridRequestDto, false);
		Aa83b04t00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b04t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b04t00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa83b04t00 filterAa83b04t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b04t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b04t00s jerarquia");
		return this.aa83b04t00Service.jerarquia(filterAa83b04t00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b04t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b04t00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa83b04t00 filterAa83b04t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b04t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b04t00s jerarquia - Hijos");
		return this.aa83b04t00Service.jerarquiaChildren(filterAa83b04t00,
				jqGridRequestDto);
	}
	/**
	 * Descarga la plantilla
	 * 
	 * @param request
	 *            la request
	 * @param response
	 *            el response
	 * @throws SQLException
	 *             excepcion
	 * @throws IOException
	 *             excepcion
	 */
	@RequestMapping(value = "/download", method = RequestMethod.GET)
	public void download(HttpServletRequest request,
			HttpServletResponse response
		) throws SQLException, IOException {
		String plantilla = request.getParameter("plantilla");
		Aa83b04t00 aa83b04t00= new Aa83b04t00();
		aa83b04t00.setId004(Integer.parseInt(plantilla));
		Aa83b04t00 result = this.aa83b04t00Service.find(aa83b04t00);

		//InputStream blobInputStream = result.getFirmaDigital019().getBinaryStream();
		response.setHeader("Set-Cookie", "fileDownload=true; path=/");
		response.setContentType("rtf");//result.getMime06()
		String extenxion = ".rtf";
		/*for (Aa71bMimeTypes mime : Aa71bMimeTypes.values()) {
			if (mime.getValue().equals(result.getMime06())) {
				extenxion = mime.getExtension();
			}
		}*/
		response.setHeader("Content-Disposition",
				"attachment; filename=template" + extenxion);
		final int _1024 = 1024;
		byte[] binaryBuffer = new byte[_1024];
		ServletOutputStream out = response.getOutputStream();
		response.setContentType("text/rtf");// + "; charset=UTF-8");//result.getMime06()
		//while (aa83b19t00.getFirmaDigital019() != -1) {
			out.write(result.getPlantilla004());//binaryBuffer
		//}
		out.flush();
		out.close();
		//blobInputStream.close();

	}
}
