package com.ejie.aa83b.control;

import com.ejie.aa83b.service.Aa83b03t00Service;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.x38.control.bind.annotation.Json;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.x38.json.JsonMixin;

import java.util.ArrayList;
import java.util.List;

import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa83b.model.Aa83b03t00;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * Aa83b03t00Controller generated by UDA, 15-dic-2015 10:40:01.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa83b03t00")
public class Aa83b03t00Controller {

	private static final String InterfazMix ="Aa83b03t00MixInEus.class";
	
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b03t00Controller.class);

	@Autowired
	private Aa83b03t00Service aa83b03t00Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param id003
	 *            Integer
	 * @return Aa83b03t00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id003}", method = RequestMethod.GET)
	public @ResponseBody
	Aa83b03t00 get(@PathVariable Integer id003) {
		Aa83b03t00 aa83b03t00 = new Aa83b03t00();
		aa83b03t00.setId003(id003);
		aa83b03t00 = this.aa83b03t00Service.find(aa83b03t00);
		Aa83b03t00Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa83b03t00 por PK");
		return aa83b03t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b03t00
	 *            Aa83b03t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b03t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b03t00> getAll(@ModelAttribute Aa83b03t00 filterAa83b03t00) {
		Aa83b03t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b03t00 por filtro");
		return this.aa83b03t00Service.findAll(filterAa83b03t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa83b03t00
	 *            Aa83b03t00 Bean que contiene la informacion a modificar.
	 * @return Aa83b03t00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa83b03t00 edit(@RequestBody Aa83b03t00 aa83b03t00) {
		Aa83b03t00 aa83b03t00Aux = this.aa83b03t00Service.update(aa83b03t00);
		Aa83b03t00Controller.logger
				.info("[PUT] : Aa83b03t00 actualizado correctamente");
		return aa83b03t00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa83b03t00
	 *            Aa83b03t00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa83b03t00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa83b03t00 add(@RequestBody Aa83b03t00 aa83b03t00) {
		Aa83b03t00 aa83b03t00Aux = this.aa83b03t00Service.add(aa83b03t00);
		Aa83b03t00Controller.logger
				.info("[POST] : Aa83b03t00 insertado correctamente");
		return aa83b03t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param id003
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Aa83b03t00 Bean eliminado.
	 */
	@RequestMapping(value = "/{id003}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa83b03t00 remove(@PathVariable Integer id003) {
		Aa83b03t00 aa83b03t00 = new Aa83b03t00();
		aa83b03t00.setId003(id003);
		this.aa83b03t00Service.remove(aa83b03t00);
		Aa83b03t00Controller.logger
				.info("[DELETE] : Aa83b03t00 borrado correctamente");
		return aa83b03t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b03t00Controller.logger.info("[GET - View] : aa83b03t00");
		return "aa83b03t00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b03t00
	 *            Aa83b03t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b03t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b03t00> filter(
			@RequestJsonBody(param = "filter") Aa83b03t00 filterAa83b03t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b03t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b03t00s");
		return this.aa83b03t00Service.filter(filterAa83b03t00,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b03t00
	 *            Aa83b03t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa83b03t00
	 *            Aa83b03t00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b03t00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa83b03t00>> search(
			@RequestJsonBody(param = "filter") Aa83b03t00 filterAa83b03t00,
			@RequestJsonBody(param = "search") Aa83b03t00 searchAa83b03t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b03t00Controller.logger
				.info("[POST - search] : Buscar Aa83b03t00s");
		return this.aa83b03t00Service.search(filterAa83b03t00,
				searchAa83b03t00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b03t00
	 *            Aa83b03t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa83b03t00 filterAa83b03t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b03t00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b03t00s");
		this.aa83b03t00Service.removeMultiple(filterAa83b03t00,
				jqGridRequestDto, false);
		Aa83b03t00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b03t00
	 *            Aa83b03t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b03t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b03t00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa83b03t00 filterAa83b03t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b03t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b03t00s jerarquia");
		return this.aa83b03t00Service.jerarquia(filterAa83b03t00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa83b03t00
	 *            Aa83b03t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b03t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b03t00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa83b03t00 filterAa83b03t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b03t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b03t00s jerarquia - Hijos");
		return this.aa83b03t00Service.jerarquiaChildren(filterAa83b03t00,
				jqGridRequestDto);
	}

	// Combo Tipos de solicitud
	/**
	 * COMBO SIMPLE para Tipos de solicitud
	 */
	interface Aa83b03t00MixIn {
		@JsonProperty("value")
		int getId003();


		@JsonProperty("label")
		int getDescEs003();

	}
	
	
	//if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
	//		.getLanguage()))
		
	@Json(mixins = { @JsonMixin(target = Aa83b03t00.class, mixin = Aa83b03t00MixIn.class) })
			
	@RequestMapping(value = "comboSol", method = RequestMethod.GET)
	public @ResponseBody ()
	List<Aa83b03t00> getComboSolRemote(@RequestParam(value = "vivienda", required = false) String vivienda) {
//		try {
//			Thread.sleep(1000);
//		} catch (InterruptedException e) {
//			Aa83b03t00Controller.logger.error ("[Aa83b03t00Controller Exception]"+e.getMessage());
//		}
		
		Aa83b03t00 filtro = new Aa83b03t00();
		if (vivienda != null)
			if (vivienda.equals("S"))
				filtro.setTipoSol003(Aa83BConstants.COD_ADE_STR);
		
		
		List<Aa83b03t00> lista = aa83b03t00Service.findAllLike(filtro,null, false);
		
		List<Aa83b03t00> listaReturn = new ArrayList<Aa83b03t00>();;
		for (int i=0; i <lista.size();i++)
		{
			if (lista.get(i).getId003() != 0)
			{
				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage()))
				{
					lista.get(i).setDescEs003(lista.get(i).getDescEu003());
				}
				listaReturn.add(lista.get(i));
			}
		}
		return listaReturn;
	}

}
