package com.ejie.aa83b.control;

import com.ejie.aa83b.service.Aa83b01t00Service;
import com.ejie.x38.control.bind.annotation.Json;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.x38.json.JsonMixin;

import java.util.ArrayList;
import java.util.List;

import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa83b.control.Aa83b14t00Controller.Aa83b14t00MixIn;
import com.ejie.aa83b.model.Aa83b01t00;
import com.ejie.aa83b.model.Aa83b03t00;
import com.ejie.aa83b.model.Aa83b14t00;
import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Aa83b01t00Controller generated by UDA, 29-dic-2015 13:41:11.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa83b01t00")
public class Aa83b01t00Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b01t00Controller.class);

	@Autowired
	private Aa83b01t00Service aa83b01t00Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param id001
	 *            Integer
	 * @param idTipoSol
	 *            Integer
	 * @return Aa83b01t00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id001}/{idTipoSol}", method = RequestMethod.GET)
	public @ResponseBody
	Aa83b01t00 get(@PathVariable Integer id001, @PathVariable Integer idTipoSol) {
		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		aa83b01t00.setId001(id001);
		aa83b01t00.setIdTipoSol(idTipoSol);
		aa83b01t00 = this.aa83b01t00Service.find(aa83b01t00);
		Aa83b01t00Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa83b01t00 por PK");
		return aa83b01t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa83b01t00
	 *            Aa83b01t00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa83b01t00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b01t00> getAll(@ModelAttribute Aa83b01t00 filterAa83b01t00) {
		Aa83b01t00Controller.logger
				.info("[GET - find_ALL] : Obtener Aa83b01t00 por filtro");
		return this.aa83b01t00Service.findAll(filterAa83b01t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa83b01t00
	 *            Aa83b01t00 Bean que contiene la informacion a modificar.
	 * @return Aa83b01t00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa83b01t00 edit(@RequestBody Aa83b01t00 aa83b01t00) {
		Aa83b01t00 aa83b01t00Aux = this.aa83b01t00Service.update(aa83b01t00);
		Aa83b01t00Controller.logger
				.info("[PUT] : Aa83b01t00 actualizado correctamente");
		return aa83b01t00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa83b01t00
	 *            Aa83b01t00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa83b01t00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa83b01t00 add(@RequestBody Aa83b01t00 aa83b01t00) {
		Aa83b01t00 aa83b01t00Aux = this.aa83b01t00Service.add(aa83b01t00);
		Aa83b01t00Controller.logger
				.info("[POST] : Aa83b01t00 insertado correctamente");
		return aa83b01t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param id001
	 *            Integer
	 * @param idTipoSol
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Aa83b01t00 Bean eliminado.
	 */
	@RequestMapping(value = "/{id001}/{idTipoSol}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa83b01t00 remove(@PathVariable Integer id001,
			@PathVariable Integer idTipoSol) {
		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		aa83b01t00.setId001(id001);
		aa83b01t00.setIdTipoSol(idTipoSol);
		this.aa83b01t00Service.remove(aa83b01t00);
		Aa83b01t00Controller.logger
				.info("[DELETE] : Aa83b01t00 borrado correctamente");
		return aa83b01t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b01t00Controller.logger.info("[GET - View] : aa83b01t00");
		return "aa83b01t00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b01t00
	 *            Aa83b01t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b01t00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b01t00> filter(
			@RequestJsonBody(param = "filter") Aa83b01t00 filterAa83b01t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b01t00Controller.logger
				.info("[POST - filter] : Obtener Aa83b01t00s");
		return this.aa83b01t00Service.filter(filterAa83b01t00,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b01t00
	 *            Aa83b01t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa83b01t00
	 *            Aa83b01t00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b01t00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa83b01t00>> search(
			@RequestJsonBody(param = "filter") Aa83b01t00 filterAa83b01t00,
			@RequestJsonBody(param = "search") Aa83b01t00 searchAa83b01t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b01t00Controller.logger
				.info("[POST - search] : Buscar Aa83b01t00s");
		return this.aa83b01t00Service.search(filterAa83b01t00,
				searchAa83b01t00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b01t00
	 *            Aa83b01t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa83b01t00 filterAa83b01t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b01t00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b01t00s");
		this.aa83b01t00Service.removeMultiple(filterAa83b01t00,
				jqGridRequestDto, false);
		Aa83b01t00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b01t00
	 *            Aa83b01t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b01t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b01t00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa83b01t00 filterAa83b01t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b01t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b01t00s jerarquia");
		return this.aa83b01t00Service.jerarquia(filterAa83b01t00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa83b01t00
	 *            Aa83b01t00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b01t00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa83b01t00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa83b01t00 filterAa83b01t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b01t00Controller.logger
				.info("[POST - jerarquia] : Obtener Aa83b01t00s jerarquia - Hijos");
		return this.aa83b01t00Service.jerarquiaChildren(filterAa83b01t00,
				jqGridRequestDto);
	}

	// Combo Fases
	/**
	 * COMBO SIMPLE para Tipos de solicitud
	 */
	interface Aa83b01t00MixIn {
		@JsonProperty("value")
		int getId001();

		@JsonProperty("label")
		int getDescEs001();
	}

	@Json(mixins = { @JsonMixin(target = Aa83b01t00.class, mixin = Aa83b01t00MixIn.class) })
	@RequestMapping(value = "comboFase", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b01t00> comboFaseRemote(@RequestParam(value = "comboLisCerradas", required = true) String soloAbiertas) {
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83b01t00Controller.logger.error ("[Aa83b01t00Controller Exception]"+e.getMessage());
		}
		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		aa83b01t00.setIdTipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
		List<Aa83b01t00> lista = aa83b01t00Service.findAllLike(aa83b01t00, null, null);
		List<Aa83b01t00> listaReturn = new ArrayList<Aa83b01t00>();;
		for (int i=0; i <lista.size();i++)
		{
			if (lista.get(i).getId001() != 0 )
			{
				if ("S".equalsIgnoreCase(soloAbiertas)){
					if (lista.get(i).getId001() != 3){
						if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage()))
						{
							lista.get(i).setDescEs001(lista.get(i).getDescEu001());
						}
						listaReturn.add(lista.get(i));
					}
				} else {
					if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage()))
					{
						lista.get(i).setDescEs001(lista.get(i).getDescEu001());
					}
					listaReturn.add(lista.get(i));					
				}
			}
		}
		return listaReturn;
	}

	@Json(mixins = { @JsonMixin(target = Aa83b01t00.class, mixin = Aa83b01t00MixIn.class) })
	@RequestMapping(value = "comboFaseTodas", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83b01t00> comboFaseTodas() {
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83b01t00Controller.logger.error ("[Aa83b01t00Controller Exception]"+e.getMessage());
		}
		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		aa83b01t00.setIdTipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));//por poner una, porque es igual para todas
		
		List<Aa83b01t00> lista = aa83b01t00Service.findAllLikeTodas(aa83b01t00, null, null);
		List<Aa83b01t00> listaReturn = new ArrayList<Aa83b01t00>();;
		for (int i=0; i <lista.size();i++)
		{
			if (lista.get(i).getId001() != 0)
			{
				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage()))
				{
					lista.get(i).setDescEs001(lista.get(i).getDescEu001());
				}
				listaReturn.add(lista.get(i));
			}
		}
		
		return listaReturn;
	}
}
