package com.ejie.aa83b.util.xml;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.Aa83b12t00;
import com.ejie.aa83b.model.Aa83b18t00;
import com.ejie.aa83b.model.Aa83b19t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b21v00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b31v01;
import com.ejie.aa83b.model.Aa83b32t00;
import com.ejie.aa83b.model.Aa83b33t00;
import com.ejie.aa83b.model.Aa83bBusquedaComunicaciones;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;

public class Aa83bXMLGenerator {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bXMLGenerator.class);

	public static Aa83bXMLGenerator getInstance() {
		return new Aa83bXMLGenerator();
	}

	public String generateXMLAcuses(
			ArrayList<Aa83bBusquedaComunicaciones> listaAcuses) {

		Aa83bXMLGenerator.logger.info("[generateXMLAcuses] INICIO=");

		StringBuffer xml = new StringBuffer();
		xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);

		Aa83bXMLGenerator.logger.info("[generateXMLAcuses] listaAcuses.size()="
				+ listaAcuses.size());

		if (listaAcuses.size() > 0) {
			xml.append(Aa83bXMLConstants.CABECERA_ACUSE);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);
			// Por cada acuse
			for (int i = 0; i < listaAcuses.size(); i++) {
				xml.append(Aa83bXMLConstants.ITEM_INICIO);
				xml.append(Aa83bXMLConstants.ITEMS_INICIO);
				xml.append(Aa83bXMLConstants.DEP_EUS);
				xml.append(
						(String) Aa83bUtilProperties.getProperty("DEPT_EU_1"))
						.append(" ")
						.append((String) Aa83bUtilProperties
								.getProperty("DEPT_EU_2"));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.DEP_CAS);
				xml.append(
						(String) Aa83bUtilProperties.getProperty("DEPT_ES_1"))
						.append(" ")
						.append((String) Aa83bUtilProperties
								.getProperty("DEPT_ES_2"));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.VICE_CAS);
				xml.append((String) Aa83bUtilProperties
						.getProperty("DEPT_ES_3"));
				xml.append(
						(String) Aa83bUtilProperties.getProperty("DEPT_ES_4"))
						.append(" ")
						.append((String) Aa83bUtilProperties
								.getProperty("DEPT_ES_5"));
				;
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.VICE_EUS);
				xml.append((String) Aa83bUtilProperties
						.getProperty("DEPT_EU_3"));
				xml.append(
						(String) Aa83bUtilProperties.getProperty("DEPT_EU_4"))
						.append(" ")
						.append((String) Aa83bUtilProperties
								.getProperty("DEPT_EU_5"));
				;
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				Aa83bBusquedaComunicaciones acuse = new Aa83bBusquedaComunicaciones();
				acuse = (Aa83bBusquedaComunicaciones) listaAcuses.get(i);

				Aa83bXMLGenerator.logger
						.info("[generateXMLAcuses] (String)acuse.getReferencia()="
								+ (String) acuse.getReferencia());

				xml.append(Aa83bXMLConstants.REF);
				xml.append((String) Aa83bUtilidades.tildesSinHtml(null == acuse.getReferencia() ? "" : (String) acuse.getReferencia()));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.APLIC);
				xml.append((String) Aa83bUtilidades.tildesSinHtml(Aa83bUtilProperties.getProperty("TITULO_APLIC_ES")));// this.langEsProperties.getProperty("NombreApp"));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.RAZON);
				xml.append((String) Aa83bUtilidades.tildesSinHtml(null == acuse.getRazon()? "" : (String) acuse.getRazon()));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.DIR);
				xml.append((String) Aa83bUtilidades.tildesSinHtml(null == acuse.getDomicilio()? "" :(String) acuse.getDomicilio()));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.CPOSTAL);
				xml.append((String) acuse.getCpostal());
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.LOCALIDAD);
				xml.append((String) Aa83bUtilidades.tildesSinHtml(null == acuse.getLocalidad()? "" :(String) acuse.getLocalidad()));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.PROVINCIA);
				xml.append((String) Aa83bUtilidades.tildesSinHtml(null == acuse.getProvincia()? "" :(String) acuse.getProvincia()));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.NUMNOTIF);
				xml.append((new Integer(i + 1).toString()));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.ITEMS_FIN);
				xml.append(Aa83bXMLConstants.ITEM_FIN);

			}
			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		}
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE);
		Aa83bXMLGenerator.logger
				.info("[generateXMLAcuses] INICIO xml **********************************");

		Aa83bXMLGenerator.logger.info("[generateXMLAcuses] xml="
				+ xml.toString());
		Aa83bXMLGenerator.logger
				.info("[generateXMLAcuses] F xml **********************************");
		return xml.toString();
	}

	public String generateXMLRelacionAcuses(
			ArrayList<Aa83bBusquedaComunicaciones> listaRelAcuses) {

		StringBuffer xml = new StringBuffer();

		xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);

		xml.append(Aa83bXMLConstants.TEMPLATE_CAB);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.CAB_DEP_EU);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_1"))
				.append(" ")
				.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_2"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CAB_DEP_ES);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_1"))
				.append(" ")
				.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_2"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CAB_VICE_EU);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_3"));
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4"))
				.append(" ")
				.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_5"));
		;
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CAB_VICE_ES);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3"));
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4"))
				.append(" ")
				.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_5"));
		;
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		xml.append(Aa83bXMLConstants.CABECERA_REL_ACUSE);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		// Por cada acuse
		for (int i = 0; i < listaRelAcuses.size(); i++) {

			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			Aa83bBusquedaComunicaciones relAcuse = new Aa83bBusquedaComunicaciones();
			relAcuse = (Aa83bBusquedaComunicaciones) listaRelAcuses.get(i);

			xml.append(Aa83bXMLConstants.NUMNOTIF);
			xml.append((new Integer(i + 1).toString()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.REF);
			xml.append((String) relAcuse.getReferencia());
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.RAZON);
			xml.append((String) Aa83bUtilidades.tildesSinHtml(null == relAcuse.getRazon() ? "" :(String) relAcuse.getRazon()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DIR);
			xml.append((String) Aa83bUtilidades.tildesSinHtml(null == relAcuse.getDomicilio() ? "" :(String) relAcuse.getDomicilio()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.LOCALIDAD);
			xml.append((String) Aa83bUtilidades.tildesSinHtml(null == relAcuse.getLocalidad() ? "" :(String) relAcuse.getLocalidad()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.PROVINCIA);
			xml.append((String) Aa83bUtilidades.tildesSinHtml(null == relAcuse.getProvincia() ? "" :(String) relAcuse.getProvincia()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);
		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE);

		Aa83bXMLGenerator.logger.info("[generateXMLRelacionAcuses] xml="
				+ xml.toString());

		return xml.toString();
	}

	public String generateXMLEtiquetas(
			ArrayList<Aa83bBusquedaComunicaciones> listaEtiquetas) {

		Aa83bXMLGenerator.logger.info("[generateXMLEtiquetas] INICIO=");

		StringBuffer xml = new StringBuffer();

		xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.CABECERA_ETIQUETA);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		// Por cada etiqeueta
		for (int i = 0; i < listaEtiquetas.size(); i++) {

			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			Aa83bBusquedaComunicaciones etiqueta = new Aa83bBusquedaComunicaciones();
			etiqueta = (Aa83bBusquedaComunicaciones) listaEtiquetas.get(i);

			xml.append(Aa83bXMLConstants.REF);
			xml.append((String) etiqueta.getReferencia());
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.RAZON);
			if (etiqueta.getRazon()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) etiqueta.getRazon()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DIR);
			if (etiqueta.getDomicilio()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) etiqueta.getDomicilio()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CPOSTAL);
			xml.append((String) etiqueta.getCpostal());
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.LOCALIDAD);
			if (etiqueta.getLocalidad()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) etiqueta.getLocalidad()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.PROVINCIA);
			if (etiqueta.getProvincia()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) etiqueta.getProvincia()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.NUMNOTIF);
			xml.append((new Integer(i + 1).toString()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE);
		Aa83bXMLGenerator.logger.info("[generateXMLEtiquetas] xml="
				+ xml.toString());

		return xml.toString();
	}

	public String generateXMLEtiquetasCarpetas(
			ArrayList<Aa83bBusquedaComunicaciones> listaEtiquetasCarpetas) {

		Aa83bXMLGenerator.logger.info("[generateXMLEtiquetasCarpetas] INICIO=");

		StringBuffer xml = new StringBuffer();
		xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);

		Aa83bXMLGenerator.logger
				.info("[generateXMLEtiquetasCarpetas] listaEtiquetasCarpetas()="
						+ listaEtiquetasCarpetas.size());
		xml.append(Aa83bXMLConstants.CABECERA_ETIQUETA_CARP);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		// Por cada etiqeueta
		for (int i = 0; i < listaEtiquetasCarpetas.size(); i++) {

			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			Aa83bBusquedaComunicaciones etiquetasCarp = new Aa83bBusquedaComunicaciones();
			etiquetasCarp = (Aa83bBusquedaComunicaciones) listaEtiquetasCarpetas
					.get(i);

			xml.append(Aa83bXMLConstants.REF);
			xml.append((String) etiquetasCarp.getReferencia());
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.RAZON);
			if (etiquetasCarp.getRazon()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) etiquetasCarp.getRazon()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE);
		Aa83bXMLGenerator.logger.info("[generateXMLEtiquetasCarpetas] xml="
				+ xml.toString());

		return xml.toString();
	}

	public String generateXMLAdjuntoRemito(
			ArrayList<Aa83bBusquedaComunicaciones> listaAdjuntoRemito,
			HashMap<String, String> seleccionadosRegistro, boolean telematica) {

		Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] INICIO=");

		Date fechoy = new Date();
		String fechaCas = (String) new SimpleDateFormat("dd-MM-yyyy")
				.format(fechoy);
		String fechaEus = (String) new SimpleDateFormat("yyyy-MM-dd")
				.format(fechoy);

		StringBuffer xml = new StringBuffer();
		xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);

		// Inicio cabecera de la pagina
		xml.append(Aa83bXMLConstants.TEMPLATE_CAB);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.CAB_DEP_EU);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_1")).append(" ").append((String) Aa83bUtilProperties.getProperty("DEPT_EU_2"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CAB_DEP_ES);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_1")).append(" ").append((String) Aa83bUtilProperties.getProperty("DEPT_ES_2"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CAB_VICE_EU);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_3"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CAB_DIRECC_EU);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4")).append(" ").append((String) Aa83bUtilProperties.getProperty("DEPT_EU_5"));
		
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CAB_VICE_ES);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CAB_DIRECC_ES);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4")).append(" ").append((String) Aa83bUtilProperties.getProperty("DEPT_ES_5"));
		
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Fin cabecera de la pagina

		xml.append(Aa83bXMLConstants.CABECERA_ADJUNTO_REMITO);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		// Por cada adjunto remito
		for (int i = 0; i < listaAdjuntoRemito.size(); i++) {

			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] Por cada adjunto remito="	+ i);
			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] listaAdjuntoRemito()="+ listaAdjuntoRemito.size());

			Aa83bBusquedaComunicaciones adjuntoRemito = new Aa83bBusquedaComunicaciones();
			adjuntoRemito = (Aa83bBusquedaComunicaciones) listaAdjuntoRemito.get(i);

			xml.append(Aa83bXMLConstants.DEP_EUS);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_1")).append(" ").append((String) Aa83bUtilProperties.getProperty("DEPT_EU_2"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DEP_CAS);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_1")).append(" ").append((String) Aa83bUtilProperties.getProperty("DEPT_ES_2"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.VICE_EUS);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_3"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CAB_DIRECC_EU);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4")).append(" ").append((String) Aa83bUtilProperties.getProperty("DEPT_EU_5"));
			
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.VICE_CAS2);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CAB_DIRECC_ES);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4")).append(" ").append((String) Aa83bUtilProperties.getProperty("DEPT_ES_5"));
			
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			String numSalida = (String) seleccionadosRegistro.get((String) adjuntoRemito.getReferencia());
			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] (String) adjuntoRemito.getReferencia()="+ (String) adjuntoRemito.getReferencia());
			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] numSalida)=" + numSalida);
			xml.append(Aa83bXMLConstants.NUMSALIDA);
			xml.append(numSalida);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.RAZON);
			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] adjuntoRemito.getRazon())=" + adjuntoRemito.getRazon());
			
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) adjuntoRemito.getRazon()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append(Aa83bXMLConstants.TIPODOCES);
			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] adjuntoRemito.gettipodoc=" + adjuntoRemito.getDescTramiteEs());
			
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) adjuntoRemito.getDescTramiteEs()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append(Aa83bXMLConstants.TIPODOCEU);
			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] adjuntoRemito.gettipodoc=" + adjuntoRemito.getDescTramiteEu());
			
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) adjuntoRemito.getDescTramiteEu()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DIR);
			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] adjuntoRemito.getDomicilio()=" + adjuntoRemito.getDomicilio());
			if (telematica)
				xml.append("");
			else
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) adjuntoRemito.getDomicilio()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CPOSTAL);
			if (telematica)
				xml.append("");
			else
				xml.append((String) adjuntoRemito.getCpostal());
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.LOCALIDAD);
			Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] adjuntoRemito.getLocalidad()=" + adjuntoRemito.getLocalidad());
			if (telematica)
				xml.append("");
			else if (adjuntoRemito.getLocalidad()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) adjuntoRemito.getLocalidad()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.PROVINCIA);
			if (telematica)
				xml.append("");
			else if (adjuntoRemito.getProvincia()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) adjuntoRemito.getProvincia()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.FECHA);
			xml.append(fechaCas);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.REF);
			xml.append((String) adjuntoRemito.getReferencia());
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.RAZON);
			if (adjuntoRemito.getRazon()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) adjuntoRemito.getRazon()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.FECHACAS);
			xml.append(fechaCas);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.FECHAEUS);
			xml.append(fechaEus);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);
		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE);

		// Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] INICIO xml **********************************");
		// Aa83bXMLGenerator.logger.info("#############################################################################");
		// Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] xml="+
		// xml.toString());
		// Aa83bXMLGenerator.logger.info("#############################################################################");
		// Aa83bXMLGenerator.logger.info("[generateXMLAdjuntoRemito] F xml **********************************");

		return xml.toString();
	}

	/**
	 * @param id int
	 * @param anyo Long
	 * @param numDoc String
	 * @param nombre String
	 * @param ape1 String
	 * @param ape2 String
	 * @param literalTipo String
	 * @param a83b12t00 Aa83b12t00
	 * @param a83bPais A83bPais
	 * @param docusInf String
	 * @param docusInfEu String
	 * @param aa83b19t00 Aa83b19t00
	 * @param imagenQR String
	 * @param literalEs String
	 * @param literalEu String
	 * @param literalQR String
	 * @return String
	 */
	public String generateXMLReqSubsana(int id, Long anyo, String numDoc,
			String nombre, String ape1, String ape2, String literalTipo,
			Aa83b12t00 a83b12t00, A83bPais a83bPais, String docusInf,
			String docusInfEu, Aa83b19t00 aa83b19t00, String imagenQR,
			String literalEs, String literalEu, String literalQR) {
		StringBuffer xml = new StringBuffer();
		try {
			Aa83bXMLGenerator.logger.info("[generateXMLReqSubsana] INICIO=");

			xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
			xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
			xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);

			// Logo
			xml.append(Aa83bXMLConstants.CABECERA_LOGO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.CABECERA_DEPT_EU1);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_1"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_DEPT_EU2);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_2"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_DEPT_ES1);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_1"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_DEPT_ES2);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_2"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU1);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_3"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU2);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU3);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_5"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES1);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES2);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES3);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_5"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
			Aa83bXMLGenerator.logger
					.info("[generateXMLReqSubsana] FIN CABECERA");
			// MARGENES
			xml.append(Aa83bXMLConstants.CABECERA_MARGENES);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.MARGENES_TEXTO_ES);
			xml.append(literalEs);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.MARGENES_TEXTO_EU);
			xml.append(literalEu);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.MARGENES_TEXTO_QR);
			xml.append(literalQR);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
			// Datos Pers
			xml.append(Aa83bXMLConstants.CABECERA_DATOS_PERS);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			Date fechoy = new Date();
			xml.append(Aa83bXMLConstants.DATOS_PERS_FECHA);
			xml.append((String) new SimpleDateFormat(Aa83BConstants.ES_PATTERN)
					.format(fechoy));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DATOS_PERS_COD_SOL);
			xml.append(literalTipo + " " + anyo + " " + id);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DATOS_PERS_NOM_SOLIC);
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) nombre
					+ " " + ape1 + " " + ape2));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DATOS_PERS_DOC_SOLIC);
			xml.append((String) Aa83bUtilidades
					.tildesSinHtml((String) a83b12t00.getDescEs012() + " "
							+ numDoc));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DATOS_PERS_NACIONALIDAD);
			xml.append(Aa83bXMLConstants.CDATA_INI);
			xml.append((String) Aa83bUtilidades
					.tildesSinHtml(null == a83bPais ? "" : a83bPais.getDs_o()));
			xml.append(Aa83bXMLConstants.CDATA_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
			Aa83bXMLGenerator.logger.info("[generateXMLReqSubsana] FIN DATOS PERSONALES");
			// Fin Datos Pers

			// Datos Texto
			xml.append(Aa83bXMLConstants.CABECERA_DATOS_TEXTO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.TEXTO_NOMBRE);
			if (nombre!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) nombre+ " " + ape1 + " " + ape2));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.TEXTO_DIR_ES);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4")
					+ " " + Aa83bUtilProperties.getProperty("DEPT_ES_5"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.TEXTO_DIR_EU);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4")
					+ " " + Aa83bUtilProperties.getProperty("DEPT_EU_5"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
			Aa83bXMLGenerator.logger.info("[generateXMLReqSubsana] FIN TEXTO");
			// Fin Datos Texto

			// Doc a subsanar (bucle
			String[] docus = docusInf.split(":");
			Aa83bXMLGenerator.logger.info("docus:" + docus.length);

			xml.append(Aa83bXMLConstants.CABECERA_DOCSUB_ES);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			for (int d = 0; d < docus.length; d++) {
				Aa83bXMLGenerator.logger.info("docus[d]:" + docus[d]);

				xml.append(Aa83bXMLConstants.ITEM_INICIO);
				xml.append(Aa83bXMLConstants.ITEMS_INICIO);

				xml.append(Aa83bXMLConstants.DOC_ES);
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) " - " + docus[d]));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.ITEMS_FIN);
				xml.append(Aa83bXMLConstants.ITEM_FIN);

			}
			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

			// Doc a subsanar (bucle
			String[] docusEu = docusInfEu.split(":");
			Aa83bXMLGenerator.logger.info("docus:" + docusEu.length);

			xml.append(Aa83bXMLConstants.CABECERA_DOCSUB_EU);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			for (int d = 0; d < docusEu.length; d++) {
				Aa83bXMLGenerator.logger.info("docusEu[d]:" + docus[d]);

				xml.append(Aa83bXMLConstants.ITEM_INICIO);
				xml.append(Aa83bXMLConstants.ITEMS_INICIO);

				xml.append(Aa83bXMLConstants.DOC_EU);
				xml.append((String) Aa83bUtilidades
						.tildesSinHtml((String) " - " + docusEu[d]));
				xml.append(Aa83bXMLConstants.ITEM_FIN);

				xml.append(Aa83bXMLConstants.ITEMS_FIN);
				xml.append(Aa83bXMLConstants.ITEM_FIN);

			}

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

			// Fin Doc a subsanar
			Aa83bXMLGenerator.logger.info("[generateXMLReqSubsana] FIN FIRMA");
			// Bloque Firma
			xml.append(Aa83bXMLConstants.CABECERA_FIRMA);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.FIRMA_FECHA);
			xml.append((String) (String) new SimpleDateFormat(Aa83BConstants.ES_PATTERN)
					.format(fechoy));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.FIRMA_NUM_TRABAJADOR);
			if (aa83b19t00.getNumEmp() != null)
				xml.append((String) aa83b19t00.getNumEmp());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append(Aa83bXMLConstants.NOMBRE_TRABAJADOR);
			xml.append((String) aa83b19t00.getNombre019().concat(" ").concat(aa83b19t00.getApel1019()).concat(" ").concat(aa83b19t00.getApel2019()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.FIRMA_CARGO_EU);
			if (aa83b19t00.getCargoEs() != null)
				xml.append((String) aa83b19t00.getCargoEu());
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.FIRMA_CARGO_ES);
			if (aa83b19t00.getCargoEs()!=null)
				xml.append((String) Aa83bUtilidades.tildesSinHtml((String) aa83b19t00.getCargoEs()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.FIRMA_VICECONSEJERIA);
			xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3")
					+ "/" + Aa83bUtilProperties.getProperty("DEPT_EU_3"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
			// Fin Bloque Firma

			// Fin DOC
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
			xml.append(Aa83bXMLConstants.FIN_TEMPLATE);
			Aa83bXMLGenerator.logger.info("[generateXMLReqSubsana] xml="
					+ xml.toString());
		} catch (Exception e) {
			Aa83bXMLGenerator.logger.info("error==>" + e.toString());
		}
		return xml.toString();
	}

	public String generateXMLInformeEsfuerzo(Aa83b23t00 esf,
			Aa83b12t00 a83b12t00, A83bPais a83bPais,
			Aa83b19t00 aa83b19t00Tecnico, Aa83b19t00 aa83b19t00Director,
			String motivoSolicitud, String estadoSolicitud,
			String actividadLaboral, String inclusionSocial) {

		Aa83bXMLGenerator.logger.info("[generateXMLInformeEsfuerzo] INICIO=");
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();

		StringBuffer xml = new StringBuffer(Aa83BConstants.SETETENTAYSIETE);
		xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);
		// Logo
		xml.append(Aa83bXMLConstants.CABECERA_LOGO);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.CABECERA_DEPT_EU1);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_1"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_DEPT_EU2);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_2"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_DEPT_ES1);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_1"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_DEPT_ES2);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_2"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU1);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_3"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU2);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU3);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_5"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES1);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES2);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES3);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_5"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Datos Pers
		xml.append(Aa83bXMLConstants.CABECERA_DATOS_PERS);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		Date fechoy = new Date();
		xml.append(Aa83bXMLConstants.DATOS_PERS_FECHA);
		// xml.append((String) new
		// SimpleDateFormat(Aa83BConstants.ES_PATTERN).format(fechoy));
		xml.append((String) (null == esf.getFecha023()? "" :esf.getFecha023().substring(0, 10)));

		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_COD_SOL);
		xml.append((String) Aa83BConstants.COD_ESF_STR + " "
				+ esf.getIdAno023() + " " + esf.getId023());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_NOM_SOLIC);
		if (esf.getNombre023()!=null)
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) esf
				.getNombre023()
				+ " "
				// + esf.getApel1023()
				+ (String) (null == esf.getApel1023() ? "" : esf.getApel1023())
				// + " " + esf.getApel2023()));
				+ " "
				+ (String) (null == esf.getApel2023() ? "" : esf.getApel2023())));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_DNI);
		if ( a83b12t00.getDescEs012()!=null)
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) a83b12t00.getDescEs012() + " " + esf.getNumDoc023()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_NACIONALIDAD);
		xml.append(Aa83bXMLConstants.CDATA_INI);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == a83bPais ? ""
				: a83bPais.getDs_o()));
		xml.append(Aa83bXMLConstants.CDATA_FIN);
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Fin Datos Pers

		// Datos sol
		xml.append(Aa83bXMLConstants.CABECERA_DATOS_SOL);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.DATOS_SOL_MOTIVO_SOLICITUD);
		xml.append((String) Aa83bUtilidades
				.tildesSinHtml(null == motivoSolicitud ? "" : motivoSolicitud));
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		xml.append(Aa83bXMLConstants.DATOS_SOL_MOTIVO_FEC_CAD);
		xml.append(esf.getFecCadTarjeta023());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_SOL_TARJETA_ID);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(Aa83bUtilProperties
				.getProperty("DATOS_IDENTIDAD")));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_SOL_ESTADO_SOL);
		xml.append((String) Aa83bUtilidades
				.tildesSinHtml(null == estadoSolicitud ? "" : estadoSolicitud));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_SOL_RESOL_FAV);
		xml.append((String) aa83bSolicitudesUtil.getDescResultadoResolucion(esf.getResolFavorable023()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		
		xml.append(Aa83bXMLConstants.DATOS_SOL_CONTRATANTE);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == esf
				.getContratante023() ? "" : esf.getContratante023()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_SOL_CONTRATO);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == esf
				.getContratoDesc023() ? "" : esf.getContratoDesc023()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_SOL_TIEMPO_RESIDENCIA);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == esf
				.getTResiAcreditado023() ? "" : esf.getTResiAcreditado023()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Fin Datos sol
		xml.append(Aa83bXMLConstants.CABECERA_ACTIVIDAD_LABORAL);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);
		String[] docus = actividadLaboral.split(":");
		for (int d = 0; d < docus.length; d++) {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.DOC_ES);
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) " - "
					+ docus[d]));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		xml.append(Aa83bXMLConstants.CABECERA_INCLUSION_SOCIAL);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);
		docus = inclusionSocial.split(":");
		for (int d = 0; d < docus.length; d++) {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.DOC_ES);
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) " - "
					+ docus[d]));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		// Documentos
		xml.append(Aa83bXMLConstants.CABECERA_DOCUMENTOS);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.DOCUMENTOS_AYUNTAMIENTO);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == esf
				.getLocalidadEmp023() ? "" : esf.getLocalidadEmp023()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DOCUMENTOS_FECHA);
		xml.append(esf.getFechaEmpadron023());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DOCUMENTOS_FECHA_DESDE);
		xml.append(esf.getFechaEmisionPadron023());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DOCUMENTOS_DIRECCION);
		xml.append(Aa83bXMLConstants.CDATA_INI);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == esf
				.getDireccionEmpadron023() ? "" : esf.getDireccionEmpadron023()));
		xml.append(Aa83bXMLConstants.CDATA_FIN);
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Fin Documentos
		// Datos Texto
		xml.append(Aa83bXMLConstants.CABECERA_DATOS_TEXTO);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.TEXTO_NOMBRE);
		xml.append((String) Aa83bUtilidades.tildesSinHtml((String) esf
				.getNombre023()
				+ " "
				+ (String) (null == esf.getApel1023() ? "" : esf.getApel1023())
				+ " "
				+ (String) (null == esf.getApel1023() ? "" : esf.getApel2023())));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.TEXTO_DIR_ES);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4") + " "
				+ Aa83bUtilProperties.getProperty("DEPT_ES_5"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.TEXTO_DIR_EU);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4") + " "
				+ Aa83bUtilProperties.getProperty("DEPT_EU_5"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Bloque Firma
		xml.append(Aa83bXMLConstants.CABECERA_FIRMA);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.FIRMA_FECHA);
		xml.append((String) (String) new SimpleDateFormat(Aa83BConstants.ES_PATTERN)
				.format(fechoy));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_CARGO_DIR_EU);
		xml.append((String) aa83b19t00Director.getCargoEu());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_CARGO_DIR_ES);
		xml.append((String) Aa83bUtilidades
				.tildesSinHtml(null == aa83b19t00Director.getCargoEs() ? ""
						: aa83b19t00Director.getCargoEs()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_NUM_TRABAJADOR);
		xml.append((String) aa83b19t00Tecnico.getNumEmp());
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		
		xml.append(Aa83bXMLConstants.NOMBRE_TRABAJADOR);
		xml.append((String) aa83b19t00Tecnico.getNombre019().concat(" ").concat(aa83b19t00Tecnico.getApel1019()).concat(" ").concat(aa83b19t00Tecnico.getApel2019()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_CARGO_EU);
		xml.append((String) Aa83bUtilidades
				.tildesSinHtml(null == aa83b19t00Tecnico.getCargoEu() ? ""
						: aa83b19t00Tecnico.getCargoEu()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_CARGO_ES);
		xml.append((String) Aa83bUtilidades
				.tildesSinHtml(null == aa83b19t00Tecnico.getCargoEs() ? ""
						: aa83b19t00Tecnico.getCargoEs()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_DIRECTOR);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(aa83b19t00Director
				.getNombre019()
				+ " "
				+ aa83b19t00Director.getApel1019()
				+ " "
				+ aa83b19t00Director.getApel2019()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_VICECONSEJERIA);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3") + "/"
				+ Aa83bUtilProperties.getProperty("DEPT_EU_3"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Fin Bloque Firma

		// Fin DOC
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE);

		Aa83bXMLGenerator.logger.info("[generateXMLInformeEsfuerzo] xml="
				+ xml.toString());
		return xml.toString();
	}

	public String generateXMLInformeArraigo(Aa83b25t00 arr, 
			Aa83b12t00 a83b12t00, A83bPais a83bPais,
			Aa83b19t00 aa83b19t00Tecnicos, Aa83b19t00 aa83b19t00Directores,
			String mediosEconomicos, String identidad, String residencia,
			String formacion, String participacion) {

		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		
		Aa83bXMLGenerator.logger.info("[generateXMLInformeArraigo] INICIO=");

		StringBuffer xml = new StringBuffer();
		xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);
		// Logo
		xml.append(Aa83bXMLConstants.CABECERA_LOGO);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.CABECERA_DEPT_EU1);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_1"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_DEPT_EU2);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_2"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_DEPT_ES1);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_1"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_DEPT_ES2);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_2"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU1);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_3"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU2);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_EU3);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_5"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES1);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES2);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.CABECERA_VICECONSEJERIA_ES3);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_5"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Datos Pers
		xml.append(Aa83bXMLConstants.CABECERA_DATOS_PERS);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		Date fechoy = new Date();
		xml.append(Aa83bXMLConstants.DATOS_PERS_FECHA);
		// Cambio la fecha de hoy por la de Solictud
		// xml.append((String) new
		// SimpleDateFormat(Aa83BConstants.ES_PATTERN).format(fechoy));
		// xml.append((String) (arr.getFecha025())); 2016-05-11 00:00:00
		xml.append((String) null == arr.getFecha025()? "" :arr.getFecha025().substring(0, 10));

		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_COD_SOL);
		xml.append((String) Aa83BConstants.COD_ARR_STR + " "
				+ arr.getIdAno025() + " " + arr.getId025());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_NOM_SOLIC);
		xml.append((String) Aa83bUtilidades.tildesSinHtml((String) arr
				.getNombre025()
				+ " "
				+ (String) (null == arr.getApel1025() ? "" : arr.getApel1025())
				// + arr.getApel1025()
				// + " " + arr.getApel2025()));
				+ " "
				+ (String) (null == arr.getApel2025() ? "" : arr.getApel2025())));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_DOC);
		xml.append((String) Aa83bUtilidades.tildesSinHtml((String) a83b12t00
				.getDescEs012() + " " + arr.getNumDoc025()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_FEC_NAC);
		xml.append(null == arr.getFNac025() ? "" : arr.getFNac025());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DATOS_PERS_NACIONALIDAD);
		xml.append(Aa83bXMLConstants.CDATA_INI);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == a83bPais ? ""
				: a83bPais.getDs_o()));
		xml.append(Aa83bXMLConstants.CDATA_FIN);
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Fin Datos Pers
		// Datos sol
		xml.append(Aa83bXMLConstants.CABECERA_DATOS_SOL);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.DATOS_SOL_TEXTO_CONTRATO);
		if (null != arr.getContratante025() || null != arr.getContratoDesc025()) {
			xml.append(Aa83bUtilProperties.getProperty("MEDIOS_ECONOMICOS"));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DATOS_SOL_CONTRATANTE);
			xml.append(Aa83bUtilProperties.getProperty("CONTRATANTE")
					+ ":"
					+ (String) Aa83bUtilidades.tildesSinHtml(null == arr
							.getContratante025() ? "" : arr.getContratante025()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DATOS_SOL_CONTRATO);
			xml.append(Aa83bUtilProperties.getProperty("CONTRATO")
					+ ":"
					+ (String) Aa83bUtilidades.tildesSinHtml(null == arr
							.getContratoDesc025() ? "" : arr
							.getContratoDesc025()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);
		} else {
			xml.append("");
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DATOS_SOL_CONTRATANTE);
			xml.append((String) Aa83bUtilidades.tildesSinHtml(null == arr
					.getContratante025() ? "" : arr.getContratante025()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.DATOS_SOL_CONTRATO);
			xml.append((String) Aa83bUtilidades.tildesSinHtml(null == arr
					.getContratoDesc025() ? "" : arr.getContratoDesc025()));
			xml.append(Aa83bXMLConstants.ITEM_FIN);
		}

		xml.append(Aa83bXMLConstants.DATOS_SOL_RESOL_FAV);
		xml.append((String) aa83bSolicitudesUtil.getDescResultadoResolucion(arr.getResolFavorable025()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// FIN DATOS SOL

		xml.append(Aa83bXMLConstants.CABECERA_IDENTIDAD);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);
		String[] docus = identidad.split(":");
		for (int d = 0; d < docus.length; d++) {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.DOC_ES);
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) " - "
					+ docus[d]));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		xml.append(Aa83bXMLConstants.CABECERA_MEDIOS_ECONOMICOS);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		docus = mediosEconomicos.split(":");
		for (int d = 0; d < docus.length; d++) {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.DOC_ES);
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) " - "
					+ docus[d]));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		xml.append(Aa83bXMLConstants.CABECERA_RESIDENCIA);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);
		docus = residencia.split(":");
		for (int d = 0; d < docus.length; d++) {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.DOC_ES);
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) " - "
					+ docus[d]));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		xml.append(Aa83bXMLConstants.CABECERA_FORMACION);

		xml.append(Aa83bXMLConstants.ITEMS_INICIO);
		docus = formacion.split(":");
		for (int d = 0; d < docus.length; d++) {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.DOC_ES);
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) " - "
					+ docus[d]));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		xml.append(Aa83bXMLConstants.CABECERA_PARTICIPACION);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);
		docus = participacion.split(":");
		for (int d = 0; d < docus.length; d++) {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append(Aa83bXMLConstants.DOC_ES);
			xml.append((String) Aa83bUtilidades.tildesSinHtml((String) " - "
					+ docus[d]));
			xml.append(Aa83bXMLConstants.ITEM_FIN);

			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);

		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);

		// Documentos
		xml.append(Aa83bXMLConstants.CABECERA_DOCUMENTOS);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.DOCUMENTOS_AYUNTAMIENTO);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == arr
				.getMunicipioEmpadron025DescEs025() ? "" : arr
				.getMunicipioEmpadron025DescEs025()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DOCUMENTOS_FECHA);
		xml.append(arr.getFechaEmpadron025());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DOCUMENTOS_FECHA_DESDE);
		xml.append(arr.getFechaEmisionPadron025());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.DOCUMENTOS_DIRECCION);
		xml.append(Aa83bXMLConstants.CDATA_INI);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(null == arr
				.getDireccionEmpadron025() ? "" : arr.getDireccionEmpadron025()));
		xml.append(Aa83bXMLConstants.CDATA_FIN);
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Fin Documentos
		// Datos Texto
		xml.append(Aa83bXMLConstants.CABECERA_DATOS_TEXTO);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.TEXTO_NOMBRE);
		xml.append((String) Aa83bUtilidades.tildesSinHtml((String) arr
				.getNombre025()
				+ " "
				// + arr.getApel1025()
				+ (String) (null == arr.getApel1025() ? "" : arr.getApel1025())
				// (+ " " + arr.getApel2025()));
				+ " "
				+ (String) (null == arr.getApel2025() ? "" : arr.getApel2025())));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.TEXTO_DIR_ES);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_4") + " "
				+ Aa83bUtilProperties.getProperty("DEPT_ES_5"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.TEXTO_DIR_EU);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_EU_4") + " "
				+ Aa83bUtilProperties.getProperty("DEPT_EU_5"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Bloque Firma
		xml.append(Aa83bXMLConstants.CABECERA_FIRMA);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

		xml.append(Aa83bXMLConstants.FIRMA_FECHA);
		xml.append((String) (String) new SimpleDateFormat(Aa83BConstants.ES_PATTERN)
				.format(fechoy));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_NUM_TRABAJADOR);
		xml.append((String) aa83b19t00Tecnicos.getNumEmp());
		xml.append(Aa83bXMLConstants.ITEM_FIN);
		
		xml.append(Aa83bXMLConstants.NOMBRE_TRABAJADOR);
		xml.append((String) aa83b19t00Tecnicos.getNombre019().concat(" ").concat(aa83b19t00Tecnicos.getApel1019()).concat(" ").concat(aa83b19t00Tecnicos.getApel2019()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_CARGO_EU);
		xml.append((String) aa83b19t00Tecnicos.getCargoEu());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_CARGO_ES);
		xml.append((String) Aa83bUtilidades
				.tildesSinHtml((String) aa83b19t00Tecnicos.getCargoEs()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_CARGO_DIR_EU);
		xml.append((String) aa83b19t00Directores.getCargoEu());
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_CARGO_DIR_ES);
		xml.append((String) Aa83bUtilidades
				.tildesSinHtml((String) aa83b19t00Directores.getCargoEs()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_DIRECTOR);
		xml.append((String) Aa83bUtilidades.tildesSinHtml(aa83b19t00Directores
				.getNombre019()
				+ " "
				+ aa83b19t00Directores.getApel1019()
				+ " " + aa83b19t00Directores.getApel2019()));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.FIRMA_VICECONSEJERIA);
		xml.append((String) Aa83bUtilProperties.getProperty("DEPT_ES_3") + "/"
				+ Aa83bUtilProperties.getProperty("DEPT_EU_3"));
		xml.append(Aa83bXMLConstants.ITEM_FIN);

		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		// Fin Bloque Firma
		Aa83bXMLGenerator.logger.info("[generateXMLInformeArraigo] FIN FIRMA");
		// Fin DOC
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE);
		Aa83bXMLGenerator.logger.info("[generateXMLInformeArraigo] xml="
				+ xml.toString());
		return xml.toString();
	}

	
	public String sXmlExit(String idProc, String procedureName,
			String userNif, String userFullName, String managingId,
			String managingDep) {

		String xml = "<ExitRegistryCreationInfo>" + "<procedureID>"
				+ idProc
				+ "</procedureID>"
				+ "<procedureName>"
				// + "<description>"
				// +
				// "<language locale=\"eu\">Etxebizitzaren egokitasun txostena</language>"
				// +
				// "<language locale=\"es\">Informes de Adecuacin de Vivienda</language>"
				// + "</description>"
				+ procedureName
				+ "</procedureName>"
				+ "<registryTopicCode>"
				+ idProc
				+ "</registryTopicCode>"
				+ "<registrySenderCode>"
				+ managingId
				+ "</registrySenderCode>"
				+ "<managingUnitID>"
				+ managingId
				+ "</managingUnitID>"
				+ "<registryAddreseeOrganID>"
				+ managingId
				+ "</registryAddreseeOrganID>"
				+ "<registryAddreseeOrganName>"
				// + "<description xmlns=\"com/ejie/mbt/xml\">"
				// +
				// "<language locale=\"eu\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// +
				// "<language locale=\"es\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// + "</description>"
				+ managingDep + "</registryAddreseeOrganName>"
				+ "</ExitRegistryCreationInfo>";
		return xml;
	}

	
	// Para el libro de registro

	public String sXmlContextRegistryHAB(String idProc, String procedureName,
			String userNif, String userFullName, String managingId,
			String managingDep) {

		String xml = "<contextRegistry>" + "<procedureID>"
				+ idProc
				+ "</procedureID>"
				+ "<procedureName>"
				// + "<description>"
				// +
				// "<language locale=\"eu\">Etxebizitzaren egokitasun txostena</language>"
				// +
				// "<language locale=\"es\">Informes de Adecuacin de Vivienda</language>"
				// + "</description>"
				+ procedureName
				+ "</procedureName>"
				+ "<registryTopicCode>"
				+ idProc
				+ "</registryTopicCode>"
				+ "<registrySenderId>"
				+ userNif
				+ "</registrySenderId>"
				+ "<registrySenderName>"
				+ "<description>"
				+ "<language locale=\"es\">"
				+ userFullName
				+ "</language>"
				+ "<language locale=\"eu\">"
				+ userFullName
				+ "</language>"
				+ "</description>"
				+ "</registrySenderName>"
				+ "<managingUnitID>"
				+ managingId
				+ "</managingUnitID>"
				+ "<managingUnitName>"
				// + " <description>"
				// +
				// " <language locale=\"eu\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// +
				// "<language locale=\"es\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// + "</description>"
				+ managingDep
				+ "</managingUnitName>"
				+ "<registryAddresseeCode>"
				+ managingId
				+ "</registryAddresseeCode>"
				+ "<registryAddresseeName>"
				// + "<description xmlns=\"com/ejie/mbt/xml\">"
				// +
				// "<language locale=\"eu\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// +
				// "<language locale=\"es\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// + "</description>"
				+ managingDep + "</registryAddresseeName>"
				+ "</contextRegistry>";
		return xml;
	}

	public String sXmlContextRegistryESF(String idProc, String procedureName,
			String userNif, String userFullName, String managingId,
			String managingDep) {

		String xml = "<contextRegistry>" + "<procedureID>"
				+ idProc
				+ "</procedureID>"
				+ "<procedureName>"
				// + "<description>"
				// +
				// "<language locale=\"eu\">Etxebizitzaren egokitasun txostena</language>"
				// +
				// "<language locale=\"es\">Informes de Esfuerzo de Integracin</language>"
				// + "</description>" +
				+ procedureName
				+ "</procedureName>"
				+ "<registryTopicCode>"
				+ idProc
				+ "</registryTopicCode>"
				+ "<registrySenderId>"
				+ userNif
				+ "</registrySenderId>"
				+ "<registrySenderName>"
				+ "<description>"
				+ "<language locale=\"es\">"
				+ userFullName
				+ "</language>"
				+ "<language locale=\"eu\">"
				+ userFullName
				+ "</language>"
				+ "</description>"
				+ "</registrySenderName>"
				+ "<managingUnitID>"
				+ managingId
				+ "</managingUnitID>"
				+ "<managingUnitName>"
				// + " <description>"
				// +
				// " <language locale=\"eu\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// +
				// "<language locale=\"es\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// + "</description>"
				+ managingDep
				+ "</managingUnitName>"
				+ "<registryAddresseeCode>"
				+ managingId
				+ "</registryAddresseeCode>"
				+ "<registryAddresseeName>"
				// + "<description xmlns=\"com/ejie/mbt/xml\">"
				// +
				// "<language locale=\"eu\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// +
				// "<language locale=\"es\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// + "</description>"
				+ managingDep + "</registryAddresseeName>"
				+ "</contextRegistry>";

		return xml;
	}

	public String sXmlContextRegistryARR(String idProc, String procedureName,
			String userNif, String userFullName, String managingId,
			String managingDep) {

		String xml = "<contextRegistry>" + "<procedureID>"
				+ idProc
				+ "</procedureID>"
				+ "<procedureName>"
				// + "<description>"
				// + "<language locale=\"eu\">Errotze txostena</language>"
				// + "<language locale=\"es\">Informes de EArraigo</language>"
				// + "</description>"
				+ procedureName
				+ "</procedureName>"
				+ "<registryTopicCode>"
				+ idProc
				+ "</registryTopicCode>"
				+ "<registrySenderId>"
				+ userNif
				+ "</registrySenderId>"
				+ "<registrySenderName>"
				+ "<description>"
				+ "<language locale=\"es\">"
				+ userFullName
				+ "</language>"
				+ "<language locale=\"eu\">"
				+ userFullName
				+ "</language>"
				+ "</description>"
				+ "</registrySenderName>"
				+ "<managingUnitID>"
				+ managingId
				+ "</managingUnitID>"
				+ "<managingUnitName>"
				// + " <description>"
				// +
				// " <language locale=\"eu\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// +
				// "<language locale=\"es\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// + "</description>"
				+ managingDep
				+ "</managingUnitName>"
				+ "<registryAddresseeCode>"
				+ managingId
				+ "</registryAddresseeCode>"
				+ "<registryAddresseeName>"
				// + "<description xmlns=\"com/ejie/mbt/xml\">"
				// +
				// "<language locale=\"eu\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// +
				// "<language locale=\"es\">DIRECCION DE TRABAJO Y SEGURIDAD SOCIAL</language>"
				// + "</description>"
				+ managingDep + "</registryAddresseeName>"
				+ "</contextRegistry>";

		return xml;
	}
	
	public String generarXmlInitExpedient (Aa83b21t00 aa83b21t00, Aa83b23t00 aa83b23t00,Aa83b25t00 aa83b25t00,Aa83bConsultationContext res, String procedure, Aa83b31t00 aa83b31t00,Aa83b32t00 aa83b32t00,  Aa83b33t00 aa83b33t00)
	{
		
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
		java.util.Date date = new java.util.Date();
		String fechaD=sdf.format(date);
		String idioma="";
		String fechareg="";
		if (aa83b21t00 != null)
			fechareg= aa83b21t00.getFecha021().substring(6,10)+"-"+ aa83b21t00.getFecha021().substring(3,5)+"-"+ aa83b21t00.getFecha021().substring(0,2)+"T00:00:00";
		else if (aa83b23t00 != null)
			fechareg= aa83b23t00.getFecha023().substring(6,10)+"-"+ aa83b23t00.getFecha023().substring(3,5)+"-"+ aa83b23t00.getFecha023().substring(0,2)+"T00:00:00";
		else if (aa83b25t00 != null)
			fechareg= aa83b25t00.getFecha025().substring(6,10)+"-"+ aa83b25t00.getFecha025().substring(3,5)+"-"+ aa83b25t00.getFecha025().substring(0,2)+"T00:00:00";
		
		String expediente= "<init_expedientNT>" +
		"   <family>CERTIF</family>" +
		"   <procedure_id>"+procedure+"</procedure_id>";
		
		if (aa83b21t00 != null)
			expediente+="   <exercise>"+aa83b21t00.getIdAno021()+"</exercise>" +
			"   <folder_number>HAB-"+aa83b21t00.getIdAno021()+"-"+aa83b21t00.getId021()+"</folder_number>";
		else if (aa83b23t00 != null)
			expediente+="   <exercise>"+aa83b23t00.getIdAno023()+"</exercise>" +
			"   <folder_number>ESF-"+aa83b23t00.getIdAno023()+"-"+aa83b23t00.getId023()+"</folder_number>";
		else if (aa83b25t00 != null)
			expediente+="   <exercise>"+aa83b25t00.getIdAno025()+"</exercise>" +
			"   <folder_number>ARR-"+aa83b25t00.getIdAno025()+"-"+aa83b25t00.getId025()+"</folder_number>";
		
		Aa83bXMLGenerator.logger.info("generarXmlInitExpedient-------------->>>>> 1");
		
		expediente+="   <description>" +
		"      <language locale='es'>"+res.getProcedureNameDesc("es")+"</language>" +
		"      <language locale='eu'>"+res.getProcedureNameDesc("eu")+"</language>" +
		"   </description>" +
		"   <entity>"+res.getEntityId()+"</entity>" +
		"   <managing_unit_id>"+res.getOrganId()+"</managing_unit_id>" +
		"   <managing_unit_name>" +
		"      <language locale='es'>"+res.getOrganNameDesc("es")+"</language>" +
		"      <language locale='eu'>"+res.getOrganNameDesc("eu")+"</language>" +
		"   </managing_unit_name>" +
		"   <status>1</status> " +
		"  <opening_timestamp>"+fechaD+"</opening_timestamp>" +
		"  <start_timestamp>"+fechaD+"</start_timestamp>" +
		"   <update_timestamp>"+fechaD+"</update_timestamp>" +
		"   <proceedings>" +
		"      <proceedings_id>11111</proceedings_id>" +
		"      <timestamp>"+fechaD+"</timestamp>" +
		"      <description>" +
		"         <language locale='es'>PRESENTACIN DE SOLICITUD</language>" +
		"         <language locale='eu'>ESKABIDEA AURKEZTEA</language>" +
		"      </description>" +
		"      <managing_unit_id>"+res.getOrganId()+"</managing_unit_id>" +
		"      <managing_unit_name>" +
		"         <language locale='es'>"+res.getOrganNameDesc("es")+"</language>" +
		"         <language locale='eu'>"+res.getOrganNameDesc("eu")+"</language>" +
		"      </managing_unit_name>" +
		"      <from_citicen>" +
		"         <registry_number>";
		
		Aa83bXMLGenerator.logger.info("generarXmlInitExpedient-------------->>>>> 2");
		
		if (aa83b21t00 != null)
			expediente+="            <registryNumber>"+aa83b21t00.getNumReg021()+"</registryNumber>" +
			"            <registryTimestamp>"+fechareg+"</registryTimestamp>" +
			"         </registry_number>" +
			"         <document>" +
			"            <rol_name>" +
			"               <language locale='es'>Instancia de Solicitud</language>" +
			"               <language locale='eu'>Eskaeraren eskabidea</language>" +
			"            </rol_name>" +
			"            <electronic>" +
			"               <rde_id>"+aa83b31t00.getOid031Papel0()+"</rde_id>" +
			"               <origin_system>RDE</origin_system>" +
			"               <name>Instancia de solicitud.pdf</name>" +
			"            </electronic>" +
			"         </document>" +
			"      </from_citicen>" +
			"      <attachment>" +
			"         <typeattchment>1</typeattchment>" +
			"         <submissionType>P</submissionType>" +
			"         <senderId>"+aa83b21t00.getNumDoc021()+"</senderId>" +
			"         <sendername>"+aa83b21t00.getApel1021()+" "+aa83b21t00.getApel2021()+", "+aa83b21t00.getNombre021()+"</sendername>";
		else if (aa83b23t00 != null)
			expediente+="            <registryNumber>"+aa83b23t00.getNumReg023()+"</registryNumber>" +
			"            <registryTimestamp>"+fechareg+"</registryTimestamp>" +
			"         </registry_number>" +
			"         <document>" +
			"            <rol_name>" +
			"               <language locale='es'>Instancia de Solicitud</language>" +
			"               <language locale='eu'>Eskaeraren eskabidea</language>" +
			"            </rol_name>" +
			"            <electronic>" +
			"               <rde_id>"+aa83b32t00.getOid032Papel0()+"</rde_id>" +
			"               <origin_system>RDE</origin_system>" +
			"               <name>Instancia de solicitud.pdf</name>" +
			"            </electronic>" +
			"         </document>" +
			"      </from_citicen>" +
			"      <attachment>" +
			"         <typeattchment>1</typeattchment>" +
			"         <submissionType>P</submissionType>" +
			"         <senderId>"+aa83b23t00.getNumDoc023()+"</senderId>" +
			"         <sendername>"+aa83b23t00.getApel1023()+" "+aa83b23t00.getApel2023()+", "+aa83b23t00.getNombre023()+"</sendername>";
		else if (aa83b25t00 != null)
			expediente+="            <registryNumber>"+aa83b25t00.getNumReg025()+"</registryNumber>" +
			"            <registryTimestamp>"+fechareg+"</registryTimestamp>" +
			"         </registry_number>" +
			"         <document>" +
			"            <rol_name>" +
			"               <language locale='es'>Instancia de Solicitud</language>" +
			"               <language locale='eu'>Eskaeraren eskabidea</language>" +
			"            </rol_name>" +
			"            <electronic>" +
			"               <rde_id>"+aa83b33t00.getOid033Papel0()+"</rde_id>" +
			"               <origin_system>RDE</origin_system>" +
			"               <name>Instancia de solicitud.pdf</name>" +
			"            </electronic>" +
			"         </document>" +
			"      </from_citicen>" +
			"      <attachment>" +
			"         <typeattchment>1</typeattchment>" +
			"         <submissionType>P</submissionType>" +
			"         <senderId>"+aa83b25t00.getNumDoc025()+"</senderId>" +
			"         <sendername>"+aa83b25t00.getApel1025()+" "+aa83b25t00.getApel2025()+", "+aa83b25t00.getNombre025()+"</sendername>";
		
		Aa83bXMLGenerator.logger.info("generarXmlInitExpedient-------------->>>>> 3");
		
		expediente+="         <input_timestamp>"+fechaD+"</input_timestamp>" +
		"      </attachment>" +
		"   </proceedings>" +
		"   <proceedings>" +
		"      <proceedings_id>11110</proceedings_id>" +
		"      <timestamp>"+fechaD+"</timestamp>" +
		"      <description>" +
		"         <language locale='es'>APERTURA DEL EXPEDIENTE</language>" +
		"         <language locale='eu'>ESPEDIENTEA IREKITZEA</language>" +
		"      </description>" +
		"      <managing_unit_id>"+res.getOrganId()+"</managing_unit_id>" +
		"      <managing_unit_name>" +
		"         <language locale='es'>"+res.getOrganNameDesc("es")+"</language>" +
		"         <language locale='eu'>"+res.getOrganNameDesc("eu")+"</language>" +
		"      </managing_unit_name>" +
		"   </proceedings>" +
		"   <participant>";
		
		Aa83bXMLGenerator.logger.info("generarXmlInitExpedient-------------->>>>> 4");
		
		if (aa83b21t00 != null)
		{
			Aa83bXMLGenerator.logger.info("aa83b21t00.getIdiomaComunic021()" + aa83b21t00.getIdiomaComunic021());
			if (aa83b21t00.getIdiomaComunic021()!= null && aa83b21t00.getIdiomaComunic021().equals(0))
				idioma="es";
			else
				idioma="eu";
			
			expediente+="      <participant_id>"+aa83b21t00.getNumDoc021()+"</participant_id>" +
						"      <role>APPLICANT</role>" +
						"      <language>"+idioma+"</language>";
				if (aa83b21t00.getTipoNotificacion021().equals("T"))
				{
					expediente+="      <notification_chanel>" +
					"         <electronic>electronic</electronic>" +
					"      </notification_chanel>" +
					"		<notice_chanel>";
					if (((aa83b21t00.getTelf1021()!=null) && ((aa83b21t00.getTelf1021().startsWith("6")) || (aa83b21t00.getTelf1021().startsWith("7")))))
						
						expediente+="  <sms>"+aa83b21t00.getTelf1021()+"</sms>" +
								"		</notice_chanel>";
					else if (((aa83b21t00.getTelf2021()!=null) && ((aa83b21t00.getTelf2021().startsWith("6")) || (aa83b21t00.getTelf2021().startsWith("7")))))
						expediente+="  <sms>"+aa83b21t00.getTelf2021()+"</sms>" +
						"		</notice_chanel>";
					else
						expediente+="  <email>"+aa83b21t00.getEmail021()+"</email>" +
								"		</notice_chanel>";
					;	
				}else
				{
					expediente+="      <notification_chanel>" +
					"         <postal>" +
					"            <street>"+aa83b21t00.getCalleComunicDescEs021()+" "+aa83b21t00.getNumeroComunic021()+" "+aa83b21t00.getBisComunic021()+ " "+aa83b21t00.getPisoComunic021()+ " "+ aa83b21t00.getLetraComunic021()+"</street>" +
					"            <province>" +
					"               <language locale='es'>"+Aa83bUtilidades.tildesSinHtml(aa83b21t00.getProvinciaComunicDescEs021())+"</language>" +
					"               <language locale='eu'>"+Aa83bUtilidades.tildesSinHtml(aa83b21t00.getProvinciaComunicDescEu021())+"</language>" +
					"            </province>" +
					"            <town>" +
					"               <language locale='es'>"+Aa83bUtilidades.tildesSinHtml(aa83b21t00.getMunicipComunicDescEs021())+"</language>" +
					"               <language locale='eu'>"+Aa83bUtilidades.tildesSinHtml(aa83b21t00.getMunicipComunicDescEu021())+"</language>" +
					"            </town>" +
					"            <zipcode>"+aa83b21t00.getCpostalComunic021()+"</zipcode>" +
					"         </postal>" +
					"      </notification_chanel>";
				}
				
			expediente+="      <participants>" +
			"         <holder id='"+aa83b21t00.getNumDoc021()+"' type='2'>" +
			"            <nombre>"+aa83b21t00.getNombre021()+"</nombre>" +
			"            <apellido1>"+aa83b21t00.getApel1021()+"</apellido1>" +
			"            <apellido2>"+aa83b21t00.getApel2021()+"</apellido2>" +
			"         </holder>" +
			"      </participants>" +
			"   </participant>" +
			"</init_expedientNT>";
		} else if (aa83b23t00 != null)
		{
			
				if (aa83b23t00.getIdiomaComunic023()!= null && aa83b23t00.getIdiomaComunic023().equals(0))
					idioma="es";
				else
					idioma="eu";
				
			expediente+="      <participant_id>"+aa83b23t00.getNumDoc023()+"</participant_id>" +
						"      <role>APPLICANT</role>" +
						"      <language>"+idioma+"</language>";
				if (aa83b23t00.getTipoNotificacion023().equals("T"))
				{
					expediente+="      <notification_chanel>" +
					"         <electronic>electronic</electronic>" +
					"      </notification_chanel>" +
					"		<notice_chanel>";
					if (((aa83b23t00.getTelf1023()!=null) && ((aa83b23t00.getTelf1023().startsWith("6")) || (aa83b23t00.getTelf1023().startsWith("7")))))
						
						expediente+="  <sms>"+aa83b23t00.getTelf1023()+"</sms>" +
								"		</notice_chanel>";
					else if (((aa83b23t00.getTelf2023()!=null) && ((aa83b23t00.getTelf2023().startsWith("6")) || (aa83b23t00.getTelf2023().startsWith("7")))))
						expediente+="  <sms>"+aa83b23t00.getTelf2023()+"</sms>" +
						"		</notice_chanel>";
					else
						expediente+="  <email>"+aa83b23t00.getEmail023()+"</email>" +
								"		</notice_chanel>";
					;	
				}else
				{
					expediente+="      <notification_chanel>" +
					"         <postal>" +
					"            <street>"+aa83b23t00.getCalleComunicDescEs023()+" "+aa83b23t00.getNumeroComunic023()+" "+aa83b23t00.getBisComunic023()+ " "+aa83b23t00.getPisoComunic023()+ " "+ aa83b23t00.getLetraComunic023()+"</street>" +
					"            <province>" +
					"               <language locale='es'>"+Aa83bUtilidades.tildesSinHtml(aa83b23t00.getProvinciaComunicDescEs023())+"</language>" +
					"               <language locale='eu'>"+Aa83bUtilidades.tildesSinHtml(aa83b23t00.getProvinciaComunicDescEu023())+"</language>" +
					"            </province>" +
					"            <town>" +
					"               <language locale='es'>"+Aa83bUtilidades.tildesSinHtml(aa83b23t00.getMunicipComunicDescEs023())+"</language>" +
					"               <language locale='eu'>"+Aa83bUtilidades.tildesSinHtml(aa83b23t00.getMunicipComunicDescEu23())+"</language>" +
					"            </town>" +
					"            <zipcode>"+aa83b23t00.getCpostalComunic023()+"</zipcode>" +
					"         </postal>" +
					"      </notification_chanel>";
				}
				
			expediente+="      <participants>" +
			"         <holder id='"+aa83b23t00.getNumDoc023()+"' type='2'>" +
			"            <nombre>"+aa83b23t00.getNombre023()+"</nombre>" +
			"            <apellido1>"+aa83b23t00.getApel1023()+"</apellido1>" +
			"            <apellido2>"+aa83b23t00.getApel2023()+"</apellido2>" +
			"         </holder>" +
			"      </participants>" +
			"   </participant>" +
			"</init_expedientNT>";
		}else if (aa83b25t00 != null)
		{
			if (aa83b25t00.getIdiomaComunic025()!= null && aa83b25t00.getIdiomaComunic025().equals(0))
				idioma="es";
			else
				idioma="eu";
			
			expediente+="      <participant_id>"+aa83b25t00.getNumDoc025()+"</participant_id>" +
						"      <role>APPLICANT</role>" +
						"      <language>"+idioma+"</language>";
				if (aa83b25t00.getTipoNotificacion025().equals("T"))
				{
					expediente+="      <notification_chanel>" +
					"         <electronic>electronic</electronic>" +
					"      </notification_chanel>" +
					"		<notice_chanel>";
					if (((aa83b25t00.getTelf1025()!=null) && ((aa83b25t00.getTelf1025().startsWith("6")) || (aa83b25t00.getTelf1025().startsWith("7")))))
						
						expediente+="  <sms>"+aa83b25t00.getTelf1025()+"</sms>" +
								"		</notice_chanel>";
					else if (((aa83b25t00.getTelf2025()!=null) && ((aa83b25t00.getTelf2025().startsWith("6")) || (aa83b25t00.getTelf2025().startsWith("7")))))
						expediente+="  <sms>"+aa83b25t00.getTelf2025()+"</sms>" +
						"		</notice_chanel>";
					else
						expediente+="  <email>"+aa83b25t00.getEmail025()+"</email>" +
								"		</notice_chanel>";
					;	
				}else
				{
					expediente+="      <notification_chanel>" +
					"         <postal>" +
					"            <street>"+aa83b25t00.getCalleComunicDescEs025()+" "+aa83b25t00.getNumeroComunic025()+ " "+aa83b25t00.getBisComunic025()+ " "+aa83b25t00.getPisoComunic025()+ " "+ aa83b25t00.getLetraComunic025()+"</street>" +
					"            <province>" +
					"               <language locale='es'>"+Aa83bUtilidades.tildesSinHtml(aa83b25t00.getProvinciaComunic025DescEs025())+"</language>" +
					"               <language locale='eu'>"+Aa83bUtilidades.tildesSinHtml(aa83b25t00.getProvinciaComunic025DescEu025())+"</language>" +
					"            </province>" +
					"            <town>" +
					"               <language locale='es'>"+Aa83bUtilidades.tildesSinHtml(aa83b25t00.getMunicipComunic025DescEs025())+"</language>" +
					"               <language locale='eu'>"+Aa83bUtilidades.tildesSinHtml(aa83b25t00.getMunicipComunic025DescEu025())+"</language>" +
					"            </town>" +
					"            <zipcode>"+aa83b25t00.getCpostalComunic025()+"</zipcode>" +
					"         </postal>" +
					"      </notification_chanel>";
				}
				
			expediente+="      <participants>" +
			"         <holder id='"+aa83b25t00.getNumDoc025()+"' type='2'>" +
			"            <nombre>"+aa83b25t00.getNombre025()+"</nombre>" +
			"            <apellido1>"+aa83b25t00.getApel1025()+"</apellido1>" +
			"            <apellido2>"+aa83b25t00.getApel2025()+"</apellido2>" +
			"         </holder>" +
			"      </participants>" +
			"   </participant>" +
			"</init_expedientNT>";
		}
		
		Aa83bXMLGenerator.logger.info("generarXmlInitExpedient-------------->>>>> 5");
		
		return expediente;
	}

	
	/**
	 * @param aa83b21t00 Aa83b21t00
	 * @param aa83b23t00 Aa83b23t00
	 * @param aa83b25t00 Aa83b25t00
	 * @param res Aa83bConsultationContext
	 * @param procedure String
	 * @param oid String
	 * @param oidNotif String
	 * @param tipoarchivo String
	 * @param lectura Boolean
	 * @return String
	 */
	public String generarXmlSaveUpdateProceedings (Aa83b21t00 aa83b21t00, Aa83b23t00 aa83b23t00,Aa83b25t00 aa83b25t00,
			Aa83bConsultationContext res, String procedure,String oid, String oidNotif, String tipoarchivo, Boolean lectura, String idProceedings)
	{
		
		boolean esSubsanacion = false;
		
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
		java.util.Date date = new java.util.Date();
		String fechaD=sdf.format(date);
		String fechareg="";
		String actNot="";
		String archivo="";
		String archivoEu="";
		String proceedings="";
		String proc_description="";
		String proc_descriptionEu="";
		String lecturaES="";
		String lecturaEU="";
		boolean esTelematica = false;
		
		if (aa83b21t00 != null){
			if ("T".equals(aa83b21t00.getTipoNotificacion021())){
				esTelematica = true;	
			}
		} else {
			if (aa83b23t00 != null){
				if ("T".equals(aa83b23t00.getTipoNotificacion023())){
					esTelematica = true;	
				}
			} else {
				if (aa83b25t00 != null){
					if ("T".equals(aa83b25t00.getTipoNotificacion025())){
						esTelematica = true;	
					}
				}
			}
		}
		
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] aa83b21t00----->"+ aa83b21t00);
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] aa83b23t00----->"+ aa83b23t00);
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] aa83b25t00----->"+ aa83b25t00);
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] res----->"+ res);
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] procedure----->"+ procedure);
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] oid----->"+ oid);
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] oid----->"+ oidNotif);
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] oid----->"+ tipoarchivo);
		Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] lectura----->"+ lectura);

		
		if (tipoarchivo!=null && tipoarchivo.indexOf("resol")!=-1)
		{
			esSubsanacion = false;
			actNot="RESOL";
			archivo= "Informe de resolucin";
			archivoEu= "Informe de resolucin";
			proceedings=idProceedings;
			proc_description="NOTIFICACIN RESOLUCIN";
			proc_descriptionEu="EBAZPENAREN JAKINARAZPENA";
		}else
		{
			esSubsanacion = true;
			actNot="REQ_SUB";
			archivo= "Requerimiento de subsanacin";
			archivoEu= "Requerimiento de subsanacin";
			//proceedings="1211N";
			proceedings=idProceedings;
			//proc_description="REQUERIMIENTO DE DIRECCIN";
			//proc_descriptionEu="ZUZENDARITZAREN ERREKERIMENDUA";
			proc_description="ABIERTO PLAZO DE SUBSANACIN";
			proc_descriptionEu="KONPONTZEAREN EPEA IREKITA";
		}
		
		if (aa83b21t00 != null) {
			fechareg= aa83b21t00.getFecha021().substring(Aa83BConstants.SEIS, Aa83BConstants.DIEZ)+"-"+ aa83b21t00.getFecha021().substring(Aa83BConstants.TRES,Aa83BConstants.CINCO)+"-"+ aa83b21t00.getFecha021().substring(Aa83BConstants.CERO,Aa83BConstants.DOS)+"T00:00:00";
		}
		else {
			if (aa83b23t00 != null) {
					fechareg= aa83b23t00.getFecha023().substring(Aa83BConstants.SEIS, Aa83BConstants.DIEZ)+"-"+ aa83b23t00.getFecha023().substring(Aa83BConstants.TRES,Aa83BConstants.CINCO)+"-"+ aa83b23t00.getFecha023().substring(Aa83BConstants.CERO,Aa83BConstants.DOS)+"T00:00:00";
			} else {
				if (aa83b25t00 != null) {
					fechareg= aa83b25t00.getFecha025().substring(Aa83BConstants.SEIS, Aa83BConstants.DIEZ)+"-"+ aa83b25t00.getFecha025().substring(Aa83BConstants.TRES,Aa83BConstants.CINCO)+"-"+ aa83b25t00.getFecha025().substring(Aa83BConstants.CERO,Aa83BConstants.DOS)+"T00:00:00";
				}
			}
		}

		String expediente="<saveorupdate_proceedingsNT>" +
				"      	   	<complete_folder_number>" +
				"         		<procedure_id>"+procedure+"</procedure_id>";

		if (aa83b21t00 != null) {
			expediente+="   <exercise>"+aa83b21t00.getIdAno021()+"</exercise>" +
					"   	<folder_number>HAB-"+aa83b21t00.getIdAno021()+"-"+aa83b21t00.getId021()+"</folder_number>"+
					"	</complete_folder_number>" +
					"      <update_timestamp>"+fechaD+"</update_timestamp>" +
					"      <participant_id>"+aa83b21t00.getNumDoc021()+"</participant_id>";
		} else if (aa83b23t00 != null) {	
			expediente+="   <exercise>"+aa83b23t00.getIdAno023()+"</exercise>" +
					"   <folder_number>ESF-"+aa83b23t00.getIdAno023()+"-"+aa83b23t00.getId023()+"</folder_number>"+
					"	</complete_folder_number>" +
					"      <update_timestamp>"+fechaD+"</update_timestamp>" +
					"      <participant_id>"+aa83b23t00.getNumDoc023()+"</participant_id>";
		}else if (aa83b25t00 != null) {	
			expediente+="   <exercise>"+aa83b25t00.getIdAno025()+"</exercise>" +
					"   <folder_number>ARR-"+aa83b25t00.getIdAno025()+"-"+aa83b25t00.getId025()+"</folder_number>"+					
					"	</complete_folder_number>" +
					"      <update_timestamp>"+fechaD+"</update_timestamp>" +
					"      <participant_id>"+aa83b25t00.getNumDoc025()+"</participant_id>";
		}
		
		expediente+="<proceedings>" +
				"         <proceedings_id>"+proceedings+"</proceedings_id>" +
				"         <timestamp>"+fechaD+"</timestamp>" +
				"         <description>" +
				"            <language locale='es'>"+proc_description+"</language>" +
				"            <language locale='eu'>"+proc_descriptionEu+"</language>" +
				"         </description>" +
				"         <managing_unit_id>"+res.getOrganId()+"</managing_unit_id>" +
				"         <managing_unit_name>" +
				"            <language locale='es'>"+res.getOrganNameDesc("es")+"</language>" +
				"            <language locale='eu'>"+res.getOrganNameDesc("eu")+"</language>" +
				"         </managing_unit_name>";
		
		if (!"waitingID-1".equalsIgnoreCase(proceedings)) {
			if(lectura){
				//para postal enviada
				if (esTelematica){
					lecturaES="Aceptada";
					lecturaEU="Onartua";
				} else {
					lecturaES="Enviada";
					lecturaEU="Bidalita";
				}
			}else{
				//para postal pendiente de envo
				if (esTelematica){
					lecturaES="Notificacin Pendiente de Recoger";
					lecturaEU="Jakinarazpena Jasotzeke";
				} else {
					lecturaES="Pendiente de envo";
					lecturaEU="Bidalketa zain dauden";
				}
			}
			Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] lecturaES----->"+ lecturaES);			
			expediente+="         <from_administration>" +
			  			"            <registry_number>";
			
			if (aa83b21t00 != null) {
				expediente+="  <registryNumber>"+aa83b21t00.getNumReg021()+"</registryNumber>";
			} else {
				if (aa83b23t00 != null) {
					expediente+="  <registryNumber>"+aa83b23t00.getNumReg023()+"</registryNumber>";
				} else {
					if (aa83b25t00 != null) {
						expediente+="  <registryNumber>"+aa83b25t00.getNumReg025()+"</registryNumber>";
					}
				}
			}
			
			expediente+="                             <registryTimestamp>"+fechareg+"</registryTimestamp>" +
						"            </registry_number>";
			
			if (oid!=null) {
				expediente+="    <document>" +
							"					<rol_name>" +
							"                  <language locale='es'>"+archivo+"</language>" +
							"                  <language locale='eu'>"+archivoEu+"</language>" +
							"               </rol_name>" +
							"               <electronic>" +
							"                  <rde_id>"+oid+"</rde_id>" +
							"                  <origin_system>RDE</origin_system>" +
							"                  <name>"+tipoarchivo+"</name>" +
							"               </electronic>" +
							"            </document>";
			}
			
			expediente+="         </from_administration>" +
						"         <notification_proceedings>" +
						"            <notification>" +
						"               <oficial_delivery_timestamp>"+fechaD.substring(0,fechaD.indexOf('T'))+"</oficial_delivery_timestamp>"+
						"               <notifiedActId>"+actNot+"</notifiedActId>" +
						"               <notifiedAct>" +
						"                  <language locale='es'>"+archivo+"</language>" +
						"                  <language locale='eu'>"+archivoEu+"</language>" +
						"               </notifiedAct>";
			
			if (esTelematica) {
				Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] Antes de escribir lecturaES="+ lecturaES);
				expediente+="               <electronic>" +
							"						<publication_timestamp>"+fechaD.substring(0,fechaD.indexOf('T'))+"</publication_timestamp>" +
							"						<oidnotification>"+oidNotif+"</oidnotification>" +
							"						<result>" +
							"							<language locale='es'>"+lecturaES+"</language>" +
							"							<language locale='eu'>"+lecturaEU+"</language>" +
							"						</result>" +
							"					</electronic>";
				Aa83bXMLGenerator.logger.info("[generarXmlSaveUpdateProceedings] Despues de escribir lecturaES="+ lecturaES);
			}else if  (!esTelematica) {
				expediente+="               <postal>" +
							"                  <publication_timestamp>"+fechaD.substring(0,fechaD.indexOf('T'))+"</publication_timestamp>" +
							"                  <result>" +
							"                     <language locale='es'>"+lecturaES+"</language>" +
							"					  <language locale='eu'>"+lecturaEU+"</language>" +
							"                  </result>" +
							"               </postal>";
			}				
			
			expediente+="            </notification>" +
						"         </notification_proceedings>" +
						"      </proceedings>" +
						"   </saveorupdate_proceedingsNT>";;

		} else {
			// es subsanacion
			expediente+=
				"         <waiting>" +
				"         	<waiting_type>1</waiting_type> " +
				"         	<official_delivery_timestamp>" + fechaD.substring(0,fechaD.indexOf('T')) + "</official_delivery_timestamp>" +
				"         	<organ_to_send_id>" + res.getOrganId() + "</organ_to_send_id>" +
				"         	<organ_to_send_name> " +
				"         		<language locale='es'>" + res.getDepartamentNameDesc("es") + " </language>" +
				"         		<language locale='eu'>" + res.getDepartamentNameDesc("eu") + " </language>" +
				"         	</organ_to_send_name>" +
				"         </waiting> " +
				"      </proceedings>" +
				"   </saveorupdate_proceedingsNT>";
		}
			

		return expediente;
	}

	
	public String generarXmlCloseExpedient (String anyo, String idSol, String tipoSol,Aa83bConsultationContext res, String procedure)
	{
		
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
		java.util.Date date = new java.util.Date();
		String fechaD=sdf.format(date);
	
		String expediente="<close_expedientNT>" +
				"	   <complete_folder_number>" +
				"	      <procedure_id>"+procedure+"</procedure_id>"+
				"	      <exercise>"+anyo+"</exercise>" +
				"	      <folder_number>"+tipoSol+"-"+anyo+"-"+idSol+"</folder_number>"+
				"	   </complete_folder_number>" +
				"	   <closing_timestamp>"+fechaD+"</closing_timestamp>" +
				"	   <update_timestamp>"+fechaD+"</update_timestamp>" +
				"	   <observations>" +
				"	      <language locale='es'>Motivo cierre castellano</language>" +
				"	      <language locale='eu'>Motivo cierre euskera</language>" +
				"	   </observations>" +
				"	   <proceedings>" +
				"	      <proceedings_id>cerrarExpediente</proceedings_id>" +
				"	      <timestamp>"+fechaD+"</timestamp>" +
				"	      <description>" +
				"	         <language locale='es'>Cierre y Archivo</language>" +
				"	         <language locale='eu'>Ixtea eta Artxibatzea</language>" +
				"	      </description>" +
				"	      <managing_unit_id>"+res.getOrganId()+"</managing_unit_id>" +
				"	      <managing_unit_name>" +
				"	         <language locale='eu'>"+res.getOrganNameDesc("es")+"</language>" +
				"	         <language locale='es'>"+res.getOrganNameDesc("eu")+"</language>" +
				"	      </managing_unit_name>" +
				"	   </proceedings>	" +
				"</close_expedientNT>";
		
	
		return expediente;
	}
	
	public String xmlRegistro(String unitCode,String sender,String matter, String person)
	{
		
		 String datos="<Datas>" +
	 		"<UnitCode>"+unitCode+"</UnitCode>" +
	 		"	<Sender>"+unitCode+"</Sender>" +
	 		"	<Matter>"+matter+"</Matter>" +
	 		"	<Persons>" +
	 		"		<WSParamPerson>" +
	 		"			<PersonName>"+person+"</PersonName>" +
	 		"		</WSParamPerson>" +
	 		"	</Persons>" +
	 		"</Datas>";
		 
		 return datos;
	}
	
	public String generateXMLFicha(Aa83b21v00 aa83b21v00){

		Aa83bXMLGenerator.logger.info("[generateXMLFicha] INICIO=");

		StringBuffer xml = new StringBuffer(Aa83BConstants.NOVECIENTOSTREINTAYSIETE);
		xml.append(Aa83bXMLConstants.CABECERA_GENERAL_XML);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE);
		xml.append(Aa83bXMLConstants.CABECERA_TEMPLATE_ITEMS);

		xml.append(Aa83bXMLConstants.CABECERA_DETALLE_SOLICITUD);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);

			xml.append("<item  etiqueta=\'idExpediente\'>");
			xml.append((String) "ADE/" + aa83b21v00.getIdano021() + "/" + aa83b21v00.getId021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'fechaSolicitud\'>");
			xml.append( aa83b21v00.getFecreg021() );
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'motivoSolicitud\'>");
			xml.append( aa83b21v00.getMotivoes015());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'autCesion\'>");
			xml.append( aa83b21v00.getConsentimientos2021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
	
			xml.append("<item  etiqueta=\'nombApels\'>");
			xml.append( aa83b21v00.getNombre021() + " " + aa83b21v00.getApel1021() + " " + aa83b21v00.getApel2021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'telf1\'>");
			xml.append( aa83b21v00.getTelf1021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'telf2\'>");
			xml.append( aa83b21v00.getTelf2021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'email\'>");
			xml.append( aa83b21v00.getEmail021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'calleComunic\'>");
			xml.append( aa83b21v00.getCallecomunic021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'numeroComunic\'>");
			xml.append( aa83b21v00.getNumerocomunic021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'bisComunic\'>");
			xml.append( aa83b21v00.getBiscomunic021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'pisoComunic\'>");
			xml.append( aa83b21v00.getPisocomunic021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
	
			xml.append("<item  etiqueta=\'letraComunic\'>");
			xml.append( aa83b21v00.getLetracomunic021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'cpComunic\'>");
			xml.append( aa83b21v00.getCpostalcomunic021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'muniComunic\'>");
			xml.append( aa83b21v00.getMunicomunic());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'provComunic\'>");
			xml.append( aa83b21v00.getProvcomunic());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'numDoc\'>");
			xml.append( aa83b21v00.getNumdoc021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'nacionalidad\'>");
			xml.append( aa83b21v00.getPaisds());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'calle\'>");
			xml.append( aa83b21v00.getCalle021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'numCalle\'>");
			xml.append( aa83b21v00.getNumcalle021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'bis\'>");
			xml.append( aa83b21v00.getBis021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'piso\'>");
			xml.append( aa83b21v00.getPiso021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'letra\'>");
			xml.append( aa83b21v00.getLetra021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'cp\'>");
			xml.append( aa83b21v00.getCp021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'muniInsp\'>");
			xml.append( aa83b21v00.getMunidsins());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'provInsp\'>");
			xml.append( aa83b21v00.getProvins());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'descTitula\'>");
			xml.append( aa83b21v00.getDesces014());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'descTitular\'>");
			xml.append( aa83b21v00.getDesces016());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'perHabitan\'>");
			xml.append( aa83b21v00.getNumpershabitan021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'perReagrupa\'>");
			xml.append( aa83b21v00.getNumpersreagrupar021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
			xml.append("<item  etiqueta=\'observaciones\'>");
			xml.append( aa83b21v00.getObservaciones021());
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		
		xml.append(Aa83bXMLConstants.CABECERA_VINCULOS);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);
		//Bucle para escribir las personas a reagrupar
		if (aa83b21v00.getVinculosL().size() > 0) {
			// Por cada acuse
			int tam = aa83b21v00.getVinculosL().size();
			for (int i = 0; i < tam; i++) {
				xml.append(Aa83bXMLConstants.ITEM_INICIO);
					xml.append(Aa83bXMLConstants.ITEMS_INICIO);

				Aa83b18t00 vinculo = new Aa83b18t00();
				vinculo = (Aa83b18t00) aa83b21v00.getVinculosL().get(i);

				xml.append("<item  etiqueta=\"vinculo\">");
				xml.append((String) Aa83bUtilidades.tildesSinHtml(vinculo.getId013VinculosFamStrEs()) + "  ");
				xml.append(Aa83bXMLConstants.ITEM_FIN);
				
				xml.append(Aa83bXMLConstants.ITEMS_FIN);
				xml.append(Aa83bXMLConstants.ITEM_FIN);

			}
		} else {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);
			xml.append("<item  etiqueta=\"vinculo\">");
			xml.append("  ");
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);
		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		
		xml.append(Aa83bXMLConstants.CABECERA_DOCUMENTOS_FICHA);
		xml.append(Aa83bXMLConstants.ITEMS_INICIO);
		if (aa83b21v00.getDocumentosL().size() > 0) {
			// Por cada acuse
			int tam = aa83b21v00.getDocumentosL().size();
			for (int i = 0; i < tam; i++) {
				xml.append(Aa83bXMLConstants.ITEM_INICIO);
					xml.append(Aa83bXMLConstants.ITEMS_INICIO);

						Aa83b31v01 documento = new Aa83b31v01();
						documento = (Aa83b31v01) aa83b21v00.getDocumentosL().get(i);

						xml.append("<item  etiqueta=\"documento\">");
						xml.append((String) Aa83bUtilidades.tildesSinHtml(documento.getDesces030()));
						xml.append(Aa83bXMLConstants.ITEM_FIN);
				
					xml.append(Aa83bXMLConstants.ITEMS_FIN);
				xml.append(Aa83bXMLConstants.ITEM_FIN);

			}
		} else {
			xml.append(Aa83bXMLConstants.ITEM_INICIO);
			xml.append(Aa83bXMLConstants.ITEMS_INICIO);
			xml.append("<item  etiqueta=\"documento\">");
			xml.append("  ");
			xml.append(Aa83bXMLConstants.ITEM_FIN);
			xml.append(Aa83bXMLConstants.ITEMS_FIN);
			xml.append(Aa83bXMLConstants.ITEM_FIN);
		}
		xml.append(Aa83bXMLConstants.ITEMS_FIN);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEM);
		
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE_ITEMS);
		xml.append(Aa83bXMLConstants.FIN_TEMPLATE);

		Aa83bXMLGenerator.logger.info("\n\n\n[generateXMLFicha] xml="+ xml.toString());
		Aa83bXMLGenerator.logger.info("\n\n\n");

		return xml.toString();
	}

	
}