package com.ejie.aa83b.util.webdav;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.StoredObject;
import com.ejie.x38.webdav.exceptions.WebdavException;

/**
 * WebDavStore para Local
 * @author amsanchez
 */

public class Aa83bLocalFileSystemStore implements IWebdavStore{

	private Logger LOG =  LoggerFactory.getLogger(Aa83bLocalFileSystemStore.class);

    private static int BUF_SIZE = 65536;

    private File _root = null;

    private String rootPath;
    
    public void setRootPath(String rootPath) {
		this.rootPath = rootPath;
	}

	public Aa83bLocalFileSystemStore(File root) {
        _root = root;
    }
    
    public Aa83bLocalFileSystemStore() {
    }

    @PostConstruct
    public void init(){
    	System.out.println("init");
    	if (_root==null){
    		if(rootPath!=null && rootPath!=""){
		        if (rootPath.equals("*WAR-FILE-ROOT*")) {
		            String file = Aa83bLocalFileSystemStore.class.getProtectionDomain()
		                    .getCodeSource().getLocation().getFile().replace('\\', '/');
		            if (file.charAt(0) == '/'
		                    && System.getProperty("os.name").indexOf("Windows") != -1) {
		                file = file.substring(1, file.length());
		            }

		            int ix = file.indexOf("/WEB-INF/");
		            if (ix != -1) {
		                rootPath = file.substring(0, ix).replace('/',
		                        File.separatorChar);
		            } else {
		                throw new WebdavException(
		                        "Could not determine root of war file. Can't extract from path '"
		                                + file + "' for this web container");
		            }
		        }
		        _root = new File(rootPath);
    		}
    	}
    }
    
    public ITransaction begin(Principal principal) throws WebdavException {
    	System.out.println("begin");
        LOG.debug("LocalFileSystemStore.begin()");
        if (!_root.exists()) {
            if (!_root.mkdirs()) {
                throw new WebdavException("root path: "
                        + _root.getAbsolutePath()
                        + " does not exist and could not be created");
            }
        }
        return null;
    }

    public void checkAuthentication(ITransaction transaction)
            throws SecurityException {
    	System.out.println("checkAuthentication");
        LOG.debug("LocalFileSystemStore.checkAuthentication()");
        // do nothing

    }

    public void commit(ITransaction transaction) throws WebdavException {
        // do nothing
    	System.out.println("commit");
        LOG.debug("LocalFileSystemStore.commit()");
    }

    public void rollback(ITransaction transaction) throws WebdavException {
        // do nothing
    	System.out.println("rollback");
        LOG.debug("LocalFileSystemStore.rollback()");

    }

    public void createFolder(ITransaction transaction, String uri)
            throws WebdavException {
    	System.out.println("createFolder");
        LOG.debug("LocalFileSystemStore.createFolder(" + uri + ")");
        File file = new File(_root, uri);
        if (!file.mkdir())
            throw new WebdavException("cannot create folder: " + uri);
    }

    public void createResource(ITransaction transaction, String uri)
            throws WebdavException {
    	System.out.println("createResource");
        LOG.debug("LocalFileSystemStore.createResource(" + uri + ")");
        File file = new File(_root, uri);
        try {
            if (!file.createNewFile())
                throw new WebdavException("cannot create file: " + uri);
        } catch (IOException e) {
            LOG
                    .error("LocalFileSystemStore.createResource(" + uri
                            + ") failed");
            throw new WebdavException(e);
        }
    }

    public long setResourceContent(ITransaction transaction, String uri,
            InputStream is, String contentType, String characterEncoding)
            throws WebdavException {
    	System.out.println("setResourceContent");
        LOG.debug("LocalFileSystemStore.setResourceContent(" + uri + ")");
        File file = new File(_root, uri);
        try {
            OutputStream os = new BufferedOutputStream(new FileOutputStream(
                    file), BUF_SIZE);
            try {
                int read;
                byte[] copyBuffer = new byte[BUF_SIZE];

                while ((read = is.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    os.write(copyBuffer, 0, read);
                }
            } finally {
                try {
                    is.close();
                } finally {
                    os.close();
                }
            }
        } catch (IOException e) {
            LOG.error("LocalFileSystemStore.setResourceContent(" + uri
                    + ") failed");
            throw new WebdavException(e);
        }
        long length = -1;

        try {
            length = file.length();
        } catch (SecurityException e) {
            LOG.error("LocalFileSystemStore.setResourceContent(" + uri
                    + ") failed" + "\nCan't get file.length");
        }

        return length;
    }

    public String[] getChildrenNames(ITransaction transaction, String uri)
            throws WebdavException {
    	System.out.println("getChildrenNames");
        LOG.debug("LocalFileSystemStore.getChildrenNames(" + uri + ")");
        File file = new File(_root, uri);
        String[] childrenNames = null;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            List<String> childList = new ArrayList<String>();
            String name = null;
            for (int i = 0; i < children.length; i++) {
                name = children[i].getName();
                childList.add(name);
                LOG.debug("Child " + i + ": " + name);
            }
            childrenNames = new String[childList.size()];
            childrenNames = (String[]) childList.toArray(childrenNames);
        }
        return childrenNames;
    }

    public void removeObject(ITransaction transaction, String uri)
            throws WebdavException {
    	System.out.println("removeObject");
        File file = new File(_root, uri);
        boolean success = file.delete();
        LOG.debug("LocalFileSystemStore.removeObject(" + uri + ")=" + success);
        if (!success) {
            throw new WebdavException("cannot delete object: " + uri);
        }

    }

    public InputStream getResourceContent(ITransaction transaction, String uri)
            throws WebdavException {
    	System.out.println("getResourceContent");
        LOG.debug("LocalFileSystemStore.getResourceContent(" + uri + ")");
        File file = new File(_root, uri);

        InputStream in;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        } catch (IOException e) {
            LOG.error("LocalFileSystemStore.getResourceContent(" + uri
                    + ") failed");
            throw new WebdavException(e);
        }
        return in;
    }

    public long getResourceLength(ITransaction transaction, String uri)
            throws WebdavException {
    	System.out.println("getResourceLength");
        LOG.debug("LocalFileSystemStore.getResourceLength(" + uri + ")");
        File file = new File(_root, uri);
        return file.length();
    }

    public StoredObject getStoredObject(ITransaction transaction, String uri) {
    	System.out.println("getStoredObject");
        StoredObject so = null;

        File file = new File(_root, uri);
        if (file.exists()) {
            so = new StoredObject();
            so.setFolder(file.isDirectory());
            so.setLastModified(new Date(file.lastModified()));
            so.setCreationDate(new Date(file.lastModified()));
            so.setResourceLength(getResourceLength(transaction, uri));
        }

        return so;
    }
}


