package com.ejie.aa83b.util.tramita;

import java.io.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.dom.DOMSource;





/**
 * Permite efectuar transformaciones de una fuente xml. <br>
 * <br>
 * El producto de una transformacin se denomina resultado. Una transformacin
 * puede utilizar o no instrucciones xsl.
 */

public final class Aa83bXmlTransformer implements java.io.Serializable{

	private static final long serialVersionUID = 1L;
   private Transformer transformer;

   private Source source;

   /** Construye un objeto de la clase. */

   public Aa83bXmlTransformer() {

      transformer = null;
      source = null;
   }

   /**
    * Crea un transformador sin instrucciones xsl.
    * 
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public void create() throws Aa83bXmlException {

      TransformerFactory fry;

      fry = TransformerFactory.newInstance();

      try {
         transformer = fry.newTransformer();
      }
      catch (Exception exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_TRANSFORM_EXCEPTION,
                  exc);
      }

   }

   /**
    * Crea un transformador con instrucciones xsl.
    * 
    * @param pathname
    *           Ruta de acceso y nombre del fichero xsl con las instrucciones.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public void createUsingXslFile(String pathname) throws Aa83bXmlException {

      TransformerFactory fry;
      StreamSource xsl;

      fry = TransformerFactory.newInstance();
      xsl = new StreamSource(new File(pathname));

      try {
         transformer = fry.newTransformer(xsl);
      }
      catch (Exception exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_TRANSFORM_EXCEPTION,
                  exc);
      }

   }

   /**
    * Crea un transformador con instrucciones xsl.
    * 
    * @param pathname
    *           Ruta de acceso y nombre del fichero xsl con las instrucciones.
    * @throws Aa83bXmlException, IOException
    *            si se produce algn error.
    */

   public void createUsingXslResourceFile(String pathname)
            throws Aa83bXmlException, IOException {

      TransformerFactory fry;
      StreamSource xsl;
      InputStream inputStream = null;

      try {
         fry = TransformerFactory.newInstance();
         inputStream = ClassLoader.getSystemResourceAsStream(pathname);
         xsl = new StreamSource(inputStream);
         transformer = fry.newTransformer(xsl);
      }
      catch (Exception exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_TRANSFORM_EXCEPTION,
                  exc);
      }
      finally {
         if (inputStream != null){
        	 inputStream.close();
         }
      }

   }

   /**
    * Crea un transformador con instrucciones xsl.
    * 
    * @param text
    *           Texto xsl con las instrucciones.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public void createUsingXslStringText(String text) throws Aa83bXmlException {

      TransformerFactory fry;
      StreamSource xsl;

      fry = TransformerFactory.newInstance();
      xsl = new StreamSource(new StringReader(text));

      try {
         transformer = fry.newTransformer(xsl);
      }
      catch (Exception exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_TRANSFORM_EXCEPTION,
                  exc);
      }

   }

   /**
    * Crea un transformador con instrucciones xsl.
    * 
    * @param text
    *           Texto xsl, codificado en UTF-8, con las instrucciones.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public void createUsingXslUtf8Text(byte[] text) throws Aa83bXmlException {

      TransformerFactory fry;
      StreamSource xsl;

      fry = TransformerFactory.newInstance();
      xsl = new StreamSource(new ByteArrayInputStream(text));

      try {
         transformer = fry.newTransformer(xsl);
      }
      catch (Exception exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_TRANSFORM_EXCEPTION,
                  exc);
      }

   }

   /**
    * Crea un transformador con instrucciones xsl.
    * 
    * @param doc
    *           Documento xsl con las instrucciones.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   /*
    * NO FUNCIONA public void createUsingXslDocument(W83AXmlDocument doc) throws
    * Aa83bXmlException {
    * 
    * TransformerFactory fry; DOMSource xsl;
    * 
    * fry = TransformerFactory.newInstance(); xsl = new
    * DOMSource(doc.getDomDocument()); transformer = fry.newTransformer(xsl); }
    */

   /**
    * Establece la fuente de la transformacin.
    * 
    * @param pathname
    *           Ruta de acceso y nombre del fichero xml con la fuente.
    */

   public void setSourceFromXmlFile(String pathname) {

      source = new StreamSource(new File(pathname));
   }

   /**
    * Establece la fuente de la transformacin.
    * 
    * @param text
    *           Texto xml con la fuente.
    */

   public void setSourceFromXmlStringText(String text) {

      source = new StreamSource(new StringReader(text));
   }

   /**
    * Establece la fuente de la transformacin.
    * 
    * @param text
    *           Texto xml, codificado en UTF-8, con la fuente.
    */

   public void setSourceFromXmlUtf8Text(byte[] text) {

      source = new StreamSource(new ByteArrayInputStream(text));
   }

   /**
    * Establece la fuente de la transformacin.
    * 
    * @param doc
    *           Documento xml con la fuente.
    */

   public void setSourceFromXmlDocument(Aa83bXmlDocument doc) {

      source = new DOMSource(doc.getDomDocument());
   }

   /**
    * Establece la fuente de la transformacin.
    * 
    * @param elem
    *           Elemento xml con la fuente.
    */

   public void setSourceFromXmlElement(Aa83bXmlElement elem) {

      source = new DOMSource(elem.getDomElement());
   }

   /**
    * Efecta la transformacin.
    * 
    * @return Texto con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public String transformToStringText() throws Aa83bXmlException {

      StreamResult res;
      StringWriter resWriter;

      resWriter = new StringWriter();
      res = new StreamResult(resWriter);

      try {
         transformer.transform(source, res);
      }
      catch (Exception exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_TRANSFORM_EXCEPTION,
                  exc);
      }

      return resWriter.toString();

   }

   /**
    * Efecta la transformacin.
    * 
    * @return Texto, codificado en UTF-8, con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public byte[] transformToUtf8Text() throws Aa83bXmlException {

      StreamResult res;
      ByteArrayOutputStream resStream;

      resStream = new ByteArrayOutputStream();
      res = new StreamResult(resStream);

      try {
         transformer.transform(source, res);
      }
      catch (Exception exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_TRANSFORM_EXCEPTION,
                  exc);
      }

      return resStream.toByteArray();

   }

   /**
    * Efecta la transformacin.
    * 
    * @param pathname
    *           Ruta de acceso y nombre del fichero en el que se almacena el
    *           resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public void transformToFile(String pathname) throws Aa83bXmlException {

      StreamResult res;

      res = new StreamResult(new File(pathname));

      try {
         transformer.transform(source, res);
      }
      catch (Exception exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_TRANSFORM_EXCEPTION,
                  exc);
      }

   }

   /**
    * Permite especificar si en el resultado de una transformacin se omite la
    * declaracin Xml.
    * 
    * @param omit
    *           Especifica si omitir la declaracin xml.
    */

   public void setOmitXmlDeclarationInOutput(boolean omit) {

      String text;

      if (omit)
      {
    	  text = "yes";
      }
      else
      {
    	  text = "no";
      }

      transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, text);

   }

   /** Permite especificar que el resultado de una transformacin es xml. */

   public void setXmlOutputMethod() {

      transformer.setOutputProperty(OutputKeys.METHOD, "xml");
   }

   /** Permite especificar que el resultado de una transformacin es html. */

   public void setHtmlOutputMethod() {

      transformer.setOutputProperty(OutputKeys.METHOD, "html");
   }

   /**
    * Efecta la transformacin de una fuente xml sin utilizar instrucciones
    * xsl.
    * 
    * @param xmlDoc
    *           Documento xml con la fuente.
    * @param omitXmlHdr
    *           Especifica si omitir la cabecera xml en el resultado.
    * @return Texto xml con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static String transformXmlDocumentToXmlStringText(Aa83bXmlDocument xmlDoc,
            boolean omitXmlHdr) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.create();
      transformer.setSourceFromXmlDocument(xmlDoc);
      transformer.setOmitXmlDeclarationInOutput(omitXmlHdr);

      return transformer.transformToStringText();

   }

   /**
    * Efecta la transformacin de una fuente xml sin utilizar instrucciones
    * xsl.
    * 
    * @param xmlDoc
    *           Documento xml con la fuente.
    * @param omitXmlHdr
    *           Especifica si omitir la cabecera xml en el resultado.
    * @return Texto xml, codificado en UTF-8, con el resultado de la
    *         transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static byte[] transformXmlDocumentToXmlUtf8Text(Aa83bXmlDocument xmlDoc,
            boolean omitXmlHdr) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.create();
      transformer.setSourceFromXmlDocument(xmlDoc);
      transformer.setOmitXmlDeclarationInOutput(omitXmlHdr);

      return transformer.transformToUtf8Text();

   }

   /**
    * Efecta la transformacin de una fuente xml sin utilizar instrucciones
    * xsl.
    * 
    * @param xmlDoc
    *           Documento xml con la fuente.
    * @param filePathName
    *           Ruta de acceso y nombre del fichero en el que se almacena el
    *           resultado xml de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static void transformXmlDocumentToXmlFile(Aa83bXmlDocument xmlDoc,
            String filePathName) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.create();
      transformer.setSourceFromXmlDocument(xmlDoc);

      transformer.transformToFile(filePathName);

   }

   /**
    * Efecta la transformacin de una fuente xml sin utilizar instrucciones
    * xsl.
    * 
    * @param xmlElem
    *           Elemento xml con la fuente.
    * @param omitXmlHdr
    *           Especifica si omitir la cabecera xml.
    * @return Texto xml con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static String transformXmlElementToXmlStringText(Aa83bXmlElement xmlElem,
            boolean omitXmlHdr) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.create();
      transformer.setSourceFromXmlElement(xmlElem);
      transformer.setOmitXmlDeclarationInOutput(omitXmlHdr);

      return transformer.transformToStringText();

   }

   /**
    * Efecta la transformacin de una fuente xml sin utilizar instrucciones
    * xsl.
    * 
    * @param xmlElem
    *           Elemento xml con la fuente.
    * @param omitXmlHdr
    *           Especifica si omitir la cabecera xml.
    * @return Texto xml, codificado en UTF-8, con el resultado de la
    *         transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static byte[] transformXmlElementToXmlUtf8Text(Aa83bXmlElement xmlElem,
            boolean omitXmlHdr) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.create();
      transformer.setSourceFromXmlElement(xmlElem);
      transformer.setOmitXmlDeclarationInOutput(omitXmlHdr);

      return transformer.transformToUtf8Text();

   }

   /**
    * Efecta la transformacin de una fuente xml utilizando instrucciones xsl.
    * 
    * @param xmlDoc
    *           Documento xml con la fuente.
    * @param xslFilePathName
    *           Ruta de acceso y nombre del fichero xsl con las instrucciones.
    * @return Texto html con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static String transformXmlDocumentToHtmlStringTextUsingXslFile(Aa83bXmlDocument xmlDoc,
            String xslFilePathName) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.createUsingXslFile(xslFilePathName);
      transformer.setSourceFromXmlDocument(xmlDoc);
      transformer.setHtmlOutputMethod();

      return transformer.transformToStringText();

   }

   public static byte[] transformXmlDocumentToHtmlUtf8TextUsingXslFile(Aa83bXmlDocument xmlDoc,
            String xslFilePathName) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.createUsingXslFile(xslFilePathName);
      transformer.setSourceFromXmlDocument(xmlDoc);
      transformer.setHtmlOutputMethod();

      return transformer.transformToUtf8Text();

   }

   /**
    * Efecta la transformacin de una fuente xml utilizando instrucciones xsl.
    * 
    * @param xmlDoc
    *           Documento xml con la fuente.
    * @param xslFilePathName
    *           Ruta de acceso y nombre del fichero xsl con las instrucciones.
    * @return Texto html con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static String transformXmlUtf8ToHtmlStringTextUsingXslFile(byte[] xmlDoc,
            String xslFilePathName) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.createUsingXslFile(xslFilePathName);
      transformer.setSourceFromXmlUtf8Text(xmlDoc);
      transformer.setHtmlOutputMethod();

      return transformer.transformToStringText();

   }

   /**
    * Efecta la transformacin de una fuente xml utilizando instrucciones xsl.
    * 
    * @param xmlDoc
    *           Documento xml con la fuente.
    * @param xslDoc
    *           Contenido del documento xsl con las instrucciones.
    * @return Texto html con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static String transformXmlUtf8ToHtmlStringTextUsingXslText(byte[] xmlDoc,
            String xslDoc) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.createUsingXslStringText(xslDoc);
      transformer.setSourceFromXmlUtf8Text(xmlDoc);
      transformer.setHtmlOutputMethod();

      return transformer.transformToStringText();

   }

   /**
    * Efecta la transformacin de una fuente xml utilizando instrucciones xsl.
    * 
    * @param xmlDoc
    *           Documento xml con la fuente.
    * @param xslFilePathName
    *           Ruta de acceso y nombre del fichero xsl con las instrucciones.
    * @return Texto html con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static String transformXmlUtf8ToHtmlStringTextUsingXslResourceFile(byte[] xmlDoc,
            String xslFilePathName) throws Aa83bXmlException, IOException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.createUsingXslResourceFile(xslFilePathName);
      transformer.setSourceFromXmlUtf8Text(xmlDoc);
      transformer.setHtmlOutputMethod();

      return transformer.transformToStringText();

   }

   public static byte[] transformXmlStringToHtmlUtf8TextUsingXslFile(String xmlDoc,
            String xslFilePathName) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.createUsingXslFile(xslFilePathName);
      transformer.setSourceFromXmlStringText(xmlDoc);
      transformer.setHtmlOutputMethod();

      return transformer.transformToUtf8Text();

   }

   /**
    * Efecta la transformacin de una fuente xml utilizando instrucciones xsl.
    * 
    * @param xmlFilePathName
    *           Ruta de acceso y nombre del fichero xml con la fuente.
    * @param xslFilePathName
    *           Ruta de acceso y nombre del fichero xsl con las instrucciones.
    * @return Texto html con el resultado de la transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static String transformXmlFileToHtmlStringTextUsingXslFile(String xmlFilePathName,
            String xslFilePathName) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.createUsingXslFile(xslFilePathName);
      transformer.setSourceFromXmlFile(xmlFilePathName);
      transformer.setHtmlOutputMethod();

      return transformer.transformToStringText();

   }

   /**
    * Efecta la transformacin de una fuente xml utilizando instrucciones xsl.
    * 
    * @param xmlFilePathName
    *           Ruta de acceso y nombre del fichero xml con la fuente.
    * @param xslFilePathName
    *           Ruta de acceso y nombre del fichero xsl con las instrucciones.
    * @return Texto html, codificado en UTF-8, con el resultado de la
    *         transformacin.
    * @throws Aa83bXmlException
    *            si se produce algn error.
    */

   public static byte[] transformXmlFileToHtmlUtf8TextUsingXslFile(String xmlFilePathName,
            String xslFilePathName) throws Aa83bXmlException {

      Aa83bXmlTransformer transformer;

      transformer = new Aa83bXmlTransformer();

      transformer.createUsingXslFile(xslFilePathName);
      transformer.setSourceFromXmlFile(xmlFilePathName);
      transformer.setHtmlOutputMethod();

      return transformer.transformToUtf8Text();

   }

} // class XmlTransformer
