
package com.ejie.aa83b.util.tramita;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.XMLReader;

import com.ejie.aa83b.exception.Aa83bErrorGenericoException;





/**
 * Validacin de una fuente xml contra un esquema xsd
 */
public class Aa83bXmlSchemaValidation implements java.io.Serializable{//NOPMD

	private static final long serialVersionUID = 1L;
	/**
     * Permite validar una fuente xml contra un esquema.
     * 
     * @param xsdPathname
     *            Ruta de acceso y nombre del fichero con el esquema
     * @param xmlDocument
     *            Ruta de acceso y nombre del fichero con la fuente xml
     * @throws W83AException
     *             Si el chequeo no es satisfactorio.
     */
	public static void validationXMLSchema(String xsdPathname, String xmlDocument)
			throws Aa83bErrorGenericoException, Aa83bXmlException {
    	
        if (log.isLoggable(Level.INFO))
        {
        	log.info("validationXMLSchema(...)");
        }
        
        Aa83bXmlValidator validator = new Aa83bXmlValidator ();
        validator.create(false);
        
        validator.setSchemaURL(xsdPathname);
        boolean isValid = validator.checkXmlStringText(xmlDocument);
        if (!isValid) {
        	
            if (log.isLoggable(Level.INFO)) {
            	log.info("isValid?:: " + isValid);
            	log.info(validator.getCheckInfo());
            }
        	throw new Aa83bErrorGenericoException("w83a", Long.toString(Aa83bXmlErrorCodes.EC_EVALUATION_EXCEPTION));
        }
    }
	
	final public static XMLReader makeXMLReader() { 
	    try {
            final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(false);
            final SAXParser saxParser = saxParserFactory.newSAXParser();
            final XMLReader parser = saxParser.getXMLReader();
            
            return parser;
        } catch (Exception e) {
        }
        
        return null;
	}	
    
	private static Logger log =Logger.getLogger(Aa83bXmlSchemaValidation.class.getName());//NOPMD

}
