
package com.ejie.aa83b.util.tramita;

import java.io.Serializable;

import com.ejie.aa83b.exception.Aa83bErrorGenericoException;


/**
 * Excepcin lanzada cuando se produce un error XML reseable.
 * <br><br>Adems de la informacin contenida en todos los objetos Exception
 * (message, cause y stack trace), cada instancia de esta clase contiene
 * tambin un cdigo de error.
 */

public class Aa83bXmlException extends Aa83bErrorGenericoException implements Serializable {

   /**
    * Construye un objeto de la clase.
    * 
    * @param errorCode
    *           Cdigo de error.
    */
   	
   public Aa83bXmlException(long errorCode) {
      super("w83a",Long.toString(errorCode));
   }

   /**
    * Construye un objeto de la clase.
    * 
    * @param errorCode
    *           Cdigo de error.
    * @param cause
    *           Excepcin que ha causado sta.
    */

   public Aa83bXmlException(long errorCode, Throwable cause) {
      super("w83a",  cause);
   }

}
