

package com.ejie.aa83b.util.tramita;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.*;


import java.util.StringTokenizer;



import javax.xml.transform.TransformerException;

/** Representa un elemento de un documento xml. */

public final class Aa83bXmlElement implements java.io.Serializable{

	private static final long serialVersionUID = 1L;
   private Element domElem;

   /**
    * Construye un objeto de la clase.
    * 
    * @param domElem
    *           Elemento Dom subyacente.
    */

   Aa83bXmlElement(Element domElem) {
      this.domElem = domElem;
   }

   /**
    * Devuelve el nombre del elemento.
    * 
    * @return El nombre del elemento.
    */

   public String getName() {
      return this.domElem.getTagName();
   }

   /**
    * Devuelve el valor del elemento.
    * 
    * @return El valor del elemento; null si no existe.
    */

   public String getValue() {

      String val = null;
      Node node;

      node = domElem.getFirstChild();
      if (node != null)
      {
    	  val = node.getNodeValue();
      }

      return val;

   }

   /**
    * Devuelve el atributo del elemento con el nombre especificado.
    * 
    * @param atrib
    *       El nombre del atributo.
    * @return El valor del atributo.
    */

   public String getAttribute(String atrib) {
      return this.domElem.getAttribute(atrib);
   }
   
   /**
    * Establece el valor del elemento.
    * 
    * @param val
    *           El nuevo valor del elemento.
    */

   public void setValue(String val) {

      Node node;
      Document doc;

      node = domElem.getFirstChild();
      if (node != null)
      {
    	  node.setNodeValue(val);
      }
      else {
         doc = domElem.getOwnerDocument();
         node = doc.createTextNode(val);
         domElem.appendChild(node);
      }

   }

   /**
    * Devuelve el padre de este nodo.
    * 
    * @return El elemento buscado; null si no existe.
    */

   public Aa83bXmlElement getParentElement() {

      Aa83bXmlElement elem = null;
      Node node;

      node = domElem.getParentNode();

      if (node != null && node instanceof Element) {
         elem = new Aa83bXmlElement((Element) node);
      }

      return elem;

   }
   
   /**
    * Devuelve el (primer) elemento hijo con el nombre especificado.
    * 
    * @param name
    *           Nombre del elemento buscado.
    * @return El elemento buscado; null si no existe.
    */

   public Aa83bXmlElement getChildElement(String name) {

      Aa83bXmlElement elem = null;
      NodeList nodes;
      int count, i;
      Node node;
      String nodeName;

      nodes = domElem.getChildNodes();
      count = nodes.getLength();

      for (i = 0; i < count; i++) {

         node = nodes.item(i);

         if (node.getNodeType() == Node.ELEMENT_NODE) {

            nodeName = node.getNodeName();

            if (nodeName.compareTo(name) == 0) {
               elem = new Aa83bXmlElement((Element) node);//NOPMD
               break;
            }

         }

      }

      return elem;

   }

   /**
    * Devuelve el (primer) elemento descendiente con el nombre especificado.
    * 
    * @param pathname
    *           Ruta de acceso y nombre del elemento buscado. <br>
    *           La ruta de acceso debe ser relativa al elemento padre.
    * @return El elemento buscado; null si no existe.
    */

   public Aa83bXmlElement getDescendantElement(String pathname) {

      Aa83bXmlElement elem = null;
      StringTokenizer strTkr;
      int count, i;
      String name;
      Aa83bXmlElement parentElem;
      Aa83bXmlElement childElem;

      strTkr = new StringTokenizer(pathname, "/");
      count = strTkr.countTokens();

      if (count < 1)
      {
    	  elem = getChildElement(pathname);
      }
      else {

         parentElem = this;

         for (i = 0; i < count; i++) {

            name = strTkr.nextToken();
            childElem = parentElem.getChildElement(name);

            if (childElem == null)
            {
            	break;
            }
            else {
               parentElem = childElem;
               if (i == (count - 1))
               {
            	   elem = childElem;
               }
            }

         }

      }

      return elem;

   }

   /**
    * Devuelve la coleccin de elementos hijo del elemento.
    * 
    * @return La coleccin mencionada.
    */

   public Aa83bXmlElements getChildElements() {
      return Aa83bXmlElement.getChildElements(domElem);
   }

   /**
    * Devuelve el texto xml del elemento.
    * 
    * @param omitXmlHdr
    *           Especifica si omitir la cabecera xml.
    * @return El texto mencionado.
    * @throws W83AXmlException
    *            si se produce algn error.
    */

   public String getStringText(boolean omitXmlHdr) throws Aa83bXmlException {

      return Aa83bXmlTransformer.transformXmlElementToXmlStringText(this,
               omitXmlHdr);
   }

   /**
    * Devuelve el texto xml del elemento codificado en UTF-8.
    * 
    * @param omitXmlHdr
    *           Especifica si omitir la cabecera xml.
    * @return El texto mencionado.
    * @throws W83AXmlException
    *            si se produce algn error.
    */

   public byte[] getUtf8Text(boolean omitXmlHdr) throws Aa83bXmlException {
      
      return Aa83bXmlTransformer.transformXmlElementToXmlUtf8Text(this,
               omitXmlHdr);
   }

   /**
    * Devuelve el elemento Dom subyacente.
    * 
    * @return El elemento mencionado.
    */

   public Element getDomElement() {
      return this.domElem;
   }

   /**
    * Devuelve la coleccin de elementos hijo del nodo Dom especificado.
    * 
    * @param domNode
    *           El nodo Dom mencionado.
    * @return La coleccin mencionada.
    */

   private static Aa83bXmlElements getChildElements(Node domNode) {

      Aa83bXmlElements elems = null;
      NodeList domNodes;
      int count, count1, i;
      Node[] domNodes1;
      Node domNode1;
      Aa83bXmlElement[] elems1;
      Aa83bXmlElement elem1;

      domNodes = domNode.getChildNodes();
      count = domNodes.getLength();
      domNodes1 = new Node[count];
      count1 = 0;

      for (i = 0; i < count; i++) {

         domNode1 = domNodes.item(i);

         if (domNode1.getNodeType() == Node.ELEMENT_NODE) {
            domNodes1[count1] = domNode1;
            count1++;
         }

      }

      elems1 = new Aa83bXmlElement[count1];

      for (i = 0; i < count1; i++) {
         domNode1 = domNodes1[i];
         elem1 = new Aa83bXmlElement((Element) domNode1);//NOPMD
         elems1[i] = elem1;
      }

      elems = new Aa83bXmlElements(elems1);

      return elems;

   }

   /**
    * Mtodo que obtiene un nodo a travs de una expresin
    * XPath.
    * 
    * @param xpathExpression
    *            Expresin que obtiene el valor deseado.
    * @return El valor del nodo elemento. Si no existe se devuelve nulo
    * @throws W83AXmlException
    */

   public Aa83bXmlElement getXmlElement(String xpathExpression) 
   throws Aa83bXmlException {

      //String value = null;
      Node node;
      Aa83bXmlElement element = null;

      try {
         node = XPathAPI.selectSingleNode((Node)getDomElement(),
               xpathExpression);
         if (node != null)
         {
        	 element = new Aa83bXmlElement((Element)node);
         }
      } 
      catch (TransformerException exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_IRRETRIEVABLE_VALUE, 
               exc);
      }

      return element;

   }
   
   /**
    * Mtodo que obtiene un conjunto de nodos a travs de una expresin XPath.
    * 
    * @param xpathExpression
    *           Expresin que obtiene el valor deseado.
    * @return El valor de los nodos elemento. Si no existe se devuelve nulo
    * @throws W83AXmlException
    */
   

   public Aa83bXmlElements getXmlElements(String xpathExpression)
   throws Aa83bXmlException {

      NodeList nodeList;
      int counter;
      Aa83bXmlElements elements = null;
      Aa83bXmlElement[] elem;
     // W83AXmlElement element;

      try {
         nodeList = XPathAPI.selectNodeList(getDomElement(), xpathExpression);

         elem = new Aa83bXmlElement[nodeList.getLength()];
         for (counter = 0; counter < nodeList.getLength(); counter++) {
            elem[counter] = new Aa83bXmlElement((Element)nodeList.item(counter));//NOPMD
         }
         elements = new Aa83bXmlElements(elem);
         
         return elements;
      }
      catch (TransformerException exc) {
         throw new Aa83bXmlException(Aa83bXmlErrorCodes.EC_IRRETRIEVABLE_VALUE,
               exc);
      }
   }
   
} // class XmlElement
