package com.ejie.aa83b.util.tramita;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class Aa83bUtilXml implements Serializable {// NOPMD

	private static final long serialVersionUID = 0;

	public static final String iniCdata = "<![CDATA[";

	public static final String finCdata = "]]>";

	private static final String defStr = "";

	private static final String INI_TAG = "<";

	private static final String INI_END_TAG = "</";

	private static final String END_TAG = ">";

	// private static final String END_END_TAG = "/>";

	private static final SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy-MM-dd");

	private static final SimpleDateFormat stf = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm:ss");

	private static final SimpleDateFormat hour = new SimpleDateFormat(
			"HH:mm:ss");

	public static String getStringValue(Aa83bXmlElement xmlDocument,
			String xPathExpression) throws Aa83bXmlException {
		Aa83bXmlElement element = xmlDocument.getXmlElement(xPathExpression);
		if (element != null) {
			String dateStr = element.getValue();
			if (dateStr != null) {
				dateStr = dateStr.trim();
				return dateStr;
			}
		}
		return null;
	}

	public static int getIntValue(Aa83bXmlElement xmlDocument,
			String xPathExpression) throws Aa83bXmlException {
		Aa83bXmlElement element = xmlDocument.getXmlElement(xPathExpression);
		if (element != null) {
			String dateStr = element.getValue();
			if (dateStr != null) {
				dateStr = dateStr.trim();
				return (Integer.valueOf(dateStr)).intValue();

			}
		}
		return -1;
	}

	public static Integer getIntegerValue(Aa83bXmlElement xmlDocument,
			String xPathExpression) throws Aa83bXmlException {
		Aa83bXmlElement element = xmlDocument.getXmlElement(xPathExpression);
		if (element != null) {
			String dateStr = element.getValue();
			if (dateStr != null) {
				dateStr = dateStr.trim();
				return Integer.valueOf(dateStr);
			}
		}
		return null;
	}

	public static Double getDoubleValue(Aa83bXmlElement xmlDocument,
			String xPathExpression) throws Aa83bXmlException {
		Aa83bXmlElement element = xmlDocument.getXmlElement(xPathExpression);
		if (element != null) {
			String dateStr = element.getValue();
			if (dateStr != null) {
				dateStr = dateStr.trim();
				return new Double(Double.parseDouble(dateStr));
			}
		}
		return null;
	}

	public static Date getDateValue(Aa83bXmlElement xmlDocument,
			String xPathExpression) throws Aa83bXmlException, ParseException {
		Aa83bXmlElement element = xmlDocument.getXmlElement(xPathExpression);
		// Adaptamos la fecha y hora en xsd a formato java
		if (element != null) {
			String dateStr = element.getValue();
			if (dateStr != null) {
				dateStr = dateStr.trim();
				return sdf.parse(dateStr);
			}
		}
		return null;
	}

	public static Date getTimestampValue(Aa83bXmlElement xmlDocument,
			String xPathExpression) throws Aa83bXmlException, ParseException {
		Aa83bXmlElement element = xmlDocument.getXmlElement(xPathExpression);
		// Adaptamos la fecha y hora en xsd a formato java
		if (element != null) {
			String dateStr = element.getValue();
			if (dateStr != null) {
				dateStr = dateStr.trim().replace('T', ' ');
				return stf.parse(dateStr);
			}
		}
		return null;
	}

	public static Aa83bXmlElement getElement(Aa83bXmlElement xmlDocument,
			String xPathExpression) throws Aa83bXmlException {
		return xmlDocument.getXmlElement(xPathExpression);
	}

	public static Aa83bXmlElements getElements(Aa83bXmlElement xmlDocument,
			String xPathExpression) throws Aa83bXmlException {
		return xmlDocument.getXmlElements(xPathExpression);
	}

	public static String getPath(Aa83bXmlElement element) {
		Aa83bXmlElement parent = element.getParentElement();
		if (parent == null) {
			return "/" + element.getDomElement().getNodeName();
		}
		return getPath(parent) + "/" + element.getName();
	}

	public static String getTag(String tag, String value) {
		return getTag(tag, value, true);
	}

	public static String getTag(String tag, String value, boolean cdata) {
		if (tag == null || value == null || tag.length() == 0
				|| value.length() == 0) {
			return defStr;
		}
		return optTag(tag, value, cdata);
	}

	public static String getTag(String tag, Integer value) {
		if (tag == null || value == null) {
			return defStr;
		}
		return optTag(tag, value.toString(), false);
	}

	public static String getTag(String tag, Date value) {
		if (tag == null || value == null) {
			return defStr;
		}
		return optTag(tag, sdf.format(value), false);
	}

	public static String getTag(String tag, Date value, SimpleDateFormat lSdf) {
		if (tag == null || value == null) {
			return defStr;
		}
		return optTag(tag, lSdf.format(value), false);
	}

	public static String getTag(String tag, Double value) {
		if (tag == null || value == null) {
			return defStr;
		}
		return optTag(tag, value.toString(), false);
	}

	public static String getTagTimestamp(String tag, Date value) {
		if (tag == null || value == null) {
			return defStr;
		}
		return optTag(tag, sdf.format(value), false);
	}

	/*
	 * private static String optTag(String tag, String value) { return
	 * optTag(tag, value, true); }
	 */
	private static String optTag(String tag, String value, boolean cdata) {
		StringBuffer rdo;
		if (cdata) {
			rdo = new StringBuffer(tag.length() + value.length() + 17);
			rdo.append(INI_TAG).append(tag).append(END_TAG).append(iniCdata)
					.append(value).append(finCdata).append(INI_END_TAG)
					.append(tag).append(END_TAG);
		} else {
			rdo = new StringBuffer(tag.length() + value.length() + 5);
			rdo.append(INI_TAG).append(tag).append(END_TAG).append(value)
					.append(INI_END_TAG).append(tag).append(END_TAG);

		}
		return rdo.toString();
	}

	public static String getTagSchemeTimestamp(String tag, Date value) {
		if (tag == null || value == null) {
			return "";
		}
		return optTag(tag, sdf.format(value) + "T" + hour.format(value), false);
	}

}