package com.ejie.aa83b.util.tramita;

import java.io.Serializable;
import java.text.ParseException;

import com.ejie.aa83b.exception.Aa83bErrorGenericoException;
//import java.util.logging.Logger;



public class Aa83bConsultationContextParser implements Serializable {

	private static final long serialVersionUID = 1L;

	public Aa83bConsultationContextParser(String xmlConstultationContext)
			throws Aa83bXmlException, Aa83bErrorGenericoException, ParseException {
		xmlDocument = new Aa83bXmlDocument();
		try {
			xmlDocument.createFromUtf8StringText(xmlConstultationContext);
		} catch (Exception e) {
			xmlDocument.createFromStringText(xmlConstultationContext);
		}
	}

	public Aa83bConsultationContextParser() {

	}

	public Aa83bConsultationContext getProcedureData() throws Aa83bErrorGenericoException,
			Aa83bXmlException, ParseException {
		Aa83bXmlElement root = xmlDocument.getRootElement();
/*		W83AXmlElement elemento;
		W83AXmlElement subElemento;
		String sAux;*/

		//W83AXmlElement elementoValidation =
		// root.getChildElement("Procedure");
//		String familyID = W83AUtilXml.getStringValue(root, "familyId");
		String procedureName = root.getXmlElement("procedureName/description")
				.getStringText(true);
		Aa83bLocaleString procedureNameLocale = null;
		if (procedureName != null && !procedureName.equals(""))
		{	procedureNameLocale = Aa83bLocaleStringXML
					.getLocaleString(procedureName);}
		String departmentId = Aa83bUtilXml.getStringValue(root, "departmentId");
		String departmentName = root
				.getXmlElement("departmentName/description")
				.getStringText(true);
		Aa83bLocaleString departmentNameLocale = Aa83bLocaleStringXML
				.getLocaleString(departmentName);
		String managingUnitId = Aa83bUtilXml.getStringValue(root,
				"organInfo/managingUnitId");
		String managingUnitName = root.getXmlElement(
				"organInfo/managingUnitName/description").getStringText(true);
		Aa83bLocaleString managingUnitNameLocale = null;
		if (managingUnitName != null && !managingUnitName.equals(""))
		{	managingUnitNameLocale = Aa83bLocaleStringXML
					.getLocaleString(managingUnitName);}
		String familyName = root.getXmlElement("familyName/description")
				.getStringText(true);
		;
		Aa83bLocaleString familyNameLocale = null;
		if (familyName != null && !familyName.equals(""))
		{	familyNameLocale = Aa83bLocaleStringXML.getLocaleString(familyName);}

		procedureCtx = new Aa83bConsultationContext(familyNameLocale,
				managingUnitId, departmentId, procedureNameLocale,
				departmentNameLocale, managingUnitNameLocale);
		return procedureCtx;
	}

	public Aa83bConsultationContext getProcedureDataAll() throws Aa83bErrorGenericoException,
			Aa83bXmlException, ParseException {

		Aa83bXmlElement root = xmlDocument.getRootElement();
	/*	W83AXmlElement elemento;
		W83AXmlElement subElemento;
		String sAux;*/

		//W83AXmlElement elementoValidation = root.getChildElement("Procedure");
		String procedureId = Aa83bUtilXml.getStringValue(root,
				"procedureId");
		
		/*String procedureName = W83AUtilXml.getStringValue(root,
		"procedureName/description");*/

		String procedureName = root.getXmlElement(
				"procedureName/description").getStringText(true);
		Aa83bLocaleString procedureNameLocale = null;
		if (procedureName != null && !procedureName.equals(""))
			procedureNameLocale = Aa83bLocaleStringXML
					.getLocaleString(procedureName);

		
		
		String departmentId = Aa83bUtilXml.getStringValue(root,
				"departmentId");
		String departmentName = root.getXmlElement(
				"departmentName/description").getStringText(true);
		Aa83bLocaleString departmentNameLocale = null;
		if (departmentName != null && !departmentName.equals(""))
		{	departmentNameLocale = Aa83bLocaleStringXML
					.getLocaleString(departmentName);}

		String entityCode = Aa83bUtilXml.getStringValue(root,
				"entityCode");

		String managingUnitId = Aa83bUtilXml.getStringValue(root,
		"managingUnitId");
		/*String managingUnitFunction = W83AUtilXml.getStringValue(
				elementoValidation, "managingUnitFunction");
		String managingUnitDeliveryKeyFunction = W83AUtilXml.getStringValue(
				elementoValidation, "managingUnitDeliveryKeyFunction");
*/
		String managingUnitName = root.getXmlElement(
				"managingUnitName/description").getStringText(true);
		Aa83bLocaleString managingUnitNameLocale = null;
		if (managingUnitName != null && !managingUnitName.equals(""))
		{	managingUnitNameLocale = Aa83bLocaleStringXML
					.getLocaleString(managingUnitName);}
/*
		String familyID = W83AUtilXml.getStringValue(elementoValidation,
				"FamilyId");

		String procedureInboxID = W83AUtilXml.getStringValue(
				elementoValidation, "ProcedureInboxId");
		String procedureInboxName = W83AUtilXml.getStringValue(
				elementoValidation, "ProcedureInboxName ");

		String certifiedValidationMode = W83AUtilXml.getStringValue(
				elementoValidation, "certifiedValidationMode");
		String telematicsCode = W83AUtilXml.getStringValue(elementoValidation,
				"telematicscode");
		String managingUnitInBoxID = W83AUtilXml.getStringValue(
				elementoValidation, "managingUnitInboxId");

		//20Septiembre
		W83AXmlElement telematicElement = root
				.getChildElement("TelematicAction");
		String telematicActionId = W83AUtilXml.getStringValue(telematicElement,
				"telematicActionId");
		String telematicActionName = telematicElement.getXmlElement(
				"telematicActionName/description").getStringText(true);
		Aa83bLocaleString telematicActionNameLocale = Aa83bLocaleStringXML
				.getLocaleString(telematicActionName);
		*/
		//adaptacion platea v2.1
		Aa83bXmlElement documentalSerieElement = null;
		String documentalSerieId = "";
		String documentalSerie01Id = "";
		String documentalSerie20Id = "";
		String documentalSerie48Id = "";
		
		if(root.getChildElement("daDocumentalSeries01")!=null){
			documentalSerieElement=	root.getChildElement("daDocumentalSeries01");
			documentalSerie01Id=Aa83bUtilXml.getStringValue(documentalSerieElement,"ID");
		}
		if(root.getChildElement("daDocumentalSeries20")!=null){
			documentalSerieElement = root.getChildElement("daDocumentalSeries20");
			documentalSerie20Id=Aa83bUtilXml.getStringValue(documentalSerieElement,"ID");
		}
		if(root.getChildElement("daDocumentalSeries48")!=null){
			documentalSerieElement = root.getChildElement("daDocumentalSeries48");
			documentalSerie48Id=Aa83bUtilXml.getStringValue(documentalSerieElement,"ID");	
		}
		else if(root.getChildElement("daDocumentalSeries")!=null){
			documentalSerieElement = root.getChildElement("daDocumentalSeries");
			documentalSerieId=Aa83bUtilXml.getStringValue(documentalSerieElement,"ID");
		}
		
		String daProcedureId = Aa83bUtilXml.getStringValue(root,
		"daProcedureID");
		
		procedureCtx = new Aa83bConsultationContext(procedureId,
				procedureNameLocale, entityCode, departmentId,
				departmentNameLocale, managingUnitId, managingUnitNameLocale,
				/*managingUnitFunction, managingUnitDeliveryKeyFunction,
				familyID, procedureInboxID, procedureInboxName,
				certifiedValidationMode, telematicsCode, entityNameLocale,
				managingUnitInBoxID, telematicActionId,
				telematicActionNameLocale, */
				documentalSerie01Id, documentalSerie20Id, documentalSerie48Id,documentalSerieId, daProcedureId);

		return procedureCtx;
	}

	//private R02DProcedure procedure;
	private Aa83bConsultationContext procedureCtx;

	private Aa83bXmlDocument xmlDocument;

//	private static Logger log = Logger
//			.getLogger(Aa83bConsultationContextParser.class.getName());
}