package com.ejie.aa83b.util.tramita;

import java.io.Serializable;
import java.util.Locale;

public class Aa83bConsultationContext implements Serializable {

	/**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 1L;

	public Aa83bConsultationContext(Aa83bLocaleString familyName,
			String organId, String departamentId,
			Aa83bLocaleString procedureName, Aa83bLocaleString departamentName,
			Aa83bLocaleString organName) {

		this.familyName = familyName;
		this.organId = organId;
		this.departamentId = departamentId;
		this.procedureName = procedureName;
		this.departamentName = departamentName;
		this.organName = organName;

	}

	public Aa83bConsultationContext() {
		super();
	}

	
	public Aa83bConsultationContext(String procedureId,
			Aa83bLocaleString procedureNameLocale, String entityCode,
			String departmentId, Aa83bLocaleString departmentNameLocale,
			String managingUnitId, Aa83bLocaleString managingUnitNameLocale/*
																			 * ,
																			 * String
																			 * managingUnitFunction
																			 * ,
																			 * String
																			 * managingUnitDeliveryKeyFunction
																			 * ,
																			 * String
																			 * familyID
																			 * ,
																			 * String
																			 * procedureInboxID
																			 * ,
																			 * String
																			 * procedureInboxName
																			 * ,
																			 * String
																			 * certifiedValidationMode
																			 * ,
																			 * String
																			 * telematicsCode
																			 * ,
																			 * W83ALocaleString
																			 * entityNameLocale
																			 * ,
																			 * String
																			 * managingUnitInBoxID
																			 * ,
																			 * String
																			 * telematicActionId
																			 * ,
																			 * W83ALocaleString
																			 * telematicActionNameLocale
																			 */) {

		this.procedureId = procedureId;
		this.procedureName = procedureNameLocale;
		this.entityCode = entityCode;
		this.departamentId = departmentId;
		this.departamentName = departmentNameLocale;
		this.organId = managingUnitId;
		this.organName = managingUnitNameLocale;
		/*
		 * this.managingUnitFunction = managingUnitFunction;
		 * this.managingUnitDeliveryKeyFunction =
		 * managingUnitDeliveryKeyFunction; this.familyID = familyID;
		 * this.procedureInboxID = procedureInboxID; this.procedureInboxName =
		 * procedureInboxName; this.certifiedValidationMode =
		 * certifiedValidationMode; this.telematicsCode = telematicsCode;
		 * this.entityName = entityNameLocale; this.managingUnitInBoxId =
		 * managingUnitInBoxID; this.telematicActionId = telematicActionId;
		 * this.telematicActionNameLocale = telematicActionNameLocale;
		 */

	}

	public Aa83bConsultationContext(
			String procedureId,// NOPMD
			Aa83bLocaleString procedureNameLocale, String entityCode,
			String departmentId, Aa83bLocaleString departmentNameLocale,
			String managingUnitId, Aa83bLocaleString managingUnitNameLocale,
			/*
			 * String managingUnitFunction, String
			 * managingUnitDeliveryKeyFunction, String familyID, String
			 * procedureInboxID, String procedureInboxName, String
			 * certifiedValidationMode, String telematicsCode, W83ALocaleString
			 * entityNameLocale, String managingUnitInBoxID, String
			 * telematicActionId, W83ALocaleString telematicActionNameLocale,
			 */
			String documentalSeries01Id, String documentalSeries20Id,
			String documentalSeries48Id, String documentalSeriesId,
			String daProcedureId) {

		this(procedureId, procedureNameLocale, entityCode, departmentId,
				departmentNameLocale, managingUnitId, managingUnitNameLocale
		/*
		 * managingUnitFunction, managingUnitDeliveryKeyFunction, familyID,
		 * procedureInboxID, procedureInboxName, certifiedValidationMode,
		 * telematicsCode, entityNameLocale, managingUnitInBoxID,
		 * telematicActionId, telematicActionNameLocale
		 */);

		this.documentalSeries01Id = documentalSeries01Id;
		this.documentalSeries20Id = documentalSeries20Id;
		this.documentalSeries48Id = documentalSeries48Id;
		this.documentalSeriesId = documentalSeriesId;
		this.daProcedureId = daProcedureId;
	}

	public Aa83bLocaleString getProcedureName() {
		return procedureName;
	}

	public String getProcedureNameDesc(String languageCode) {
		return this.procedureName.getString(new Locale(languageCode));
	}

	public void setProcedureName(Aa83bLocaleString procedureName) {
		this.procedureName = procedureName;
	}

	public Aa83bLocaleString getDepartamentName() {
		return departamentName;
	}

	public String getDepartamentNameDesc(String languageCode) {
		return this.departamentName.getString(new Locale(languageCode));
	}

	public Aa83bLocaleString getOrganName() {
		return organName;
	}

	public String getOrganNameDesc(String languageCode) {
		return this.organName.getString(new Locale(languageCode));
	}

	public Aa83bLocaleString getEntityName() {
		return entityName;
	}

	public String getEntityNameDesc(String languageCode) {
		return this.entityName.getString(new Locale(languageCode));
	}

	public String getDepartamentId() {
		return departamentId;
	}

	public String getOrganId() {
		return organId;
	}

	public Aa83bLocaleString getFamilyName() {
		return familyName;
	}

	public String getFamilyNameDesc(String languageCode) {
		return this.familyName.getString(new Locale(languageCode));
	}

	// ////
	public String getProcedureId() {
		return procedureId;
	}

	public String getEntityId() {
		return entityCode;
	}

	public String getManagingUnitFunction() {
		return managingUnitFunction;
	}

	public String getManagingUnitDeliveryKeyFunction() {
		return managingUnitDeliveryKeyFunction;
	}

	public String getFamilyID() {
		return familyID;
	}

	public String getManagingUnitInboxID() {
		return managingUnitInBoxId;
	}

	public String getProcedureInboxID() {
		return procedureInboxID;
	}

	public String getProcedureInboxName() {
		return procedureInboxName;
	}

	public String getCertifiedValidationMode() {
		return certifiedValidationMode;
	}

	public String getTelematicsCode() {
		return telematicsCode;
	}

	// private static Logger log =
	// Logger.getLogger(W83AConsultationContext.class
	// .getName());

	/**
	 * @return Returns the telematicActionId.
	 */
	public String getTelematicActionId() {
		return telematicActionId;
	}

	/**
	 * @param telematicActionId
	 *            The telematicActionId to set.
	 */
	public void setTelematicActionId(String telematicActionId) {
		this.telematicActionId = telematicActionId;
	}

	/**
	 * @return Returns the telematicActionNameLocale.
	 */
	public Aa83bLocaleString getTelematicActionNameLocale() {
		return telematicActionNameLocale;
	}

	/**
	 * @param telematicActionNameLocale
	 *            The telematicActionNameLocale to set.
	 */
	public void setTelematicActionNameLocale(
			Aa83bLocaleString telematicActionNameLocale) {
		this.telematicActionNameLocale = telematicActionNameLocale;
	}

	/**
	 * @return the documentalSeries01Id
	 */
	public String getDocumentalSeries01Id() {
		return documentalSeries01Id;
	}

	/**
	 * @return the documentalSeries20Id
	 */
	public String getDocumentalSeries20Id() {
		return documentalSeries20Id;
	}

	/**
	 * @return the documentalSeries48Id
	 */
	public String getDocumentalSeries48Id() {
		return documentalSeries48Id;
	}

	public String getDocumentalSeriesId() {
		return documentalSeriesId;
	}

	public void setDocumentalSeriesId(String documentalSeriesId) {
		this.documentalSeriesId = documentalSeriesId;
	}

	public String getDaProcedureId() {
		return daProcedureId;
	}

	private Aa83bLocaleString procedureName;

	private Aa83bLocaleString departamentName;

	private String departamentId;

	private Aa83bLocaleString organName;

	private String organId;

	private Aa83bLocaleString familyName;

	private String entityCode;

	//
	private String procedureId;

	private String managingUnitInBoxId;

	private String managingUnitFunction;

	private String managingUnitDeliveryKeyFunction;

	private String familyID;

	private String procedureInboxID;

	private String procedureInboxName;

	private String certifiedValidationMode;

	private String telematicsCode;

	private Aa83bLocaleString entityName;

	private String telematicActionId;

	private Aa83bLocaleString telematicActionNameLocale;

	// adaptacion platea v2.1
	private String documentalSeries01Id, documentalSeries20Id,
			documentalSeries48Id, documentalSeriesId;

	private String daProcedureId;

}
