package com.ejie.aa83b.util;

import java.util.Properties;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@Component(value = "Aa83bUtilsConfig")
public class Aa83bUtilsConfig extends SpringBeanAutowiringSupport {

	@Autowired
	private static Properties appConfiguration;

	/**
	 * 
	 * @param appConfiguration
	 *            Properties
	 */
	@Autowired
	public void setAppConfiguration(Properties appConfiguration) {
		Aa83bUtilsConfig.appConfiguration = appConfiguration;
	}

	/**
	 * @param propiedad
	 *            String
	 * @return String
	 */
	public String getPropiedadConfig(String propiedad) {
		System.out.println("Leyendo propiedad :" + propiedad);
		return Aa83bUtilsConfig.appConfiguration.getProperty(propiedad);
	}
}
