package com.ejie.aa83b.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.multipart.MultipartFile;

import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

import com.ejie.aa83b.exception.Aa83bParametroKey;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.model.Aa83bDocumentoDokusi;
import com.ejie.aa83b.service.Aa83bTramitacionExpedienteServiceImpl;
import com.ejie.x38.json.JSONObject;

//import sun.misc.BASE64Decoder;
//import sun.misc.BASE64Encoder;

public class Aa83bUtilidades {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bUtilidades.class);

	private static final int STREAM_ALLOCATE_BUFFER_SIZE = 1024;

	/*********************************************************************************************
	 * From String to CLOB
	 * 
	 * @return CLOB representation of string
	 *********************************************************************************************/
	public static java.sql.Clob stringToClob(String source) {
		try {
			return new javax.sql.rowset.serial.SerialClob(source.toCharArray());
		} catch (Exception e) {
			return null;
		}
	}

	public static String[] cargarTiposSolicitud(String[] listaTodos,
			List<Aa83b30t00> listaTiposDocCombo) {
		for (int i = 0; i < listaTodos.length; i++) {
			boolean encontrado = false;
			int c = 0;
			while (!encontrado && c < listaTiposDocCombo.size()) {
				if (i < listaTiposDocCombo.get(c).getId030()) {
					// lo metemos vacio
					listaTodos[i] = "";
				} else if (i == listaTiposDocCombo.get(c).getId030()) {
					listaTodos[i] = listaTiposDocCombo.get(c).getDescEs030();
					listaTiposDocCombo.remove(c);
					encontrado = true;
				} else if (i > listaTiposDocCombo.get(c).getId030()) {
					// pasamos
				}
				c++;
			}
		}
		return listaTodos;
	}

	/**
	 * Codifica un array de bytes en Base 64
	 * 
	 * @param data
	 *            Array de bytes a codificar
	 * @return String que representa el array de bytes codificado en Base64
	 */
	public static String encodeBase64(byte[] data) {
		String encData = null;

		if (data != null) {
			BASE64Encoder encoder = new BASE64Encoder();

			encData = encoder.encodeBuffer(data);
		}

		return encData;
	}

	/**
	 * Decodifica un String que est en Base 64
	 * 
	 * @param data
	 *            String codificado en Base 64
	 * @return String que representa la decodificacin del String pasado como
	 *         parmetro
	 */
	public static String decodeBase64(String data) {
		byte[] decData = null;
		BASE64Decoder decoder;
		decoder = new BASE64Decoder();

		try {
			decData = decoder.decodeBuffer(data);
		} catch (IOException e) {
			Aa83bUtilidades.logger.error("decodeBase64->EXCEPTION"
					+ e.getMessage());
		}
		return new String(decData);
	}

	private static final String REGEX_URL = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";

	/**
	 * Constructor de Utilidades
	 */
	private Aa83bUtilidades() {
	}

	/**
	 * Devuelve true en caso de que la cadena sea: <li><b>null</b></li><li>
	 * <b>length == 0</b></li>.<br>
	 * 
	 * @param cadena
	 *            String
	 * @return Boolean
	 */
	public static Boolean isEmpty(String cadena) {
		return cadena == null || cadena.trim().length() == 0;
	}

	/**
	 * Devuelve true en caso de que el numero sea: <li><b>null</b></li><li>
	 * <b>0</b></li>.<br>
	 * El objeto pasado debe implementar el metodo (toString).
	 * 
	 * @param number
	 *            Object
	 * @return Boolean
	 */
	public static Boolean isEmptyNumber(Object number) {
		String strNumber = String.valueOf(number);
		return Aa83bUtilidades.isEmpty(strNumber)
				|| strNumber.equalsIgnoreCase("0")
				|| strNumber.equalsIgnoreCase("null");
	}

	/**
	 * Devuelve true en caso de que la lista sea: <li><b>null</b></li><li>
	 * <b>length == 0</b></li>.<br>
	 * 
	 * @param lista
	 *            List<?>
	 * @return Boolean
	 */
	public static Boolean isEmptyList(List<?> lista) {
		return lista == null || lista.isEmpty();
	}

	/**
	 * Devuelve true en caso de que la fecha sea: <li><b>null</b></li>.<br>
	 * 
	 * @param fecha
	 *            Date
	 * @return Boolean
	 */
	public static Boolean isEmptyDate(Date fecha) {
		return fecha == null;
	}

	/**
	 * Devuelve un entero con el nmero que contiene la cadena recibida. Retorna
	 * null si no es un integer.
	 * 
	 * @param strInteger
	 *            String
	 * @return Integer
	 */
	public static Integer formatStringToInteger(String strInteger) {
		Integer numero = null;
		try {
			numero = !Aa83bUtilidades.isEmpty(strInteger) ? Integer
					.valueOf(strInteger) : null;
		} catch (NumberFormatException e) {
		}
		return numero;
	}

	/**
	 * Devuelve el entero en formato String
	 * 
	 * @param integer
	 *            Integer
	 * @return String
	 */
	public static String formatIntegerToString(Integer integer) {
		String resultado = null;
		if (integer != null) {
			resultado = String.valueOf(integer);
		}
		return resultado;
	}

	/**
	 * Devuelve un Long con el nmero que contiene la cadena recibida. Retorna
	 * null si no es un long.
	 * 
	 * @param strLong
	 *            String
	 * @return Long
	 */
	public static Long formatStringToLong(String strLong) {
		Long numero = null;
		try {
			numero = !Aa83bUtilidades.isEmpty(strLong) ? Long.valueOf(strLong)
					: null;
		} catch (NumberFormatException e) {
		}
		return numero;
	}

	/**
	 * Devuelve el string pasado con el Translate(UPPER()))) pero en java
	 * 
	 * @param texto
	 *            String
	 * @return String
	 */
	public static String upperTranslateString(String texto) {
		return Aa83bUtilidades.isEmpty(texto) ? texto : texto.toUpperCase()
				.replaceAll("\u00c1", "A").replaceAll("\u00c9", "E")
				.replaceAll("\u00cd", "I").replaceAll("\u00d3", "O")
				.replaceAll("\u00da", "U");
	}

	/**
	 * Funcion que obtiene del file(MultipartFile) la info necesaria y la aade
	 * al objeto Documento
	 * 
	 * @param documento
	 *            DocMenu
	 * @param file
	 *            MultipartFile
	 * 
	 * @throws IOException
	 *             e
	 */
	public static void setFileInfo(Aa83bDocumentoDokusi documento,
			MultipartFile file) throws IOException {
		if (documento != null && file != null) {
			documento.setContentType(file.getContentType());
			documento.setExtension(Aa83bUtilidades.getFileExtension(file
					.getOriginalFilename()));
			documento.setTamanyo((int) file.getSize());
		}
	}

	/**
	 * Dado un nombre de fichero completo (nombre.ext) devuelve la extensin
	 * 
	 * @param fullName
	 *            String
	 * @return String
	 */
	public static String getFileExtension(String fullName) {
		String ext = "";
		int dotPos = fullName.lastIndexOf(".");
		if (dotPos != -1) {
			ext = fullName.substring(dotPos + 1);
		}
		return ext;
	}

	/**
	 * Traspasa informacion de un stream de entrada a uno de salida, de forma
	 * 'no bloqueante' (usando la libreria nio).
	 * 
	 * @param input
	 *            InputStream
	 * @param output
	 *            OutputStream
	 * @return long
	 * @throws IOException
	 *             e
	 */
	public static long stream(InputStream input, OutputStream output)
			throws IOException {
		Aa83bUtilidades.logger.trace("stream INI");
		ReadableByteChannel inputChannel = null;
		WritableByteChannel outputChannel = null;

		try {
			inputChannel = Channels.newChannel(input);
			outputChannel = Channels.newChannel(output);
			ByteBuffer buffer = ByteBuffer
					.allocate(Aa83bUtilidades.STREAM_ALLOCATE_BUFFER_SIZE);
			long size = 0;

			while (inputChannel.read(buffer) != -1) {
				buffer.flip();
				size += outputChannel.write(buffer);
				buffer.clear();
			}

			Aa83bUtilidades.logger.trace("stream FIN", size);
			return size;
		} finally {
			if (outputChannel != null) {
				try {
					outputChannel.close();
				} catch (IOException e) {
					Aa83bUtilidades.logger.error(
							"Error al cerrar canal de salida", e);
				}
			}
			if (inputChannel != null) {
				try {
					inputChannel.close();
				} catch (IOException e) {
					Aa83bUtilidades.logger.error(
							"Error al cerrar canal de entrada", e);
				}
			}
		}
	}

	/**
	 * Metodo que parsea los parametros a objects
	 * 
	 * @param messageSource
	 *            ReloadableResourceBundleMessageSource
	 * @param listaParametroKey
	 *            List<ParametroKey>
	 * @return Object[]
	 */
	public static Object[] parseParametroKeyToObject(
			ReloadableResourceBundleMessageSource messageSource,
			List<Aa83bParametroKey> listaParametroKey) {
		Object[] objetos = null;
		if (!Aa83bUtilidades.isEmptyList(listaParametroKey)) {
			objetos = new Object[listaParametroKey.size()];
			int i = 0;
			for (Aa83bParametroKey parametroKey : listaParametroKey) {
				objetos[i] = parametroKey.isEsKey() ? Aa83bUtilidades
						.getLiteralMessage(messageSource,
								parametroKey.getValorParametro())
						: parametroKey.getValorParametro();
				i++;
			}
		}
		return objetos;
	}

	/**
	 * Consigue el mensaje "code" del messageSource indicado, en el idioma
	 * actual
	 * 
	 * *Es posible que si se cambian los literales a BBDD, haga falta cambiar*
	 * 
	 * @param messageSource
	 *            ReloadableResourceBundleMessageSource
	 * @param code
	 *            String
	 * @return String
	 */
	public static String getLiteralMessage(
			ReloadableResourceBundleMessageSource messageSource, String code) {
		Locale locale = LocaleContextHolder.getLocale();
		return messageSource.getMessage(code, null, locale);
	}

	/**
	 * Consigue el mensaje "code" del messageSource indicado, en el idioma
	 * actual, utilizando los parametros indicados
	 * 
	 * *Es posible que si se cambian los literales a BBDD, haga falta cambiar*
	 * 
	 * @param messageSource
	 *            ReloadableResourceBundleMessageSource
	 * @param code
	 *            String
	 * @param params
	 *            Object[]
	 * @return String
	 */
	public static String getLiteralMessageWithParams(
			ReloadableResourceBundleMessageSource messageSource, String code,
			Object[] params) {
		Locale locale = LocaleContextHolder.getLocale();
		return messageSource.getMessage(code, params, locale);
	}

	/**
	 * Devuelve true en caso de que la cadena sea: <li><b>null</b></li><li>
	 * <b>length <= longitudMax</b></li>.<br>
	 * 
	 * @param cadena
	 *            String
	 * @param longitudMax
	 *            int
	 * @return Boolean
	 */
	public static Boolean isLongitudValida(String cadena, int longitudMax) {
		return cadena == null || cadena.length() <= longitudMax;
	}

	/**
	 * Devuelve true en caso de que la cadena represente un nmero entero,
	 * positivo o decimal
	 * 
	 * @param number
	 *            BigDecimal
	 * @param parteEntera
	 *            int
	 * @param parteDecimal
	 *            int
	 * @return Boolean
	 */
	public static Boolean isNumeric(BigDecimal number, int parteEntera,
			int parteDecimal) {

		// JBHG: parece que la funcion longValue no recoge el valor entero del
		// bigdecimal, se pueden utilizar funciones especificas para ello:
		// int longitudEntera = String.valueOf(number.longValue()).length();
		// int longitudDecimal = Utilidades.getNumberOfDecimalPlaces(number);
		int longitudDecimal = number.scale();
		int longitudEntera = number.precision() - number.scale();

		if (!Aa83bUtilidades.isEmptyNumber(number)
				&& number.compareTo(BigDecimal.ZERO) < 0) {
			return false;
		} else if (longitudEntera > parteEntera
				|| longitudDecimal > parteDecimal) {
			return false;
		}
		return true;
	}

	public static boolean isNumeric(String str) {
		try {
			double d = Double.parseDouble(str);
		} catch (NumberFormatException nfe) {
			return false;
		}
		return true;
	}

	/**
	 * Devuelve true en caso de que la cadena represente una URL
	 * 
	 * @param references
	 *            String
	 * @return Boolean
	 */
	public static boolean isValidURL(String references) {
		return references.length() > 0
				&& references.matches(Aa83bUtilidades.REGEX_URL);
	}

	/**
	 * Calcula el nmero de decimales que tiene un BigDecimal
	 * 
	 * @param bigDecimal
	 *            BigDecimal
	 * @return int nmero de decimales que tiene el nmero
	 */
	public static int getNumberOfDecimalPlaces(BigDecimal bigDecimal) {
		String string = bigDecimal.stripTrailingZeros().toPlainString();
		int index = string.indexOf(".");
		return index < 0 ? 0 : string.length() - index - 1;
	}

	/**
	 * Formatea una cadena de la que se espera que contenga un decimal. Si la
	 * cadena pasada como parametro es nula o vacia devolver null.
	 * 
	 * @param cadena
	 *            convierte una cadena a numero decimal
	 * @return Decimal formateado
	 */
	public static BigDecimal convertirADecimal(String cadena) {
		BigDecimal decimal = null;
		if (!Aa83bUtilidades.isEmpty(cadena)) {
			String nuevaCad = cadena
					.replace(Aa83BConstants.SEPARADOR_MILES, "");
			try {
				decimal = new BigDecimal(nuevaCad.replace(
						Aa83BConstants.SEPARADOR_DECIMALES,
						Aa83BConstants.SEPARADOR_MILES));
			} catch (NumberFormatException nfe) {
				decimal = null;
			}
		}
		return decimal;
	}

	/**
	 * Formatea una cadena de la que se espera que contenga un decimal. Si la
	 * cadena pasada como parametro es nula o vacia devolver null.
	 * 
	 * @param cadena
	 *            convierte una cadena a numero decimal
	 * @return Decimal formateado
	 */
	public static BigDecimal convertirADecimalGeometria(String cadena) {
		BigDecimal decimal = null;
		if (!Aa83bUtilidades.isEmpty(cadena)) {
			try {
				decimal = new BigDecimal(cadena.replace(
						Aa83BConstants.SEPARADOR_DECIMALES,
						Aa83BConstants.SEPARADOR_MILES));
			} catch (NumberFormatException nfe) {
				decimal = null;
			}
		}
		return decimal;
	}

	/**
	 * Parsea una cadena de geometria a un array de coordenadas
	 * 
	 * Coordenada[0] -> X Coordenada[1] -> Y
	 * 
	 * @param geometria
	 *            String formato: "POINT (522261.000500696 4748959.98178855)"
	 * @return Decimal formateado
	 */
	public static BigDecimal[] parseGeometriaToDecimalArray(String geometria) {
		BigDecimal[] coordenadas = null;

		if (!Aa83bUtilidades.isEmpty(geometria)) {
			String[] puntos = geometria.substring(geometria.indexOf("(") + 1,
					geometria.indexOf(")")).split(
					Aa83BConstants.SEPARADOR_PUNTO_GEOMETRICO);

			// Convertir a BigDecimal[]
			if (puntos != null && puntos.length != 0) {
				coordenadas = new BigDecimal[2];
				coordenadas[0] = Aa83bUtilidades
						.convertirADecimalGeometria(puntos[0]);
				coordenadas[1] = Aa83bUtilidades
						.convertirADecimalGeometria(puntos[1]);
			}
		}
		return coordenadas;
	}

	/**
	 * Convierte un BigDecimal a un String. Si la cadena pasada por parmetro es
	 * nula o vaca devolver cadena vaca
	 * 
	 * @param number
	 *            BigDecimal a convertir
	 * @return String formateado con una coma como separador de decimales
	 * 
	 */
	public static String bigDecimalToString(BigDecimal number) {
		String res = "";
		if (!Aa83bUtilidades.isEmptyNumber(number)) {
			try {
				res = number.setScale(
						Aa83bUtilidades.getNumberOfDecimalPlaces(number),
						RoundingMode.DOWN).toPlainString();
				res = res.replace(Aa83BConstants.SEPARADOR_MILES,
						Aa83BConstants.SEPARADOR_DECIMALES);
			} catch (Exception ex) {
				Aa83bUtilidades.logger.error(
						"Error al convertir un Number a String", ex);
			}

		}
		return res;
	}

	/**
	 * Mtodo que compone la url a partir de la url del servidor y los
	 * parmetros en formato JSON
	 * 
	 * @param servletURL
	 *            String
	 * @param params
	 *            JSONObject
	 * @return String
	 * @throws NullPointerException
	 *             e
	 */
	public static String setUrl(String servletURL, JSONObject params)
			throws NullPointerException {
		Aa83bUtilidades.logger.trace("setUrl INI");
		StringBuffer url = new StringBuffer();
		if (Aa83bUtilidades.isValidURL(servletURL)) {
			try {
				url = new StringBuffer(servletURL);
				url.append("?");
				for (Iterator<Object> iterator = params.keys(); iterator
						.hasNext();) {
					if (url.indexOf("?") != url.length() - 1) {
						url.append("&");
					}
					String key = (String) iterator.next();
					url.append(key).append("=").append(params.get(key));
				}
			} catch (NullPointerException e) {
				Aa83bUtilidades.logger.error("Url o parmetros nulos: ", e);
			}
		} else {
			Aa83bUtilidades.logger.error("Url no vlida");
		}
		Aa83bUtilidades.logger.trace("url: " + url.toString());
		Aa83bUtilidades.logger.trace("setUrl FIN");
		return url.toString();
	}

	/**
	 * @param time
	 *            long en milisegundos
	 * @param soon
	 *            int tiempo minutos que quedan para expirar
	 * @return si time va a expirar en el tiempo indicado en minutos
	 */
	public static boolean isTimeExpiresSoon(long time, int soon) {
		Calendar nowCal = Calendar.getInstance();
		long soonMils = soon * Integer.parseInt("60000");
		return (time - nowCal.getTimeInMillis()) <= soonMils;
	}

	/**
	 * Mtodo que convierte un Objeto a un String en formato JSON.
	 * 
	 * @param object
	 *            object a ser convertida
	 * @return String en formato JSON de la EntidadTransversal
	 */
	public static String objectToJSONString(Object object) {
		String res = "";

		try {
			ObjectMapper mapper = new ObjectMapper();
			res = mapper.writeValueAsString(object);
		} catch (JsonGenerationException e) {
			Aa83bUtilidades.logger
					.error("JsonGenerationException - Error al convertir un Object a String JSON",
							e);
		} catch (JsonMappingException e) {
			Aa83bUtilidades.logger
					.error("JsonMappingException - Error al convertir un Object a String JSON",
							e);
		} catch (IOException e) {
			Aa83bUtilidades.logger.error(
					"IOException - Error al convertir un Object a String JSON",
					e);
		}
		return res;
	}

	public static String leerFichero(String elFichero, boolean codificar) {
		String cadenaSesion = "";
		try {
			File laSesion = new File(elFichero);

			InputStream is = new FileInputStream(laSesion);

			long length = laSesion.length();

			// Create the byte array to hold the data
			byte[] bytes = new byte[(int) length];

			// Read in the bytes
			int offset = 0;
			int numRead = 0;
			while (offset < bytes.length
					&& (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
				offset += numRead;
			}

			// Ensure all the bytes have been read in
			if (offset < bytes.length) {
				throw new IOException("No se ha podido leer " + elFichero);
			}

			// Close the input stream and return bytes
			is.close();

			BASE64Encoder encoder = new BASE64Encoder();

			if (codificar) {
				cadenaSesion = encoder.encodeBuffer(bytes);
			} else {
				cadenaSesion = new String(bytes);
			}

		} catch (Exception e) {
			Aa83bUtilidades.logger.error(
					"Aa83BPlateaUtils.leerFichero->EXCEPTION", e);
		}

		return cadenaSesion;
	}

	/**
	 * Convierte las tildes de un texto a sus entidades HTML.
	 * 
	 * @param string
	 *            $cadena Cadena a modificar.
	 * @return string Cadena de texto con codigos html.
	 */
	public static String TildesHtml(String cadena) {
		cadena = cadena.replace("", "&Aacute;");
		cadena = cadena.replace("", "&Eacute;");
		cadena = cadena.replace("", "&Iacute;");
		cadena = cadena.replace("", "&Oacute;");
		cadena = cadena.replace("", "&Uacute;");
		cadena = cadena.replace("", "&aacute;");
		cadena = cadena.replace("", "&eacute;");
		cadena = cadena.replace("", "&iacute;");
		cadena = cadena.replace("", "&oacute;");
		cadena = cadena.replace("", "&uacute;");
		cadena = cadena.replace("", "&ntilde;");
		cadena = cadena.replace("", "&Ntilde;");
		return cadena;
	}

	/**
	 * Convierte las tildes de un texto a sus entidades HTML.
	 * 
	 * @param string
	 *            $cadena Cadena a modificar.
	 * @return string Cadena de texto con codigos html.
	 */
	public static String tildesSinHtml(String cadena) {
		cadena = cadena.replace("&Aacute;", "");
		cadena = cadena.replace("&Eacute;", "");
		cadena = cadena.replace("&Iacute;", "");
		cadena = cadena.replace("&Oacute;", "");
		cadena = cadena.replace("&Uacute;", "");
		cadena = cadena.replace("&aacute;", "");
		cadena = cadena.replace("&eacute;", "");
		cadena = cadena.replace("&iacute;", "");
		cadena = cadena.replace("&oacute;", "");
		cadena = cadena.replace("&uacute;", "");
		cadena = cadena.replace("&ntilde;", "");
		cadena = cadena.replace("&Ntilde;", "");
		return cadena;
	}

	public static String SinTildes(String input) {
		// Cadena de caracteres original a sustituir.
		String original = "u";
		// Cadena de caracteres ASCII que reemplazarn los originales.
		String ascii = "aaaeeeiiiooouuunAAAEEEIIIOOOUUUNcC";
		String output = input;
		for (int i = 0; i < original.length(); i++) {
			// Reemplazamos los caracteres especiales.
			output = output.replace(original.charAt(i), ascii.charAt(i));
		}// for i
		return output;
	}
	
	
	public static String getDateFormat(){
		String formato = "";
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		} else {
			formato = Aa83BConstants.ES_PATTERN;
		}
		return formato;
	}
	
	public static String convertirFechaStr(String fecha, String idioma){
		String solifNac = "";
		if (fecha == null){
			fecha = "";
		}
		if (fecha.length()>0){
			if (idioma.equals(Aa83BConstants.LANG_EUSKERA_COD)){
				String[] f = fecha.split("/");
				solifNac = f[2] + "/" + f[1] + "/" + f[0];
			} 	else {
				solifNac = fecha;
			}
		}
		
		return solifNac;
	}
	
	public static int getPosicionPrimeraLetra (String cadena){
		int posicion = 0;
		String patron = "[a-z]";
		Pattern p = Pattern.compile(patron);
		Matcher matcher = p.matcher(cadena.toLowerCase().trim());
		if (!Aa83bUtilidades.isNumeric(cadena)){
			while(matcher.find()){
				Aa83bUtilidades.logger.info("letra Encontrada : " + matcher.group() + 
						" empieza en " + matcher.start() + "y termina en " + matcher.end());
				break;
			}
			posicion = matcher.start();
		}
		return posicion;
	}
}
