package com.ejie.aa83b.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import n38a.exe.N38APISesion;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;

import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.service.Aa83b04t00Service;
import com.ejie.x38.security.UserCredentials;

/**
 * Clase de utilidades para el acceso al objeto de seguridad 'UsuarioConectado'
 * y al fichero 'aa24tSeguridad.properties'.
 * 
 * @author DS
 * 
 */
@Component(value = "seguridadProperties")
public class Aa83bUtilSeguridad extends PropertyPlaceholderConfigurer {
	public static final String APP_ORIGEN = "AA83B";

	@Autowired
	private Aa83b04t00Service aa83b04t00Service;

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bUtilSeguridad.class);

	/*
	 * ****************************************************************
	 * Seguridad properties
	 * ****************************************************************
	 */
	private static Map<String, String> propertiesMap;

	@Override
	protected void processProperties(
			ConfigurableListableBeanFactory beanFactory, Properties props)
			throws BeansException {
		super.processProperties(beanFactory, props);
		Aa83bUtilSeguridad.propertiesMap = new HashMap<String, String>();
		for (Object key : props.keySet()) {
			String keyStr = key.toString();
			Aa83bUtilSeguridad.propertiesMap.put(keyStr,
					props.getProperty(keyStr));
		}
	}

	/**
	 * Obtiene el valor de una propiedad definida en el fichero
	 * 'aa83bSeguridad.properties'.
	 * 
	 * @param name
	 *            String
	 * @return String
	 */
	public static String getProperty(String name) {
		return Aa83bUtilSeguridad.propertiesMap.get(name);
	}

	/**
	 * Recupera la instancia de seguridad asociada al tipo de entidad.
	 * 
	 * @param entidad
	 *            String con el tipo de entidad
	 * @return String con la instancia de seguridad asociada
	 */
	public static String getSeguridadEntidad(String entidad) {
		StringBuilder prop = new StringBuilder(
				Aa83BConstants.STRING_BUILDER_INIT);
		prop.append("seg.inst.").append(entidad);
		return Aa83bUtilSeguridad.propertiesMap.get(prop.toString());
	}

	/**
	 * Comprueba si el código de aplicación, está entre los que pueden
	 * informar datos relativos al origen de la informacion definidos en
	 * aa24tSeguridad.properties.
	 * 
	 * @param codApp
	 *            código de aplicación
	 * @return ¿Es aplicación origen?
	 */
	public static boolean isAppOrigen(String codApp) {
		String appsEspeciales = Aa83bUtilSeguridad.propertiesMap
				.get(Aa83bUtilSeguridad.APP_ORIGEN);
		String[] arrApps = appsEspeciales.split(",");
		boolean resultado = false;
		for (String app : arrApps) {
			if (app.trim().equalsIgnoreCase(codApp)) {
				resultado = true;
				break;
			}
		}
		return resultado;
	}

	/*
	 * ****************************************************************
	 * UsuarioConectado & XLNets
	 * ****************************************************************
	 */

	/**
	 * Devuelve el objeto UsuarioConectado guardado en el contexto.
	 * 
	 * @return UsuarioConectado
	 */
	public static UserCredentials getUsuarioConectado() {
		Aa83bUtilSeguridad.logger.trace("getUsuarioConectado INI");
		// System.out.println("Estoy en UserCredentials - getUsuarioConectado");
		// System.out.println("Estoy en UserCredentials - getUsuarioConectado 1:"
		// + SecurityContextHolder.getContext());
		// System.out.println("Estoy en UserCredentials - getUsuarioConectado 1:"
		// + SecurityContextHolder.getContext().getAuthentication());
		// System.out.println("Estoy en UserCredentials - getUsuarioConectado 1:"
		// + SecurityContextHolder.getContext().getAuthentication()
		// .getCredentials());
		if (enOficina()) {
			UserCredentials userCredentials = new UserCredentials();
			userCredentials.setUserName("USER-OFICINA");
			userCredentials.setNif("11223344A");
			userCredentials.setfullName("FULL-NAME-OFICINA");
			userCredentials.setPosition("PUESTO-OFICINA");
			return userCredentials;
		} else
			return (UserCredentials) SecurityContextHolder.getContext()
					.getAuthentication().getCredentials();
	}

	/**
	 * Devuelve el objeto UsuarioConectado guardado en el contexto.
	 * 
	 * @return UsuarioConectado
	 */
	public static String getUsername() {
		// Aa83bUtilSeguridad.logger.info("getUsuarioConectado.getUsername-1");
		UserCredentials userCredentials = new UserCredentials();
		// Aa83bUtilSeguridad.logger.info("getUsuarioConectado.getUsername-2");
		if (enOficina())
			userCredentials.setUserName("Oficina");
		else {
			// Aa83bUtilSeguridad.logger.info("getUsuarioConectado.getUsername-3");
			// Aa83bUtilSeguridad.logger
			// .info("getUsuarioConectado.getUsername-3.1"
			// + SecurityContextHolder.getContext()
			// .getAuthentication().getCredentials());
			//
			// Aa83bUtilSeguridad.logger
			// .info("getUsuarioConectado.getUsername-3.2"
			// + SecurityContextHolder.getContext()
			// .getAuthentication().getCredentials()
			// .toString());

			userCredentials = (UserCredentials) SecurityContextHolder
					.getContext().getAuthentication().getCredentials();
			logger.info("SECURITY CONTEXT: " + SecurityContextHolder.getContext());
			logger.info("AUTHENTICATION: " + SecurityContextHolder.getContext().getAuthentication());
			logger.info("CREDENTIALS: " + SecurityContextHolder.getContext().getAuthentication().getCredentials());
			// Aa83bUtilSeguridad.logger.info("getUsuarioConectado.getUsername-4");
		}
		// Aa83bUtilSeguridad.logger.info("getUsuarioConectado.getUsername-5");
		return userCredentials.getUserName();
	}

	/**
	 * Devuelve el objeto UsuarioConectado guardado en el contexto.
	 * 
	 * @return UsuarioConectado
	 */
	public static String getUsuarioLog() {
		// Aa83bUtilSeguridad.logger.trace("getUsuarioLog INI");
		UserCredentials usuarioConectado = Aa83bUtilSeguridad
				.getUsuarioConectado();

		StringBuilder usuarioLog = new StringBuilder();
		usuarioLog.append(usuarioConectado.getPosition());
		usuarioLog.append("#");
		usuarioLog.append(usuarioConectado.getNif());

		return usuarioLog.toString();
	}

	/**
	 * Devuelve el objeto UsuarioConectado guardado en el contexto.
	 * 
	 * @param session
	 *            HttpSession
	 * 
	 * @return UsuarioConectado
	 */
	public static String getUsuarioLogIntgr(HttpSession session) {
		Aa83bUtilSeguridad.logger.trace("getUsuarioLogIntgr INI");

		StringBuilder usuarioLog = new StringBuilder();
		usuarioLog
				.append(session.getAttribute(Aa83BConstants.APP_ORIGEN_INTGR));

		return usuarioLog.toString();
	}

	/**
	 * Devuelve un String con el token de sesion
	 * 
	 * @param idAplic
	 *            String
	 * @return String
	 */
	public static String getTokenStringXLNets(String idAplic) {

		Aa83bUtilSeguridad.logger.trace("getTokenStringXLNets INI");
		String token = Aa83bUtilXML.document2String(Aa83bUtilSeguridad
				.getTokenDocumentXLNets(idAplic));
		Aa83bUtilSeguridad.logger.trace("getTokenStringXLNets FIN");

		return token;
	}

	public static final String getCodReq(String idDocReq) {
		// Buscamos el ID de la plantilla que se pasa
		System.out.println("Busco el codigo ::: " + idDocReq);
		return getProperty(idDocReq);
	}

	public static String esVivienda(String idAplic, HttpServletRequest request) {
		String salida = "N";
		Aa83bUtilSeguridad.logger.trace("esVivienda INI");
		String token = Aa83bUtilXML.document2String(Aa83bUtilSeguridad
				.getTokenDocumentXLNets(idAplic));

		String[] perfs = Aa83bSesionUtils.getProfiles(request);

		String perfilesVivienda = Aa83BConstants.ListaRolVivienda;
		// System.out.println("Antes del FOR:::" + salida);
		for (int p = 0; p < perfs.length; p++) {
			// System.out.println("perfil nuevo :::" + perfs[p]);
			if (perfilesVivienda.indexOf(perfs[p]) != -1)
				salida = "S";
		}
		// System.out.println("Salida tras FOR:::" + salida);
		// String perfiles = recogerEtiquetaN38(token, "n38perfiles");
		// String[] valores = perfiles.split("<valor>");
		// int ocurrencias = valores.length - 1;
		// for (int o = 1; o <= ocurrencias; o++) {
		// String perfil = recogerEtiqueta(perfiles, "valor");
		// System.out.println("perfil :::" + o + "::" + perfil);
		// if (perfilesVivienda.indexOf(perfil) != -1)
		// salida = "S";
		// perfiles = perfiles.substring(perfiles.indexOf("</valor>")
		// + "</valor>".length(), perfiles.length());
		// }
		Aa83bUtilSeguridad.logger.trace("esVivienda FIN");
		// salida = "S";
		return salida;
	}

	public static String esZuzenean(String idAplic, HttpServletRequest request) {
		String salida = "N";
		Aa83bUtilSeguridad.logger.trace("esZuzenean INI");
		String token = Aa83bUtilXML.document2String(Aa83bUtilSeguridad
				.getTokenDocumentXLNets(idAplic));
		Aa83bUtilSeguridad.logger.trace("esZuzenean INI-2:" + token);
		// System.out.println("esZuzenean INI-2:" + token);
		String[] perfs = Aa83bSesionUtils.getProfiles(request);
		// System.out.println("esZuzenean INI-2:" + Arrays.toString(perfs));
		String perfilesZuzenean = Aa83BConstants.ListaRolZuzenean;

		for (int p = 0; p < perfs.length; p++) {
			if (perfilesZuzenean.indexOf(perfs[p]) != -1) {
				salida = "S";
			}
		}
		// System.out.println("esZuzenean INI-333333333:" + salida);
		return salida;
	}

	public static String getPerfil(String idAplic) {

		Aa83bUtilSeguridad.logger.trace("getTokenStringXLNets INI");
		String token = Aa83bUtilXML.document2String(Aa83bUtilSeguridad
				.getTokenDocumentXLNets(idAplic));

		UserCredentials userCredentials = Aa83bUtilSeguridad
				.getUsuarioConectado();

		System.out.println("Sacamos el perfil:"
				+ userCredentials.getUserProfiles());
		Aa83bUtilSeguridad.logger.trace("getTokenStringXLNets FIN");

		return token;
	}

	/**
	 * Devuelve un objeto Document con el token de sesion
	 * 
	 * @param idAplic
	 *            String
	 * @return String
	 */
	public static Document getTokenDocumentXLNets(String idAplic) {

		Aa83bUtilSeguridad.logger.info("getTokenDocumentXLNets INI");
		Document token = null;
		try {
			Aa83bUtilSeguridad.logger.info("getTokenDocumentXLNets INI Bool::"
					+ Aa83bUtilSeguridad.enOficina() + " -- "
					+ Aa83BConstants.COD_APLICACION);

			if (Aa83bUtilSeguridad.enOficina()) {
				if (Aa83BConstants.COD_APLICACION.equals(idAplic)) {
					Aa83bUtilSeguridad.logger.info("ENTRO POR RAMA 1");
					token = Aa83bUtilXML
							.string2Document(Aa83bSesionUtils
									.leerFichero(
											"c:/config/dominio_desa/aa83b/Tokenaa83b.xml",
											false));
					Aa83bUtilSeguridad.logger.info("ENTRO POR RAMA 1.1");
				}
			} else {
				Aa83bUtilSeguridad.logger.info("ENTRO POR RAMA 2");
				N38APISesion miAPISesion = new N38APISesion();
				token = miAPISesion.n38APISesionCrearApp(idAplic);
			}

		} catch (Exception e) {

			Aa83bUtilSeguridad.logger.info("getTokenDocumentXLNets", e);
		}
		Aa83bUtilSeguridad.logger.info("getTokenDocumentXLNets FIN");
		return token;
	}

	/**
	 * Obtiene el usuario a auditar.
	 * 
	 * @return String
	 */
	public static String getAuditUser() {
		UserCredentials userCredentials = Aa83bUtilSeguridad
				.getUsuarioConectado();
		StringBuilder sbUser = new StringBuilder(
				Aa83BConstants.STRING_BUILDER_INIT);
		sbUser.append(userCredentials.getNif()).append("#");
		sbUser.append(userCredentials.getFullName()).append("#");
		sbUser.append(userCredentials.getPosition()).append("#");
		sbUser.append(Aa83BConstants.COD_APLICACION);
		return sbUser.toString();
	}

	/**
	 * Devuelve 'true' si la aplicacion está desplegada en la oficina.
	 * 
	 * @return boolean
	 */
	public static boolean enOficina() {
		return Aa83BConstants.VALUE_SI.equals(Aa83bUtilProperties.OFICINA);
	}

	public static String recogerEtiquetaN38(String xml, String etiqueta) {
		try {
			String inicio = "<parametro id=\"" + etiqueta + "\">";

			// int inicioint = xml.indexOf(inicio) + inicio.length();
			int inicioint = xml.indexOf(inicio);
			String fin = "</parametro>";
			xml = xml.substring(inicioint, xml.length());

			int finint = xml.indexOf(fin);
			xml = xml.substring(inicio.length(), finint);

		} catch (Exception e) {
			// No hacemos nada
			// e.printStackTrace();
		}
		return xml;
	}

	private static String recogerEtiqueta(String xml, String etiqueta) {
		String valor = "";
		try {
			String inicio = "<" + etiqueta + ">";
			int inicioint = xml.indexOf(inicio) + inicio.length();
			String fin = "</" + etiqueta + ">";
			int finint = xml.indexOf(fin);
			valor = xml.substring(inicioint, finint);
			// if (!etiqueta.equals("sourceBinary"))
			// logger.info("la etiqueta==>" + etiqueta + " es==>" + valor);
		} catch (Exception e) {
			// No hacemos nada
			// e.printStackTrace();
		}
		return valor;
	}

	public static boolean esPerfValido(HttpServletRequest request) {
		// TODO Auto-generated method stub
		boolean salida = false;
		String[] perfs = Aa83bSesionUtils.getProfiles(request);
		String perfilesValidos = Aa83BConstants.ListaRolAplicacion;
		for (int p = 0; p < perfs.length; p++) {
			// System.out.println("perfil nuevo :::" + perfs[p]);
			if (perfilesValidos.indexOf(perfs[p]) != -1)
				salida = true;
		}
		// return salida;
		return salida;
	}
}