package com.ejie.aa83b.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.stereotype.Component;

/**
 * Clase para recuperar valores de propiedades
 * 
 * 
 */

@Component(value = "applicationProperties")
public class Aa83bUtilProperties extends PropertyPlaceholderConfigurer {

	/** The app configuration. */
	// @Autowired()
	// private static Properties appConfiguration;

	// simulacion oficina
	public static final String OFICINA = "0"; // 1 si estamos en oficina; 0 si
												// estamos en desarrollo
	public static final String TOKEN_OFICINA = Aa83BConstants.tokenValido;
	// PIF
	// public static final String PIF_PATH_APP_TMP = "pif.path.app.tmp";
	public static final String PIF_PATH_APP_TMP = "/t65e/aa83b";
	public static final String PIF_PATH_DOKUSI = "/aa83b";

	public static final String PIF_PATH = "/aa83b/apps/";

	public static final String PIF_TTL = "1296000";
	// DOKUSI
	public static final String DOKUSI_ACL = "dokusi.acl";
	public static final String DOKUSI_SERIE_PREFIJO = "dokusi.seriedocumental.";// (Prefijo)
	public static final String DOKUSI_ORIGEN_PREFIJO = "dokusi.origen.";// (Prefijo)
	public static final String DOKUSI_NONE = "none";
	// Servicios web
	public static final String WS_T65BFSD_WSDL = "webservice.T65BFSD.wsdl";
	public static final String WS_T65BFSD_WSDL_NS = "webservice.T65BFSD.namespace";

	public static final String DOC_INF_RESOL_ADE_STR = "ResolADE";
	public static final String DOC_INF_RESOL_ESF_STR = "ResolESF";
	public static final String DOC_INF_RESOL_ARR_STR = "ResolARR";

	public static final String DOC_REQ_SUB_ADE_STR = "RequerimientoADE";
	public static final String DOC_REQ_SUB_ESF_STR = "RequerimientoESF";
	public static final String DOC_REQ_SUB_ARR_STR = "RequerimientoARR";
	public static final String RUTA_IMPRIMIR_SOBRES = "RUTA_IMPRIMIR_SOBRES";
	public static final String DOC_INF_RESOL_TITULO = "Informe de Resolucin";

	public static final String DOC_REQ_SUB_TITULO = "Requerimiento de Subsanacin";

	private static Map<String, String> propertiesMap;

	@SuppressWarnings("deprecation")
	@Override
	protected void processProperties(
			ConfigurableListableBeanFactory beanFactory, Properties props)
			throws BeansException {
		super.processProperties(beanFactory, props);
		Aa83bUtilProperties.propertiesMap = new HashMap<String, String>();
		for (Object key : props.keySet()) {
			String keyStr = key.toString();
			// PropertyPlaceholderHelper
			Aa83bUtilProperties.propertiesMap.put(
					keyStr,
					parseStringValue(props.getProperty(keyStr), props,
							new HashSet()));// NOPMD necesaria instanciacion
											// para rellenar una lista
		}
	}

	/**
	 * 
	 * @param name
	 *            String
	 * @return String
	 */
	public static String getProperty(String name) {
		return Aa83bUtilProperties.propertiesMap.get(name);
	}

}