package com.ejie.aa83b.util;

import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.webservice.client.aa19b.DocumentoWebServiceImpl;
import com.ejie.aa83b.exception.Aa83bPIFException;
import com.ejie.aa83b.exception.Aa83bWebserviceException;
import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 * Utilidades para el manejo de PIF
 * 
 * @author DS
 * 
 */
public class Aa83bUtilPIF {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bUtilPIF.class);

	@Autowired
	private static DocumentoWebServiceImpl webserviceAa19B;

	/**
	 * 'UtilXML'
	 */
	private Aa83bUtilPIF() {
	}

	private static final long ttl_default = 86400L;// 1dia

	/**
	 * Guarda un archivo en PIF, en la ruta especificada (no mantiene el
	 * nombre).
	 * 
	 * @param nombreFichero
	 *            String
	 * @param rutaFichero
	 *            String
	 * @param contenidoFichero
	 *            InputStream
	 * @return Y31AttachmentBean
	 * @throws Aa83bPIFException
	 *             e
	 */
	public static Y31AttachmentBean put(String nombreFichero,
			String rutaFichero, InputStream contenidoFichero)
			throws Aa83bPIFException {
		Long ttl = null;
		try {
			// Se recupera el TTL definido en el properties
			ttl = Long.valueOf(Aa83bUtilProperties
					.getProperty(Aa83bUtilProperties.PIF_TTL));
		} catch (NumberFormatException e) {
			ttl = Aa83bUtilPIF.ttl_default;
		}
		return Aa83bUtilPIF.put(nombreFichero, rutaFichero, contenidoFichero,
				false, ttl);
	}

	/**
	 * 
	 * Guarda un archivo en PIF, en la ruta especificada pudiendo elegir el
	 * tiempo de vida, y si se debe mantener el nombre.
	 * 
	 * @param nombreFichero
	 *            String
	 * @param rutaFichero
	 *            String
	 * @param contenidoFichero
	 *            InputStream
	 * @param mantenerNombre
	 *            Boolean
	 * @param ttl
	 *            Long
	 * @return Y31AttachmentBean
	 * @throws Aa83bPIFException
	 *             e
	 */
	public static Y31AttachmentBean put(String nombreFichero,
			String rutaFichero, InputStream contenidoFichero,
			Boolean mantenerNombre, Long ttl) throws Aa83bPIFException {
		Aa83bUtilPIF.logger.trace("put INI");
		ttl = Long.valueOf(Aa83bUtilProperties.PIF_TTL);
		Y31AttachmentBean ficheroPIF = null;
		// Path completo
		String path = Aa83bUtilPIF.calculaRutaFichero(nombreFichero,
				rutaFichero);
		try {
			// Subir archivo a pif
			Y31JanoService y31JanoService = Y31JanoServiceAbstractFactory
					.getInstance();
			ficheroPIF = y31JanoService.put(Aa83bUtilSeguridad
					.getTokenDocumentXLNets(Aa83BConstants.COD_APLICACION),
					contenidoFichero, path, ttl);
		} catch (Y31JanoServiceGenericException e) {
			Aa83bUtilPIF.logger.error("Error en put", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceFileNameFormatException e) {
			Aa83bUtilPIF.logger.error("Error en put", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			Aa83bUtilPIF.logger.error("Error en put", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceEventJmsException e) {
			Aa83bUtilPIF.logger.error("Error en put", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			Aa83bUtilPIF.logger.error("Error en put", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		}
		Aa83bUtilPIF.logger.trace("put FIN",
				Aa83bUtilPIF.pifFiletoString(ficheroPIF));
		return ficheroPIF;
	}

	/**
	 * Copia un archivo entre carpetas PIF.
	 * 
	 * @param rutaOrigen
	 *            Incluye carpeta y nombre del archivo
	 * @param carpetaDestino
	 *            Solo la carpeta a la que se quiere copiar el archivo
	 * @return Y31AttachmentBean
	 * @throws Aa83bPIFException
	 *             e
	 */
	public static Y31AttachmentBean copy(String rutaOrigen,
			String carpetaDestino) throws Aa83bPIFException {
		System.out.println("Y31AttachmentBean.copy");
		Aa83bUtilPIF.logger.trace("copy INI");
		Y31AttachmentBean ficheroPIF = null;
		System.out.println("Y31AttachmentBean.copy 1");
		try {
			StringBuilder rutaDestino = new StringBuilder(
					Aa83BConstants.STRING_BUILDER_INIT);
			rutaDestino.append(carpetaDestino);
			rutaDestino
					.append(rutaOrigen.substring(rutaOrigen.lastIndexOf("/")));

			System.out.println("Y31AttachmentBean.copy 2: " + rutaDestino);

			// Mover archivo de carpeta pif
			Y31JanoService y31JanoService = Y31JanoServiceAbstractFactory
					.getInstance();
			System.out.println("Despues de GetInstalnce: ");

			System.out.println("Despues de rutaOrigen: " + rutaOrigen);
			System.out.println("Despues de rutaDestino: "
					+ rutaDestino.toString());

			ficheroPIF = y31JanoService.copy(Aa83bUtilSeguridad
					.getTokenDocumentXLNets(Aa83BConstants.COD_APLICACION),
					rutaOrigen, rutaDestino.toString());

			System.out.println("Despues de copy" + ficheroPIF);
			System.out.println("Despues de copy" + ficheroPIF.toString());
		} catch (Y31JanoServiceGenericException e) {
			Aa83bUtilPIF.logger.error("Error en copy", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceFileNameFormatException e) {
			Aa83bUtilPIF.logger.error("Error en copy", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			Aa83bUtilPIF.logger.error("Error en copy", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceEventJmsException e) {
			Aa83bUtilPIF.logger.error("Error en copy", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			Aa83bUtilPIF.logger.error("Error en copy", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		} catch (Y31JanoServiceFileNotFoundException e) {
			Aa83bUtilPIF.logger.error("Error en copy", e);
			throw new Aa83bPIFException(Aa83bPIFException.PUT_ERROR, e);
		}
		Aa83bUtilPIF.logger.trace("copy FIN",
				Aa83bUtilPIF.pifFiletoString(ficheroPIF));
		return ficheroPIF;
	}

	/**
	 * Obtiene el contenido de un fichero de PIF. Si rutaFichero es null, se
	 * cogera la ruta por defecto de la aplicacion.
	 * 
	 * @param nombreFichero
	 *            String
	 * @param rutaFichero
	 *            String
	 * @return InputStream
	 * @throws Aa83bPIFException
	 *             e
	 */
	public static InputStream get(String nombreFichero, String rutaFichero)
			throws Aa83bPIFException {
		// Path completo
		String path = Aa83bUtilPIF.calculaRutaFichero(nombreFichero,
				rutaFichero);
		return Aa83bUtilPIF.get(path);
	}

	/**
	 * Obtiene el contenido de un fichero de PIF.
	 * 
	 * @param pathCompleto
	 *            String
	 * @return InputStream
	 * @throws Aa83bPIFException
	 *             e
	 */
	public static InputStream get(String pathCompleto) throws Aa83bPIFException {
		Aa83bUtilPIF.logger.trace("get INI");
		InputStream isResult = null;
		// Subir archivo a pif
		Y31AttachmentBean ficheroPIF = null;
		try {
			Y31JanoService y31JanoService = Y31JanoServiceAbstractFactory
					.getInstance();
			ficheroPIF = y31JanoService.info(Aa83bUtilSeguridad
					.getTokenDocumentXLNets(Aa83BConstants.COD_APLICACION),
					pathCompleto);
			if (ficheroPIF != null) {
				isResult = y31JanoService.get(Aa83bUtilSeguridad
						.getTokenDocumentXLNets(Aa83BConstants.COD_APLICACION),
						pathCompleto);
			}
		} catch (Y31JanoServiceFileNameFormatException e) {
			Aa83bUtilPIF.logger.error("Error en get", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			Aa83bUtilPIF.logger.error("Error en get", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			Aa83bUtilPIF.logger.error("Error en get", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceFileNotFoundException e) {
			Aa83bUtilPIF.logger.error("Error en get", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceOracleGenericException e) {
			Aa83bUtilPIF.logger.error("Error en get", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceGenericException e) {
			Aa83bUtilPIF.logger.error("Error en get", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		}
		Aa83bUtilPIF.logger.debug("get FIN",
				Aa83bUtilPIF.pifFiletoString(ficheroPIF));
		return isResult;
	}

	/**
	 * Crea la ruta al fichero pif. Si no se especifica la ruta, se utiliza la
	 * ruta de la aplicacion.
	 * 
	 * @param nombreFichero
	 *            String
	 * @param rutaFichero
	 *            String
	 * @return String
	 */
	private static String calculaRutaFichero(String nombreFichero,
			String rutaFichero) {
		// Path completo
		StringBuilder pathPIF = new StringBuilder();
		// Si no se especifica ruta, se coge la configurada por defecto
		if (Aa83bUtilidades.isEmpty(rutaFichero)) {
			pathPIF.append(Aa83bUtilProperties
					.getProperty(Aa83bUtilProperties.PIF_PATH_APP_TMP));
		} else {
			pathPIF.append(rutaFichero);
		}
		pathPIF.append(nombreFichero);
		return pathPIF.toString();
	}

	/**
	 * Funcion para tracear los datos de un fichero pif
	 * 
	 * @param ficheroPIF
	 *            Y31AttachmentBean
	 * @return String
	 */
	private static String pifFiletoString(Y31AttachmentBean ficheroPIF) {
		StringBuilder result = new StringBuilder(
				Aa83BConstants.STRING_BUILDER_INIT);
		result.append(" Y31AttachmentBean { ");
		if (ficheroPIF != null) {
			result.append(" [ fileName: ").append(ficheroPIF.getFileName())
					.append(" ]");
			result.append(" [ filePath: ").append(ficheroPIF.getFilePath())
					.append(" ]");
			result.append(" [ size: ").append(ficheroPIF.getSize())
					.append(" ]");
			result.append(" [ ttl: ").append(ficheroPIF.getTtl()).append(" ]");
			result.append(" [ creationDate: ")
					.append(ficheroPIF.getCreationDate()).append(" ]");
		} else {
			result.append("null");
		}
		result.append("}");
		return result.toString();
	}

	/**
	 * Obtiene la información de un fichero de PIF. Si rutaFichero es null, se
	 * cogera la ruta por defecto de la aplicacion.
	 * 
	 * @param nombreFichero
	 *            String
	 * @param rutaFichero
	 *            String
	 * @return Y31AttachmentBean
	 * @throws Aa83bPIFException
	 *             e
	 */
	public static Y31AttachmentBean info(String nombreFichero,
			String rutaFichero) throws Aa83bPIFException {
		// Path completo
		String path = Aa83bUtilPIF.calculaRutaFichero(nombreFichero,
				rutaFichero);
		return Aa83bUtilPIF.info(path);
	}

	/**
	 * Obtiene la información de un fichero PIF
	 * 
	 * @param pathCompleto
	 *            String
	 * @return Y31AttachmentBean
	 * @throws Aa83bPIFException
	 *             e
	 */
	public static Y31AttachmentBean info(String pathCompleto)
			throws Aa83bPIFException {
		Aa83bUtilPIF.logger.trace("info INI");
		Y31AttachmentBean ficheroPIF = null;
		try {
			Y31JanoService y31JanoService = Y31JanoServiceAbstractFactory
					.getInstance();
			ficheroPIF = y31JanoService.info(Aa83bUtilSeguridad
					.getTokenDocumentXLNets(Aa83BConstants.COD_APLICACION),
					pathCompleto);

		} catch (Y31JanoServiceFileNameFormatException e) {
			Aa83bUtilPIF.logger.error("Error en info", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			Aa83bUtilPIF.logger.error("Error en info", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			Aa83bUtilPIF.logger.error("Error en info", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceFileNotFoundException e) {
			Aa83bUtilPIF.logger.error("Error en info", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		} catch (Y31JanoServiceGenericException e) {
			Aa83bUtilPIF.logger.error("Error en info", e);
			throw new Aa83bPIFException(Aa83bPIFException.GET_ERROR, e);
		}
		Aa83bUtilPIF.logger.debug("info FIN",
				Aa83bUtilPIF.pifFiletoString(ficheroPIF));
		return ficheroPIF;
	}

	/**
	 * Valida la llamada al método info
	 * 
	 * @param pathCompleto
	 *            String
	 * @return boolean
	 */
	public static boolean validaInfo(String pathCompleto) {
		Y31AttachmentBean ficheroPIF = null;
		try {
			ficheroPIF = Aa83bUtilPIF.info(pathCompleto);
		} catch (Aa83bPIFException e) {
			return false;
		}
		if (ficheroPIF == null) {
			return false;
		}
		return true;
	}

	/**
	 * Genera un documento word en base a un XML y una Plantilla previamnete
	 * almacenados en PIF y devuelve su ruta en PIF
	 * 
	 * @param pathPifXML
	 *            la ruta del XML en PIF
	 * @param pathPifPlantilla
	 *            la ruta de la plantilla en PIF
	 * @param pathPifDocGenerado
	 *            la ruta en la que queremos guardar documento generado en PIF
	 * @return la ruta REAL del documento generado en PIF
	 * @throws Aa71bWebserviceException
	 *             error de Webservice
	 */

	public static String create(String pathPifXML, String pathPifPlantilla,
			String pathPifDocGenerado) throws Aa83bWebserviceException {

		Aa83bUtilPIF.logger.info("[Aa83bUtilPIF] : create INICIO: ");
		Aa83bUtilPIF.logger.info("[Aa83bUtilPIF] : create pathPifXML: "
				+ pathPifXML);
		Aa83bUtilPIF.logger.info("[Aa83bUtilPIF] : create pathPifPlantilla: "
				+ pathPifPlantilla);
		Aa83bUtilPIF.logger
				.info("[Aa83bUtilPIF] : create pathPifDocGeneradooo: "
						+ pathPifDocGenerado);

		Aa83bUtilPIF.logger.info("[Aa83bUtilPIF] : webserviceAa19B.getClass : "
				+ webserviceAa19B.getClass());

		try {
			String result = webserviceAa19B.create(pathPifXML,
					pathPifPlantilla, pathPifDocGenerado);
			Aa83bUtilPIF.logger.info("[Aa83bUtilPIF] : create result: "
					+ result);
			return result;

		} catch (Exception e) {
			throw new Aa83bWebserviceException(e);
		}
	}
}
