package com.ejie.aa83b.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import com.ejie.aa83b.exception.Aa83bSendJmsMessageException;
import com.ejie.aa83b.exception.Aa83bUnmarshalException;
import com.ejie.aa83b.model.tramitacion.Aa83bEventoTramitacion;

import weblogic.jms.extensions.WLMessageProducer;

/**
 * Utilidades de tramitación del expediente
 * 
 * @author DS
 * 
 */
public class Aa83bTramitacionUtils {
	/**
	 * Constructor privado por tratarse de una clase estatica
	 */
	private Aa83bTramitacionUtils() {
	}

	/**
	 * Dado un XML que representa un evento de tramitacion, devuelve el objeto
	 * que representa adicho evento
	 * 
	 * @param xml
	 *            el xml
	 * @return el objeto
	 * @throws Aa71bUnmarshalException
	 *             excepcion al convertir de xml a objeto
	 */
	public static Aa83bEventoTramitacion unmarshalEventoTramitacion(String xml)
			throws Aa83bUnmarshalException {
		try {
			JAXBContext jaxbContext = JAXBContext
					.newInstance(Aa83bEventoTramitacion.class);
			Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
			return (Aa83bEventoTramitacion) jaxbUnmarshaller
					.unmarshal(new ByteArrayInputStream(xml.getBytes("UTF-8")));
		} catch (JAXBException e) {
			throw new Aa83bUnmarshalException(
					"Error de JAXB al transformar de  xml a objeto", e);
		} catch (UnsupportedEncodingException e) {
			throw new Aa83bUnmarshalException(
					"Error de ENCODIG al transformar de  xml a objeto", e);
		}
	}

	/**
	 * Dado un Objeto que representa un evento de tramitacion, devuelve el XML
	 * que representa adicho evento
	 * 
	 * @param eventoTramitacion
	 *            el objeto
	 * @return el XML
	 * @throws Aa71bUnmarshalException
	 *             excepcion al convertir de objeto a XML
	 */
	public static String marshalEventoTRamitacion(
			Aa83bEventoTramitacion eventoTramitacion)
			throws Aa83bUnmarshalException {
		try {
			JAXBContext jaxbContext = JAXBContext
					.newInstance(Aa83bEventoTramitacion.class);
			Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
			ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
			jaxbMarshaller.marshal(eventoTramitacion, byteArrayStream);
			return new String(byteArrayStream.toByteArray());
		} catch (JAXBException e) {
			throw new Aa83bUnmarshalException(
					"Error de JAXB al transformar de  objeto a xml", e);
		}

	}

	/**
	 * Lanza un evento de tramitacion
	 * 
	 * @param eventoTramitacion
	 *            el evento
	 * @throws Aa83bSendJmsMessageException
	 *             excepcion al enviar el mensaje
	 */
	public static void lanzarEventoTramitacion(
			Aa83bEventoTramitacion eventoTramitacion)
			throws Aa83bSendJmsMessageException {
		QueueConnection queueconnection = null;
		try {
			InitialContext ctx = new InitialContext();
			QueueConnectionFactory factory = (QueueConnectionFactory) ctx
					.lookup("aa71b.aa71bConnectionFactory");
			queueconnection = factory.createQueueConnection();

			QueueSession qsession = queueconnection.createQueueSession(false,
					Session.CLIENT_ACKNOWLEDGE);
			Queue queue = (Queue) ctx.lookup("aa71b.aa71bProcessQueue");
			QueueSender qp = qsession.createSender(queue);
			queueconnection.start();
			TextMessage msg = qsession.createTextMessage();
			msg.setText(Aa83bTramitacionUtils
					.marshalEventoTRamitacion(eventoTramitacion));

			((WLMessageProducer) qp).setTimeToDeliver(Long.valueOf("10000"));
			qp.send(msg);
		} catch (JMSException e) {
			throw new Aa83bSendJmsMessageException("Error en la conexin JMS",
					e);
		} catch (Aa83bUnmarshalException e) {
			throw new Aa83bSendJmsMessageException(
					"Error al convertir a XML un objeto del tipo Aa71bEventoTramitacion",
					e);
		} catch (Exception e) {
			throw new Aa83bSendJmsMessageException(
					"Error indeterminado al lanzar el mensaje JMS", e);
		} finally {
			if (queueconnection != null) {
				try {
					queueconnection.close();
				} catch (JMSException e) {
					throw new Aa83bSendJmsMessageException(
							"Error al cerrar la conexion JMS", e);
				}
			}
		}
	}

}
