package com.ejie.aa83b.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa83b.model.Aa83b06t00;
import com.ejie.aa83b.model.Aa83b07t00;
import com.ejie.aa83b.model.Aa83b08t00;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b19t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.service.Aa83b30t00Service;

public class Aa83bSolicitudesUtil {

	//private static final Logger logger = LoggerFactory.getLogger(Aa83bSolicitudesUtil.class);

	public Aa83b06t00 guardarAccesoADE(Aa83b21t00 aa83b21t00New,
			String tipoAcceso, String telem) {
		Aa83b06t00 aa83b06t00 = new Aa83b06t00();
		// Fecha
		java.util.Date utilDate = new java.util.Date();
		Date date = new Date(utilDate.getTime());
		String fecha = "";
		String anyo = "";
		String mes = "";
		String dia = "";

		fecha = date.toString().replaceAll("-", "/");
		anyo = fecha.substring(0, 4);
		mes = fecha.substring(5, 7);
		dia = fecha.substring(8, 10);
		if ((Aa83BConstants.ES.equals(LocaleContextHolder.getLocale()
				.getLanguage()))) {
			fecha = dia + "/" + mes + "/" + anyo;
		} else {
			fecha = anyo + "/" + mes + "/" + dia;
		}

		java.util.Date utilDate2 = new java.util.Date();
		Date date2 = new Date(utilDate2.getTime());
		aa83b06t00.setfActu006(new Timestamp(date2.getTime()).toString());

		// aa83b06t00.setfActu006(fecha);// new Timestamp(date.getTime()));
		// Usuario
		if (telem.equals(Aa83BConstants.VALUE_STR_S))
			aa83b06t00.setUsuModif006("TELEMATICA");
		else {
			if (Aa83bUtilSeguridad.enOficina())
				aa83b06t00.setUsuModif006("Sin Login");
			else
				aa83b06t00.setUsuModif006(Aa83bUtilSeguridad.getUsername());
		}
		// TipoModif
		aa83b06t00.setTipoModif038(tipoAcceso);
		// Tipo de Solicitud
		aa83b06t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
		// Numero de Solicitud
		aa83b06t00.setId021NumSol(aa83b21t00New.getId021());
		aa83b06t00.setIdAno021(aa83b21t00New.getIdAno021());
		// Grabamos el acceso
		return aa83b06t00;
	}

	public Aa83b07t00 guardarAccesoESF(Aa83b23t00 aa83b23t00New,
			String tipoAcceso, String telem) {
		Aa83b07t00 aa83b07t00 = new Aa83b07t00();
		// Fecha
		java.util.Date utilDate = new java.util.Date();
		Date date = new Date(utilDate.getTime());
		String fecha = "";
		/*
		 * String formato = Aa83BConstants.ES_PATTERN; if
		 * (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
		 * .getLanguage())) { formato = Aa83BConstants.EU_PATTERN; }
		 */
		String anyo = "";
		String mes = "";
		String dia = "";

		fecha = date.toString().replaceAll("-", "/");
		anyo = fecha.substring(0, 4);
		mes = fecha.substring(5, 7);
		dia = fecha.substring(8, 10);
		if ((Aa83BConstants.ES.equals(LocaleContextHolder.getLocale()
				.getLanguage()))) {
			fecha = dia + "/" + mes + "/" + anyo;
		} else {
			fecha = anyo + "/" + mes + "/" + dia;
		}
		/*
		 * if ((Aa83bUtilSeguridad.enOficina()) &&
		 * (Aa83BConstants.ES.equals(LocaleContextHolder.getLocale()
		 * .getLanguage()))) { fecha = date.toString().replaceAll("-", "/");
		 * fecha = fecha.substring(8, 10) + "/" + fecha.substring(5, 7) + "/" +
		 * fecha.substring(0, 4); } else { fecha =
		 * date.toString().replaceAll("-", "/"); fecha = fecha.substring(8, 10)
		 * + "/" + fecha.substring(5, 7) + "/" + fecha.substring(0, 4); }
		 */
		aa83b07t00.setfActu007(fecha);// new Timestamp(date.getTime()));
		// Usuario
		if (telem.equals(Aa83BConstants.VALUE_STR_S))
			aa83b07t00.setUsuModif007("TELEMATICA");
		else {
			if (Aa83bUtilSeguridad.enOficina())
				aa83b07t00.setUsuModif007("PDTE COOKIE");
			else
				aa83b07t00.setUsuModif007(Aa83bUtilSeguridad.getUsername());
		}
		// TipoModif
		aa83b07t00.setTipoModif038(tipoAcceso);
		// Tipo de Solicitud
		aa83b07t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
		// Numero de Solicitud
		aa83b07t00.setId023NumSol(aa83b23t00New.getId023());
		aa83b07t00.setIdAno023(aa83b23t00New.getIdAno023());
		// Grabamos el acceso
		return aa83b07t00;
	}

	public Aa83b08t00 guardarAccesoARR(Aa83b25t00 aa83b25t00New,
			String tipoAcceso, String telem) {
		Aa83b08t00 aa83b08t00 = new Aa83b08t00();
		// Fecha
		java.util.Date utilDate = new java.util.Date();
		Date date = new Date(utilDate.getTime());
		String fecha = "";
		String anyo = "";
		String mes = "";
		String dia = "";

		fecha = date.toString().replaceAll("-", "/");
		anyo = fecha.substring(0, 4);
		mes = fecha.substring(5, 7);
		dia = fecha.substring(8, 10);
		if ((Aa83BConstants.ES.equals(LocaleContextHolder.getLocale()
				.getLanguage()))) {
			fecha = dia + "/" + mes + "/" + anyo;
		} else {
			fecha = anyo + "/" + mes + "/" + dia;
		}
		/*
		 * if ((Aa83bUtilSeguridad.enOficina()) &&
		 * (Aa83BConstants.ES.equals(LocaleContextHolder.getLocale()
		 * .getLanguage()))) { fecha = date.toString().replaceAll("-", "/");
		 * fecha = fecha.substring(8, 10) + "/" + fecha.substring(5, 7) + "/" +
		 * fecha.substring(0, 4); } else { fecha =
		 * date.toString().replaceAll("-", "/"); fecha = fecha.substring(8, 10)
		 * + "/" + fecha.substring(5, 7) + "/" + fecha.substring(0, 4); }
		 */
		aa83b08t00.setfActu008(fecha);// new Timestamp(date.getTime()));
		// Usuario
		if (telem.equals(Aa83BConstants.VALUE_STR_S))
			aa83b08t00.setUsuModif008("TELEMATICA");
		else {
			if (Aa83bUtilSeguridad.enOficina())
				aa83b08t00.setUsuModif008("PDTE COOKIE");
			else
				aa83b08t00.setUsuModif008(Aa83bUtilSeguridad.getUsername());
		}
		// TipoModif
		aa83b08t00.setTipoModif038(tipoAcceso);
		// Tipo de Solicitud
		aa83b08t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
		// Numero de Solicitud
		aa83b08t00.setId025NumSol(aa83b25t00New.getId025());
		aa83b08t00.setIdAno025(aa83b25t00New.getIdAno025());
		// Grabamos el acceso
		return aa83b08t00;
		// TODO Auto-generated method stub
	}

	public Aa83b09t00 guardarHistoADE(Aa83b21t00 aa83b21t00New,
			String codFase1, String codTram1, String telem) {
		java.util.Date utilDate = new java.util.Date();
		Date date = new Date(utilDate.getTime());
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		aa83b09t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
		aa83b09t00.setId021NumSol(aa83b21t00New.getId021());
		aa83b09t00.setIdAno021(aa83b21t00New.getIdAno021());
		aa83b09t00.setId001Fase(Integer.parseInt(codFase1));
		aa83b09t00.setId002Tram(Integer.parseInt(codTram1));
		aa83b09t00.setfActu009(new Timestamp(date.getTime()));
		if (telem.equals(Aa83BConstants.VALUE_STR_S)) {
			aa83b09t00.setUsua009("TELEMATICA");
			aa83b09t00.setUsuMod009("TELEMATICA");
		} else {
			if (Aa83bUtilSeguridad.enOficina()) {
				aa83b09t00.setUsua009("PDTE COOKIE");
				aa83b09t00.setUsuMod009("PDTE COOKIE");
			} else {
				aa83b09t00.setUsua009(Aa83bUtilSeguridad.getUsername());
				aa83b09t00.setUsuMod009(Aa83bUtilSeguridad.getUsername());
			}
		}
		return aa83b09t00;

	}

	public Aa83b10t00 guardarHistoESF(Aa83b23t00 aa83b23t00New,
			String codFase1, String codTram1, String telem) {
		java.util.Date utilDate = new java.util.Date();
		Date date = new Date(utilDate.getTime());
		Aa83b10t00 aa83b10t00 = new Aa83b10t00();
		aa83b10t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
		aa83b10t00.setId023NumSol(Long.parseLong(aa83b23t00New.getId023()
				.toString()));
		aa83b10t00.setIdAno023(aa83b23t00New.getIdAno023());
		aa83b10t00.setId001Fase(Integer.parseInt(codFase1));
		aa83b10t00.setId002Tram(Integer.parseInt(codTram1));
		aa83b10t00.setfActu010(new Timestamp(date.getTime()));
		if (telem.equals(Aa83BConstants.VALUE_STR_S)) {
			aa83b10t00.setUsua010("TELEMATICA");
			aa83b10t00.setUsuMod010("TELEMATICA");
		} else {
			if (Aa83bUtilSeguridad.enOficina()) {
				aa83b10t00.setUsua010("PDTE COOKIE");
				aa83b10t00.setUsuMod010("PDTE COOKIE");
			} else {
				aa83b10t00.setUsua010(Aa83bUtilSeguridad.getUsername());
				aa83b10t00.setUsuMod010(Aa83bUtilSeguridad.getUsername());
			}
		}
		// TODO Auto-generated method stub
		return aa83b10t00;
	}

	public Aa83b11t00 guardarHistoARR(Aa83b25t00 aa83b25t00New,
			String codFase1, String codTram1, String telem) {
		java.util.Date utilDate = new java.util.Date();
		Date date = new Date(utilDate.getTime());
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		aa83b11t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
		aa83b11t00.setId025NumSol(Integer.parseInt(aa83b25t00New.getId025()
				.toString()));
		aa83b11t00.setIdAnoSol025(aa83b25t00New.getIdAno025());
		aa83b11t00.setId001Fase(Integer.parseInt(codFase1));
		aa83b11t00.setId002Tram(Integer.parseInt(codTram1));
		aa83b11t00.setfActu011(new Timestamp(date.getTime()));

		if (telem.equals(Aa83BConstants.VALUE_STR_S)) {
			aa83b11t00.setUsua011("TELEMATICA");
			aa83b11t00.setUsuMod011("TELEMATICA");
		} else {

			if (Aa83bUtilSeguridad.enOficina()) {
				aa83b11t00.setUsua011("PDTE COOKIE");
				aa83b11t00.setUsuMod011("PDTE COOKIE");
			} else {
				aa83b11t00.setUsua011(Aa83bUtilSeguridad.getUsername());
				aa83b11t00.setUsuMod011(Aa83bUtilSeguridad.getUsername());
			}
		}
		// TODO Auto-generated method stub
		return aa83b11t00;

	}
	
	public List<Aa83b30t00> getDocumentosOrdenadosAlf(Aa83b30t00Service aa83b30t00Service, String tipoSol, String codFase, String codTram) {

		Aa83b30t00 documentoTipo = new Aa83b30t00();
		documentoTipo.setId003TipoSol(Integer.parseInt(tipoSol));
		documentoTipo.setId001Fase(Aa83bUtilidades.formatStringToInteger(Aa83BConstants.COD_FASE_1));
		documentoTipo.setId002Tram(Aa83bUtilidades.formatStringToInteger(Aa83BConstants.COD_TRAM_1));
		List<Aa83b30t00> listaTiposDoc = aa83b30t00Service.getDocumentosOrdenadosAlf(documentoTipo);
		
		return listaTiposDoc;
	}
	
	/**
	 * @param aa83b19t00ListTecnicos List<Aa83b19t00>
	 * @return List<Aa83b19t00>
	 */
	public List<Aa83b19t00> getTecnicosCaducados (List<Aa83b19t00> aa83b19t00ListTecnicos){
		
		List<Aa83b19t00> tecnicosCaducados = new ArrayList<Aa83b19t00>();
		DateFormat format = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		Date hoy = new Date();
		
		for (int j = 0; j < aa83b19t00ListTecnicos.size(); j++) {
			Aa83b19t00 tecnico = aa83b19t00ListTecnicos.get(j);
			try {
				String fechaFinVigenciaStr = tecnico.getFecfinvigencia019();
				if (fechaFinVigenciaStr != null) {
					Date dateFinVigencia = format.parse(fechaFinVigenciaStr);
					if (dateFinVigencia.before(hoy)) {
						tecnicosCaducados.add(tecnico);
					}
				}
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}
		return tecnicosCaducados;
	}
	
	/**
	 * @param aa83b19t00ListDirector List<Aa83b19t00>
	 * @return List<Aa83b19t00>
	 */
	public List<Aa83b19t00> getDirectoresCaducados (List<Aa83b19t00> aa83b19t00ListDirector){
		
		List<Aa83b19t00> directoresCaducados = new ArrayList<Aa83b19t00>();
		DateFormat format = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		Date hoy = new Date();
		
		for (int j = 0; j < aa83b19t00ListDirector.size(); j++) {
			Aa83b19t00 director = aa83b19t00ListDirector.get(j);
			try {
				String fechaFinVigenciaStr = director.getFecfinvigencia019();
				if (fechaFinVigenciaStr != null) {
					Date dateFinVigencia = format.parse(fechaFinVigenciaStr);
					if (dateFinVigencia.before(hoy)) {
						directoresCaducados.add(director);
					}
				}
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}
		return directoresCaducados;
	}
	
	public String getDescResultadoResolucion (int res){
		String resolFav = "";
		switch (res) {
		case 0:
			resolFav = Aa83bUtilProperties.getProperty("RESOLUCION_DESFAVORABLE");
			break;
		case 1:
			resolFav = Aa83bUtilProperties.getProperty("RESOLUCION_FAVORABLE");
			break;
		case 2:
			resolFav = Aa83bUtilProperties.getProperty("RESOLUCION_ANULADA");
			break;
		default:
			break;
		}
		return resolFav;
	}
}
