package com.ejie.aa83b.util;

import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Clase para obtener el XML a partir de un objeto
 * 
 * @author DS
 * 
 * @param <O>
 *            Tipo de la clase a convertir a String (codificacion UTF-8).
 */
public class Aa83bMessageUnparser<O> {

	/**
	 * Metodo que genera un String con el XML que representa un objeto java.
	 * Utiliza codificacion ISO-8859-1.
	 * 
	 * @param object
	 *            <O> Objeto a convertir a String
	 * @return String
	 * @throws JAXBException
	 *             e
	 */
	public String parse(O object) throws JAXBException {
		return this.parse(object, Aa83BConstants.ISO_8859_1);
	}

	/**
	 * Metodo que genera un String con el XML que representa un objeto java
	 * 
	 * @param object
	 *            <O> Objeto a convertir a String
	 * @param encoding
	 *            Codificacion a utilizar
	 * @return String
	 * @throws JAXBException
	 *             e
	 */
	public String parse(O object, String encoding) throws JAXBException {

		if (object == null) {
			return null;
		}

		JAXBContext context = JAXBContext.newInstance(object.getClass());
		Marshaller marshaller = context.createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		marshaller.setProperty(Marshaller.JAXB_ENCODING, encoding);
		StringWriter stringWriter = new StringWriter();
		marshaller.marshal(object, stringWriter);

		return stringWriter.getBuffer().toString();
	}

	/**
	 * Metodo que genera un String con el XML que representa un objeto java.
	 * Utiliza codificacion ISO-8859-1.<br/>
	 * A utilizar cuando la clase no tienen la anotacion XMLRootElement pero si
	 * que tiene ObjectFactory.
	 * 
	 * @param jaxbElement
	 *            <O> Objeto a convertir a String
	 * @return String
	 * @throws JAXBException
	 *             e
	 */
	public String parse(JAXBElement<O> jaxbElement) throws JAXBException {
		return this.parse(jaxbElement, Aa83BConstants.ISO_8859_1);
	}

	/**
	 * Metodo que genera un String con el XML que representa un objeto java.<br/>
	 * A utilizar cuando la clase no tienen la anotacion XMLRootElement pero si
	 * que tiene ObjectFactory.
	 * 
	 * @param jaxbElement
	 *            JAXBElement
	 * @param encoding
	 *            String
	 * @return String
	 * @throws JAXBException
	 *             e
	 */
	public String parse(JAXBElement<O> jaxbElement, String encoding)
			throws JAXBException {

		JAXBContext context = JAXBContext.newInstance(jaxbElement.getValue()
				.getClass());
		Marshaller marshaller = context.createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		marshaller.setProperty(Marshaller.JAXB_ENCODING, encoding);
		StringWriter stringWriter = new StringWriter();
		marshaller.marshal(jaxbElement, stringWriter);

		return stringWriter.getBuffer().toString();
	}
}
