package com.ejie.aa83b.util;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Clase que implementa el parser de String a objeto Java (codifica desde
 * UTF-8).
 * 
 * @author DS
 * @param <O>
 *            Tipo a parsear
 */
public class Aa83bMessageParser<O> {

	private String packageName;

	/**
	 * Constructor de la clase
	 * 
	 * @param packageName
	 *            String
	 */
	public Aa83bMessageParser(String packageName) {
		this.packageName = packageName;
	}

	/**
	 * Metodo que parsea una cadena XML (utf-8) a un objeto java.
	 * 
	 * @param message
	 *            String
	 * @return <O> Objeto java del tipo especificado
	 * @throws JAXBException
	 *             e
	 * @throws UnsupportedEncodingException
	 *             e
	 */
	public O parse(String message) throws JAXBException,
			UnsupportedEncodingException {
		return this.parse(message, Aa83BConstants.UTF8);
	}

	/**
	 * Metodo que parsea una cadena XML a un objeto java
	 * 
	 * @param message
	 *            String
	 * @param encoding
	 *            Codificacion de la cadena
	 * @return <O> Objeto java del tipo especificado
	 * @throws JAXBException
	 *             e
	 * @throws UnsupportedEncodingException
	 *             e
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public O parse(String message, String encoding) throws JAXBException,
			UnsupportedEncodingException {
		if (message != null) {
			JAXBContext jc;
			// Paquete que contiene las clases generadas en la compilacion del
			// xsd
			jc = JAXBContext.newInstance(this.packageName);
			Unmarshaller unmarshaller = jc.createUnmarshaller();
			Object jaxbObject = null;

			// Le ponemos encoding a UTF-8 para que acepte
			// posibles caracteres extranyos
			jaxbObject = unmarshaller.unmarshal(new ByteArrayInputStream(
					message.getBytes(encoding)));

			/*
			 * Se realiza una comprobacion de que el elemento que devuelve la
			 * funcion 'unmarshal' sea de tipo JAXBElement. Si es asi, es
			 * necesario recuperar la clase que se quiere devolver de su
			 * atributo 'value'. La funcion unmarshal devuelve el objeto
			 * JAXBElement cuando encuentra algún problema con la anotacion
			 * 'xmlRootElement' de las clases a parsear.
			 */
			if (jaxbObject instanceof JAXBElement<?>) {
				return (O) ((JAXBElement) jaxbObject).getValue();
			} else {
				return (O) jaxbObject;
			}
		} else {// Si el mensaje es null devuelve null.
			return null;
		}
	}
}
