
package com.ejie.aa83b.util;

import com.ejie.aa83b.exception.Aa83bErrorGenericoException;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;




/**
 * Proporciona funciones de conversin de cadena de caracteres a Base64 y
 * viceversa.
 */

public final class Aa83bBase64 implements java.io.Serializable{

   /**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 1L;

/**
    * Construye un objeto de la clase.
    */
   
   private Aa83bBase64() {
   }

   /**
    * Codifica en Base64 un array de bytes.
    * 
    * @param decData
    *           Datos a codificar.
    * @return Datos codificados en Base64.
    */
   
   public static String encode(byte[] decData) {

      String encData;
      BASE64Encoder encoder;

      encoder = new BASE64Encoder();
      encData = encoder.encode(decData);

      return encData;

   }

   /**
    * Codifica en Base64 una cadena de caracteres.
    * 
    * @param decData
    *           Datos a codificar.
    * @return Datos codificados en Base64.
    */
   
   
   public static String encodeString(String decData) {
      return encode(decData.getBytes());
   }

   /**
    * Decodifica una cadena de caracteres que se encuentra codificada en 
    * formato Base64.
    * 
    * @param encData
    *           Datos a decodificar.
    * @return Datos decodificados.
    * @throws W83AException
    *            Si los datos a codificar no estn en formato Base64.
    */
   
   public static byte[] decode(String encData) throws Aa83bErrorGenericoException {

      byte[] decData;
      BASE64Decoder decoder;

      decoder = new BASE64Decoder();
      try {
         decData = decoder.decodeBuffer(encData);
      }
      catch (Exception exc) {
         throw new Aa83bErrorGenericoException(APP_CODE,  exc);
      }

      return decData;

   }

   /**
    * Decodifica una cadena de caracteres que se encuentra codificada en 
    * formato Base64.
    * 
    * @param encData
    *           Datos a decodificar.
    * @return Datos decodificados.
    * @throws W83AException
    *            Si los datos a codificar no estn en formato Base64.
    */
   
   public static String decodeToString(String encData) throws Aa83bErrorGenericoException {

      String decoded = null;

      try {
         decoded = new String(decode(encData));
      }
      catch (Exception exc) {
         throw new Aa83bErrorGenericoException(APP_CODE,  exc);      }
      return decoded;

   }
   
   /**
    * Decodifica una cadena de caracteres que se encuentra codificada en 
    * formato Base64.
    * 
    * @param encData
    *           Datos a decodificar.
    * @param encoding
    *           character encoding.
    * @return Datos decodificados.
    * @throws W83AException
    *            Si los datos a codificar no estn en formato Base64.
    */
   
   public static String decodeToString(String encData, String encoding) throws Aa83bErrorGenericoException {

      String decoded = null;

      try {
         decoded = new String(decode(encData), encoding);
      }
      catch (Exception exc) {
         throw new Aa83bErrorGenericoException(APP_CODE,  exc);
      }

      return decoded;

   }

   private static final String APP_CODE = "W83A"; 
}
