package com.ejie.aa83b.threadmonitor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.support.lob.DefaultLobHandler;

import com.ejie.aa83b.exception.Aa83bUnmarshalException;
import com.ejie.aa83b.model.tramitacion.Aa83bEventoTramitacion;

//import com.ejie.aa83b.service.Aa71b08s00Service;
//import com.ejie.aa83b.utils.Aa71bTramitacionUtils;
//import com.ejie.aa83b.model.Aa71b08s00;

import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;
//import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.util.Aa83bTramitacionUtils;

/**
 * Monitor de hilos de ejecucion
 * 
 * @author DS
 * 
 */
public class Aa83bThreadmonitor {

	private Aa83b34t00Service monitorService;

	private final String threadId;
	private Long traceNumber;
	private final String folderId;
	private Long tramiteId = 0L;
	private Long FaseId = 0L;

	/**
	 * Constructor por defecto
	 * 
	 * @param folderId
	 *            id expediente
	 */
	public Aa83bThreadmonitor(String folderId) {
		String uid = UUID.randomUUID().toString();
		StringBuilder id = new StringBuilder("AA83BTRACE");
		for (String s : uid.split("-")) {
			id.append(s.toUpperCase());
		}
		this.threadId = id.toString().toUpperCase();
		this.traceNumber = 1L;
		this.folderId = folderId;

	}

	/**
	 * Constructor para el caso en que sea necesario parsar el identificador del
	 * hilo, y el nmero de traza anterior
	 * 
	 * @param threadId
	 *            id del hilo d eejecucion
	 * @param traceNumber
	 *            numer ode traza anterior
	 * @param folderId
	 *            id expediente
	 */
	public Aa83bThreadmonitor(String threadId, Long traceNumber, String folderId) {
		this.threadId = threadId;
		this.traceNumber = traceNumber + 1;
		this.folderId = folderId;

	}

	/**
	 * obtiene el identificador del hilo
	 * 
	 * @return id del hilo
	 */
	public String getThreadId() {
		return this.threadId;
	}

	/**
	 * obtiene el numero de la traza
	 * 
	 * @return numero de traza
	 */
	public Long getTraceNumber() {
		return this.traceNumber;
	}

	/**
	 * Establece el servicio
	 * 
	 * @param monitorService
	 *            el servicio
	 */
	public void setMonitorService(Aa83b34t00Service monitorService) {
		this.monitorService = monitorService;
	}

	/**
	 * Rstablece el tramite vinculado a la traza
	 * 
	 * @param tramiteId
	 *            Long
	 */
	public void setTramiteId(Long tramiteId) {
		this.tramiteId = tramiteId;
	}

	/**
	 * Establece la fase vinculada a la traza
	 * 
	 * @param faseId
	 *            Long
	 */
	public void setFaseId(Long faseId) {
		FaseId = faseId;
	}

	/**
	 * Marca el inicio del mtodo
	 * 
	 * @param className
	 *            Nombre de la clase a la que pertenece el mtodo
	 * @param methodName
	 *            Nombre del mtofo
	 */
	public void markMethodStartPoint(String className, String methodName) {
		Aa83b34t00 trace = this.getTraceInstance();
		trace.setMetodo034(methodName);
		trace.setClase034(className);
		trace.setFlagnivel034(Aa83bTraceLevels.INFO.getValue());
		trace.setFregistro034(new Date());
		trace.setFlaginterv034(Aa83bTiposIntervencion.SIN_INTERVENCION
				.getValue());
		trace.setMensaje034Str("aa71b.threadMonitor.method.initPoint");
		this.trace(trace);
	}

	/**
	 * Marca el fin del mtodo
	 * 
	 * @param className
	 *            Nombre de la clase a la que pertenece el mtodo
	 * @param methodName
	 *            Nombre del mtofo
	 */
	public void markMethodEndPoint(String className, String methodName) {
		Aa83b34t00 trace = this.getTraceInstance();
		trace.setMetodo034(methodName);
		trace.setClase034(className);
		trace.setFlagnivel034(Aa83bTraceLevels.INFO.getValue());
		trace.setFregistro034(new Date());
		trace.setFlaginterv034(Aa83bTiposIntervencion.SIN_INTERVENCION
				.getValue());
		trace.setMensaje034Str("aa71b.threadMonitor.method.endPoint");
		this.trace(trace);
	}

	/**
	 * Genera una traza de error de apicacin
	 * 
	 * @param className
	 *            la clase en la que se produce el error
	 * @param methodName
	 *            el mtodo en el que se produce el error
	 * @param t
	 *            la excepcin
	 * @param codigoError
	 *            e cdigo de error
	 */
	public void traceAppError(String className, String methodName, Throwable t,
			String codigoError) {
		Aa83b34t00 trace = this.getTraceInstance();
		trace.setMetodo034(methodName);
		trace.setClase034(className);
		trace.setFlagnivel034(Aa83bTraceLevels.APP_ERROR.getValue());
		trace.setFregistro034(new Date());
		trace.setFlaginterv034(Aa83bTiposIntervencion.INTERVENCION_APLICACION
				.getValue());
		trace.setCoderror034(codigoError);
		trace.setMensaje034Str("aa71b.threadMonitor.errors." + codigoError
				+ "|||" + t.getMessage());

		InputStream stream = new ByteArrayInputStream(ExceptionUtils
				.getStackTrace(t).getBytes());

		SqlLobValue stacktraceLobValue = new SqlLobValue(stream,
				(int) ExceptionUtils.getStackTrace(t).length(),
				new DefaultLobHandler());
		trace.setStacktr08LobValue(stacktraceLobValue);

		this.trace(trace);
	}

	/**
	 * Genera una traza de error de apicacin
	 * 
	 * @param className
	 *            la clase en la que se produce el error
	 * @param methodName
	 *            el mtodo en el que se produce el error
	 * @param t
	 *            la excepcin
	 * @param codigoError
	 *            el cdigo de error
	 * @param eventoTramitacion
	 *            el mensaje jms que motiva la traza
	 */
	public void traceAppError(String className, String methodName, Throwable t,
			String codigoError, Aa83bEventoTramitacion eventoTramitacion) {
		Aa83b34t00 trace = this.getTraceInstance();
		trace.setMetodo034(methodName);
		trace.setClase034(className);
		trace.setFlagnivel034(Aa83bTraceLevels.APP_ERROR.getValue());
		trace.setFregistro034(new Date());
		trace.setFlaginterv034(Aa83bTiposIntervencion.INTERVENCION_APLICACION
				.getValue());
		trace.setCoderror034(codigoError);
		trace.setMensaje034Str("aa71b.threadMonitor.errors." + codigoError
				+ "|||" + t.getMessage());

		InputStream stream = new ByteArrayInputStream(ExceptionUtils
				.getStackTrace(t).getBytes());

		SqlLobValue stacktraceLobValue = new SqlLobValue(stream,
				(int) ExceptionUtils.getStackTrace(t).length(),
				new DefaultLobHandler());
		trace.setStacktr08LobValue(stacktraceLobValue);
		String mensajeJMS = null;
		try {
			mensajeJMS = Aa83bTramitacionUtils
					.marshalEventoTRamitacion(eventoTramitacion);
		} catch (Aa83bUnmarshalException e) {

		}
		if (mensajeJMS != null) {
			InputStream streamJMS = new ByteArrayInputStream(
					mensajeJMS.getBytes());
			SqlLobValue jmsmsg08LobValue = new SqlLobValue(streamJMS,
					(int) mensajeJMS.length(), new DefaultLobHandler());
			trace.setJmsmsg08LobValue(jmsmsg08LobValue);
		}

		this.trace(trace);
	}

	/**
	 * Genera una traza de error de sistema / imfraestructura
	 * 
	 * @param className
	 *            la clase en la que se produce el error
	 * @param methodName
	 *            el mtodo en el que se produce el error
	 * @param t
	 *            la excepcin
	 * @param codigoError
	 *            e cdigo de error
	 */
	public void traceSystemError(String className, String methodName,
			Throwable t, String codigoError) {
		Aa83b34t00 trace = this.getTraceInstance();
		trace.setMetodo034(methodName);
		trace.setClase034(className);
		trace.setFlagnivel034(Aa83bTraceLevels.SYSTEM_ERROR.getValue());
		trace.setFregistro034(new Date());
		trace.setFlaginterv034(Aa83bTiposIntervencion.INTERVENCION_INFRAESTRUCTURA
				.getValue());
		trace.setCoderror034(codigoError);
		trace.setMensaje034Str("aa71b.threadMonitor.errors." + codigoError
				+ "|||" + t.getMessage());
		InputStream stream = new ByteArrayInputStream(ExceptionUtils
				.getStackTrace(t).getBytes());

		SqlLobValue stacktraceLobValue = new SqlLobValue(stream,
				(int) ExceptionUtils.getStackTrace(t).length(),
				new DefaultLobHandler());
		trace.setStacktr08LobValue(stacktraceLobValue);

		this.trace(trace);
	}

	/**
	 * Genera una traza de error de sistema / imfraestructura
	 * 
	 * @param className
	 *            la clase en la que se produce el error
	 * @param methodName
	 *            el mtodo en el que se produce el error
	 * @param t
	 *            la excepcin
	 * @param codigoError
	 *            e cdigo de error
	 * @param eventoTramitacion
	 *            el mensaje jms que motiva la traza
	 */
	public void traceSystemError(String className, String methodName,
			Throwable t, String codigoError,
			Aa83bEventoTramitacion eventoTramitacion) {
		Aa83b34t00 trace = this.getTraceInstance();
		trace.setMetodo034(methodName);
		trace.setClase034(className);
		trace.setFlagnivel034(Aa83bTraceLevels.SYSTEM_ERROR.getValue());
		trace.setFregistro034(new Date());
		trace.setFlaginterv034(Aa83bTiposIntervencion.INTERVENCION_INFRAESTRUCTURA
				.getValue());
		trace.setCoderror034(codigoError);
		trace.setMensaje034Str("aa71b.threadMonitor.errors." + codigoError
				+ "|||" + t.getMessage());
		InputStream stream = new ByteArrayInputStream(ExceptionUtils
				.getStackTrace(t).getBytes());

		SqlLobValue stacktraceLobValue = new SqlLobValue(stream,
				(int) ExceptionUtils.getStackTrace(t).length(),
				new DefaultLobHandler());
		trace.setStacktr08LobValue(stacktraceLobValue);
		String mensajeJMS = null;
		try {
			mensajeJMS = Aa83bTramitacionUtils
					.marshalEventoTRamitacion(eventoTramitacion);
		} catch (Aa83bUnmarshalException e) {

		}
		if (mensajeJMS != null) {
			InputStream streamJMS = new ByteArrayInputStream(
					mensajeJMS.getBytes());
			SqlLobValue jmsmsg08LobValue = new SqlLobValue(streamJMS,
					(int) mensajeJMS.length(), new DefaultLobHandler());
			trace.setJmsmsg08LobValue(jmsmsg08LobValue);
		}

		this.trace(trace);
	}

	/**
	 * Genera una traza de Debug
	 * 
	 * @param className
	 *            Clase en la que se genera la traza
	 * @param methodName
	 *            mtodo que genera la traza
	 * @param msg
	 *            mensaje de la traza
	 */
	public void traceDebug(String className, String methodName, String msg) {
		Aa83b34t00 trace = this.getTraceInstance();
		trace.setMetodo034(methodName);
		trace.setClase034(className);
		trace.setFlagnivel034(Aa83bTraceLevels.DEBUG.getValue());
		trace.setFregistro034(new Date());
		trace.setFlaginterv034(Aa83bTiposIntervencion.SIN_INTERVENCION
				.getValue());
		trace.setMensaje034Str(msg);
		this.trace(trace);
	}

	/**
	 * Genera una ALERTA
	 * 
	 * @param className
	 *            Clase en la que se genera la alerta
	 * @param methodName
	 *            mtodo que genera la alerta
	 * @param msg
	 *            mensaje de alerta
	 */
	public void generateAlert(String className, String methodName, String msg) {
		Aa83b34t00 trace = this.getTraceInstance();
		trace.setMetodo034(methodName);
		trace.setClase034(className);
		trace.setFlagnivel034(Aa83bTraceLevels.WARNING.getValue());
		trace.setFregistro034(new Date());
		trace.setFlaginterv034(Aa83bTiposIntervencion.ALERTA.getValue());
		trace.setMensaje034Str(msg);
		this.trace(trace);
	}

	/**
	 * Obtiene una instancia de traza
	 * 
	 * @return Aa71b08s00
	 */
	private Aa83b34t00 getTraceInstance() {
		Aa83b34t00 trace = new Aa83b34t00(this.threadId, this.traceNumber);
		trace.setFolderid034(this.folderId);
		this.traceNumber++;
		return trace;
	}

	/**
	 * 
	 * @param trace
	 *            Aa71b08s00 la traza
	 */
	private void trace(Aa83b34t00 trace) {
		if (this.monitorService != null) {
			try {
				trace.setCodtra034(this.tramiteId.toString());
				trace.setCodfase034(this.FaseId.toString());
				if (trace.getMensaje034Str().length() > Integer
						.parseInt("2000")) {
					trace.setMensaje034Str(trace.getMensaje034Str().substring(
							0, Integer.parseInt("1999")));
				}

				this.monitorService.add(trace);
			} catch (Exception e) {
				Aa83b34t00 aa83b34t00 = new Aa83b34t00();
				aa83b34t00.setJmsid034(trace.getThreadid08());
				// CREAR METODO en la 34

				List<Aa83b34t00> result = this.monitorService.findAll(
						aa83b34t00, null);
				trace.setNumtraza034(new Long(result.size() + 1));
				this.monitorService.add(aa83b34t00);
				this.traceNumber = trace.getNumtraza034() + 1;
				this.generateAlert(this.getClass().getName(), "trace",
						"Se ha perdido el nunmero de traza, recalculando...");
			}
		}
	}
}
