package com.ejie.aa83b.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.jms.Message;
import javax.jms.TextMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.exception.Aa83bServiceException;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b18t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b28t00;
import com.ejie.aa83b.model.Aa83b29t00;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b32t00;
import com.ejie.aa83b.model.Aa83b33t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;
import com.ejie.aa83b.model.Aa83b36t00;
import com.ejie.aa83b.model.Aa83b37t00;
import com.ejie.aa83b.model.Aa83b41t00;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.model.Aa83bDocumentoDokusi;
import com.ejie.aa83b.model.Aa83bTipoDocumento;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bHexUtils;
import com.ejie.aa83b.util.Aa83bMessageParser;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContextParser;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.dokusi.T65BFSDWSClasePort;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.vdc.Q99USendMessageSCPFacadeWSSoap;
import com.ejie.schemas.t65b.T65BDocumentIDType;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
import org.w3c.dom.Document;

/**
 * Implementación del procesador de eventos de Tramitación del expediente
 * 
 * @author DS
 * 
 */
@Service(value = "aa83bTramitacionExpedienteService")
public class Aa83bTramitacionExpedienteServiceImpl implements
		Aa83bTramitacionExpedienteService {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bTramitacionExpedienteServiceImpl.class);

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private T65BFSDWSClasePort t65bService;

	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;

	@Autowired()
	private Aa83b35t00Service aa83b35t00Service;

	/** The service. */
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;

	/** The service. */
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;

	/** The service. */
	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;

	/** The service. */
	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;

	/** The service. */
	@Autowired()
	private Aa83b06t00Service aa83b06t00Service;

	/** The service. */
	@Autowired()
	private Aa83b07t00Service aa83b07t00Service;

	/** The service. */
	@Autowired()
	private Aa83b08t00Service aa83b08t00Service;

	/** The service. */
	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;

	/** The service. */
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;

	/** The service. */
	@Autowired()
	private Aa83b37t00Service aa83b37t00Service;

	/** The service. */
	@Autowired()
	private Aa83b41t00Service aa83b41t00Service;

	/** The service. */
	@Autowired()
	private Aa83b36t00Service aa83b36t00Service;

	/** The service. */
	@Autowired()
	private Aa83b31t00Service aa83b31t00Service;

	/** The service. */
	@Autowired()
	private Aa83b32t00Service aa83b32t00Service;

	/** The service. */
	@Autowired()
	private Aa83b33t00Service aa83b33t00Service;

	/** The service. */
	@Autowired()
	private Aa83b30t00Service aa83b30t00Service;

	/** The service. */
	@Autowired()
	private Aa83b18t00Service aa83b18t00Service;

	/** The service. */
	@Autowired()
	private Aa83b28t00Service aa83b28t00Service;

	/** The service. */
	@Autowired()
	private Aa83b29t00Service aa83b29t00Service;
	
	@Autowired()
	private Aa83bNoraService aa83bNoraService;

	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;

	/** The service. */
	@Autowired()
	private Q99USendMessageSCPFacadeWSSoap q99USendMessageSCPFacadeWSSoap;

	private static final int _1200 = 1200;

	@Override()
	@Transactional(rollbackFor = Throwable.class, timeout = Aa83bTramitacionExpedienteServiceImpl._1200)
	public void capturarEvento(Message mensajeJMS) throws Aa83bServiceException {

		// try {
		Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo capturarEvento");

		Aa83bTramitacionExpedienteServiceImpl.logger.info("Aqui capturarEvento -1 ");
		this.tramtitarEvento(mensajeJMS);

	}

	/**
	 * @param msg Message
	 */
	private void tramtitarEvento(Message msg) {
		Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo tramtitarEvento 1");
		int i = 1;

		Aa83b34t00 aa83b34t00 = new Aa83b34t00();
		Aa83b35t00 aa83b35t00 = new Aa83b35t00();
		TextMessage textMessage = null;
		try {

			textMessage = (TextMessage) msg;
			String xml = "";
			String jmsIdID = "";
			// Guardamos los datos en la tabla 37
			if (Aa83bUtilSeguridad.enOficina()) {
				Aa83bTramitacionExpedienteServiceImpl.logger.info("Entro en TRUCO ");
				// String truco = (Aa83bSesionUtils.leerFichero(
				// "C:/config/dominio_desa/REQ_Subsana_CDAR.xml", false));
				String truco = (Aa83bSesionUtils.leerFichero(
						"C:/config/dominio_desa/aa83b/mensajeJMS_Telematico_ARR.xml",
						false));
				xml = truco;
				jmsIdID = "123456789";
			} else {
				Aa83bTramitacionExpedienteServiceImpl.logger.info("Flujo normal");
				textMessage = (TextMessage) msg;
				xml = textMessage.getText();
				jmsIdID = textMessage.getStringProperty("messageIdPropagado");
				aa83b34t00.setJmsid034(jmsIdID);
			}

			xml = xml.replaceAll("&lt;", "<");
			xml = xml.replaceAll("&gt;", ">");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Aqui capturarEvento -" + i++);
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Voy a pintar el mensaje");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Mensaje de CDAR::" + xml + "::");

			// recogerEtiqueta(xml, "procedure");
			// recogerEtiqueta(xml, "registryDate");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo tramtitarEvento 2");
			Aa83bTramitacionExpedienteServiceImpl.logger
					.debug("Estoy en altaPapel0 - 1");
			java.util.Date utilDate = new java.util.Date();
			Date date = new Date(utilDate.getTime());
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo tramtitarEvento 3");

			// Cargamos el objeto 34
			aa83b34t00.setBloqueo034(0);
			String coddel034 = this.recogerEtiqueta(xml, "territorioHistorico");// "01";//puede
																			// ser
																			// 99,
																			// que
																			// es
																			// lakua
			Aa83bTramitacionExpedienteServiceImpl.logger
					.info("territorio historico==>" + coddel034);
			String jmsid034 = jmsIdID;// "DD";
			Aa83bTramitacionExpedienteServiceImpl.logger.info("jms id==>"
					+ jmsid034);
			String registryDate = this.recogerEtiqueta(xml, "registryDate");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("registryDate==>"
					+ registryDate);

			Long numano034 = new Long(this.recogerEtiqueta(xml, "registryDate")
					.substring(0, Aa83BConstants.CUATRO));
			Aa83bTramitacionExpedienteServiceImpl.logger.info("ao==>"
					+ numano034);
			Integer numdel034 = 0;// 123456;//no lo sabemos.duda
			String numreg034 = this.recogerEtiqueta(xml, "registryNumber");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("numreg034==>"
					+ numreg034);
			String qrcode034 = this.recogerEtiqueta(xml, "QRCode");// "QR";
			Aa83bTramitacionExpedienteServiceImpl.logger.info("qrcode034==>"
					+ qrcode034);

			String remitente034 = this.recogerEtiqueta(xml, "name");// "El que lo pide";
			Aa83bTramitacionExpedienteServiceImpl.logger.info("remitente034==>"
					+ remitente034);
			String situacion034 = Aa83BConstants.VOLCADA;
			String tipsub034 = "";

			String codPlatea_jms = this.recogerEtiqueta(xml, "procedure");// Aa83BConstants.COD_ADE_PLATEA;
			Aa83bTramitacionExpedienteServiceImpl.logger
					.info("codPlatea_jms==>" + codPlatea_jms);
			String tipo034 = "";// ???no lo sabemos. duda//o es solicitud o
								// requerimiento. depende del qr, si tiene sol o
								// no

			// miramos el procedicmiento que nos llega:
			if (codPlatea_jms.equals(Aa83BConstants.COD_ADE_PLATEA)){
				tipsub034 = Aa83BConstants.COD_ADE;
			} else {
				if (codPlatea_jms.equals(Aa83BConstants.COD_ESF_PLATEA)) {
					tipsub034 = Aa83BConstants.COD_ESF;
				} else {
					if (codPlatea_jms.equals(Aa83BConstants.COD_ARR_PLATEA)) {
						tipsub034 = Aa83BConstants.COD_ARR;
					}
				}
			}
			Aa83bTramitacionExpedienteServiceImpl.logger.info("tipsub034==>"
					+ tipsub034);
			aa83b34t00.setCoddel034(coddel034);

			aa83b34t00.setFlectura034(date);
			Aa83bTramitacionExpedienteServiceImpl.logger
					.info("setFlectura034==>" + date);
			String fechaXml = this.recogerEtiqueta(xml, "registryDate").substring(0,Aa83BConstants.OCHO);

			fechaXml = fechaXml.substring(Aa83BConstants.SEIS, Aa83BConstants.OCHO) + "/"
					+ fechaXml.substring(Aa83BConstants.CUATRO, Aa83BConstants.SEIS) + "/" + fechaXml.substring(0, Aa83BConstants.CUATRO);

			Aa83bTramitacionExpedienteServiceImpl.logger
					.info("fechaXml antes formater==>" + fechaXml);

			Aa83bTramitacionExpedienteServiceImpl.logger.info("registryDate==>"
					+ registryDate);

			Aa83bTramitacionExpedienteServiceImpl.logger.info("Y la fechaaaa");

			try {

				SimpleDateFormat formatter2 = new SimpleDateFormat(
				// "dd/MM/yyyy hh:mm:ss");
						"yyyyMMddHHmmss");
				java.util.Date dateRegistro2 = formatter2.parse(registryDate);

				Aa83bTramitacionExpedienteServiceImpl.logger
						.info("dateRegistro2==>" + dateRegistro2);
				Aa83bTramitacionExpedienteServiceImpl.logger.info("dateRegistro2==>" + dateRegistro2);
				aa83b34t00.setFregistro034(dateRegistro2);
				aa83b34t00.setFregistro034Str(registryDate);
			} catch (Exception fes) {
				Aa83bTramitacionExpedienteServiceImpl.logger
						.info("EXCEP  Aa83bTramitacionExpedienteServiceImpl: "
								+ fes.getMessage());
			}

			aa83b34t00.setJmsid034(jmsid034);
			aa83b34t00.setNumano034(numano034);
			aa83b34t00.setNumdel034(numdel034);
			aa83b34t00.setNumreg034(numreg034);
			aa83b34t00.setQrcode034(qrcode034);
			aa83b34t00.setRemitente034(remitente034);
			aa83b34t00.setSituacion034(situacion034);
			aa83b34t00.setTipsub034(tipsub034);
			// aa83b34t00.setMensaje034(Aa83bUtilidades.stringToClob(xml));
			aa83b34t00.setMensaje034(xml);

			// validar que existe la solicitud que viene en el cdigo qr
			String tipoSolqr = "";
			String anoSolqr = "";
			String numSolqr = "";
			boolean existe = false;

			Aa83bTramitacionExpedienteServiceImpl.logger.info("qrcode034::" + qrcode034);

			if (StringUtils.isNotEmpty(qrcode034)) {
				Aa83bTramitacionExpedienteServiceImpl.logger.info("qrcode034 VALIO::");
				if (qrcode034.length() > Aa83BConstants.DIEZ) {
					String[] qrpartes = qrcode034.split("#");
					Aa83bTramitacionExpedienteServiceImpl.logger.info("qrpartes.length:: " + qrpartes.length);
					Aa83bTramitacionExpedienteServiceImpl.logger.info("qrcode034:: " + qrcode034);
					Aa83bTramitacionExpedienteServiceImpl.logger.info("qrpartes.length:: " + qrpartes.length);
					if (qrpartes.length > 1) {
						Aa83bTramitacionExpedienteServiceImpl.logger.info("qrpartes[0]:: " + qrpartes[0]);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("qrpartes[1]:: " + qrpartes[1]);
						String[] datosSolicitud = qrpartes[1].split(":");
						Aa83bTramitacionExpedienteServiceImpl.logger.info("datosSolicitud:: " + datosSolicitud.length);
						if (datosSolicitud.length > 1) {
							tipoSolqr = datosSolicitud[0].substring(0, Aa83BConstants.TRES);
							anoSolqr = datosSolicitud[0].substring(Aa83BConstants.TRES, Aa83BConstants.SIETE);
							numSolqr = datosSolicitud[0].substring(Aa83BConstants.SIETE);
						}
					}
				}

				Aa83bTramitacionExpedienteServiceImpl.logger.info("tipoSolqr::" + tipoSolqr);
				Aa83bTramitacionExpedienteServiceImpl.logger.info("anoSolqr::" + anoSolqr);
				Aa83bTramitacionExpedienteServiceImpl.logger.info("numSolqr::" + numSolqr);

				if (Aa83BConstants.COD_ADE_STR.equals(tipoSolqr)) {
					Aa83b21t00 aa83b21t00 = new Aa83b21t00(Long.parseLong(anoSolqr), Integer.parseInt(numSolqr));
					aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);
					if (null != aa83b21t00.getId021()) {
						existe = true;
					}
				} else if (Aa83BConstants.COD_ESF_STR.equals(tipoSolqr)) {
					Aa83b23t00 aa83b23t00 = new Aa83b23t00(Long.parseLong(anoSolqr),
							Integer.parseInt(numSolqr));
					aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);
					if (null != aa83b23t00.getId023()) {
						existe = true;
					}
				} else if (Aa83BConstants.COD_ARR_STR.equals(tipoSolqr)) {
					Aa83b25t00 aa83b25t00 = new Aa83b25t00(Long.parseLong(anoSolqr),
							Integer.parseInt(numSolqr));
					aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);
					if (null != aa83b25t00.getId025()) {
						existe = true;
					}
				}
				// aa83b34t00.setMensaje034(Aa83bUtilidades.stringToClob(mensajeJMS));
				// Si es requerimiento de subsanacion cargamos el ID de la
				// solicitud
			}
			Aa83bTramitacionExpedienteServiceImpl.logger.info("existe::" + existe);

			if (!existe) {
				// Ee nueva solictud

				tipo034 = Aa83BConstants.TIPO_SOL;
				aa83b34t00.setCodapl034("0");
				aa83b34t00.setCodfase034(Aa83BConstants.COD_FASE_1);
				aa83b34t00.setCodtra034(Aa83BConstants.COD_TRAM_1);
				aa83b34t00.setCortra034(Long
						.parseLong(Aa83BConstants.COD_TRAM_1));

			} else {
				// Requerimiento de Subsanacion
				tipo034 = Aa83BConstants.TIPO_REQ;
				aa83b34t00.setCodapl034(numSolqr);
				aa83b34t00.setCodfase034(Aa83BConstants.COD_FASE_1);
				aa83b34t00.setCodtra034(Aa83BConstants.COD_TRAM_3);
				aa83b34t00.setCortra034(Long
						.parseLong(Aa83BConstants.COD_TRAM_3));
			}

			Aa83bTramitacionExpedienteServiceImpl.logger.info("tipo034==>"
					+ tipo034);
			aa83b34t00.setTipo034(tipo034);
			// Message message = session.createTextMessage(mensajeJMS);
			Aa83bTramitacionExpedienteServiceImpl.logger
					.info("Estoy en altaPapel0 - 3");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Antes Alta 34:: " + aa83b34t00.toString());
			this.aa83b34t00Service.add(aa83b34t00);
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Despues Alta 34");
			Aa83bTramitacionExpedienteServiceImpl.logger
					.info("Estoy en altaPapel0 - 4");

			String id = "";
			String texto = xml;
			// for (int d = 1; d <= numDocs; d++) {
			Aa83bTramitacionExpedienteServiceImpl.logger.info("ANTES OID");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("trato los documentOid::"
					+ texto.indexOf("<documentOid>"));
			while (texto.indexOf("<documentOid>") > -1) {
				texto = texto.substring(texto.indexOf("<documentOid><id>"));
				id = this.recogerEtiqueta(texto, "id");
				texto = texto.substring(texto.indexOf("</id></documentOid>"));
				Aa83bTramitacionExpedienteServiceImpl.logger
						.info("Guardando DOD==>" + id);
				Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardando DOD==>" + id);
				aa83b35t00.setOid035(id);
				aa83b35t00.setAa83b34t00(aa83b34t00);
				this.aa83b35t00Service.add(aa83b35t00);
			}

		} catch (Exception es) {
			Aa83bTramitacionExpedienteServiceImpl.logger.info("EXCEP::" + es.getMessage());
			Aa83bTramitacionExpedienteServiceImpl.logger.info("EXCEP  papel0: "
					+ es.getMessage());
		}

	}

	@Override()
	@Transactional(rollbackFor = Throwable.class, timeout = Aa83bTramitacionExpedienteServiceImpl._1200)
	public void capturarEventoTelematico(Message mensajeJMS)
			throws Aa83bServiceException {

		Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo capturarEventoTelematico 2");

		// this.tramtitarEvento(threadMonitor, eventoTramitacion,
		// mensajeJMS);
		Aa83b37t00 aa83b37t00 = new Aa83b37t00();

		aa83b37t00.setCodfase037(Aa83BConstants.COD_FASE_1);
		aa83b37t00.setCodtra037(Aa83BConstants.COD_TRAM_1);
		aa83b37t00.setRemitenteNom037("TEST ANTES DE METODO");
		// aa83b37t00 = aa83b37t00Service.add(aa83b37t00);
		this.tramtitarEventoTelematico(mensajeJMS);

		Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo capturarEventoTelematico 3");

	}

	private void tramtitarEventoTelematico(Message msg) {

		Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo tramtitarEvento 1");
		Aa83b37t00 aa83b37t00 = new Aa83b37t00();
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		TextMessage textMessage = null;
		String xml = "";
		String idFase = "";
		String idTramite = "";
		
		try {
			// Guardamos los datos en la tabla 37
			if (Aa83bUtilSeguridad.enOficina()) {
				String truco = (Aa83bSesionUtils.leerFichero("C:/config/dominio_desa/aa83b/mensajeJMS_Telematico_ARR.xml",false));
				xml = truco;
			} else {
				textMessage = (TextMessage) msg;
				xml = textMessage.getText();
				String jmsIdID = textMessage.getStringProperty("messageIdPropagado");
				aa83b37t00.setJmsid037(jmsIdID);
			}

			xml = xml.replaceAll("&lt;", "<");
			xml = xml.replaceAll("&gt;", ">");

			Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo tramtitarEventoTelematico::" + xml + "::--");
			// Aa83bTramitacionExpedienteServiceImpl.logger.info("Metodo tramtitarEvento 2.2::" + xml +
			// "::--");
			
			// Recoger Etiquetas del XML
			String procedure = this.recogerEtiqueta(xml, "procedureID");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("procedure::" + procedure);
			String registrySenderName = this.recogerEtiqueta(xml,"registrySenderName");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("registrySenderName" + registrySenderName);
			String registryNumber = this.recogerEtiqueta(xml, "registryNumber");
			String registryDate = this.recogerEtiqueta(xml, "registryTimestamp");
			String registrySenderID = this.recogerEtiqueta(xml, "registrySenderID");
		/*	String entityID = this.recogerEtiqueta(xml, "registrySenderID");
			String managingUnitID = this.recogerEtiqueta(xml, "managingUnitID");
			String managingUnitES = this.recogerEtiqueta(xml, "managingUnitNameEs");
			String managingUnitEU = this.recogerEtiqueta(xml, "managingUnitNameEu");
			String departamentoID = this.recogerEtiqueta(xml, "departmentID");
			String departamentoES = this.recogerEtiqueta(xml, "departmentNameEs");
			String departamentoEU = this.recogerEtiqueta(xml, "departmentNameEu");
			String procedureNameEs = this.recogerEtiqueta(xml, "procedureNameEs");
			String procedureNameEu = this.recogerEtiqueta(xml, "procedureNameEu");*/
			String solicitud = this.recogerEtiqueta(xml, "sourceBinary");
			String strSolicitud = new String(Aa83bHexUtils.decodeHex(solicitud.toCharArray()), "UTF-8");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Solicitud 2 (UTF-8)::" + strSolicitud);
			String ejgvDoc = this.recogerEtiqueta(strSolicitud, "ejgvDocument");
			String submissionType = this.recogerEtiqueta(xml, "submissionType");
			String codExpediente = this.recogerEtiqueta(xml, "folderNumber");
			String nombre = this.recogerEtiqueta(xml, "name");
			String apel1 = this.recogerEtiqueta(xml, "lastname1");
			String apel2 = this.recogerEtiqueta(xml, "lastname2");
			String dni = this.recogerEtiqueta(xml, "id");
			String tipodni = this.recogerEtiqueta(xml, "personType"); // personType
			String genero = this.recogerEtiqueta(ejgvDoc, "holder1Sexo");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Genero antes::" + genero + "::");
			
			genero = this.getGenero(genero);

			String language = this.recogerEtiqueta(ejgvDoc, "language");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Tratando idioma de Comunicacion en Telematica: language="+ language);
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Comparo con contante Castellano:"+ Aa83BConstants.LANG_CASTELLANO);
			if (language.equals(Aa83BConstants.LANG_CASTELLANO)){
				language = Aa83BConstants.LANG_CASTELLANO_COD;
			} else {
				language = Aa83BConstants.LANG_EUSKERA_COD;
			}			
			
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Genero despues::" + genero + "::");
			String telf1 = this.recogerEtiqueta(ejgvDoc, "Soli1Tlf1");
			String holder1Pais = this.recogerEtiqueta(ejgvDoc, "holder1Pais");
			// si la fecha llega en euskera se pone en formato castellano, para que no casque al insertar el registro en BD
			String solifNac = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "SolifNac"), language);
			String ComboProvinciaEmp = this.recogerEtiqueta(ejgvDoc,"ComboProvinciaEmp");
			String ComboMunicipioEmp = this.recogerEtiqueta(ejgvDoc,"ComboMunicipioEmp");

	//		String notification = this.recogerEtiqueta(ejgvDoc, "notification");
			String canal = this.recogerEtiqueta(xml, "channelType");
			String canalpostal = this.recogerEtiqueta(xml, "channelInfoTypeEvent");
			//String canalpostal = this.recogerEtiqueta(ejgvDoc, "postalAddress");
			String emailAddress = this.recogerEtiqueta(xml, "emailAddress");
			String smsNumber = this.recogerEtiqueta(xml, "smsNumber");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Canal Comunica::-channelType-::" + canal);

			
			// Guardar en objeto valores de las etiquetas
			aa83b37t00.setMensaje037(xml);
			aa83b37t00.setSituacion037(Aa83BConstants.VOLCADA);
			aa83b37t00.setRemitenteNom037(registrySenderName);
			aa83b37t00.setNumreg037(registryNumber);
			String ano = registryDate.substring(Aa83BConstants.SEIS, Aa83BConstants.DIEZ);
			aa83b37t00.setNumano037(Long.parseLong(ano));
			aa83b37t00.setRemitenteId037(registrySenderID);
			Aa83bTramitacionExpedienteServiceImpl.logger.info("\n\n\n*********** solicitud codificada ISO-8859-1 ***********");
			java.util.Date utilDate = new java.util.Date();
			Date date = new Date(utilDate.getTime());
			aa83b37t00.setFlectura037(date);
			String fechaXml = registryDate.substring(0, Aa83BConstants.DIEZ);
			SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
			java.util.Date dateRegistro = formatter.parse(registryDate);
			aa83b37t00.setFregistro037(dateRegistro);

			aa83b37t00.setTipoSol037(this.getTipoSolicitud(procedure));

			
			// Se da de alta el registro en el repositorio de entradas telematicas T37
			if ("4".equals(submissionType)){ //Es una subsanacion
				aa83b37t00.setSolRelac(codExpediente.replace("-", ":"));
				aa83b37t00.setCodfase037(Aa83BConstants.COD_FASE_1);
				aa83b37t00.setCodtra037(Aa83BConstants.COD_TRAM_4);
			} else {
				aa83b37t00.setCodfase037(Aa83BConstants.COD_FASE_1);
				aa83b37t00.setCodtra037(Aa83BConstants.COD_TRAM_1);
			}
			aa83b37t00 = this.aa83b37t00Service.add(aa83b37t00);

			// Contamos el numero de Documentos:
			// llamada al getProcedureFac para recuperar los
			// datos del procedimiento
			String idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");
			Aa83bConsultationContextParser resParser = new Aa83bConsultationContextParser();

			Aa83bConsultationContext res;
			String procedureRes = "";
			String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");

			if (!Aa83bUtilSeguridad.enOficina()) {
				try {
					procedureRes = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcedimiento);
					Aa83bTramitacionExpedienteServiceImpl.logger.info("procedureAdecuacion-->" + procedureRes);
					resParser = new Aa83bConsultationContextParser(procedureRes);
				} catch (Exception e) {
					Aa83bTramitacionExpedienteServiceImpl.logger.info("Tramitacion Excep1: " + e.getMessage());
					Aa83bTramitacionExpedienteServiceImpl.logger.error(e.getMessage());
				}
				res = resParser.getProcedureDataAll();
			} else {
				Aa83bTramitacionExpedienteServiceImpl.logger.info("Oficina, no llamos al WS de FCDP");
				res = new Aa83bConsultationContext();
				res.setDocumentalSeriesId("7424");
			}
			
			ArrayList<HashMap<String, String>> documentosEntregados = new ArrayList<HashMap<String, String>>();
			String sTextoBuscado = "<documentEvent>";
			String sTextoBuscadoFin = "</documentEvent>";
			String xmlTratabjo = xml;
			while (xmlTratabjo.indexOf(sTextoBuscado) > -1) {
				int inicioint = xmlTratabjo.indexOf(sTextoBuscado) + sTextoBuscado.length();
				int finint = xmlTratabjo.indexOf(sTextoBuscadoFin);
				String valor = xmlTratabjo.substring(inicioint, finint);
				Aa83bTramitacionExpedienteServiceImpl.logger.info(valor);

				String oid = "0";
				oid = this.recogerEtiqueta(valor, "oid");
				String tipoDokusi = this.recogerEtiqueta(valor, "roleId");
				
				Aa83b41t00 aa83b41t00 = new Aa83b41t00();
				aa83b41t00.setIdCod037(aa83b37t00.getId037());
				aa83b41t00.setMetaInf041(tipoDokusi);
	
				Aa83bTramitacionExpedienteServiceImpl.logger.info("tipoDokusi:::" + tipoDokusi);
				Aa83bTramitacionExpedienteServiceImpl.logger.info("oid:::" + oid);
				//En este if se graban los documentos que se han adjuntado a la solicitud en la tabla 41 (OIDs Docusi entrada Telematica)
				if (!"".equals(oid) || "ejgv_d_solicitud.0.0".equals(tipoDokusi)) {
					if (!"ejgv_d_solicitud.0.0".equals(tipoDokusi)) {
						// Control si es de Otros -ejgv_d_archivo-
						aa83b41t00.setIdCodOid041(oid);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Entro por NO Solictud");
						if (tipoDokusi.indexOf("ejgv_d_archivo") != -1) {
							// Recupero la info de Doc/otros
							String otrosDoc_es = this.recogerEtiqueta(valor, "roleNameEs");
							String otrosDoc_eu = this.recogerEtiqueta(valor, "roleNameEu");
							aa83b41t00.setDescEs041(otrosDoc_es);
							aa83b41t00.setDescEu041(otrosDoc_eu);
						}
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Inserto Soli en la Tabla 41:" + aa83b41t00.toString());

						aa83b41t00 = this.aa83b41t00Service.add(aa83b41t00);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Inserto Soli en la Tabla 41 OK");
					} else {
						// Guardo el DOC HTML en PIF
						// strSolicitud
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Entro por SI Solictud");
	
						if (!Aa83bUtilSeguridad.enOficina()) {
							String rutaDoc = Aa83bUtilProperties.PIF_PATH_APP_TMP+ "Solicitud_"+ aa83b37t00.getId037()+ ".html";
							DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
							DocumentBuilder builder = factory.newDocumentBuilder();
							Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
	
							Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));// NOPMD
	
							//Comentado para que salgan bien los acentos en el documento html que se sube a dokusi.
							//InputStream is = new ByteArrayInputStream(strSolicitud.getBytes());
							String strSol = new String(Aa83bHexUtils.decodeHex(solicitud.toCharArray()));
							InputStream is = new ByteArrayInputStream(strSol.getBytes());
	
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Input Stream decodeHex::"+ Aa83bHexUtils.decodeHex(solicitud.toCharArray()));
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Input Stream HTML::"+ is.toString());
	
							Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is, rutaDoc, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
	
							Aa83bTramitacionExpedienteServiceImpl.logger.info("adjunto remito despus del put " + rdoRTF.getFilePath());
//							String pathPifPlantilla = rdoRTF.getFilePath();
							// Ahora lo guardo en Dokusi
	
							String auditUser = "";
							// if (Aa83bUtilSeguridad.enOficina())
							// auditUser = "AA83B-1#AA83B-1#AA83B-1";
							// else
							// auditUser = Aa83bUtilSeguridad.getAuditUser();

							auditUser = dni + "#" + registrySenderName + "#TELEMATICA#AA83B";
	
							// Quitar esto
							auditUser = "AA83BTRA#AA83B-03, AA83B-03#AA83B-03#AA83B";

							String t65bAttributeList = "";
							String tipoDocumentalRem = "ejgv_d_solicitud";
							t65bAttributeList = "<attributeList><attribute><key>ejgv_origen</key><value>ORGANISMO_EXTERNO</value></attribute>"
									+ "<attribute><key>acl_name</key><value>ejgv_acl_d_AA83B_001</value></attribute><attribute><key>ejgv_serie</key><value>"
									+ res.getDocumentalSeriesId()
									+ "</value></attribute>"
									+ "<attribute><key>title</key><value>Solicitud original</value></attribute>"
									+ "<attribute><key>object_name</key><value>ejgv_d_archivo</value></attribute></attributeList>";

							Aa83bDocumentoDokusi documentoGuardar = new Aa83bDocumentoDokusi();
							documentoGuardar.setExtension("html");
							documentoGuardar.setAuditUserDokusi(auditUser);
							documentoGuardar.setContentType("text/html");
	
							String t65bContentType = "<content><pifId>"
									+ rdoRTF.getFilePath()
									+ "</pifId><format><extension>HTML</extension><mimeType>text/html</mimeType>"
									+ "</format></content>";
	
							documentoGuardar.setRutaPif(rdoRTF.getFilePath());
							Aa83bTipoDocumento tipoDocumento = new Aa83bTipoDocumento();
							tipoDocumento.setTipoDocumental("html");
							documentoGuardar.setTipoDocumento(tipoDocumento);

							// oid = "";
							try {
								Aa83bTramitacionExpedienteServiceImpl.logger.info("documentoGuardar HTML a guardar antes de llamar a Dokusi");
								Aa83bTramitacionExpedienteServiceImpl.logger.info("Tramitacion-12");
								String respuesta = this.t65bService.storeDocument(sesionToken, auditUser,t65bContentType,
												tipoDocumentalRem,t65bAttributeList);

								Aa83bTramitacionExpedienteServiceImpl.logger.info("Respuesta Dokusi:" + respuesta);

								T65BDocumentIDType obj = (T65BDocumentIDType) new Aa83bMessageParser<T65BDocumentIDType>(
										T65BDocumentIDType.class.getPackage().getName()).parse(respuesta);
								Aa83bTramitacionExpedienteServiceImpl.logger.info("Respuesta:" + respuesta.toString());
								String oidSol = obj.getId();
								Aa83bTramitacionExpedienteServiceImpl.logger.info("OID Solicitud:: " + oidSol);

								aa83b41t00.setIdCodOid041(oidSol);

								Aa83bTramitacionExpedienteServiceImpl.logger.info("Inserto Soli en la Tabla 41:" + aa83b41t00.toString());
								aa83b41t00 = this.aa83b41t00Service.add(aa83b41t00);
								Aa83bTramitacionExpedienteServiceImpl.logger.info("Inserto Soli en la Tabla 41 OK");
								// Ahora lo catalogo

							} catch (Exception e) {
								Aa83bTramitacionExpedienteServiceImpl.logger.error(e.getMessage());
							}
							// FIN DE SUBIR A DOKUSI LASOLICITUD

							Aa83bTramitacionExpedienteServiceImpl.logger.info("despus de subir a dokusi el HTML");

						}
					}
				} else {
					String organoEntregado = this.recogerEtiqueta(valor, "organoEntregado");
					if (!"".equals(organoEntregado)) {
						String tipoDoc = this.recogerEtiqueta(valor, "roleId");
						String documentoEntregado = this.recogerEtiqueta(valor, "documentoEntregado");
						String fechaEntregado = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "fechaEntregado"), language);
						HashMap<String, String> docEntregado = new HashMap<String, String>();
						docEntregado.put("documentoEntregado", documentoEntregado);
						docEntregado.put("organoEntregado", organoEntregado);
						docEntregado.put("fechaEntregado", fechaEntregado);
						docEntregado.put("tipoDoc", tipoDoc);
						// Si es de Otros -ejgv_d_archivo-
						if (tipoDoc.indexOf("ejgv_d_archivo") != -1) {
							// Recupero la info de Doc/otros
							String otrosDocEs = this.recogerEtiqueta(valor, "roleNameEs");
							String otrosDocEu = this.recogerEtiqueta(valor, "roleNameEu");
							docEntregado.put("descOtrosEs", otrosDocEs);
							docEntregado.put("descOtrosEu", otrosDocEu);
						}
						documentosEntregados.add(docEntregado);
					}
				}
	
				xmlTratabjo = xmlTratabjo.substring(finint + sTextoBuscadoFin.length(),xmlTratabjo.length());
	
			}
			
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Despues de tratar los documentos");
			Aa83bTramitacionExpedienteServiceImpl.logger.debug("procedure:::"+ procedure);

			// Aa83bTramitacionExpedienteServiceImpl.logger.info("Trato el canal de comunicacion");
			// Fuerzo a que el canal de comunicacion sea electrnco al llegar de
			// forma telemtica

			// Llamamos el WS de Alta de Expediente para que sea consultado
			// desde "Mis Expedientes"
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Antes del Alta de Expediente");
//			String sXMLExpedient = "";
			Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Despues del Alta de Expediente");
			Aa83bTramitacionExpedienteServiceImpl.logger.info("TipoSOL" + procedure + ":::" + Aa83BConstants.COD_ADE_PLATEA);
		
			if (!"4".equals(submissionType)){
				if (procedure.equals(Aa83BConstants.COD_ADE_PLATEA + "01")) {
					
					Aa83b21t00 aa83b21t00 = new Aa83b21t00();
					
					Aa83bTramitacionExpedienteServiceImpl.logger.info("ALTA EN ADECUACION");
					Aa83bTramitacionExpedienteServiceImpl.logger.info("ALTA EN ADECUACION");
					Aa83bTramitacionExpedienteServiceImpl.logger.info("Paso a dar de alta la Adecuacion");
					
					
					// Si es telematica, la notificacion siempre ser telemtica:
					if (canal.equals(Aa83BConstants.DOS_STR))
					{
						 
						String domicilioComuniCP = this.recogerEtiqueta(canalpostal,"cp");
						aa83b21t00.setCpostalComunic021(domicilioComuniCP);
						String domicilioComuniLetra = this.recogerEtiqueta(canalpostal,"letra");
						aa83b21t00.setLetraComunic021(domicilioComuniLetra);
						String domicilioComuniPiso = this.recogerEtiqueta(canalpostal,"piso");
						aa83b21t00.setPisoComunic021(domicilioComuniPiso);
						
						/*String domicilioComuniPortal = this.recogerEtiqueta(canalpostal,"portal");
						aa83b21t00.setNumeroComunic021(domicilioComuniPortal);
						String domicilioComuniBis= this.recogerEtiqueta(canalpostal,"bis");
						aa83b21t00.setBisComunic021(domicilioComuniBis);*/						
						
						// En el numero del portal pueden venir datos que no son numericos. 
						//Si eso sucede se guarda parte del dato en el campo BIS
						String domicilioComuniPortal = this.recogerEtiqueta(canalpostal,"portal");
						int posicion =  Aa83bUtilidades.getPosicionPrimeraLetra(domicilioComuniPortal);
						if (posicion == 0) {
							aa83b21t00.setNumeroComunic021(domicilioComuniPortal);
							aa83b21t00.setBisComunic021("");
						} else {
							aa83b21t00.setNumeroComunic021(domicilioComuniPortal.substring(0,posicion));
							aa83b21t00.setBisComunic021(domicilioComuniPortal.substring(posicion));
						}

						
						
						String domicilioComuniMunicipio = this.recogerEtiqueta(canalpostal,"municipio");
						String idMunicipio = domicilioComuniMunicipio.substring(domicilioComuniMunicipio.indexOf("(")+1, domicilioComuniMunicipio.indexOf(")"));
						aa83b21t00.setMunicipComunic021(idMunicipio);
						String domicilioComuniProvince = this.recogerEtiqueta(canalpostal,"provincia");
						String idProvincia = domicilioComuniProvince.substring(domicilioComuniProvince.indexOf("(")+1, domicilioComuniProvince.indexOf(")"));
						aa83b21t00.setProvinciaComunic021(idProvincia);
						aa83b21t00.setTipoNotificacion021(Aa83BConstants.CANAL_POSTAL_COD);
						String domicilioComuniDomicilio = this.recogerEtiqueta(canalpostal,"direccion");
						Aa83bCalle calle=new Aa83bCalle();
						calle.setDs_o(domicilioComuniDomicilio);
						calle.setProvincia_id(idProvincia);
						calle.setMunicipio_id(idMunicipio);
						calle = this.aa83bNoraService.findCallePorString(calle);
						if(StringUtils.isNotEmpty(calle.getId())){
							aa83b21t00.setCalleIdComunic021(calle.getId());
							aa83b21t00.setCalleComunic021(calle.getId());
						} else {
							aa83b21t00.setCalleComunic021(domicilioComuniDomicilio);
						}

					}else
					{
						aa83b21t00.setTipoNotificacion021(Aa83BConstants.CANAL_ELECTRONIC_COD);
					}
					aa83b21t00.setFecha021(registryDate);
					
		
					aa83b21t00.setNumReg021(aa83b37t00.getNumreg037());
					aa83b21t00.setIdAno021(Long.parseLong(ano));
					aa83b21t00.setApel1021(apel1);
					aa83b21t00.setApel2021(apel2);
					aa83b21t00.setNombre021(nombre);
					aa83b21t00.setNumDoc021(dni);
					aa83b21t00.setTelf1021(telf1);

					aa83b21t00.setLocalidadEmp021(ComboMunicipioEmp);
					aa83b21t00.setProvEmp021(ComboProvinciaEmp);
					if (!"".equals(holder1Pais)) {
						aa83b21t00.setNacionalidad021(Integer.parseInt(holder1Pais));
					}
					aa83b21t00.setfNac021(solifNac);
					aa83b21t00.setEmail021(emailAddress);
					Aa83bTramitacionExpedienteServiceImpl.logger.info("smsNumber::" + smsNumber + "::");
					/*
					 * if (smsNumber.equals("")) if (!telf1.equals("")) if
					 * (telf1.charAt(0) == ('6' | '7')) {
					 * Aa83bTramitacionExpedienteServiceImpl.logger.info("smsNumber: pongo el telf1" + telf1); smsNumber =
					 * telf1; }
					 */
					// if (smsNumber.equals(""))
					// if (!telf2.equals(""))
					// if (telf2.charAt(0) == ('6' | '7')) {
					// Aa83bTramitacionExpedienteServiceImpl.logger.info("smsNumber: pongo el telf2" + telf2);
					// smsNumber = telf2;
					// }
		
					// Cambiamos y ponemos el telefono del Canal
					// aa83b21t00.setTelf2021(telf2);
					if (!"".equals(smsNumber)) {
						aa83b21t00.setTelf2021(smsNumber);
					}
		
					aa83b21t00.setTelf_notificacion_021(smsNumber);
		
					aa83b21t00.setTelf1Rep021(smsNumber);
					aa83b21t00.setIdiomaComunic021(Integer.parseInt(language));
		
					aa83b21t00.setConsentimientos021(Aa83BConstants.VALUE_STR_S);
					aa83b21t00.setConsentimientos2021(Aa83BConstants.VALUE_STR_S);
		
					aa83b21t00.setId017Genero(Integer.parseInt(genero));
		
					// Identifiamos la relacion entre Tipos de Documentos Toolkit y
					// los nuestros
					aa83b21t00.setId012TipoDoc(Integer.parseInt(tipodni));
		
					String reagrupacion2 = this.recogerEtiqueta(ejgvDoc, "Reagrupacion2");
					if (!"".equals(reagrupacion2)) {
						aa83b21t00.setNumPersHabitan021(Long.parseLong(reagrupacion2));
					}
					String reagrupacion3 = this.recogerEtiqueta(ejgvDoc, "Reagrupacion3");
					if (!"".equals(reagrupacion3)) {
						aa83b21t00.setUdsFamHabitan021(Long.parseLong(reagrupacion3));
					}
					String reagrupacion4 = this.recogerEtiqueta(ejgvDoc, "Reagrupacion4");
					if (!"".equals(reagrupacion4)) {
						aa83b21t00.setNumMenoresHabitan021(Long.parseLong(reagrupacion4));
					}
					String reagrupacion5 = this.recogerEtiqueta(ejgvDoc, "Reagrupacion5");
					if (!"".equals(reagrupacion5)) {
						aa83b21t00.setNumAdultHabitan021(Long.parseLong(reagrupacion5));
					}

					String tituVivienda1 = this.recogerEtiqueta(ejgvDoc, "tituVivienda1");
					if (!"".equals(tituVivienda1)) {
						aa83b21t00.setId014TitularidadViv(Integer.parseInt(tituVivienda1));
					}
					String tituVivienda2 = this.recogerEtiqueta(ejgvDoc, "tituVivienda2");
					if (!"".equals(tituVivienda2)) {
						aa83b21t00.setId016DerechosOcup(Integer.parseInt(tituVivienda2));
					}
		
					String tituVivienda2Otros = this.recogerEtiqueta(ejgvDoc,"tituVivienda2Otros");
					aa83b21t00.setDerechoOcOtros021(tituVivienda2Otros);
		
					String domicilioInspec2CP = this.recogerEtiqueta(ejgvDoc,"DomicilioInspec2CP");
					aa83b21t00.setCp021(domicilioInspec2CP);
					String domicilioInspecLetra = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecLetra");
					aa83b21t00.setLetra021(domicilioInspecLetra);
					String domicilioInspecPiso = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecPiso");
					aa83b21t00.setPiso021(domicilioInspecPiso);
					
					/*String domicilioInspecPortal = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecPortal");
					aa83b21t00.setNumCalle021(domicilioInspecPortal);
					String domicilioInspecBis = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecBis");
					aa83b21t00.setBis021(domicilioInspecBis);*/
					
					// En el numero del portal pueden venir datos que no son numericos. 
					//Si eso sucede se guarda parte del dato en el campo BIS
					String domicilioInspecPortal = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecPortal");
					int posicion =  Aa83bUtilidades.getPosicionPrimeraLetra(domicilioInspecPortal);
					if (posicion == 0) {
						aa83b21t00.setNumCalle021(domicilioInspecPortal);
						aa83b21t00.setBis021("");
					} else {
						aa83b21t00.setNumCalle021(domicilioInspecPortal.substring(0,posicion));
						aa83b21t00.setBis021(domicilioInspecPortal.substring(posicion));
					}

					
					
					String domicilioInspecDomicilio = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecDomicilio");
					aa83b21t00.setCalle021(domicilioInspecDomicilio);
					String domicilioInspecMunicipio = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecMunicipio");
					aa83b21t00.setMunicipio021(domicilioInspecMunicipio);
					String domicilioInspecProvince = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecProvince");
					aa83b21t00.setProvincia021(domicilioInspecProvince);
		
					String comboMotivoSol = this.recogerEtiqueta(ejgvDoc,"ComboMotivoSol");
					if (!"".equals(comboMotivoSol)) {
						aa83b21t00.setId015MotivosSol(Integer.parseInt(comboMotivoSol));
					}
		
					String comboMotivoSolOtros = this.recogerEtiqueta(ejgvDoc,"ComboMotivoSolOtros");
					aa83b21t00.setMotivoOtros021(comboMotivoSolOtros);
		
					String sTextoReagrupar = this.recogerEtiqueta(ejgvDoc,"grupoRepeticionFamiliares");
		
					String[] reagrup = sTextoReagrupar.split("<elementoGR>");
					// Aa83bTramitacionExpedienteServiceImpl.logger.info("sTextoReagrupar:::" + reagrup.length);
		
					String edades[] = new String[reagrup.length - 1];
					String vinculos[] = new String[reagrup.length - 1];
		
					for (int r = 1; r < (reagrup.length); r++) {
						// Aa83bTramitacionExpedienteServiceImpl.logger.info("TEXTO:: " + r + "::" + reagrup[r]);
						// Aa83bTramitacionExpedienteServiceImpl.logger.info("sTextoReagrupar:: " + r + "::"
						// + sTextoReagrupar);
						String persReagrupParentesco = this.recogerEtiqueta(sTextoReagrupar, "PersReagrupParentesco");
						edades[r - 1] = persReagrupParentesco;
						sTextoReagrupar = sTextoReagrupar.substring(sTextoReagrupar.indexOf("</elementoGR>")
										+ "</elementoGR>".length(),
								sTextoReagrupar.length());
					}
		
					Aa83bTramitacionExpedienteServiceImpl.logger.info("sTextoReagrupar salida FOR::" + sTextoReagrupar);
		
					for (int r = 1; r < (reagrup.length); r++) {
						// Aa83bTramitacionExpedienteServiceImpl.logger.info("TEXTO:: " + r + "::" + reagrup[r]);
						String vinculo = this.recogerEtiqueta(sTextoReagrupar, "Vinculo");
						vinculos[r - 1] = vinculo;
						sTextoReagrupar = sTextoReagrupar.substring(
								sTextoReagrupar.indexOf("</Vinculo")
										+ "</Vinculo".length(),
								sTextoReagrupar.length());
						Aa83bTramitacionExpedienteServiceImpl.logger.info("VINCULOS::" + sTextoReagrupar);
					}
		
					// Este campo
					Aa83bTramitacionExpedienteServiceImpl.logger.info("reagrup.length" + reagrup.length);
					int max = reagrup.length - 1;
					if (max > Aa83BConstants.DIEZ) {
						max = Aa83BConstants.DIEZ;
					}
					aa83b21t00.setNumPersReagrupar021((long) max);
					Aa83bTramitacionExpedienteServiceImpl.logger.info("reagrup.length -- max" + max);
					aa83b21t00 = this.aa83b21t00Service.add(aa83b21t00);
					// Inserto las personas a reagrupar

					for (int r = 1; r <= (max); r++) {
						Aa83b18t00 aa83b18t00 = new Aa83b18t00();
						aa83b18t00.setIdAno021(aa83b21t00.getIdAno021());
						aa83b18t00.setId021NumSol(aa83b21t00.getId021());
						aa83b18t00.setEdad018(Long.parseLong(edades[r - 1]));
						aa83b18t00.setId013VinculosFam(Integer.parseInt(vinculos[r - 1]));
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Inserto en la tabla 18" + aa83b18t00.toString());
						aa83b18t00 = this.aa83b18t00Service.add(aa83b18t00);
					}
					
					// Guardo la relacin en la tabla 37
					aa83b37t00.setSolRelac(Aa83BConstants.COD_ADE_STR + ":"+ aa83b21t00.getIdAno021() + ":"
							+ aa83b21t00.getId021());
					aa83b37t00 = this.aa83b37t00Service.update(aa83b37t00);

					// Guardamos el acceso:
					this.aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(aa83b21t00, Aa83BConstants.ACCESOS_ALTA, "S"));
					
					idFase = Aa83BConstants.COD_FASE_1;
					idTramite = Aa83BConstants.COD_TRAM_0;
					// Guardamos el Historial de la tramitacion
					Aa83b09t00 aa83b09t00 = this.aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(aa83b21t00,idFase, idTramite, "S"));
					Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el Histo TRAM:");

					// Tratamos la documentacion Adjunta, guardada en la tabla 41:
					List<Aa83b41t00> aa83b41t00List = this.getListaDocumentosAdjuntos(aa83b37t00.getId037());
					Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardo la Documentacion Acreditiva:");
					
					Aa83b41t00 aa83b41t00 = new Aa83b41t00();
					for (int i = 0; i < aa83b41t00List.size(); i++) {
						aa83b41t00 = aa83b41t00List.get(i);
						List<Aa83b36t00> aa83b36t00List = this.getListaTiposDocumentos(aa83b41t00);
						
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Resultado tabla 36:" + aa83b36t00List.size());
						Aa83b31t00 aa83b31t00 = new Aa83b31t00();
						aa83b31t00.setIdAno021(aa83b21t00.getIdAno021());
						aa83b31t00.setId021NumSol(aa83b21t00.getId021());
						aa83b31t00.setId009HistoTram(aa83b09t00.getId009());
						aa83b31t00.setOid031Papel0(aa83b41t00.getIdCodOid041());
						aa83b31t00.setTipoAportacion031("A");
						StringBuffer descripOtros = new StringBuffer();
		
						if (aa83b41t00.getDescEs041() != null) {
							descripOtros.append(aa83b41t00.getDescEs041());
						}
		
						if (aa83b41t00.getDescEu041() != null){
							descripOtros.append("/").append(aa83b41t00.getDescEu041());
						}
		
						aa83b31t00.setDescOtros031(descripOtros.toString());
						if (aa83b36t00List.size() == 0) {
							// Asimilamos a archivo generico
							aa83b31t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ADE")));
						} else {
							Aa83b36t00 aa83b36t00 = aa83b36t00List.get(0);
							// Guardo en la tabla 31
							// Busco el tipoDOC de la tabla 30
							List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ADE), 
									Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_1), aa83b36t00.getIdCodigo036());
		
							if (aa83b30t00List.size() != 0) {
								aa83b31t00.setId030TipDocSol(aa83b30t00List.get(0).getId030());
							}
							else {
								Aa83bTramitacionExpedienteServiceImpl.logger.info("ES de OTROS :: " + aa83b30t00List.size());
								aa83b31t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ADE")));
							}
						}
						aa83b31t00 = this.aa83b31t00Service.add(aa83b31t00);
					}
						
						for (HashMap<String, String> documentoEntregado : documentosEntregados) {
							Aa83b31t00 aa83b31t00 = new Aa83b31t00();
							aa83b31t00.setIdAno021(aa83b21t00.getIdAno021());
							aa83b31t00.setId021NumSol(aa83b21t00.getId021());
							aa83b31t00.setOid031Papel0("0");
							aa83b31t00.setId009HistoTram(aa83b09t00.getId009());
							aa83b31t00.setNomDocEntregado031(documentoEntregado.get("documentoEntregado"));
							aa83b31t00.setOrgDocEntregado031(documentoEntregado.get("organoEntregado"));
							
							if (null != documentoEntregado.get("fechaEntregado") && !"".equals(documentoEntregado.get("fechaEntregado")) ){
								SimpleDateFormat formatoFecha = new SimpleDateFormat("dd-MM-yyyy");
								Date fecEntreg = formatoFecha.parse(documentoEntregado.get("fechaEntregado"));
								aa83b31t00.setFecDocEntregado031(fecEntreg);
							} else {
								aa83b31t00.setFecDocEntregado031(null);
							}
							aa83b31t00.setTipoAportacion031("E");
							
							
							List<Aa83b36t00> aa83b36t00List = this.getListaTiposDocumentos(aa83b41t00);
							if (aa83b36t00List.size() == 0) {
								// Asimilamos a archivo generico
								aa83b31t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ADE")));
							} else {
								Aa83b36t00 aa83b36t00 = aa83b36t00List.get(0);
								// Guardo en la tabla 31
								// Busco el tipoDOC de la tabla 30
								List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ADE), 
										Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_1), aa83b36t00.getIdCodigo036());								
		
								if (aa83b30t00List.size() != 0) {
									aa83b31t00.setId030TipDocSol(aa83b30t00List.get(0).getId030());
								} else {
									aa83b31t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ADE")));
								}
							}
							
							String descOtrosEs = documentoEntregado.get("descOtrosEs");
							String descOtrosEu = documentoEntregado.get("descOtrosEu");
							StringBuffer descOtros = new StringBuffer();
							if (descOtrosEs != null) {
								descOtros.append(descOtrosEs);
							}
		
							if (descOtrosEu != null) {
								descOtros.append("/").append(descOtrosEu);
							}
		
							aa83b31t00.setDescOtros031(descOtros.toString());
		
							aa83b31t00 = this.aa83b31t00Service.add(aa83b31t00);
						}
		
						Aa83b31t00 adjunto = new Aa83b31t00();
						adjunto.setId021NumSol(aa83b21t00.getId021().intValue());
						adjunto.setIdAno021(aa83b21t00.getIdAno021().longValue());
						List<Aa83b31t00> aa83b31t00List = new ArrayList<Aa83b31t00>();
						aa83b31t00List = this.aa83b31t00Service.findAllLike(adjunto, null, false);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("listaAdjuntos-->" + aa83b31t00List);
						adjunto = new Aa83b31t00();
						for (int i = 0; i < aa83b31t00List.size(); i++) {
							adjunto = aa83b31t00List.get(i);
							Aa83bTramitacionExpedienteServiceImpl.logger.info("adjunto-->" + adjunto);
		
							if (adjunto.getId030TipDocSol().equals(
								Integer.getInteger("1"))) {
								break;
							}
						}
		
						aa83b21t00 = this.aa83b21t00Service.findIdsNora(aa83b21t00);
		
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el acceso:");
		
						String expediente = aa83bXMLGenerator.generarXmlInitExpedient(
								aa83b21t00, null, null, res, procedure, adjunto, null,
								null);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("*********** expediente-->" + expediente);
						this.q99USendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken, expediente, "initExpedientNT");


				
		
		
						} else if (procedure.equals(Aa83BConstants.COD_ARR_PLATEA + "01")) {
						Aa83bTramitacionExpedienteServiceImpl.logger.info("ALTA EN ARR");
						Aa83bTramitacionExpedienteServiceImpl.logger.info(":: Alta en ARR::");
						Aa83b25t00 aa83b25t00 = new Aa83b25t00();
						aa83b25t00.setFecha025(registryDate);
						
						// Si la comunicain es postal, recuperamos los datos de notificaicn
						if (canal.equals(Aa83BConstants.DOS_STR))
						{
							 
							String domicilioComuniCP = this.recogerEtiqueta(canalpostal,"cp");
							aa83b25t00.setCpostalComunic025(domicilioComuniCP);
							String domicilioComuniLetra = this.recogerEtiqueta(canalpostal,"letra");
							aa83b25t00.setLetraComunic025(domicilioComuniLetra);
							String domicilioComuniPiso = this.recogerEtiqueta(canalpostal,"piso");
							aa83b25t00.setPisoComunic025(domicilioComuniPiso);
							
							// En el numero del portal pueden venir datos que no son numericos. 
							//Si eso sucede se guarda parte del dato en el campo BIS
							String domicilioComuniPortal = this.recogerEtiqueta(canalpostal,"portal");
							int posicion =  Aa83bUtilidades.getPosicionPrimeraLetra(domicilioComuniPortal);
							if (posicion == 0) {
								aa83b25t00.setNumeroComunic025(domicilioComuniPortal);
								aa83b25t00.setBisComunic025("");	
							} else {
								aa83b25t00.setNumeroComunic025(domicilioComuniPortal.substring(0,posicion));
								aa83b25t00.setBisComunic025(domicilioComuniPortal.substring(posicion));
							}
							//String domicilioComuniBis = this.recogerEtiqueta(canalpostal,"bis");
							//aa83b25t00.setBisComunic025(domicilioComuniBis);
							
							String domicilioComuniMunicipio = this.recogerEtiqueta(canalpostal,"municipio");
							String idMunicipio = domicilioComuniMunicipio.substring(domicilioComuniMunicipio.indexOf("(")+1, domicilioComuniMunicipio.indexOf(")"));
							aa83b25t00.setMunicipComunic025(idMunicipio);
							String domicilioComuniProvince = this.recogerEtiqueta(canalpostal,"provincia");
							String idProvincia = domicilioComuniProvince.substring(domicilioComuniProvince.indexOf("(")+1, domicilioComuniProvince.indexOf(")"));
							aa83b25t00.setProvinciaComunic025(idProvincia);
							aa83b25t00.setTipoNotificacion025(Aa83BConstants.CANAL_POSTAL_COD);
							String domicilioComuniDomicilio = this.recogerEtiqueta(canalpostal,"direccion");
							Aa83bCalle calle=new Aa83bCalle();
							calle.setDs_o(domicilioComuniDomicilio);
							calle.setProvincia_id(idProvincia);
							calle.setMunicipio_id(idMunicipio);
							calle = this.aa83bNoraService.findCallePorString(calle);
							if(StringUtils.isNotEmpty(calle.getId())){
								aa83b25t00.setCalleIdComunic025(calle.getId());
								aa83b25t00.setCalleComunic025(calle.getId());
							} else {
								aa83b25t00.setCalleComunic025(domicilioComuniDomicilio);
							}
				
						}else
						{
							aa83b25t00.setTipoNotificacion025(Aa83BConstants.CANAL_ELECTRONIC_COD);
						}
						aa83b25t00.setNumReg025(aa83b37t00.getNumreg037());
						aa83b25t00.setIdAno025(Long.parseLong(ano));
						aa83b25t00.setApel1025(apel1);
						aa83b25t00.setApel2025(apel2);
						aa83b25t00.setNombre025(nombre);
						aa83b25t00.setNumDoc025(dni);
						aa83b25t00.setTelf1025(telf1);
						// aa83b25t00.setTelf2025(telf2);
						if (!"".equals(smsNumber)) {
							aa83b25t00.setTelf2025(smsNumber);
						}
						aa83b25t00.setLocalidadEmp025(ComboMunicipioEmp);
						aa83b25t00.setProvEmp025(ComboProvinciaEmp);
						BigDecimal a = new BigDecimal(holder1Pais);
						aa83b25t00.setNacionalidad025(a);
						aa83b25t00.setFNac025(solifNac);
						aa83b25t00.setConsentimientos025(Aa83BConstants.VALUE_STR_S);
						aa83b25t00.setEmail025(emailAddress);
						aa83b25t00.setTelf_notificacion_025(smsNumber);
						aa83b25t00.setTelf1Rep025(smsNumber);
						aa83b25t00.setIdiomaComunic025(Integer.parseInt(language));
		
						aa83b25t00.setId017Genero(Integer.parseInt(genero));
		
						// Identifiamos la relacion entre Tipos de Documentos Toolkit y
						// los nuestros
						aa83b25t00.setId012TipoDoc(Integer.parseInt(tipodni));
		
						// Recuperamos la parte propia de la Solicitud
						aa83b25t00.setFecha025(fechaXml);
						String fEmisionPadron = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "fEmisionPadron"), language);
						
						if (!"".equals(fEmisionPadron)) {
							aa83b25t00.setFechaEmisionPadron025(fEmisionPadron);
						}
		
						String fEmpActual = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "FEmpActual"), language);
						if (!"".equals(fEmpActual)) {
							aa83b25t00.setfEmpActual025(fEmpActual);
						}
		
						String fPrimerEmp = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "FPrimerEmp"), language);
						if (!"".equals(fPrimerEmp)) {
							aa83b25t00.setF1Empadron025(fPrimerEmp);
						}
		
						String fEntradaEsp = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "FEntradaEsp"), language);
						if (!"".equals(fEntradaEsp)) {
							aa83b25t00.setfEntradaEsp025(fEntradaEsp);
						}
		
						String contratado = this.recogerEtiqueta(ejgvDoc, "Contratado");
						if (!"".equals(contratado)) {
							aa83b25t00.setContratoDesc025(contratado);
						}
		
						String contratante = this.recogerEtiqueta(ejgvDoc, "Contratante");
						if (!"".equals(contratante)) {
							aa83b25t00.setContratante025(contratante);
						}
		
						// Domicilio Empadronamiento:
						String domicilioInspecChoice = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecChoice");
						//String domicilioInspec2CP = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspec2CP");
						String domicilioInspecLetra = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecLetra");
						String domicilioInspecPiso = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecPiso");
						String domicilioInspecPortal = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecPortal");
						String domicilioInspecDomicilio = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecDomicilio");
						// Falta el codigo:::
						String domicilioInspecMunicipio = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecMunicipio");
						String domicilioInspecProvince = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecProvince");
		
						aa83b25t00.setMunicipioEmpadron025(domicilioInspecMunicipio);
						aa83b25t00.setProvinciaEmpadron025(domicilioInspecProvince);
						aa83b25t00.setDireccionEmpadron025(domicilioInspecDomicilio
								+ " " + domicilioInspecPortal + " " + domicilioInspecPiso + " " + domicilioInspecLetra);
		
						// Vinculos Familiares
		
						// Guardamos la solictud de Arraigo:
						// Aa83bTramitacionExpedienteServiceImpl.logger.info("aa83b25t00::: " + aa83b25t00.toString());
						aa83b25t00 = this.aa83b25t00Service.add(aa83b25t00);
		
						// Guardo la relacin en la tabla 37
						aa83b37t00.setSolRelac(Aa83BConstants.COD_ARR_STR + ":"
								+ aa83b25t00.getIdAno025() + ":"
								+ aa83b25t00.getId025());
						aa83b37t00 = this.aa83b37t00Service.update(aa83b37t00);
		
						// Guardamos el HISTOTRAM
		
						Aa83b11t00 aa83b11t00 = this.aa83b11t00Service
								.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00,
										Aa83BConstants.COD_FASE_1,
										Aa83BConstants.COD_TRAM_0, "S"));
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el Histo TRAM:");
		
						// Guardamos el acceso:
						this.aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(
								aa83b25t00, Aa83BConstants.ACCESOS_ALTA, "S"));
		
						// Vinculos Familiares
						String sTextoReagrupar = this.recogerEtiqueta(ejgvDoc,
								"grupoRepeticionVinculos");
		
						String[] reagrup = sTextoReagrupar.split("<elementoGR>");
						// Aa83bTramitacionExpedienteServiceImpl.logger.info("sTextoReagrupar:::" + reagrup.length);
		
						String dnis[] = new String[reagrup.length - 1];
						String nombres[] = new String[reagrup.length - 1];
						String lugarResi[] = new String[reagrup.length - 1];
						String vinculos[] = new String[reagrup.length - 1];
		
						for (int r = 1; r < (reagrup.length); r++) {
							String persReagrupParentesco = this.recogerEtiqueta(
									sTextoReagrupar, "VinculosDNI");
							dnis[r - 1] = persReagrupParentesco;
							String persReagrupNombre = this.recogerEtiqueta(sTextoReagrupar,
									"VinculosNombre");
							nombres[r - 1] = persReagrupNombre;
							String persReagrupResidencia = this.recogerEtiqueta(
									sTextoReagrupar, "VinculosLugarResi");
							lugarResi[r - 1] = persReagrupResidencia;
		
							String persReagrupVinculo = this.recogerEtiqueta(
									sTextoReagrupar, "VinculoParentesco");
							vinculos[r - 1] = persReagrupVinculo;
		
							sTextoReagrupar = sTextoReagrupar.substring(
									sTextoReagrupar.indexOf("</elementoGR>")
											+ "</elementoGR>".length(),
									sTextoReagrupar.length());
		
						}
						;
		
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardamos los vinculos familiares::"
								+ reagrup.length);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("nombres:" + nombres.toString());
						Aa83bTramitacionExpedienteServiceImpl.logger.info("lugarResi:" + lugarResi.toString());
						Aa83bTramitacionExpedienteServiceImpl.logger.info("dnis:" + dnis.toString());
						Aa83bTramitacionExpedienteServiceImpl.logger.info("vinculos:" + vinculos.toString());
		
						for (int r = 1; r < (reagrup.length); r++) {
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Saco reagrupados ciclo:" + r);
							Aa83b29t00 aa83b29t00 = new Aa83b29t00();
							aa83b29t00.setIdAno025(aa83b25t00.getIdAno025());
							aa83b29t00.setId025NumSol(aa83b25t00.getId025());
							aa83b29t00.setNombre029(nombres[r - 1]);
							aa83b29t00.setResidencia029(lugarResi[r - 1]);
							aa83b29t00.setDniNie029(dnis[r - 1]);
							aa83b29t00.setParentensco029(vinculos[r - 1]);
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Inserto en la tabla 28"
									+ aa83b29t00.toString());
							aa83b29t00 = this.aa83b29t00Service.add(aa83b29t00);
						}
		
						// Tratamos la documentacion Adjunta, guardada en la tabla 41:
						List<Aa83b41t00> aa83b41t00List = this.getListaDocumentosAdjuntos(aa83b37t00.getId037());
		
						Aa83b41t00 aa83b41t00 = new Aa83b41t00();
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Num DOCS ARR::: " + aa83b41t00List.size());
						for (int i = 0; i < aa83b41t00List.size(); i++) {
							aa83b41t00 = aa83b41t00List.get(i);
							String tipoDocusi = aa83b41t00.getMetaInf041().replace(
									".0", "");
							String td_padre = null;
							String td_hijo = null;
							tipoDocusi = tipoDocusi.replace(".", ":");
							if (tipoDocusi.indexOf(":") != -1) {
								String[] trozos = tipoDocusi.split(":");
								td_padre = trozos[1];
								td_hijo = trozos[0];
							} else {
								td_padre = tipoDocusi;
							}
							Aa83b36t00 aa83b36t00 = new Aa83b36t00();
							aa83b36t00.setDescEs036(td_padre);
							aa83b36t00.setIdCodPadre(td_hijo);
		
							List<Aa83b36t00> aa83b36t00List = this.aa83b36t00Service
									.findAllLike(aa83b36t00, null, false);
		
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Num ARR aa83b36t00List::: "
									+ aa83b36t00List.size());
		
							Aa83b33t00 aa83b33t00 = new Aa83b33t00();
							aa83b33t00.setIdAno025(aa83b25t00.getIdAno025());
							aa83b33t00.setId025NumSol(aa83b25t00.getId025());
							aa83b33t00.setId011HistoTram(aa83b11t00.getId011());
							aa83b33t00.setOid033Papel0(aa83b41t00.getIdCodOid041());
							aa83b33t00.setTipoAportacion033("A");
							String descripOtros = "";
		
							if (aa83b41t00.getDescEs041() != null){
								descripOtros = aa83b41t00.getDescEs041();
							}
		
							if (aa83b41t00.getDescEu041() != null){
								descripOtros = descripOtros + "/" + aa83b41t00.getDescEu041();
							}
		
							aa83b33t00.setDescOtros033(descripOtros);
							if (aa83b36t00List.size() == 0) {
								// Asimilamos a archivo generico
								aa83b33t00
										.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties
												.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ARR")));
							} else {
								aa83b36t00 = aa83b36t00List.get(0);
								// Guardo en la tabla 31
								// Busco el tipoDOC de la tabla 30
								List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ARR), 
										Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_1), aa83b36t00.getIdCodigo036());								
		
								if (aa83b30t00List.size() != 0){
									aa83b33t00.setId030TipDocSol(aa83b30t00List.get(0)
											.getId030());
								}else {
									Aa83bTramitacionExpedienteServiceImpl.logger.info("ES de OTROS :: "
											+ aa83b30t00List.size());
		
									aa83b33t00
											.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties
													.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ARR")));
								}
							}
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardo el DOC ARR:: "
									+ aa83b33t00.toString());
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardo el DOC ARR:: " + aa83b33t00.toString());
							this.aa83b33t00Service.add(aa83b33t00);
						}
						
						for (HashMap<String, String> documentoEntregado : documentosEntregados) {
							Aa83b33t00 aa83b33t00 = new Aa83b33t00();
							aa83b33t00.setIdAno025(aa83b25t00.getIdAno025());
							aa83b33t00.setId025NumSol(aa83b25t00.getId025());
							aa83b33t00.setOid033Papel0("0");
							aa83b33t00.setId011HistoTram(aa83b11t00.getId011());
							aa83b33t00.setNomDocEntregado033(documentoEntregado.get("documentoEntregado"));
							aa83b33t00.setOrgDocEntregado033(documentoEntregado.get("organoEntregado"));
							
							if (null != documentoEntregado.get("fechaEntregado") && !"".equals(documentoEntregado.get("fechaEntregado")) ){
								SimpleDateFormat formatoFecha = new SimpleDateFormat("dd-MM-yyyy");
								Date fecEntreg = formatoFecha.parse(documentoEntregado.get("fechaEntregado"));
								aa83b33t00.setFecDocEntregado033(fecEntreg);
							} else {
								aa83b33t00.setFecDocEntregado033(null);
							}

							aa83b33t00.setTipoAportacion033("E");
							
							String tipoDocusi = documentoEntregado.get("tipoDoc").replace(".0", "");
							tipoDocusi = tipoDocusi.replace(".0", "");
							String td_padre = null;
							String td_hijo = null;
							tipoDocusi = tipoDocusi.replace(".", ":");
							if (tipoDocusi.indexOf(":") != -1) {
								String[] trozos = tipoDocusi.split(":");
								td_padre = trozos[1];
								td_hijo = trozos[0];
							} else {
								td_padre = tipoDocusi;
							}
							Aa83b36t00 aa83b36t00 = new Aa83b36t00();
							aa83b36t00.setDescEs036(td_padre);
							aa83b36t00.setIdCodPadre(td_hijo);
		
							List<Aa83b36t00> aa83b36t00List = this.aa83b36t00Service.findAllLike(aa83b36t00, null, false);
							if (aa83b36t00List.size() == 0) {
								// Asimilamos a archivo generico
								aa83b33t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ARR")));
							} else {
								aa83b36t00 = aa83b36t00List.get(0);
								// Guardo en la tabla 31
								// Busco el tipoDOC de la tabla 30
								List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ARR), 
										Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_1), aa83b36t00.getIdCodigo036());
								
								if (aa83b30t00List.size() != 0) {
									aa83b33t00.setId030TipDocSol(aa83b30t00List.get(0).getId030());
								} else {
									aa83b33t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ARR")));
								}
							}
							
							String descOtrosEs = documentoEntregado.get("descOtrosEs");
							String descOtrosEu = documentoEntregado.get("descOtrosEu");
							StringBuffer descOtros = new StringBuffer();
							if (descOtrosEs != null) {
								descOtros.append(descOtrosEs);
							}
		
							if (descOtrosEu != null) {
								descOtros.append("/").append(descOtrosEu);
							}
		
							aa83b33t00.setDescOtros033(descOtros.toString());
							
							aa83b33t00 = this.aa83b33t00Service.add(aa83b33t00);
						}
		
						Aa83b33t00 adjunto = new Aa83b33t00();
						adjunto.setId025NumSol(aa83b25t00.getId025().intValue());
						adjunto.setIdAno025(aa83b25t00.getIdAno025().longValue());
						List<Aa83b33t00> aa83b33t00List = new ArrayList<Aa83b33t00>();
						aa83b33t00List = this.aa83b33t00Service.findAllLike(adjunto, null,
								false);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("listaAdjuntos-->" + aa83b33t00List);
						adjunto = new Aa83b33t00();
						for (int i = 0; i < aa83b33t00List.size(); i++) {
							adjunto = aa83b33t00List.get(i);
							Aa83bTramitacionExpedienteServiceImpl.logger.info("adjunto-->" + adjunto);
		
							if (adjunto.getId030TipDocSol().equals(
									Integer.getInteger("1"))) {
								break;
							}
						}
		
						aa83b25t00 = this.aa83b25t00Service.findIdsNora(aa83b25t00);
		
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el acceso:");
		
						String expediente = aa83bXMLGenerator.generarXmlInitExpedient(
								null, null, aa83b25t00, res, procedure, null, null,
								adjunto);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("*********** expediente-->" + expediente);
						if (!Aa83bUtilSeguridad.enOficina()) {
							this.q99USendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken,expediente, "initExpedientNT");
						}
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el ACCESO:");
		
						} else if (procedure.equals(Aa83BConstants.COD_ESF_PLATEA + "01")) {
						Aa83bTramitacionExpedienteServiceImpl.logger.info("ALTA EN ESF");
						Aa83bTramitacionExpedienteServiceImpl.logger.info(":: Alta en ESF::");
						Aa83b23t00 aa83b23t00 = new Aa83b23t00();
						aa83b23t00.setFecha023(registryDate);

						// Si la comunicain es postal, recuperamos los datos de notificaicn
						if (canal.equals(Aa83BConstants.DOS_STR))
						{
							 
							String domicilioComuniCP = this.recogerEtiqueta(canalpostal,"cp");
							aa83b23t00.setCpostalComunic023(domicilioComuniCP);
							String domicilioComuniLetra = this.recogerEtiqueta(canalpostal,"letra");
							aa83b23t00.setLetraComunic023(domicilioComuniLetra);
							String domicilioComuniPiso = this.recogerEtiqueta(canalpostal,"piso");
							aa83b23t00.setPisoComunic023(domicilioComuniPiso);
							
							/*String domicilioComuniPortal = this.recogerEtiqueta(canalpostal,"portal");
							aa83b23t00.setNumeroComunic023(domicilioComuniPortal);
							String domicilioComuniBis = this.recogerEtiqueta(canalpostal,"bis");
							aa83b23t00.setBisComunic023(domicilioComuniBis);*/
							
							// En el numero del portal pueden venir datos que no son numericos. 
							//Si eso sucede se guarda parte del dato en el campo BIS
							String domicilioComuniPortal = this.recogerEtiqueta(canalpostal,"portal");
							int posicion =  Aa83bUtilidades.getPosicionPrimeraLetra(domicilioComuniPortal);
							if (posicion == 0) {
								aa83b23t00.setNumeroComunic023(domicilioComuniPortal);
								aa83b23t00.setBisComunic023("");
							} else {
								aa83b23t00.setNumeroComunic023(domicilioComuniPortal.substring(0,posicion));
								aa83b23t00.setBisComunic023(domicilioComuniPortal.substring(posicion));
							}
							
							String domicilioComuniMunicipio = this.recogerEtiqueta(canalpostal,"municipio");
							String idMunicipio = domicilioComuniMunicipio.substring(domicilioComuniMunicipio.indexOf("(")+1, domicilioComuniMunicipio.indexOf(")"));
							aa83b23t00.setMunicipComunic023(idMunicipio);
							String domicilioComuniProvince = this.recogerEtiqueta(canalpostal,"provincia");
							String idProvincia = domicilioComuniProvince.substring(domicilioComuniProvince.indexOf("(")+1, domicilioComuniProvince.indexOf(")"));
							aa83b23t00.setProvinciaComunic023(idProvincia);
							aa83b23t00.setTipoNotificacion023(Aa83BConstants.CANAL_POSTAL_COD);
							String domicilioComuniDomicilio = this.recogerEtiqueta(canalpostal,"direccion");
							Aa83bCalle calle=new Aa83bCalle();
							calle.setDs_o(domicilioComuniDomicilio);
							calle.setProvincia_id(idProvincia);
							calle.setMunicipio_id(idMunicipio);
							calle = this.aa83bNoraService.findCallePorString(calle);
							if(StringUtils.isNotEmpty(calle.getId())){
								aa83b23t00.setCalleIdComunic023(calle.getId());
								aa83b23t00.setCalleComunic023(calle.getId());
							} else {
								aa83b23t00.setCalleComunic023(domicilioComuniDomicilio);
							}
				
						}else
						{
							aa83b23t00.setTipoNotificacion023(Aa83BConstants.CANAL_ELECTRONIC_COD);
						}
						
						aa83b23t00.setNumReg023(aa83b37t00.getNumreg037());
						aa83b23t00.setIdAno023(Long.parseLong(ano));
						aa83b23t00.setApel1023(apel1);
						aa83b23t00.setApel2023(apel2);
						aa83b23t00.setNombre023(nombre);
						aa83b23t00.setNumDoc023(dni);
						aa83b23t00.setTelf1023(telf1);
						// aa83b23t00.setTelf2023(telf2);
						if (!"".equals(smsNumber)) {
							aa83b23t00.setTelf2023(smsNumber);
						}
						aa83b23t00.setLocalidadEmp023(ComboMunicipioEmp);
						aa83b23t00.setProvEmp023(ComboProvinciaEmp);
						aa83b23t00.setNacionalidad023(Integer.parseInt(holder1Pais));
						aa83b23t00.setFNac023(solifNac);
						aa83b23t00.setConsentimientos023(Aa83BConstants.VALUE_STR_S);
						aa83b23t00.setEmail023(emailAddress);
						aa83b23t00.setTelf_notificacion_023(smsNumber);
						aa83b23t00.setTelf1Rep023(smsNumber);
						aa83b23t00.setId012TipoDoc(Integer.parseInt(tipodni));
						aa83b23t00.setIdiomaComunic023(Integer.parseInt(language));
		
						aa83b23t00.setId017Genero(Integer.parseInt(genero));
		
						// Recuperamos la parte propia de la Solicitud
						String comboMotivoSol = this.recogerEtiqueta(ejgvDoc,
								"ComboMotivoSol");
						if (!"".equals(comboMotivoSol)){
							aa83b23t00.setId026Motivos(Integer.parseInt(comboMotivoSol));
						}
		
						String comboEstadoSol = this.recogerEtiqueta(ejgvDoc,
								"ComboEstadoSol");
						if (!"".equals(comboEstadoSol)){
							aa83b23t00.setId027EstadosEsf(Integer.parseInt(comboEstadoSol));
						}
						String fechaNotificacionP = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "FechaNotificacionP"), language);
						if (!"".equals(fechaNotificacionP)) {
							aa83b23t00.setFechaNotifTramite023(fechaNotificacionP);
						}
		
						String fechaCaducidad = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "FechaCaducidad"), language);
						aa83b23t00.setFecCadTarjeta023(fechaCaducidad);
		
						String tManifestado = this.recogerEtiqueta(ejgvDoc, "TManifestado");
						aa83b23t00.setTResiManifestado023(tManifestado);
		
						String tAcreditado = this.recogerEtiqueta(ejgvDoc, "TAcreditado");
						aa83b23t00.setTResiAcreditado023(tAcreditado);
		
						String contratado = this.recogerEtiqueta(ejgvDoc, "Contratado");
						String contratante = this.recogerEtiqueta(ejgvDoc, "Contratante");
						aa83b23t00.setContratante023(contratante);
						aa83b23t00.setContratoDesc023(contratado);
		
						String tActLaboral = this.recogerEtiqueta(ejgvDoc, "TActLaboral");
		
						String tBusLaboral = this.recogerEtiqueta(ejgvDoc, "TBusLaboral");
						if (!"".equals(tBusLaboral)) {
							aa83b23t00.setTotalDiasBusqueda023(Integer.parseInt(tBusLaboral));
						}
		
						if (!"".equals(tActLaboral)) {
							aa83b23t00.setTotalDiasActivo023(Integer.parseInt(tActLaboral));
						}
		
						String elementoSinTrabajo = this.recogerEtiqueta(ejgvDoc,
								"elementoSinTrabajo");
						String elementoOfertaTrabajo = this.recogerEtiqueta(ejgvDoc,
								"elementoOfertaTrabajo");
						String elementoContratoTrabajo = this.recogerEtiqueta(ejgvDoc,
								"elementoContratoTrabajo");
		
						aa83b23t00.setContrato023(elementoContratoTrabajo);
						aa83b23t00.setOferta023(elementoOfertaTrabajo);
						aa83b23t00.setPrestacion023(elementoSinTrabajo);
		
						String fEmisionPadron = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "fEmisionPadron"), language);
						if (!"".equals(fEmisionPadron)) {
							aa83b23t00.setFechaEmisionPadron023(fEmisionPadron);
						}
		
						String fEmpDomicActual = Aa83bUtilidades.convertirFechaStr(this.recogerEtiqueta(ejgvDoc, "fEmpDomicActual"), language);
						if (!"".equals(fEmpDomicActual)) {
							aa83b23t00.setFechaEmpadron023(fEmpDomicActual);
						}
		
						// Domicilio Empadronamiento:
						String domicilioInspecChoice = this.recogerEtiqueta(ejgvDoc,"DomicilioInspecChoice");
						//String domicilioInspec2CP = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspec2CP");
						String domicilioInspecLetra = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecLetra");
						String domicilioInspecPiso = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecPiso");
						String domicilioInspecPortal = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecPortal");
						String domicilioInspecDomicilio = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecDomicilio");
						// Falta el codigo:::
						String domicilioInspecMunicipio = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecMunicipio");
						String domicilioInspecProvince = this.recogerEtiqueta(domicilioInspecChoice, "DomicilioInspecProvince");
		
						aa83b23t00.setMunicipioEmpadron023(domicilioInspecMunicipio);
						aa83b23t00.setProvinciaEmpadron023(domicilioInspecProvince);
						aa83b23t00.setDireccionEmpadron023(domicilioInspecDomicilio
								+ " " + domicilioInspecPortal + " " + domicilioInspecPiso + " " + domicilioInspecLetra);
		
						// Guardamos la solictud de Esfuerzo:
						aa83b23t00 = this.aa83b23t00Service.add(aa83b23t00);
		
						// Guardo la relacin en la tabla 37
						aa83b37t00.setSolRelac(Aa83BConstants.COD_ESF_STR + ":"
								+ aa83b23t00.getIdAno023() + ":"
								+ aa83b23t00.getId023());
						aa83b37t00 = this.aa83b37t00Service.update(aa83b37t00);
		
						// Guardamos el HISTOTRAM
						Aa83b10t00 aa83b10t00 = this.aa83b10t00Service
								.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00,
										Aa83BConstants.COD_FASE_1,
										Aa83BConstants.COD_TRAM_0, "S"));
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el Histo TRAM:");
		
						// Guardamos el acceso:
						this.aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(
								aa83b23t00, Aa83BConstants.ACCESOS_ALTA, "S"));
		
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el ACCESO:");
		
						// Vinculos Familiares
						String sTextoReagrupar = this.recogerEtiqueta(ejgvDoc,
								"grupoRepeticionVinculos");
		
						String[] reagrup = sTextoReagrupar.split("<elementoGR>");
						// Aa83bTramitacionExpedienteServiceImpl.logger.info("sTextoReagrupar:::" + reagrup.length);
		
						String dnis[] = new String[reagrup.length - 1];
						String nombres[] = new String[reagrup.length - 1];
						String lugarResi[] = new String[reagrup.length - 1];
						String vinculos[] = new String[reagrup.length - 1];
		
						for (int r = 1; r < (reagrup.length); r++) {
							String persReagrupParentesco = this.recogerEtiqueta(
									sTextoReagrupar, "VinculosDNI");
							dnis[r - 1] = persReagrupParentesco;
							String persReagrupNombre = this.recogerEtiqueta(sTextoReagrupar,
									"VinculosNombre");
							nombres[r - 1] = persReagrupNombre;
							String persReagrupResidencia = this.recogerEtiqueta(
									sTextoReagrupar, "VinculosLugarResi");
							lugarResi[r - 1] = persReagrupResidencia;
		
							String persReagrupVinculo = this.recogerEtiqueta(
									sTextoReagrupar, "VinculoParentesco");
							vinculos[r - 1] = persReagrupVinculo;
		
							sTextoReagrupar = sTextoReagrupar.substring(
									sTextoReagrupar.indexOf("</elementoGR>")
											+ "</elementoGR>".length(),
									sTextoReagrupar.length());
		
						}
						;
		
						for (int r = 1; r < (reagrup.length); r++) {
							Aa83b28t00 aa83b28t00 = new Aa83b28t00();
							aa83b28t00.setIdAno023(aa83b23t00.getIdAno023());
							aa83b28t00.setId023NumSol(aa83b23t00.getId023());
							aa83b28t00.setNombre028(nombres[r - 1]);
							aa83b28t00.setResidencia028(lugarResi[r - 1]);
							aa83b28t00.setDniNie028(dnis[r - 1]);
							aa83b28t00.setParentesco028(vinculos[r - 1]);
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Inserto en la tabla 28"
									+ aa83b28t00.toString());
							aa83b28t00 = this.aa83b28t00Service.add(aa83b28t00);
						}
		
						// Tratamos la documentacion Adjunta, guardada en la tabla 41:
						List<Aa83b41t00> aa83b41t00List = this.getListaDocumentosAdjuntos(aa83b37t00.getId037());
						
						Aa83b41t00 aa83b41t00 = new Aa83b41t00();
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Tenemos estos adjuntos en ESF:: "
								+ aa83b41t00List.size());
						for (int i = 0; i < aa83b41t00List.size(); i++) {
							aa83b41t00 = aa83b41t00List.get(i);
							
							List<Aa83b36t00> aa83b36t00List = this.getListaTiposDocumentos(aa83b41t00);
							
							Aa83bTramitacionExpedienteServiceImpl.logger.info("Docs ESF aa83b36t00List"+ aa83b36t00List.size());
							
							Aa83b32t00 aa83b32t00 = new Aa83b32t00();
							aa83b32t00.setIdAno023(aa83b23t00.getIdAno023());
							aa83b32t00.setId023NumSol(aa83b23t00.getId023());
							aa83b32t00.setId010HistoTram(aa83b10t00.getId010());
							aa83b32t00.setOid032Papel0(aa83b41t00.getIdCodOid041());
							aa83b32t00.setTipoAportacion032("A");
							StringBuffer descripOtros = new StringBuffer();
							if (aa83b41t00.getDescEs041() != null) {
								descripOtros.append(aa83b41t00.getDescEs041());
							}
		
							if (aa83b41t00.getDescEu041() != null) {
								descripOtros.append("/").append(aa83b41t00.getDescEu041());
							}
		
							aa83b32t00.setDescOtros032(descripOtros.toString());
							
							if (aa83b36t00List.size() == 0) {
								// Asimilamos a archivo generico
								aa83b32t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ESF")));
							} else {
								Aa83b36t00 aa83b36t00 = aa83b36t00List.get(0);
								// Guardo en la tabla 31
								// Busco el tipoDOC de la tabla 30
								List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ESF), 
										Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_1), aa83b36t00.getIdCodigo036());
		
								Aa83bTramitacionExpedienteServiceImpl.logger.info("aa83b30t00List:" + aa83b30t00List.size());
		
								if (aa83b30t00List.size() != 0) {
									aa83b32t00.setId030TipDocSol(aa83b30t00List.get(0).getId030());
								} else {
									Aa83bTramitacionExpedienteServiceImpl.logger.info("ES de OTROS :: " + aa83b30t00List.size());
									aa83b32t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ESF")));
								}
							}
		
							this.aa83b32t00Service.add(aa83b32t00);
						}
						
						for (HashMap<String, String> documentoEntregado : documentosEntregados) {
							Aa83b32t00 aa83b32t00 = new Aa83b32t00();
							aa83b32t00.setIdAno023(aa83b23t00.getIdAno023());
							aa83b32t00.setId023NumSol(aa83b23t00.getId023());
							aa83b32t00.setOid032Papel0("0");
							aa83b32t00.setId010HistoTram(aa83b10t00.getId010());
							aa83b32t00.setNomDocEntregado032(documentoEntregado.get("documentoEntregado"));
							aa83b32t00.setOrgDocEntregado032(documentoEntregado.get("organoEntregado"));
							if (null != documentoEntregado.get("fechaEntregado") && !"".equals(documentoEntregado.get("fechaEntregado")) ){
								SimpleDateFormat formatoFecha = new SimpleDateFormat("dd-MM-yyyy");
								Date fecEntreg = formatoFecha.parse(documentoEntregado.get("fechaEntregado"));
								aa83b32t00.setFecDocEntregado032(fecEntreg);
							} else {
								aa83b32t00.setFecDocEntregado032(null);
							}
							

							aa83b32t00.setTipoAportacion032("E");
							
							String tipoDocusi = documentoEntregado.get("tipoDoc").replace(".0", "");
							tipoDocusi = tipoDocusi.replace(".0", "");
							String td_padre = null;
							String td_hijo = null;
							tipoDocusi = tipoDocusi.replace(".", ":");
							if (tipoDocusi.indexOf(":") != -1) {
								String[] trozos = tipoDocusi.split(":");
								td_padre = trozos[1];
								td_hijo = trozos[0];
							} else {
								td_padre = tipoDocusi;
							}
							Aa83b36t00 aa83b36t00 = new Aa83b36t00();
							aa83b36t00.setDescEs036(td_padre);
							aa83b36t00.setIdCodPadre(td_hijo);
		
							List<Aa83b36t00> aa83b36t00List = this.aa83b36t00Service.findAllLike(aa83b36t00, null, false);
							if (aa83b36t00List.size() == 0) {
								// Asimilamos a archivo generico
								aa83b32t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ESF")));
							} else {
								aa83b36t00 = aa83b36t00List.get(0);
								// Guardo en la tabla 31
								// Busco el tipoDOC de la tabla 30
								List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ESF), 
										Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_1), aa83b36t00.getIdCodigo036());								
		
								if (aa83b30t00List.size() != 0) {
									aa83b32t00.setId030TipDocSol(aa83b30t00List.get(0).getId030());
								} else {
									aa83b32t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ESF")));
								}
							}
							
							String descOtrosEs = documentoEntregado.get("descOtrosEs");
							String descOtrosEu = documentoEntregado.get("descOtrosEu");
							StringBuffer descOtros = new StringBuffer();
							if (descOtrosEs != null) {
								descOtros.append(descOtrosEs);
							}
		
							if (descOtrosEu != null) {
								descOtros.append("/").append(descOtrosEu);
							}
		
							aa83b32t00.setDescOtros032(descOtros.toString());
							
							aa83b32t00 = this.aa83b32t00Service.add(aa83b32t00);
						}
		
						Aa83b32t00 adjunto = new Aa83b32t00();
						adjunto.setId023NumSol(aa83b23t00.getId023().intValue());
						adjunto.setIdAno023(aa83b23t00.getIdAno023().longValue());
						List<Aa83b32t00> aa83b32t00List = new ArrayList<Aa83b32t00>();
						aa83b32t00List = this.aa83b32t00Service.findAllLike(adjunto, null, false);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("listaAdjuntos-->" + aa83b32t00List);
						adjunto = new Aa83b32t00();
						for (int i = 0; i < aa83b32t00List.size(); i++) {
							adjunto = aa83b32t00List.get(i);
							Aa83bTramitacionExpedienteServiceImpl.logger.info("adjunto-->" + adjunto);
		
							if (adjunto.getId030TipDocSol().equals(
									Integer.getInteger("1"))) {
								break;
							}
						}
		
						aa83b23t00 = this.aa83b23t00Service.findIdsNora(aa83b23t00);
		
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el acceso:");
		
						String expediente = aa83bXMLGenerator.generarXmlInitExpedient(
								null, aa83b23t00, null, res, procedure, null, adjunto,
								null);
						Aa83bTramitacionExpedienteServiceImpl.logger.info("*********** expediente-->" + expediente);
						this.q99USendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken,expediente, "initExpedientNT");
						Aa83bTramitacionExpedienteServiceImpl.logger.info("Guardado el ACCESO:");
		
					}
			}
		} catch (Exception es) {
			Aa83bTramitacionExpedienteServiceImpl.logger.info("Aa83bTramitacionExpedienteServiceImpl: "+ es.getMessage());
		}
	}
	
	/**
	 * @param g String
	 * @return String
	 */
	private String getGenero(String g){
		String genero = "";
		if ("".equals(g)) {
			genero = "<H/>";
		}
		if ("<H/>".equals(g)) {
			genero = Aa83BConstants.GENERO_VARON;
		} else {
			genero = Aa83BConstants.GENERO_MUJER;
		}
		
		return genero;
	}

	/**
	 * @param procedure String
	 * @return String
	 */
	private String getTipoSolicitud (String procedure){
		String retorno = "";
		if (procedure.equals(Aa83BConstants.COD_ADE_PLATEA + "01")) {
			retorno = Aa83BConstants.COD_ADE;
		} else if (procedure.equals(Aa83BConstants.COD_ARR_PLATEA + "01")) {
			retorno = Aa83BConstants.COD_ARR;
		} else if (procedure.equals(Aa83BConstants.COD_ESF_PLATEA + "01")) {
			retorno = Aa83BConstants.COD_ESF;
		}
		return retorno;
	}
	
	/**
	 * @param xml String
	 * @param etiqueta String
	 * @return String
	 */
	private String recogerEtiqueta(String xml, String etiqueta) {
		String valor = "";
		try {
			if ("language".equals(etiqueta)) {
				String inicio = "<" + etiqueta + ">";
				int inicioint = xml.indexOf(inicio) + inicio.length();
				//String fin = "</" + etiqueta + ">";
				// int finint = xml.indexOf(fin);
				valor = xml.substring(inicioint, inicioint + 2);
			} else {
				String inicio = "<" + etiqueta + ">";
				int inicioint = xml.indexOf(inicio) + inicio.length();
				String fin = "</" + etiqueta + ">";
				int finint = xml.indexOf(fin);
				valor = xml.substring(inicioint, finint);
			}
			if (!"sourceBinary".equals(etiqueta)) {
				Aa83bTramitacionExpedienteServiceImpl.logger.info("la etiqueta==>" + etiqueta + " es==>" + valor);
			}
		} catch (Exception e) {
			// No hacemos nada
		}
		return valor;
	}
	
	/**
	 * @param id037 int
	 * @return List<Aa83b41t00>
	 */
	private List<Aa83b41t00> getListaDocumentosAdjuntos(int id037) {

		Aa83b41t00 aa83b41t00 = new Aa83b41t00();
		aa83b41t00.setIdCod037(id037);
		return this.aa83b41t00Service.findAllLike(aa83b41t00, null, false);
	}
	
	/**
	 * @param aa83b41t00 Aa83b41t00
	 * @return List<Aa83b36t00>
	 */
	private List<Aa83b36t00> getListaTiposDocumentos(Aa83b41t00 aa83b41t00 ) {

		String tipoDocusi = aa83b41t00.getMetaInf041().replace(".0", "");
		Aa83bTramitacionExpedienteServiceImpl.logger.info("Despues del Replace::" + tipoDocusi);
		String td_padre = null;
		String td_hijo = null;
		tipoDocusi = tipoDocusi.replace(".", ":");
		if (tipoDocusi.indexOf(":") != -1) {
			String[] trozos = tipoDocusi.split(":");
			td_padre = trozos[1];
			td_hijo = trozos[0];
		} else {
			td_padre = tipoDocusi;
		}
		Aa83b36t00 aa83b36t00 = new Aa83b36t00();
		aa83b36t00.setDescEs036(td_padre);
		aa83b36t00.setIdCodPadre(td_hijo);

		return this.aa83b36t00Service.findAllLike(aa83b36t00, null, false);
	}
	
	/** 
	 * @param tipoSol int 
	 * @param idFase int
	 * @param idTramite int
	 * @param idCod036 String
	 * @return List<Aa83b30t00>
	 */
	private List<Aa83b30t00> getTipoDocSolicitudes(int tipoSol, int idFase, int idTramite, String idCod036) {

		Aa83b30t00 aa83b30t00 = new Aa83b30t00();
		aa83b30t00.setId003TipoSol(tipoSol);
		aa83b30t00.setTdDokusi030(idCod036);
		aa83b30t00.setId001Fase(idFase);
		aa83b30t00.setId002Tram(idTramite);

		Aa83bTramitacionExpedienteServiceImpl.logger.info("Busco en la 30:" + aa83b30t00);

		return this.aa83b30t00Service.findAll(aa83b30t00, null);
	
	}	
}

