package com.ejie.aa83b.service;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;


import javax.jms.Message;
import javax.jms.TextMessage;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


import com.ejie.aa83b.exception.Aa83bServiceException;

import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContextParser;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.vdc.Q99USendMessageSCPFacadeWSSoap;


/**
 * Implementación del procesador de eventos de Tramitación del expediente
 * 
 * @author DS
 * 
 */
@Service(value = "aa83bNotificacionesService")
public class Aa83bNotificacionesServiceImpl implements
		Aa83bNotificacionesService {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bNotificacionesServiceImpl.class);

	/** The service. */
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;

	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;

	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;	
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;

	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;

	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;
	
	@Autowired()
	private Q99USendMessageSCPFacadeWSSoap q99uSendMessageSCPFacadeWSSoap;
	
	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;
	
	@Autowired()
	private Properties appConfiguration;
	

	private static final int _1200 = 1200;

	@Override()
	@Transactional(rollbackFor = Throwable.class, timeout = Aa83bNotificacionesServiceImpl._1200)
	public void capturarEventoNotificacion(Message mensajeJMS)
			throws Aa83bServiceException {
		
		Aa83bNotificacionesServiceImpl.logger.info("notificacion");
		this.tramtitarEventoNotificacion(mensajeJMS);

		Aa83bNotificacionesServiceImpl.logger.info("Metodo capturarEvento 3");
	}

	/**
	 * @param msg Message
	 */
	private void tramtitarEventoNotificacion(Message msg) {
		Aa83bNotificacionesServiceImpl.logger.info("Metodo tramtitarEventoNotificacion 1");
		TextMessage textMessage = null;

		try {
			String xml = "";
			
			if (Aa83bUtilSeguridad.enOficina()) {
//				String acuseLectura = "C:/workspace/aa83bConfig/AcuseLectura.xml";
//				String resolucion =  "C:/workspace/aa83bConfig/acuse_Resolucin.xml";
				String acuserecibo = "C:/config/dominio_desa/aa83b/acuseRecibo.xml";
//				String ficheroALeer = resolucion;
				String ficheroALeer = acuserecibo;
				String truco = (Aa83bSesionUtils.leerFichero(ficheroALeer
						, false));
				xml = truco;
			}else
			{
				textMessage = (TextMessage) msg;
				xml = textMessage.getText().trim();
			}
			// 

			xml = xml.replaceAll("&lt;", "<");
			xml = xml.replaceAll("&gt;", ">");
			Aa83bNotificacionesServiceImpl.logger.info("Mensaje de Notificacion Lectura:::" + xml + "::");

			
//			String jmsIdID = textMessage
//				.getStringProperty("messageIdPropagado");
//			System.out.println("ID: " + jmsIdID);
			 
			// recogerEtiqueta(xml, "procedure");
			String folderNumber = this.recogerEtiqueta(xml, "folderNumber");
			String[] tokens = folderNumber.split("-");
			String tipoSol = tokens[0];
			String anoSol = tokens[1];
			String numSol = tokens[2];
			
			String notifiedActId = this.recogerEtiqueta(xml, "notifiedActId");
			String registryNumber = this.recogerEtiqueta(xml, "registryNumber");
			String registryTimestamp = this.recogerEtiqueta(xml, "registryTimestamp");
			

			String procedure="";
			String idProcedimiento="";
			

			Aa83b21t00 aa83b21t00 = null;
			Aa83b23t00 aa83b23t00 = null;
			Aa83b25t00 aa83b25t00 = null;
			
			Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
			String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
		
			Aa83bConsultationContext res;
			Aa83bConsultationContextParser resParser = new Aa83bConsultationContextParser();
			
			Aa83bNotificacionesServiceImpl.logger.info("Metodo tramtitarEvento 2");
			// PDTE DE SABER ESTRUCTURA DEL XML DEVEULTO
			// String tipoSol = Aa83BConstants.COD_ADE;
			// String numSol = "1";
			// String anoSol = "2016";

			Aa83bNotificacionesServiceImpl.logger.info("ID: " + numSol);
			Aa83bNotificacionesServiceImpl.logger.info("Tipo: " + tipoSol);
			Aa83bNotificacionesServiceImpl.logger.info("Ao sol: " + anoSol);

			Aa83bNotificacionesServiceImpl.logger.info("notifiedActId: " + notifiedActId);
			Aa83bNotificacionesServiceImpl.logger.info("registryNumber:" + registryNumber);
			Aa83bNotificacionesServiceImpl.logger.info("registryTimestampl: " + registryTimestamp);

			
			
			//recogemos la etiqueta roleId para saber si en el xml viene ejgv_d_acuserecibo.0.0
			Aa83bNotificacionesServiceImpl.logger.info("Leemos el mensaje");
//			Boolean lectura=leerXML(xml);//devuelve true si el mensaje contiene ejgv_d_acuserecibo.0.0, sino false
			
			Boolean lectura=this.recogerListaEtiquetas(xml);
			Aa83bNotificacionesServiceImpl.logger.info("el mensaje contiene ejgv_d_acuserecibo.0.0 ====="+ lectura);
			String idProceedings = "";
			if(lectura){
				int fase = 0;
				int tramite = 0;
				Aa83bNotificacionesServiceImpl.logger.info("el mensaje contiene ejgv_d_acuserecibo.0.0");
				Integer idhist = 0;
				if ("REQ_SUB".equals(notifiedActId)) {
					Aa83bNotificacionesServiceImpl.logger.info("Req sub leido");

					fase = Aa83BConstants.UNO;
					tramite = Aa83BConstants.TRES;
					
					if (tipoSol.equals(Aa83BConstants.COD_ADE_STR)) {
						// Actualizar req_leido_023					
						aa83b21t00 = new Aa83b21t00();
						aa83b21t00.setId021(Integer.parseInt(numSol));
						aa83b21t00.setIdAno021(Long.parseLong(anoSol));
						aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);
						aa83b21t00.setReqSubsanaLeido021("S");
						this.aa83b21t00Service.marcarReqSubsanaLeido021(aa83b21t00);		
						idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");
						
						Aa83b09t00 aa83b09t00 = new Aa83b09t00 ();
						aa83b09t00.setIdAno021(aa83b21t00.getIdAno021());
						aa83b09t00.setId021NumSol(aa83b21t00.getId021());
						aa83b09t00.setId001Fase(fase);
						aa83b09t00.setId002Tram(tramite);
						List <Aa83b09t00> aa83b09t00l = this.aa83b09t00Service.findAll(aa83b09t00, null);
						idhist = aa83b09t00l.get(0).getId009();
					
					} else if (tipoSol.equals(Aa83BConstants.COD_ESF_STR)) {
						// Actualizar req_leido_023
					
						aa83b23t00 = new Aa83b23t00();
						aa83b23t00.setId023(Integer.parseInt(numSol));
						aa83b23t00.setIdAno023(Long.parseLong(anoSol));
						aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);
						aa83b23t00.setReqSubsanaLeido023("S");
						this.aa83b23t00Service.marcarReqSubsanaLeido023(aa83b23t00);
						idProcedimiento = this.appConfiguration.getProperty("procedure.esfuerzo.id");
						
						Aa83b10t00 aa83b10t00 = new Aa83b10t00 ();
						aa83b10t00.setIdAno023(aa83b23t00.getIdAno023());
						aa83b10t00.setId023NumSol(aa83b23t00.getId023().longValue());
						aa83b10t00.setId001Fase(fase);
						aa83b10t00.setId002Tram(tramite);
						List <Aa83b10t00> aa83b10t00l = this.aa83b10t00Service.findAll(aa83b10t00, null);
						idhist = aa83b10t00l.get(0).getId010();
					
					} else if (tipoSol.equals(Aa83BConstants.COD_ARR_STR)) {			
						// Actualizar req_leido_025
						aa83b25t00 = new Aa83b25t00();
						aa83b25t00.setId025(Integer.parseInt(numSol));
						aa83b25t00.setIdAno025(Long.parseLong(anoSol));
						aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);
						aa83b25t00.setReqSubsanaLeido025("S");
						this.aa83b25t00Service.marcarReqSubsanaLeido025(aa83b25t00);
						idProcedimiento = this.appConfiguration.getProperty("procedure.arraigo.id");
						
						Aa83b11t00 aa83b11t00 = new Aa83b11t00 ();
						aa83b11t00.setIdAnoSol025(aa83b25t00.getIdAno025().longValue());
						aa83b11t00.setId025NumSol(aa83b25t00.getId025());
						aa83b11t00.setId001Fase(fase);
						aa83b11t00.setId002Tram(tramite);
						List <Aa83b11t00> aa83b11t00l = this.aa83b11t00Service.findAll(aa83b11t00, null);
						idhist = aa83b11t00l.get(0).getId011();
	
					}
	
				} else if ("RESOL".equals(notifiedActId)) {
					Aa83bNotificacionesServiceImpl.logger.info("Resol leida");
					fase = Aa83BConstants.DOS;
					tramite = Aa83BConstants.DOS;
					// 	Marco la solicitud como leida
					if (tipoSol.equals(Aa83BConstants.COD_ADE_STR)) { // Marco la de Adecuacion
						aa83b21t00 = new Aa83b21t00();
						aa83b21t00.setId021(Integer.parseInt(numSol));
						aa83b21t00.setIdAno021(Long.parseLong(anoSol));
						aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);
						aa83b21t00.setNotifLeida021("S");
						this.aa83b21t00Service.marcarNotifLeida(aa83b21t00);
						idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");
						
						Aa83b09t00 aa83b09t00 = new Aa83b09t00 ();
						aa83b09t00.setIdAno021(aa83b21t00.getIdAno021());
						aa83b09t00.setId021NumSol(aa83b21t00.getId021());
						aa83b09t00.setId001Fase(fase);
						aa83b09t00.setId002Tram(tramite);
						List <Aa83b09t00> aa83b09t00l = this.aa83b09t00Service.findAll(aa83b09t00, null);
						idhist = aa83b09t00l.get(0).getId009();
						
					} else if (tipoSol.equals(Aa83BConstants.COD_ESF_STR)) { // Marco la de Esfuerzo
						aa83b23t00 = new Aa83b23t00();
						aa83b23t00.setId023(Integer.parseInt(numSol));
						aa83b23t00.setIdAno023(Long.parseLong(anoSol));
						aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);
						aa83b23t00.setNotifLeida023("S");
						this.aa83b23t00Service.marcarNotifLeida(aa83b23t00);
						idProcedimiento = this.appConfiguration.getProperty("procedure.esfuerzo.id");
						
						Aa83b10t00 aa83b10t00 = new Aa83b10t00 ();
						aa83b10t00.setIdAno023(aa83b23t00.getIdAno023());
						aa83b10t00.setId023NumSol(aa83b23t00.getId023().longValue());
						aa83b10t00.setId001Fase(fase);
						aa83b10t00.setId002Tram(tramite);
						List <Aa83b10t00> aa83b10t00l = this.aa83b10t00Service.findAll(aa83b10t00, null);
						idhist = aa83b10t00l.get(0).getId010();
						
					} else if (tipoSol.equals(Aa83BConstants.COD_ARR_STR)) { // Marco la de Arraigo
						aa83b25t00 = new Aa83b25t00();
						aa83b25t00.setId025(Integer.parseInt(numSol));
						aa83b25t00.setIdAno025(Long.parseLong(anoSol));
						aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);
						aa83b25t00.setNotifLeida025("S");
						this.aa83b25t00Service.marcarNotifLeida(aa83b25t00);
						idProcedimiento = this.appConfiguration.getProperty("procedure.arraigo.id");
						
						Aa83b11t00 aa83b11t00 = new Aa83b11t00 ();
						aa83b11t00.setIdAnoSol025(aa83b25t00.getIdAno025().longValue());
						aa83b11t00.setId025NumSol(aa83b25t00.getId025());
						aa83b11t00.setId001Fase(fase);
						aa83b11t00.setId002Tram(tramite);
						List <Aa83b11t00> aa83b11t00l = this.aa83b11t00Service.findAll(aa83b11t00, null);
						idhist = aa83b11t00l.get(0).getId011();
					}
				}
		
				
				//Enviar notificacion
				procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken,idProcedimiento);
				resParser = new Aa83bConsultationContextParser(procedure);
				res = resParser.getProcedureDataAll();
				String expediente= aa83bXMLGenerator.generarXmlSaveUpdateProceedings(aa83b21t00, aa83b23t00, aa83b25t00, res, idProcedimiento, null, null, notifiedActId.toLowerCase(), lectura, idhist.toString());
				Aa83bNotificacionesServiceImpl.logger.info("*********** expediente-->"+ expediente);
				this.q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken, expediente, "saveOrUpdateProceedingsNT");
			}	
		} catch (Exception es) {
			Aa83bNotificacionesServiceImpl.logger.info("Exception "+es);
			es.printStackTrace();
			Aa83bNotificacionesServiceImpl.logger.info("EXCEP  papel0: "
					+ es.getMessage());
		}

	}

	/**
	 * @param xml String
	 * @param etiqueta String
	 * @return String
	 */
	private String recogerEtiqueta(String xml, String etiqueta) {
		String valor = "";
		try {
			String inicio = "<" + etiqueta + ">";
			int inicioint = xml.indexOf(inicio) + inicio.length();
			String fin = "</" + etiqueta + ">";
			int finint = xml.indexOf(fin);
			valor = xml.substring(inicioint, finint);
			if (!"sourceBinary".equals(etiqueta)){
				Aa83bNotificacionesServiceImpl.logger.info("la etiqueta==>" + etiqueta + " es==>" + valor);
			}
		} catch (Exception e) {
			// No hacemos nada
			// e.printStackTrace();
		}
		return valor;
	}
	
	/**
	 * @param xml String
	 * @return Boolean
	 */
	private Boolean recogerListaEtiquetas(String xml) {
		
			if(xml.contains("ejgv_d_acuserecibo.0.0")){
				return true;
			}else{
				return false;
			}	
	}
	
	/**
	 * @param xml String
	 * @return Boolean
	 */
	public Boolean leerXML(String xml){
		Aa83bNotificacionesServiceImpl.logger.info("Entramos en leerXML");
		 //Se crea un SAXBuilder para poder parsear el archivo
	    SAXBuilder builder = new SAXBuilder();
//	    File xmlFile = new File(xml);
//	    InputSource is = new InputSource(new StringReader(xml));
		try {
			Aa83bNotificacionesServiceImpl.logger.info("Dentro del try");
//			logger.info("xmlFile::::::::" +is);
			//Se crea el documento a traves del archivo
	        Document document = (Document) builder.build(new StringReader(xml));
	        Aa83bNotificacionesServiceImpl.logger.info("Document:: " + document);
	        //Se obtiene la raiz 'notificationEventAttachments'
	        Element rootNode = document.getRootElement();
	        Aa83bNotificacionesServiceImpl.logger.info("rootNode:: " + rootNode);
	        //Se obtiene la lista de hijos de la raiz 'notificationEventAttachments'
	        List list = rootNode.getChildren("notificationEventAttachment");
	        Aa83bNotificacionesServiceImpl.logger.info("list:: " + list);
	      //Se recorre la lista de hijos de 'notificationEventAttachments'
	        Aa83bNotificacionesServiceImpl.logger.info("Vamos a recorrer la lista");
	        for ( int i = 0; i < list.size(); i++ )
	        {
	        	Aa83bNotificacionesServiceImpl.logger.info("Recorriendo la lista");
	            //Se obtiene el elemento 'notificationEventAttachment'
	            Element notificationEventAttachment = (Element) list.get(i);
	            //Se obtiene la lista de hijos del tag 'notificationEventAttachments'
	            List lista_campos = notificationEventAttachment.getChildren();

	            //Se recorre la lista de campos
	            for ( int j = 0; j < lista_campos.size(); j++ )
	            {
	            	Aa83bNotificacionesServiceImpl.logger.info("lista_campos.get( j )=====" +  lista_campos.get(j));
	                //Se obtiene el elemento 'campo'
	                Element campo = (Element)lista_campos.get( j );
	                //Se obtiene el valor que esta entre los tags '<roleId></roleId>'
	                Aa83bNotificacionesServiceImpl.logger.info("roleId=====" +  campo.getChildTextTrim("roleId"));
	                if(campo.getChildTextTrim("roleId").equals("ejgv_d_acuserecibo.0.0")){
	                	return true;
	                }
	            }
	            }
		 }catch ( IOException io ) {
			 io.printStackTrace();
		        } catch (JDOMException e) {
			e.printStackTrace();
		}
			

			return false;
	}
	

}
