package com.ejie.aa83b.service;


import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import n38c.exe.N38API;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

import com.ejie.aa83b.dao.Aa83bNotificacionesCorreosDao;
import com.ejie.aa83b.model.Aa83bNotificacionCorreosDatosRemesa;
import com.ejie.aa83b.model.Aa83bNotificacionCorreosDatosUsuario;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilXML;
import com.ejie.aa83b.webservice.client.aa66.AA66Notificaciones;
import com.ejie.aa83b.webservice.client.aa66.EnvioOutWs;
import com.ejie.aa83b.webservice.client.aa66.EnvioWs;
import com.ejie.aa83b.webservice.client.aa66.ErrorWs;
import com.ejie.aa83b.webservice.client.aa66.RemesaOutWs;
import com.ejie.aa83b.webservice.client.aa66.RemesaWs;

@Service(value = "Aa83bNotificacionesCorreosService")
public class Aa83bNotificacionesCorreosServiceImpl implements
		Aa83bNotificacionesCorreosService {
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bNotificacionesCorreosServiceImpl.class);
	@Autowired
	private Aa83bNotificacionesCorreosDao aa83bNotificacionesCorreosDao;
	@Autowired
	private AA66Notificaciones service;

	@Override
	public Aa83bNotificacionCorreosDatosUsuario findComunicaciones(String id,
			String anyo, String tipoSol) {

		return (Aa83bNotificacionCorreosDatosUsuario) this.aa83bNotificacionesCorreosDao
				.findComunicaciones(id, anyo, tipoSol);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Aa83bNotificacionCorreosDatosRemesa add(
			Aa83bNotificacionCorreosDatosRemesa datosRemesa) {
		return this.aa83bNotificacionesCorreosDao.add(datosRemesa);

	}

	public RemesaOutWs enviarRemesas(List<EnvioWs> listaEnvios,
			String tipoRemesa, HttpSession session, HttpServletRequest request) {

		RemesaWs remesa = new RemesaWs();
		// MotivoWs motivo = new MotivoWs();
		// motivo.setMotivoCastellano("Prueba WS AA83b");
		// motivo.setMotivoEuskera("AA83b WS Froga");
		// remesa.setMotivoEnvios(motivo);
		for (int i = 0; i < listaEnvios.size(); i++) {
			remesa.getListaEnvios().add(listaEnvios.get(i));
		}
		remesa.setAplicacion(Aa83BConstants.COD_APLICACION);
		remesa.setAplicacionDescEs(Aa83bUtilProperties
				.getProperty("TITULO_APLIC_ES"));
		remesa.setAplicacionDescEu(Aa83bUtilProperties
				.getProperty("TITULO_APLIC_ES"));
		remesa.setDescripcionRemesa("Informes de inmigracion AA83b");
		remesa.setTipoRemesa(tipoRemesa);

		try {
			// XLNETS
			Document miSesion;
			N38API n38api = new N38API(request);
			logger.info("n38API:::::::::::::" + n38api);
			miSesion = n38api.n38ItemSesion();
			

			// PUESTO
			String filtro = "//parametro[@id='n38puestouid']/valor/text()";
			String[] valoresFiltro;
			valoresFiltro = Aa83bUtilXML.obtenerValorNodosXPath(miSesion,
					filtro);
		
				logger.info("Valores n38puestouid:::::::::::::" + valoresFiltro[0]);
			
			remesa.setUidPuestoTramitador(valoresFiltro[0]);
			
			if ((valoresFiltro == null) || (0 == valoresFiltro.length)) {
				throw new Exception("No se ha obtenido n38puestouid de XLNets");
			}

			
			// PERSONA - N38LOGIN
			filtro = "//parametro[@id='n38login']/valor/text()";
		
			valoresFiltro = Aa83bUtilXML.obtenerValorNodosXPath(miSesion,
					filtro);
			logger.info("n38login valoresFiltro:::::::::::::"+ valoresFiltro[0]);
		
			if ((valoresFiltro == null) || (0 == valoresFiltro.length)) {
				throw new Exception("No se ha obtenido n38login de XLNets");
			}

			Document miPersona = null;
			miPersona = n38api.n38ItemObtenerPersonas("n38login="
					+ valoresFiltro[0]);
			logger.info("documento miPersona:::::::::::::" + miPersona);

			
			filtro="/n38/elementos/elemento[@subtipo='n38persona']/parametro[@id='telephonenumber']/valor";		
			String[] telefono = Aa83bUtilXML.obtenerValorNodosXPath(miPersona,filtro);

			
			String[] mail = Aa83bUtilXML.obtenerValorNodosXPath(miPersona,
			"/n38/elementos/elemento[@subtipo='n38persona']/parametro[@id='mail']/valor");
			logger.info("telefono telephonenumber:::::::::::::" + telefono[0]);

			if ((valoresFiltro == null) || (0 == valoresFiltro.length)) {
				throw new Exception("No se ha obtenido n38login de XLNets");
			}

			if (telefono[0] != null) {

				remesa.setTelefonoTramitador(telefono[0]);

			} else {
				remesa.setTelefonoTramitador("000000000");
			}
			if (mail[0] != null) {
				remesa.setRecibirMail(true);
				remesa.setEmail(mail[0]);

			} else {
				remesa.setRecibirMail(false);
			}

		} catch (Exception e1) {
			e1.printStackTrace();
		}
		
		RemesaOutWs remesaOut = new RemesaOutWs();
		remesaOut = service.cargaMasiva(remesa);
		for (ErrorWs error : remesaOut.getErrores()) {
			logger.info("ERROR!!!!!!!!!!");
			logger.info(error.getDescripcionCastellano());
			logger.info("ID ERRONEO: " + error.getIdErroneo());
		}
		for (EnvioOutWs envio : remesaOut.getEnvios()) {
			logger.info("ENVIO!!!!!!!!!!");
			logger.info("ENVIO ID: " + envio.getIdEnvio());
			logger.info("ENVIO COD ENVIO: " + envio.getCodEnvio());
			logger.info("ENVIO COD INTERNO: " + envio.getIdInterno());
		}
		return remesaOut;

	}

	@Override
	public List<Aa83bNotificacionCorreosDatosRemesa> buscarSituacionRemesa(
			String id, String anyo, String tipoSol) {
		return (List<Aa83bNotificacionCorreosDatosRemesa>) this.aa83bNotificacionesCorreosDao
				.buscarSituacionRemesa(id, anyo, tipoSol);
	}

}
