package com.ejie.aa83b.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.aa83b.dao.Aa83bNoraDao;
import com.ejie.aa83b.model.A83bComunidad;
import com.ejie.aa83b.model.A83bLocalidad;
import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.x38.dto.JQGridRequestDto;

//TODO: Auto-generated Javadoc
/**
 * The Interface Y62bNoraService.
 * 
 * @author Deusto Sistemas
 */

@Service(value = "a83bNoraService")
public class Aa83bNoraServiceImpl implements Aa83bNoraService {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bNoraServiceImpl.class);

	/** The a83b nora dao. */
	@Autowired
	private Aa83bNoraDao a83bNoraDao;

	/**
	 * Finds a List of provinces.
	 * 
	 * @param a83bMunicipio
	 *            the a83b municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<A83bMunicipio> findMunicipios(A83bMunicipio a83bMunicipio,
			JQGridRequestDto jqGridRequestDto) {

		return (List<A83bMunicipio>) this.a83bNoraDao.findMunicipios(
				a83bMunicipio, jqGridRequestDto);
	}

	public A83bMunicipio findMunicipiosId(A83bMunicipio a83bMunicipio) {

		return (A83bMunicipio) this.a83bNoraDao.findMunicipiosId(a83bMunicipio);
	}

	/**
	 * Finds a List of provinces.
	 * 
	 * @param a83bprovincia
	 *            A83bProvincia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<A83bProvincia> findProvincias(A83bProvincia a83bprovincia,
			JQGridRequestDto jqGridRequestDto) {
		return (List<A83bProvincia>) this.a83bNoraDao.findProvincias(
				a83bprovincia, jqGridRequestDto);
	}

	/**
	 * Find the province by id.
	 * 
	 * @param a83bprovincia
	 *            A83bProvincia
	 * @param pagination
	 *            Pagination
	 * @return A83bProvincia
	 */
	public A83bProvincia findProvinciasId(A83bProvincia a83bprovincia) {
		return (A83bProvincia) this.a83bNoraDao.findProvinciasId(a83bprovincia);
	}

	/**
	 * Finds a List of states.
	 * 
	 * @param a83bcomunidad
	 *            A83bComunidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<A83bComunidad> findComunidades(A83bComunidad a83bcomunidad,
			JQGridRequestDto jqGridRequestDto) {
		List<A83bComunidad> comunidades = this.a83bNoraDao.findComunidades(
				a83bcomunidad, jqGridRequestDto);
		A83bComunidad euskadi = null;
		for (A83bComunidad comunidad : comunidades) {
			if (comunidad.getId().equals("16")) {
				comunidades.remove(comunidad);
				euskadi = comunidad;
				break;
			}
		}
		comunidades.add(0, euskadi);
		return comunidades;
	}

	/**
	 * Finds a List of countries.
	 * 
	 * @param a83bMunicipio
	 *            the a83b municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<A83bPais> findPaises(A83bPais a83bPais,
			JQGridRequestDto jqGridRequestDto) {
		return (List<A83bPais>) this.a83bNoraDao.findPaises(a83bPais,
				jqGridRequestDto);
	}

	/**
	 * Finds a country.
	 * 
	 * @param a83bMunicipio
	 *            the a83b municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public A83bPais findPaisesById(A83bPais a83bPais) {
		return (A83bPais) this.a83bNoraDao.findPaisesById(a83bPais);
	}

	/**
	 * Finds a List of streets.
	 * 
	 * @param a83bcomunidad
	 *            A83bComunidad
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	public List<Aa83bCalle> findCalles(Aa83bCalle aa83bCalle,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa83bCalle>) this.a83bNoraDao.findCalles(aa83bCalle,
				jqGridRequestDto);
	}
	public List<Aa83bCalle> findCallesPorId(Aa83bCalle aa83bCalle,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa83bCalle>) this.a83bNoraDao.findCallesPorId(aa83bCalle,
				jqGridRequestDto);
	}
	/**
	 * Finds a street.
	 * 
	 * @param a83bNoraDao
	 *            the new a83b nora dao
	 */
	public Aa83bCalle findCalle(Aa83bCalle Aa83bCalle,
			JQGridRequestDto jqGridRequestDto) {
		return this.a83bNoraDao.findCalle(Aa83bCalle, jqGridRequestDto);
	}

	public Aa83bCalle findCallePorString(Aa83bCalle Aa83bCalle) {
		return this.a83bNoraDao.findCallePorString(Aa83bCalle);
	}
	public String findCodigoPostal(String id,int numero) {
		return this.a83bNoraDao.findCodigoPostal(id,numero);
	}
	
	public String findTipoViaPorDefecto() {
		return this.a83bNoraDao.findTipoViaPorDefecto();
	}
	/**
	 * Gets the a83b nora dao.
	 * 
	 * @return the a83b nora dao
	 */
	public Aa83bNoraDao getA83bNoraDao() {
		return a83bNoraDao;
	}
	

	/**
	 * Sets the a83b nora dao.
	 * 
	 * @param a83bNoraDao
	 *            the new a83b nora dao
	 */
	public void setA83bNoraDao(Aa83bNoraDao a83bNoraDao) {
		logger.info("Setting Dependency " + a83bNoraDao);
		this.a83bNoraDao = a83bNoraDao;
	}

	public A83bLocalidad findProvMunLocalidadByCodPostal(String codigoPostal, String calleId, int numero) {
		return this.a83bNoraDao.findProvMunLocalidadByCodPostal(codigoPostal, calleId, numero);
	}

}
