package com.ejie.aa83b.service;

import java.util.List;

import com.ejie.aa83b.model.A83bComunidad;
import com.ejie.aa83b.model.A83bLocalidad;
import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.x38.dto.JQGridRequestDto;

//TODO: Auto-generated Javadoc
/**
 * The Interface A83bNoraService.
 * 
 * @author Deusto Sistemas
 */
public interface Aa83bNoraService {

	/**
	 * Finds a List of towns.
	 * 
	 * @param aa83bmunicipio
	 *            aa83bMunicipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<A83bMunicipio> findMunicipios(A83bMunicipio a83bbmunicipio,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a List of provinces.
	 * 
	 * @param aa83bprovincia
	 *            aa83bProvincia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<A83bProvincia> findProvincias(A83bProvincia a83bprovincia,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a province by Id.
	 * 
	 * @param aa83bprovincia
	 *            aa83bProvincia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	A83bProvincia findProvinciasId(A83bProvincia a83bprovincia);

	/**
	 * Finds a List of states.
	 * 
	 * @param aa83bcomunidad
	 *            aa83bComunidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<A83bComunidad> findComunidades(A83bComunidad a83bcomunidad,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a List of countries.
	 * 
	 * @param aa83bcomunidad
	 *            aa83bComunidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<A83bPais> findPaises(A83bPais a83bpais,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find a country.
	 * 
	 * @param aa83bcomunidad
	 *            aa83bComunidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	A83bPais findPaisesById(A83bPais a83bpais);

	/**
	 * Finds a List of streets.
	 * 
	 * @param a83bcomunidad
	 *            A83bComunidad
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa83bCalle> findCalles(Aa83bCalle aa83bCalle,
			JQGridRequestDto jqGridRequestDto);
	List<Aa83bCalle> findCallesPorId(Aa83bCalle aa83bCalle,
			JQGridRequestDto jqGridRequestDto);
	/**
	 * Finds a street.
	 * 
	 * @param a83bcomunidad
	 *            A83bComunidad
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	Aa83bCalle findCalle(Aa83bCalle Aa83bCalle,
			JQGridRequestDto jqGridRequestDto);

	
	Aa83bCalle findCallePorString(Aa83bCalle Aa83bCalle);
	
	String findCodigoPostal(String id,int numero);
	
	String findTipoViaPorDefecto();
	
	A83bMunicipio findMunicipiosId(A83bMunicipio a83bMunicipio);
	
	A83bLocalidad findProvMunLocalidadByCodPostal(String codigoPostal, String calleId, int numero);
}
