package com.ejie.aa83b.service;

import java.util.List;

import com.ejie.aa83b.model.Aa83bContadorGraficos;
import com.ejie.aa83b.model.Aa83bContadorNacionalidad;
import com.ejie.aa83b.model.Aa83bContadorTerritorios;
import com.ejie.aa83b.model.Aa83bEstadisticasBusqueda;
import com.ejie.aa83b.model.Aa83bEstadisticasFechas;
import com.ejie.x38.dto.JQGridRequestDto;

public interface Aa83bEstadisticasService {
	/**
	 * Cuenta el numero de Nacionalidades de solicitud HAB
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bContadorNacionalidad> contar(Aa83bContadorNacionalidad cont,
			JQGridRequestDto jqGridRequestDto);

	List<Aa83bContadorNacionalidad> contarADE(Aa83bContadorNacionalidad cont,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Cuenta el numero de Nacionalidades de solicitud ARR
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */

	List<Aa83bContadorNacionalidad> contarPorArraigo(
			Aa83bContadorNacionalidad cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Cuenta el numero de Nacionalidades de solicitud ESF
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */

	List<Aa83bContadorNacionalidad> contarPorIntegracion(
			Aa83bContadorNacionalidad cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Cuenta el numero de Nacionalidades de solicitud TODAS
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */

	List<Aa83bContadorNacionalidad> contarTodas(Aa83bContadorNacionalidad cont,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Cuenta por Territorios. Tipo de solicitud: HAB
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bContadorTerritorios> contTerritoriosHab(
			Aa83bContadorTerritorios cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Cuenta por Territorios. Tipo de solicitud: ARR
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bContadorTerritorios> contTerritoriosArr(
			Aa83bContadorTerritorios cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Cuenta por Territorios. Tipo de solicitud: Esf
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bContadorTerritorios> contTerritoriosEsf(
			Aa83bContadorTerritorios cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Graficos.
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bContadorGraficos> contGraficos(Aa83bContadorGraficos cont,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Busqueda Standard ADE
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bEstadisticasBusqueda> estadBusquedaADE(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Busqueda Standard ARR
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bEstadisticasBusqueda> estadBusquedaARR(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Busqueda Standard ESF
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bEstadisticasBusqueda> estadBusquedaESF(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Busqueda Fechas minima y maxima
	 * 
	 * @param cont
	 * @param jqGridRequestDto
	 * @return
	 */
	List<Aa83bEstadisticasFechas> fMinMax(Aa83bEstadisticasFechas estadBusq,
			JQGridRequestDto jqGridRequestDto);

}
