package com.ejie.aa83b.service;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.dao.Aa83b23t00Dao;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b28t00;
import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b32t00;
import com.ejie.aa83b.model.Aa83b33t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83bDocumentoDokusi;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.x38.dto.JQGridRequestDto;
import org.springframework.context.i18n.LocaleContextHolder;
import java.sql.Date;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Aa83b21t00ServiceImpl generated by UDA, 28-dic-2015 17:45:22.
 * 
 * @author UDA
 */

@Service(value = "Aa83bESFService")
public class Aa83bESFServiceImpl implements Aa83bESFService {

	@Autowired
	private Aa83b23t00Dao aa83b23t00Dao;
	@Autowired()
	private Aa83b28t00Service aa83b28t00Service;
	@Autowired()
	private Aa83b32t00Service aa83b32t00Service;
	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;
	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;
	@Autowired()
	private Aa83b07t00Service aa83b07t00Service;
	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	/** The service. */
	@Autowired
	private Aa83bDokusiService aa83bDokusiService;
	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bESFServiceImpl.class);

	/**
	 * Inserts a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b23t00 add(Aa83b23t00 aa83b23t00, String daSeries) {
		Aa83b23t00 aa83b23t00New = new Aa83b23t00();

		aa83b23t00.setSolicerrada023("N");

		aa83b23t00New = aa83b23t00Service.add(aa83b23t00);
		int idSolicitud = aa83b23t00New.getId023();
		Long anyoSolicitud = aa83b23t00New.getIdAno023();
		/*
		 * List<Aa83b23t00> nuevaSolList = aa83b23t00Service.findAllLike(
		 * aa83b23t00, null, false); int contaMax = 0;
		 */

		// aa83b23t00New.setId023(0);

		/*
		 * for (int i = 0; i < nuevaSolList.size(); i++) { aa83b23t00New =
		 * nuevaSolList.get(i); if (aa83b23t00New.getId023() > contaMax) {
		 * contaMax = aa83b23t00New.getId023(); // aa83b23t00 = aa83b23t00New; }
		 * }
		 */
		// aa83b23t00New = aa83b23t00;

		// ** START ACCESO
		// Despues de crear la Solicitud, registramos el actor:
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		// Introduzco un nuevo registro de Acceso
		aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(
				aa83b23t00New, Aa83BConstants.ACCESOS_ALTA, "N"));
		// ** FIN ACCESO

		// Guardamos el HISTOTRAM
		Aa83b10t00 aa83b10t00 = aa83b10t00Service.add(aa83bSolicitudesUtil
				.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_1,
						Aa83BConstants.COD_TRAM_1, "N"));

		// Inserto Vinculos Familiares:
		Aa83b28t00 aa83b28t001 = new Aa83b28t00();
		Aa83b28t00 aa83b28t002 = new Aa83b28t00();
		Aa83b28t00 aa83b28t003 = new Aa83b28t00();
		Aa83b28t00 aa83b28t004 = new Aa83b28t00();
		Aa83b28t00 aa83b28t005 = new Aa83b28t00();
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente1())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente1())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente1())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden1())) {
			aa83b28t001.setDniNie028(aa83b23t00.getdNINIEResidente1());
			aa83b28t001.setId023NumSol(aa83b23t00New.getId023());
			aa83b28t001.setIdAno023(aa83b23t00New.getIdAno023());
			aa83b28t001.setNombre028(aa83b23t00.getNombreResidente1());
			aa83b28t001.setParentesco028(aa83b23t00.getParentescoResidente1());
			aa83b28t001.setResidencia028(aa83b23t00.getLugResiden1());
			aa83b28t001 = aa83b28t00Service.add(aa83b28t001);
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente2())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente2())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente2())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden2())) {
			aa83b28t002.setId023NumSol(aa83b23t00New.getId023());
			aa83b28t002.setIdAno023(aa83b23t00New.getIdAno023());
			aa83b28t002.setDniNie028(aa83b23t00.getdNINIEResidente2());
			aa83b28t002.setNombre028(aa83b23t00.getNombreResidente2());
			aa83b28t002.setParentesco028(aa83b23t00.getParentescoResidente2());
			aa83b28t002.setResidencia028(aa83b23t00.getLugResiden2());
			aa83b28t002 = aa83b28t00Service.add(aa83b28t001);
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente3())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente3())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente3())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden3())) {
			aa83b28t003.setId023NumSol(aa83b23t00New.getId023());
			aa83b28t003.setIdAno023(aa83b23t00New.getIdAno023());
			aa83b28t003.setDniNie028(aa83b23t00.getdNINIEResidente3());
			aa83b28t003.setNombre028(aa83b23t00.getNombreResidente3());
			aa83b28t003.setParentesco028(aa83b23t00.getParentescoResidente3());
			aa83b28t003.setResidencia028(aa83b23t00.getLugResiden3());
			aa83b28t003 = aa83b28t00Service.add(aa83b28t001);
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente4())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente4())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente4())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden4())) {
			aa83b28t004.setId023NumSol(aa83b23t00New.getId023());
			aa83b28t004.setIdAno023(aa83b23t00New.getIdAno023());
			aa83b28t004.setDniNie028(aa83b23t00.getdNINIEResidente4());
			aa83b28t004.setNombre028(aa83b23t00.getNombreResidente4());
			aa83b28t004.setParentesco028(aa83b23t00.getParentescoResidente4());
			aa83b28t004.setResidencia028(aa83b23t00.getLugResiden4());
			aa83b28t004 = aa83b28t00Service.add(aa83b28t001);
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente5())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente5())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente5())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden5())) {
			aa83b28t005.setId023NumSol(aa83b23t00New.getId023());
			aa83b28t005.setIdAno023(aa83b23t00New.getIdAno023());
			aa83b28t005.setDniNie028(aa83b23t00.getdNINIEResidente5());
			aa83b28t005.setNombre028(aa83b23t00.getNombreResidente5());
			aa83b28t005.setParentesco028(aa83b23t00.getParentescoResidente5());
			aa83b28t005.setResidencia028(aa83b23t00.getLugResiden5());
			aa83b28t005 = aa83b28t00Service.add(aa83b28t005);
		}

		// ** FIN HISTO
		// GRABAMOS LOS DOCUMENTOS
		// insertar documentos
		String documento = "";
		String[] valoresDocumento;
		Aa83b32t00 documentacion = new Aa83b32t00();
		List<Aa83b32t00> aa83b32t00s = new ArrayList<Aa83b32t00>();
		if (StringUtils.isNotEmpty(aa83b23t00.getDocumentosString())) {
			String[] documentos = aa83b23t00.getDocumentosString().split("#");

			for (int i = 0; i < documentos.length; i++) {
				documentacion = new Aa83b32t00();
				documentacion.setId010HistoTram(aa83b10t00.getId010());
				documentacion.setId023NumSol(idSolicitud);
				documentacion.setIdAno023(anyoSolicitud);
				// recogemos cada documento
				documento = documentos[i];
				valoresDocumento = documento.split("-");
				documentacion.setOid032Papel0(valoresDocumento[1]);
				if (Aa83BConstants.VALOR_VACIO.equals(valoresDocumento[2])) {
					documentacion
							.setId030TipDocSol(Aa83BConstants.TIPO_DOC_VACIO);
				} else {
					documentacion.setId030TipDocSol(new Integer(
							valoresDocumento[2]));
				}
				if (valoresDocumento.length == 4) {
					// es otros
					documentacion.setDescOtros032(valoresDocumento[3]);
				}
				aa83b32t00Service.add(documentacion);
				aa83b32t00s.add(documentacion);
				// CAMBIAMOS EL CONTEXTO AL PROCESARLO
				Aa83bDocumentoDokusi documentoDokusi = new Aa83bDocumentoDokusi();
				documentoDokusi.setOid(documentacion.getOid032Papel0());
				// Uso la descripcion EU para pasar el numero de registro
				documentoDokusi.setDescripcionEu(aa83b23t00.getFecha023()
						.toString());

				String formato = Aa83BConstants.ES_PATTERN;

				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
						.getLanguage())) {
					formato = Aa83BConstants.EU_PATTERN;
				}
				java.util.Date utilDate2 = new java.util.Date();
				Date date2 = new Date(utilDate2.getTime());
				String fechaD = (String) new SimpleDateFormat(formato)
						.format(date2);

				documentoDokusi.setDescripcionEu(fechaD);

				// Uso la descripcion ES para pasar el numero de registro
				documentoDokusi.setDescripcionEs(aa83b23t00.getNumReg023());
				// Cambiamos el contexto en DOKUSI del documento
				// System.out.println("Cambiando contexto a: " +
				// solicitud35.getOid035());
				Boolean docSubido = this.aa83bDokusiService.tramitateDocument(
						documentoDokusi, daSeries);
				logger.info("Contexto de: " + documentacion.getOid032Papel0()
						+ " cambiado " + docSubido);
			}
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getDocumentosNoPresentados())) {
			String[] documentosNoPresentados = aa83b23t00
					.getDocumentosNoPresentados().split("#");
			for (int i = 0; i < documentosNoPresentados.length; i++) {
				documentacion = new Aa83b32t00();
				documentacion.setId010HistoTram(aa83b10t00.getId010());
				documentacion.setId023NumSol(idSolicitud);
				documentacion.setIdAno023(anyoSolicitud);
				// recogemos cada documento
				documentacion.setOid032Papel0(Aa83BConstants.OID_VACIO);
				documentacion.setId030TipDocSol(new Integer(
						documentosNoPresentados[i]));
				aa83b32t00Service.add(documentacion);
				aa83b32t00s.add(documentacion);
			}
		}
		// FIN DE LOS DOCUMENTOS
		// pasamos la solicitud a aceptada
		Aa83b34t00 aa83b34t00 = new Aa83b34t00();
		aa83b34t00.setCodsolic034(aa83b23t00.getCodSolicitud034());
		aa83b34t00Service.aceptarSolicitud(aa83b34t00);
		aa83b23t00New.setAccion(Aa83BConstants.ACC_SOL_ALTA);

		return aa83b23t00New;
	}

	/**
	 * Updates a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b23t00 update(Aa83b23t00 aa83b23t00) {
		Aa83b28t00 aa83b28t00 = new Aa83b28t00();
		System.out.println("Service Impl -1");
		aa83b28t00.setId023NumSol(aa83b23t00.getId023());
		aa83b28t00.setIdAno023(aa83b23t00.getIdAno023());
		// List<Aa83b28t00> aa83b28t00List = new ArrayList<Aa83b28t00>();
		// Meto los datos de reagrupados en el objeto a modificar:
		// Borramos la lista de ragrupados y la volvemos a insertar
		// Sacamos la lista de reagrupados a borrar:
		// aa83b28t00List = aa83b28t00Service.findAllLike(aa83b28t00, null,
		// false);
		// for (int b = 0; b < aa83b28t00List.size(); b++) {
		aa83b28t00Service.removePorSolicitud(aa83b28t00);

		// }

		// La volvemos a insertar - Inserto Vinculos Familiares:
		Aa83b28t00 aa83b28t001 = new Aa83b28t00();
		Aa83b28t00 aa83b28t002 = new Aa83b28t00();
		Aa83b28t00 aa83b28t003 = new Aa83b28t00();
		Aa83b28t00 aa83b28t004 = new Aa83b28t00();
		Aa83b28t00 aa83b28t005 = new Aa83b28t00();

		System.out.println("Service Impl -2");

		List<Aa83b28t00> aa83b28t00ListNew = new ArrayList<Aa83b28t00>();
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente1())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente1())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente1())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden1())) {
			aa83b28t001.setDniNie028(aa83b23t00.getdNINIEResidente1());
			aa83b28t001.setId023NumSol(aa83b23t00.getId023());
			aa83b28t001.setIdAno023(aa83b23t00.getIdAno023());
			aa83b28t001.setNombre028(aa83b23t00.getNombreResidente1());
			aa83b28t001.setParentesco028(aa83b23t00.getParentescoResidente1());
			aa83b28t001.setResidencia028(aa83b23t00.getLugResiden1());
			aa83b28t001 = aa83b28t00Service.add(aa83b28t001);
			aa83b28t00ListNew.add(aa83b28t001);
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente2())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente2())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente2())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden2())) {
			aa83b28t002.setId023NumSol(aa83b23t00.getId023());
			aa83b28t002.setIdAno023(aa83b23t00.getIdAno023());
			aa83b28t002.setDniNie028(aa83b23t00.getdNINIEResidente2());
			aa83b28t002.setNombre028(aa83b23t00.getNombreResidente2());
			aa83b28t002.setParentesco028(aa83b23t00.getParentescoResidente2());
			aa83b28t002.setResidencia028(aa83b23t00.getLugResiden2());
			aa83b28t002 = aa83b28t00Service.add(aa83b28t002);
			aa83b28t00ListNew.add(aa83b28t002);
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente3())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente3())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente3())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden3())) {
			aa83b28t003.setId023NumSol(aa83b23t00.getId023());
			aa83b28t003.setIdAno023(aa83b23t00.getIdAno023());
			aa83b28t003.setDniNie028(aa83b23t00.getdNINIEResidente3());
			aa83b28t003.setNombre028(aa83b23t00.getNombreResidente3());
			aa83b28t003.setParentesco028(aa83b23t00.getParentescoResidente3());
			aa83b28t003.setResidencia028(aa83b23t00.getLugResiden3());
			aa83b28t003 = aa83b28t00Service.add(aa83b28t003);
			aa83b28t00ListNew.add(aa83b28t003);
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente4())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente4())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente4())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden4())) {
			aa83b28t004.setId023NumSol(aa83b23t00.getId023());
			aa83b28t004.setIdAno023(aa83b23t00.getIdAno023());
			aa83b28t004.setDniNie028(aa83b23t00.getdNINIEResidente4());
			aa83b28t004.setNombre028(aa83b23t00.getNombreResidente4());
			aa83b28t004.setParentesco028(aa83b23t00.getParentescoResidente4());
			aa83b28t004.setResidencia028(aa83b23t00.getLugResiden4());
			aa83b28t004 = aa83b28t00Service.add(aa83b28t004);
			aa83b28t00ListNew.add(aa83b28t004);
		}
		if (StringUtils.isNotEmpty(aa83b23t00.getdNINIEResidente5())
				|| StringUtils.isNotEmpty(aa83b23t00.getNombreResidente5())
				|| StringUtils.isNotEmpty(aa83b23t00.getParentescoResidente5())
				|| StringUtils.isNotEmpty(aa83b23t00.getLugResiden5())) {
			aa83b28t005.setId023NumSol(aa83b23t00.getId023());
			aa83b28t005.setIdAno023(aa83b23t00.getIdAno023());
			aa83b28t005.setDniNie028(aa83b23t00.getdNINIEResidente5());
			aa83b28t005.setNombre028(aa83b23t00.getNombreResidente5());
			aa83b28t005.setParentesco028(aa83b23t00.getParentescoResidente5());
			aa83b28t005.setResidencia028(aa83b23t00.getLugResiden5());
			aa83b28t005 = aa83b28t00Service.add(aa83b28t005);
			aa83b28t00ListNew.add(aa83b28t005);
		}

		System.out.println("Service Impl -3");
		aa83b23t00.setAa83b28t00s(aa83b28t00ListNew);
		System.out.println("Service Impl -4");
		// insertar documentos
		// primero los borramos y los volvemos a insertar

		String documento = "";
		String[] valoresDocumento;
		Aa83b32t00 documentacion = new Aa83b32t00();
		documentacion.setId023NumSol(aa83b23t00.getId023());
		documentacion.setIdAno023(aa83b23t00.getIdAno023());
		List<Aa83b32t00> aa83b32t00sBorrar = new ArrayList<Aa83b32t00>();
		aa83b32t00sBorrar = aa83b32t00Service.findAllLike(documentacion, null, false);
		List<Aa83b32t00> docsEntregados = new ArrayList<Aa83b32t00>();
		for (int b = 0; b < aa83b32t00sBorrar.size(); b++) {
			Aa83b32t00 borrar = aa83b32t00sBorrar.get(b);
			// Guardar la info de los documentos entregados para recuperarla ms abajo
			if (borrar.getTipoAportacion032() != null && borrar.getTipoAportacion032().equals("E")) {
				docsEntregados.add(borrar);
			}
			aa83b32t00Service.remove(borrar);
		}
		System.out.println("Service Impl -5");
		List<Aa83b32t00> aa83b32t00s = new ArrayList<Aa83b32t00>();
		// buscamos la tramitacion
		Aa83b10t00 aa83b10t00 = new Aa83b10t00();
		aa83b10t00.setId023NumSol(new Long(aa83b23t00.getId023()));
		aa83b10t00.setIdAno023(aa83b23t00.getIdAno023());
		aa83b10t00 = (aa83b10t00Service.findAll(aa83b10t00, null)).get(0);
		
		if (StringUtils.isNotEmpty(aa83b23t00.getDocumentosString())) {
			String[] documentos = aa83b23t00.getDocumentosString().trim().split("#");
			for (int i = 0; i < documentos.length; i++) {
				documentacion = new Aa83b32t00();
			//	documentacion.setId010HistoTram(aa83b10t00.getId010());
				documentacion.setId023NumSol(aa83b23t00.getId023());
				documentacion.setIdAno023(aa83b23t00.getIdAno023());
				// recogemos cada documento
				documento = documentos[i];
				valoresDocumento = documento.split("-");
				String tipoAportacion = "";
				String idHistTramit="";
				documentacion.setId032(Integer.parseInt(valoresDocumento[0]));
				if (valoresDocumento.length == 5) {
					tipoAportacion = valoresDocumento[3];
					idHistTramit= valoresDocumento[4];
				} else if (valoresDocumento.length == 6) {
					// es otros
					documentacion.setDescOtros032(valoresDocumento[3]);
					tipoAportacion = valoresDocumento[4];
					idHistTramit= valoresDocumento[5];
				}
				documentacion.setId010HistoTram(Integer.valueOf(idHistTramit));
				if (tipoAportacion.equals("A")) {
					documentacion.setOid032Papel0(valoresDocumento[1]);
					documentacion.setTipoAportacion032("A");
				} else if (tipoAportacion.equals("E")) {
					documentacion.setOid032Papel0(Aa83BConstants.OID_VACIO);
					documentacion.setTipoAportacion032("E");
					// Buscar la info del documento entregado que no cambia y no viene en la peticin
					for (Aa83b32t00 docEntregado : docsEntregados) {
						if (docEntregado.getId032() == Integer.parseInt(valoresDocumento[0])) {
							documentacion.setOrgDocEntregado032(docEntregado.getOrgDocEntregado032());
							documentacion.setNomDocEntregado032(docEntregado.getNomDocEntregado032());
							documentacion.setFecDocEntregado032(docEntregado.getFecDocEntregado032());
						}
					}
				}
				if (Aa83BConstants.VALOR_VACIO.equals(valoresDocumento[2])) {
					documentacion.setId030TipDocSol(Aa83BConstants.TIPO_DOC_VACIO);
				} else {
					documentacion.setId030TipDocSol(new Integer(valoresDocumento[2]));
				}
				aa83b32t00Service.add(documentacion);
				aa83b32t00s.add(documentacion);
			}
		}

		if (StringUtils.isNotEmpty(aa83b23t00.getDocumentosNoPresentados())) {
			String[] documentosNoPresentados = aa83b23t00
					.getDocumentosNoPresentados().split("#");
			for (int i = 0; i < documentosNoPresentados.length; i++) {
				documentacion = new Aa83b32t00();
			//	documentacion.setId010HistoTram(aa83b10t00.getId010());
				documentacion.setId023NumSol(aa83b23t00.getId023());
				documentacion.setIdAno023(aa83b23t00.getIdAno023());
				// recogemos cada documento
				documentacion.setOid032Papel0(Aa83BConstants.OID_VACIO);
				documentacion.setId030TipDocSol(new Integer(
						documentosNoPresentados[i]));
				aa83b32t00Service.add(documentacion);
				aa83b32t00s.add(documentacion);
			}
		}

		aa83b23t00.setAa83b32t00s(aa83b32t00s);

		System.out.println("Service Impl -6");
		aa83b23t00 = aa83b23t00Service.update(aa83b23t00);

		// ** START ACCESO
		// Registramos el actor de modificacion

		System.out.println("Service Impl -7");

		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		// Introduzco un nuevo registro de Acceso
		aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(aa83b23t00,
				Aa83BConstants.ACCESOS_MODIF, "N"));
		// ** FIN ACCESO}
		System.out.println("Service Impl -8");
		return aa83b23t00;
	}

	/**
	 * Deletes a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83b23t00 aa83b23t00) {
		this.aa83b23t00Dao.remove(aa83b23t00);
	}

	/**
	 * Removes rows from the Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa83b23t00 filterAa83b23t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa83b23t00Dao.removeMultiple(filterAa83b23t00, jqGridRequestDto,
				startsWith);
	}

}
