package com.ejie.aa83b.service;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.jws.WebParam;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.exception.Aa83bDokusiException;
import com.ejie.aa83b.model.Aa83bDocumentoDokusi;
import com.ejie.aa83b.util.Aa83bDokusiUtil;
import com.ejie.aa83b.util.Aa83bMessageParser;
import com.ejie.aa83b.util.Aa83bUtilPIF;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;
import com.ejie.aa83b.util.Aa83bUtilidades;

import com.ejie.aa83b.webservice.client.dokusi.T65BFSDWSClasePort;
import com.ejie.schemas.t65b.T65BDocumentIDListType;
import com.ejie.schemas.t65b.T65BDocumentIDType;
import com.ejie.schemas.t65b.T65BDocumentType;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 * Clase que implementa los metodos a utilizar para invocar a los servicios web
 * de T65BFSD
 * 
 * @author DS
 * 
 */
@Service(value = "aa83bDokusiService")
public class Aa83bDokusiService {

	@Autowired
	private T65BFSDWSClasePort t65bService;

	@Autowired
	private Properties appConfiguration;

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bDokusiService.class);

	/**
	 * Recupera un documento almacenado en Dokusi. El documento recuperado se
	 * guardara en la ruta pif especificada(parametro rutaPif), para luego poder
	 * recuperarse con las utilidades PIF de la aplicacion. La ruta completa en
	 * la que se ha guardado se carga en el parametro rutaPif del objeto
	 * Documento devuelto.
	 * 
	 * @param documentoDokusi
	 *            DocumentoDokusi
	 * @return T65BDocumentType
	 * @throws Aa83bDokusiException
	 *             e
	 */
	public Aa83bDocumentoDokusi retrieveDocument2PIF(
			Aa83bDocumentoDokusi documentoDokusi) throws Aa83bDokusiException {
		Aa83bDocumentoDokusi resultado = documentoDokusi;

		try {

			String integrationToken = Aa83bUtilSeguridad
					.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);

			// String integrationToken = Aa83BConstants.tokenValido;

			// Si no está informado auditUserDokusi, se coge el de seguridad
			String auditUser = "";
			if (Aa83bUtilSeguridad.enOficina()) {
				logger.info("retrieveDocument2PIF:: EStamos en oficina");
				auditUser = "AA83BTRAAAX#AA83B-03, AA83B-03#AA83B-03#AA83B";
			} else {
				if (Aa83bUtilidades.isEmpty(auditUser)) {
					logger.info("retrieveDocument2PIF:: Estamos en EJIE-DES");
					auditUser = Aa83bUtilSeguridad.getAuditUser();
				}
			}

			// resultado.setRutaPif(Aa83bUtilProperties.PIF_PATH_APP_TMP);

			// Invocamos a Dokusi
			String respuesta = "";
			String rutaPIF = "<content><pifId>"
					+ this.appConfiguration.getProperty("RUTA_PIF_ADJ")
					+ "</pifId></content>";
			Aa83bDokusiService.logger
					.trace("respuesta WS 1 retrieveDocument:::"
							+ respuesta.toString());
			documentoDokusi.setRutaPif(rutaPIF);
			String docDokusi = "<documentID><id>" + documentoDokusi.getOid()
					+ "</id><version>CURRENT</version></documentID>";

			respuesta = this.t65bService.retrieveDocument(integrationToken,
					auditUser, docDokusi, "", rutaPIF);

			Aa83bDokusiService.logger.info("respuesta WS 2 retrieveDocument:::"
					+ respuesta.toString());

			// T65BDocumentType obj = (T65BDocumentType) new
			// Aa83bMessageParser<T65BDocumentType>(
			// T65BDocumentType.class.getPackage().getName())
			// .parse(respuesta);

			T65BDocumentType obj = (T65BDocumentType) new Aa83bMessageParser<T65BDocumentType>(
					T65BDocumentType.class.getPackage().getName())
					.parse(respuesta);

			resultado.setRutaPif(recogerEtiqueta(respuesta, "pifId"));

			// Iterator
			//
			// + obj.getAttributeList().getAttribute().get(0));

			resultado.setContent(obj.getContent().getContent());
			resultado.setTamanyo(Integer.parseInt(obj.getContent().getLenght()
					.toString()));
			resultado.setExtension(obj.getContent().getFormat().getExtension());
			resultado
					.setContentType(obj.getContent().getFormat().getMimeType());

			Aa83bDokusiService.logger.trace("retrieveDocument FIN");
		} catch (JAXBException e) {
			Aa83bDokusiService.logger.error("Error en retrieveDocument", e);

			throw new Aa83bDokusiException(
					Aa83bDokusiException.RETRIEVEDOCUMENT_ERROR, e);
		} catch (UnsupportedEncodingException e) {
			Aa83bDokusiService.logger.error("Error en retrieveDocument", e);

			throw new Aa83bDokusiException(
					Aa83bDokusiException.RETRIEVEDOCUMENT_ERROR, e);
		} catch (Exception e) {
			Aa83bDokusiService.logger.error(
					"Error en retrieveDocument CATCH 3", e);

		}
		return resultado;
	}

	/**
	 * Recupera un documento almacenado en Dokusi. El documento recuperado se
	 * guardara en la ruta pif especificada(parametro rutaPif), para luego poder
	 * recuperarse con las utilidades PIF de la aplicacion. La ruta completa en
	 * la que se ha guardado se carga en el parametro rutaPif del objeto
	 * Documento devuelto.
	 * 
	 * @param documentoDokusi
	 *            DocumentoDokusi
	 * @return T65BDocumentType
	 * @throws Aa83bDokusiException
	 *             e
	 */
	public Aa83bDocumentoDokusi retrieveDocument_OLDDD(
			Aa83bDocumentoDokusi documentoDokusi) throws Aa83bDokusiException {
		Aa83bDocumentoDokusi resultado = documentoDokusi;
		Aa83bDokusiService.logger.trace("retrieveDocument INI");

		try {

			String integrationToken = Aa83bUtilSeguridad
					.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);

			// String integrationToken = Aa83BConstants.tokenValido;

			// Si no está informado auditUserDokusi, se coge el de seguridad
			String auditUser = "";
			if (Aa83bUtilSeguridad.enOficina()) {
				logger.info("EStamos en oficina");
				auditUser = "AA83BTRAAAX#AA83B-03, AA83B-03#AA83B-03#AA83B";
			} else {
				if (Aa83bUtilidades.isEmpty(auditUser)) {
					auditUser = Aa83bUtilSeguridad.getAuditUser();
				}
			}

			// resultado.setRutaPif(Aa83bUtilProperties.PIF_PATH_APP_TMP);

			// Invocamos a Dokusi
			String respuesta = "";

			Aa83bDokusiService.logger
					.trace("respuesta WS 1 retrieveDocument:::"
							+ respuesta.toString());
			documentoDokusi.setRutaPif(null);

			respuesta = this.t65bService
					.retrieveDocument(
							integrationToken,
							auditUser,
							Aa83bDokusiUtil
									.getT65BDocumentIDAsString(documentoDokusi),
							"",
							Aa83bDokusiUtil
									.getT65BContentTypeAsString(documentoDokusi));

			Aa83bDokusiService.logger.info("respuesta WS 2 retrieveDocument:::"
					+ respuesta.toString());

			// T65BDocumentType obj = (T65BDocumentType) new
			// Aa83bMessageParser<T65BDocumentType>(
			// T65BDocumentType.class.getPackage().getName())
			// .parse(respuesta);

			T65BDocumentType obj = (T65BDocumentType) new Aa83bMessageParser<T65BDocumentType>(
					T65BDocumentType.class.getPackage().getName())
					.parse(respuesta);

			// Iterator
			//
			// + obj.getAttributeList().getAttribute().get(0));

			resultado.setContent(obj.getContent().getContent());
			resultado.setTamanyo(Integer.parseInt(obj.getContent().getLenght()
					.toString()));
			resultado.setExtension(obj.getContent().getFormat().getExtension());
			resultado
					.setContentType(obj.getContent().getFormat().getMimeType());

			Aa83bDokusiService.logger.trace("retrieveDocument FIN");
		} catch (JAXBException e) {
			Aa83bDokusiService.logger.error("Error en retrieveDocument", e);

			throw new Aa83bDokusiException(
					Aa83bDokusiException.RETRIEVEDOCUMENT_ERROR, e);
		} catch (UnsupportedEncodingException e) {
			Aa83bDokusiService.logger.error("Error en retrieveDocument", e);

			throw new Aa83bDokusiException(
					Aa83bDokusiException.RETRIEVEDOCUMENT_ERROR, e);
		} catch (Exception e) {
			Aa83bDokusiService.logger.error(
					"Error en retrieveDocument CATCH 3", e);

		}
		return resultado;
	}

	/**
	 * Almacena un documento en Dokusi. Devuelve el objeto documento, con su
	 * parametro OID informado.
	 * 
	 * @param documento
	 *            DocumentoDokusi
	 * @return T65BDocumentIDType
	 * @throws Aa83bDokusiException
	 *             e
	 * 
	 */
	public Aa83bDocumentoDokusi storeDocument(Aa83bDocumentoDokusi documento,String daSeries)
			throws Aa83bDokusiException {
		// Documento resultado = documento;
		Aa83bDokusiService.logger.trace("storeDocument INI");

		String rutaPifOriginal = documento.getRutaPif();
		try {
			/*
			 * La ruta al archivo en PIF a guardar en dokusi, debe estar dentro
			 * de la carpeta "/t65e/", para que funcione el WS de Dokusi.
			 * Copiamos el archivo PIF a la carpeta correspondiente.
			 */

			String extension = documento.getRutaPif().substring(
					documento.getRutaPif().length() - 3,
					documento.getRutaPif().length());

			// Hay que coger la extension del archivo!!!
			documento.setExtension(documento.getRutaPif().substring(
					documento.getRutaPif().indexOf(".") + 1,
					documento.getRutaPif().length()));

			// Y31AttachmentBean pifResult = Aa83bUtilPIF.copy(
			// documento.getRutaPif(),
			// (Aa83bUtilProperties.PIF_PATH_DOKUSI));

			// documento.setRutaPif(pifResult.getFilePath());

			String integrationToken = Aa83bUtilSeguridad
					.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
			// Si no está informado auditUserDokusi, se coge el de seguridad
			String auditUser = documento.getAuditUserDokusi();

			if (Aa83bUtilidades.isEmpty(auditUser)) {
				auditUser = Aa83bUtilSeguridad.getAuditUser();
			}
			String t65bContentType = Aa83bDokusiUtil
					.getT65BContentTypeAsString(documento);
			String tipoDocumental = documento.getTipoDocumento()
					.getTipoDocumental();
			String t65bAttributeList = "<attributeList><attribute><key>ejgv_origen</key><value>ORGANISMO_EXTERNO</value></attribute>"
					+ "<attribute><key>acl_name</key><value>ejgv_acl_d_AA83B_001</value></attribute><attribute><key>ejgv_serie</key><value>"+daSeries+"</value></attribute>"
					+ "<attribute><key>title</key><value>Certificado identidad pareja</value></attribute>"
					+ "<attribute><key>object_name</key><value>ejgv_d_ejgv_d_archivo</value></attribute></attributeList>";
			// t65bAttributeList = Aa83bDokusiUtil
			// .getT65BAttibuteListTypeAsString(documento);
			//

			// Llamamos a Dokusi
			String respuesta = this.t65bService.storeDocument(integrationToken,
					auditUser, t65bContentType, tipoDocumental,
					t65bAttributeList);
			T65BDocumentIDType obj = (T65BDocumentIDType) new Aa83bMessageParser<T65BDocumentIDType>(
					T65BDocumentIDType.class.getPackage().getName())
					.parse(respuesta);

			documento.setOid(obj.getId());

		} catch (JAXBException e) {
			Aa83bDokusiService.logger.error("Error en storeDocument", e);
			throw new Aa83bDokusiException(
					Aa83bDokusiException.STOREDOCUMENT_ERROR, e);
		} catch (UnsupportedEncodingException e) {
			Aa83bDokusiService.logger.error("Error en storeDocument", e);
			throw new Aa83bDokusiException(
					Aa83bDokusiException.STOREDOCUMENT_ERROR, e);
		} finally {
			// Se restaura la ruta temporal al fichero en PIF.
			documento.setRutaPif(rutaPifOriginal);
		}
		return documento;
	}

	/**
	 * Almacena varios documentos en Dokusi. Devuelve List<Documento>, con su
	 * parametro OID informado.
	 * 
	 * @param documentos
	 *            List<Documento>
	 * @return List<Documento>
	 * @throws Aa83bDokusiException
	 *             e
	 */
	public List<Aa83bDocumentoDokusi> storeDocuments(
			List<Aa83bDocumentoDokusi> documentos) throws Aa83bDokusiException {
		Aa83bDokusiService.logger.trace("storeDocuments INI");
		List<String> rutasPifOriginal = new ArrayList<String>();
		// StringBuffer documentalTypeArray = new StringBuffer();

		if (!Aa83bUtilidades.isEmptyList(documentos)) {
			try {
				/*
				 * La ruta al archivo en PIF a guardar en dokusi, debe estar
				 * dentro de la carpeta "/t65e/", para que funcione el WS de
				 * Dokusi. Copiamos los archivos PIF a la carpeta
				 * correspondiente.
				 */
				for (Aa83bDocumentoDokusi documento : documentos) {
					rutasPifOriginal.add(documento.getRutaPif());
					Y31AttachmentBean pifResult = Aa83bUtilPIF.copy(documento
							.getRutaPif(), Aa83bUtilProperties
							.getProperty(Aa83bUtilProperties.PIF_PATH_DOKUSI));
					documento.setRutaPif(pifResult.getFilePath());
				}

				String integrationToken = Aa83bUtilSeguridad
						.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
				// Si no está informado auditUserDokusi, se coge el de
				// seguridad
				String auditUser = documentos.get(0).getAuditUserDokusi();
				if (Aa83bUtilidades.isEmpty(auditUser)) {
					auditUser = Aa83bUtilSeguridad.getAuditUser();
				}
				String t65bContentTypeArray = Aa83bDokusiUtil
						.getT65BContentListTypeAsString(documentos);
				String documentalTypeArray = Aa83bDokusiUtil
						.getT65BStringListTypeAsString(documentos);
				String t65bAttributeListListType = Aa83bDokusiUtil
						.getT65BAttibuteListListTypeAsString(documentos);

				// Invocamos a Dokusi
				String respuesta = this.t65bService.storeDocuments(
						integrationToken, auditUser, t65bContentTypeArray,
						documentalTypeArray, t65bAttributeListListType);

				T65BDocumentIDListType obj = (T65BDocumentIDListType) new Aa83bMessageParser<T65BDocumentIDListType>(
						T65BDocumentIDListType.class.getPackage().getName())
						.parse(respuesta);

				int i = 0;
				for (Aa83bDocumentoDokusi documento : documentos) {
					documento.setOid(obj.getDocumentID().get(i).getId());
					i++;
				}

				Aa83bDokusiService.logger.trace("storeDocuments FIN");
			} catch (JAXBException e) {
				Aa83bDokusiService.logger.error("Error en storeDocument", e);
				throw new Aa83bDokusiException(
						Aa83bDokusiException.STOREDOCUMENTS_ERROR, e);
			} catch (UnsupportedEncodingException e) {
				Aa83bDokusiService.logger.error("Error en storeDocument", e);
				throw new Aa83bDokusiException(
						Aa83bDokusiException.STOREDOCUMENTS_ERROR, e);
			} finally {
				// Se restaura la ruta temporal al fichero en PIF.
				int i = 0;
				for (Aa83bDocumentoDokusi documento : documentos) {
					documento.setRutaPif(rutasPifOriginal.get(i));
					i++;
				}
			}

		}

		return documentos;
	}

	public Boolean tramitateDocument(Aa83bDocumentoDokusi documentoDokusi, String daSeries)
			throws Aa83bDokusiException {

		String auditUser = "";

		// if (Aa83bUtilSeguridad.enOficina()) {
		// System.out.println("EStamos en oficina");
		// auditUser = "AA83BTRAAAX#AA83B-03, AA83B-03#AA83B-03#AA83B";
		// } else {
		// if (Aa83bUtilidades.isEmpty(auditUser)) {
		// System.out.println("En EJIE-DES");
		// auditUser = Aa83bUtilSeguridad.getAuditUser();
		// System.out.println("En EJIE-DES auditUser"
		// + auditUser.toString());
		// }
		// }
		// No hay sesion, pongo un usuario ficticio para la accion de
		// tramitacin
		auditUser = "AA83BTRAAAX#AA83B-03, AA83B-03#AA83B-03#AA83B";
		String integrationToken = Aa83bUtilSeguridad
				.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
		String newDocumentalType = "";
		String documentID = "<documentID><id>" + documentoDokusi.getOid()
				+ "</id></documentID>";
		logger.info("documentID: " + documentID);
		String fechaReg = documentoDokusi.getDescripcionEu();
		String numReg = documentoDokusi.getDescripcionEs();
		
		

		String attributeList = "<attributeList><attribute><key>ejgv_entrada_salida</key><value>E</value></attribute><attribute><key>ejgv_entidad</key><value>EJIE</value>"
				+ "</attribute><attribute><key>ejgv_libro_registro</key><value>2016-ENTRADAS  (R. GENERAL G.V.)</value></attribute><attribute><key>ejgv_fecha_registro</key>"
				+ "<value>"
				+ fechaReg
				+ "</value></attribute>"

				+ "<attribute><key>ejgv_serie</key>"
				+ "<value>"
				+ daSeries
				+ "</value></attribute>"

				+ "<attribute><key>ejgv_formato_registro</key><value>pdf</value></attribute><attribute>"
				+ "<key>ejgv_num_registro</key><value>"
				+ numReg
				+ "</value></attribute></attributeList>";
		// Llamamos a Dokusi

		Boolean respuesta = false;
		try {
			respuesta = this.t65bService.tramitateDocument(integrationToken,
					auditUser, documentID, newDocumentalType, attributeList);

			logger.info("respuesta Tramitate::" + respuesta);

		} catch (Exception e) {
			// TODO: handle exception
			logger.info("Exception en Tramitate Document:: " + e.toString());
		}
		logger.info("Respues TRamitate Document:: " + respuesta);
		return respuesta;
	}

	private String recogerEtiqueta(String xml, String etiqueta) {
		String valor = "";
		try {
			String inicio = "<" + etiqueta + ">";
			int inicioint = xml.indexOf(inicio) + inicio.length();
			String fin = "</" + etiqueta + ">";
			int finint = xml.indexOf(fin);
			valor = xml.substring(inicioint, finint);
			if (!etiqueta.equals("sourceBinary"))
				logger.info("la etiqueta==>" + etiqueta + " es==>" + valor);
		} catch (Exception e) {
			// No hacemos nada
			// e.printStackTrace();
		}
		return valor;
	}
}