package com.ejie.aa83b.service;
import com.ejie.aa83b.dao.Aa83bCierresDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83bCierres;

/**
 * CierresServiceImpl generated by UDA, 13-mar-2017 13:44:14.
 * @author UDA
 */

@Service(value = "cierresService")
public class Aa83bCierresServiceImpl implements Aa83bCierresService {

	@Autowired
	private Aa83bCierresDao cierresDao;

	/**
	 * Inserts a single row in the Cierres table.
	 *
	 * @param cierres Cierres
	 * @return Cierres
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83bCierres add(Aa83bCierres cierres) {
		return this.cierresDao.add(cierres);
	}

	/**
	 * Updates a single row in the Cierres table.
	 *
	 * @param cierres Cierres
	 * @return Cierres
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83bCierres update(Aa83bCierres cierres) {
		return this.cierresDao.update(cierres);
	 }

	/**
	 * Finds a single row in the Cierres table.
	 *
	 * @param cierres Cierres
	 * @return Cierres
	 */
	public Aa83bCierres find(Aa83bCierres cierres) {
		return (Aa83bCierres) this.cierresDao.find(cierres);
	}
	
	/**
	 * Deletes a single row in the Cierres table.
	 *
	 * @param cierres Cierres
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83bCierres cierres) {
		this.cierresDao.remove(cierres);
	}

	/**
	 * Finds a list of rows in the Cierres table.
	 *
	 * @param cierres Cierres
	 * @param jqGridRequestDto JQGridRequestDto
	 * @return List<Cierres>
	 */
	public List<Aa83bCierres> findAll(Aa83bCierres cierres, JQGridRequestDto jqGridRequestDto){
		return (List<Aa83bCierres>) this.cierresDao.findAll(cierres, jqGridRequestDto);
	}
    
	/**
	 * Finds rows in the Cierres table using like.
	 *
	 * @param cierres Cierres
	 * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean	 
	 * @return List<Cierres>
	 */
	public List<Aa83bCierres> findAllLike(Aa83bCierres cierres, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return (List<Aa83bCierres>) this.cierresDao.findAllLike(cierres, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	 
	/**
	 * Removes rows from the Cierres table.
	 *
	 * @param filterCierres Cierres
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 */	
	public void removeMultiple(Aa83bCierres filterCierres, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		this.cierresDao.removeMultiple(filterCierres, jqGridRequestDto, startsWith);
	}
        
	/**
	 * Filter method in the Cierres table.
	 *
	 * @param filterCierres Cierres
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 * @return JQGridResponseDto<Cierres>
	 */	
	public JQGridResponseDto< Aa83bCierres> filter(Aa83bCierres filterCierres, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		List<Aa83bCierres> listaCierres =  this.cierresDao.findAllLike(filterCierres, jqGridRequestDto, false);
		Long recordNum =  this.cierresDao.findAllLikeCount(filterCierres != null ? filterCierres: new Aa83bCierres (),false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds()!=null){
			List< TableRowDto< Aa83bCierres>> reorderSelection = this.cierresDao.reorderSelection(filterCierres, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<Aa83bCierres>(jqGridRequestDto, recordNum, listaCierres, reorderSelection);
		}
		return new JQGridResponseDto<Aa83bCierres>(jqGridRequestDto, recordNum, listaCierres);   
	}
    
    /**
	 * Searches rows in the Cierres table.
	 *
	 * @param filterCierres Cierres
	 * @param searchCierres Cierres
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 * @return List<TableRowDto<Cierres>>
	 */	
    public List< TableRowDto< Aa83bCierres>> search(Aa83bCierres filterCierres, Aa83bCierres searchCierres, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.cierresDao.search(filterCierres, searchCierres, jqGridRequestDto, startsWith);
	}
    
    /**
	 * Reorder the selection made in Cierres table.
	 *
	 * @param filterCierres Cierres
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 * @return Object
	 */	
    public Object reorderSelection(Aa83bCierres filterCierres, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.cierresDao.reorderSelection(filterCierres, jqGridRequestDto, startsWith);
	}
    
    /*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */
	 
	/**
	 * Finder method in the hierarchical the Cierres table.
	 *
	 * @param filterCierres Cierres
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Cierres>>
	 */	
	public JQGridResponseDto<JerarquiaDto<Aa83bCierres>> jerarquia(Aa83bCierres filterCierres, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		List<JerarquiaDto<Aa83bCierres>> listaCierres =  this.cierresDao.findAllLikeJerarquia(filterCierres, jqGridRequestDto);
		Long recordNum = this.cierresDao.findAllLikeCountJerarquia(filterCierres, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa83bCierres>>(jqGridRequestDto, recordNum, listaCierres);
	}
	
	/**
	 * Finder method for siblings rows in the hierarchical the Cierres table.
	 *
	 * @param filterCierres Cierres
	 * @param jqGridRequestDto JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Cierres>>
	 */	
	public JQGridResponseDto<JerarquiaDto<Aa83bCierres>> jerarquiaChildren(Aa83bCierres filterCierres, JQGridRequestDto jqGridRequestDto){
		JQGridResponseDto<JerarquiaDto<Aa83bCierres>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa83bCierres>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN, this.cierresDao.findAllChild(filterCierres, jqGridRequestDto));
		return jqGridResponseDto;
	}
	
	
}

