package com.ejie.aa83b.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ejie.aa83b.model.Aa83bDocumentoDokusi;
import com.ejie.aa83b.service.Aa83bDokusiService;
import java.text.SimpleDateFormat;

import com.ejie.aa83b.dao.Aa83b25t00Dao;
import com.ejie.aa83b.model.Aa83b08t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b29t00;
import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b33t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.x38.dto.JQGridRequestDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Aa83b21t00ServiceImpl generated by UDA, 28-dic-2015 17:45:22.
 * 
 * @author UDA
 */

@Service(value = "Aa83bARRService")
public class Aa83bARRServiceImpl implements Aa83bARRService {

	@Autowired
	private Aa83b25t00Dao aa83b25t00Dao;
	@Autowired()
	private Aa83b08t00Service aa83b08t00Service;
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;
	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;
	@Autowired()
	private Aa83b29t00Service aa83b29t00Service;
	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	@Autowired()
	private Aa83b33t00Service aa83b33t00Service;
	/** The service. */
	@Autowired
	private Aa83bDokusiService aa83bDokusiService;
	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bARRServiceImpl.class);
	/**
	 * Inserts a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b25t00 add(Aa83b25t00 aa83b25t00, String daSeries) {

		Aa83b25t00 aa83b25t00New = new Aa83b25t00();
		if (StringUtils.isEmpty(aa83b25t00.getF1Empadron025())) {
			aa83b25t00.setF1Empadron025(null);
		}
		if (StringUtils.isEmpty(aa83b25t00.getFNac025())) {
			aa83b25t00.setFNac025(null);
		}
		if (StringUtils.isEmpty(aa83b25t00.getfEmpActual025())) {
			aa83b25t00.setfEmpActual025(null);
		}
		if (StringUtils.isEmpty(aa83b25t00.getfEntradaEsp025())) {
			aa83b25t00.setfEntradaEsp025(null);
		}
		aa83b25t00.setSolicerrada025("N");
		aa83b25t00New = aa83b25t00Service.add(aa83b25t00);
		int idSolicitud = aa83b25t00New.getId025();
		Long anyoSolicitud = aa83b25t00New.getIdAno025();
		// ** START ACCESO
		// Despues de crear la Solicitud, registramos el actor:
		// Aa83b08t00 aa83b08t00 = new Aa83b08t00();

		// Guardamos el acceso:
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(
				aa83b25t00New, Aa83BConstants.ACCESOS_ALTA, "N"));

		// ** FIN ACCESO

		// ** START HISTO
		// Despues de crear la Solicitud, registramos el historial de
		// tramitacion
		// Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		Aa83b11t00 aa83b11t00 = aa83b11t00Service.add(aa83bSolicitudesUtil
				.guardarHistoARR(aa83b25t00New, Aa83BConstants.COD_FASE_1,
						Aa83BConstants.COD_TRAM_1, "N"));
		// ** FIN HISTO

		// Inserto Vinculos Familiares:
		Aa83b29t00 aa83b29t001 = new Aa83b29t00();
		Aa83b29t00 aa83b29t002 = new Aa83b29t00();
		Aa83b29t00 aa83b29t003 = new Aa83b29t00();
		Aa83b29t00 aa83b29t004 = new Aa83b29t00();
		Aa83b29t00 aa83b29t005 = new Aa83b29t00();
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente1())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente1())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente1())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden1()))
		{
		aa83b29t001.setDniNie029(aa83b25t00.getdNINIEResidente1());
		aa83b29t001.setId025NumSol(aa83b25t00New.getId025());
		aa83b29t001.setIdAno025(aa83b25t00New.getIdAno025());
		aa83b29t001.setNombre029(aa83b25t00.getNombreResidente1());
		aa83b29t001.setParentensco029(aa83b25t00.getParentescoResidente1());
		aa83b29t001.setResidencia029(aa83b25t00.getLugResiden1());
		aa83b29t001 = aa83b29t00Service.add(aa83b29t001);
		}
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente2())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente2())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente2())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden2()))
		{
		aa83b29t002.setId025NumSol(aa83b25t00New.getId025());
		aa83b29t002.setIdAno025(aa83b25t00New.getIdAno025());
		aa83b29t002.setDniNie029(aa83b25t00.getdNINIEResidente2());
		aa83b29t002.setNombre029(aa83b25t00.getNombreResidente2());
		aa83b29t002.setParentensco029(aa83b25t00.getParentescoResidente2());
		aa83b29t002.setResidencia029(aa83b25t00.getLugResiden2());
		aa83b29t002 = aa83b29t00Service.add(aa83b29t002);
		}
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente3())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente3())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente3())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden3()))
		{
		aa83b29t003.setId025NumSol(aa83b25t00New.getId025());
		aa83b29t003.setIdAno025(aa83b25t00New.getIdAno025());
		aa83b29t003.setDniNie029(aa83b25t00.getdNINIEResidente3());
		aa83b29t003.setNombre029(aa83b25t00.getNombreResidente3());
		aa83b29t003.setParentensco029(aa83b25t00.getParentescoResidente3());
		aa83b29t003.setResidencia029(aa83b25t00.getLugResiden3());
		aa83b29t003 = aa83b29t00Service.add(aa83b29t003);
		}
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente4())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente4())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente4())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden4()))
		{
		aa83b29t004.setId025NumSol(aa83b25t00New.getId025());
		aa83b29t004.setIdAno025(aa83b25t00New.getIdAno025());
		aa83b29t004.setDniNie029(aa83b25t00.getdNINIEResidente4());
		aa83b29t004.setNombre029(aa83b25t00.getNombreResidente4());
		aa83b29t004.setParentensco029(aa83b25t00.getParentescoResidente4());
		aa83b29t004.setResidencia029(aa83b25t00.getLugResiden4());
		aa83b29t004 = aa83b29t00Service.add(aa83b29t004);
		}
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente5())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente5())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente5())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden5()))
		{
		aa83b29t005.setId025NumSol(aa83b25t00New.getId025());
		aa83b29t005.setIdAno025(aa83b25t00New.getIdAno025());
		aa83b29t005.setDniNie029(aa83b25t00.getdNINIEResidente5());
		aa83b29t005.setNombre029(aa83b25t00.getNombreResidente5());
		aa83b29t005.setParentensco029(aa83b25t00.getParentescoResidente5());
		aa83b29t005.setResidencia029(aa83b25t00.getLugResiden5());
		aa83b29t005 = aa83b29t00Service.add(aa83b29t005);
		}
		

		// ** FIN HISTO
		// insertar documentos
		String documento = "";
		String[] valoresDocumento;
		Aa83b33t00 documentacion = new Aa83b33t00();
		List<Aa83b33t00> aa83b33t00s = new ArrayList<Aa83b33t00>();
		if (StringUtils.isNotEmpty(aa83b25t00.getDocumentosString())) {
			String[] documentos = aa83b25t00.getDocumentosString().split("#");
			for (int i = 0; i < documentos.length; i++) {
				documentacion = new Aa83b33t00();
				documentacion.setId011HistoTram(aa83b11t00.getId011());
				documentacion.setId025NumSol(idSolicitud);
				documentacion.setIdAno025(anyoSolicitud);
				// recogemos cada documento
				documento = documentos[i];
				valoresDocumento = documento.split("-");
				documentacion.setOid033Papel0(valoresDocumento[1]);
				if (Aa83BConstants.VALOR_VACIO.equals(valoresDocumento[2])) {
					documentacion
							.setId030TipDocSol(Aa83BConstants.TIPO_DOC_VACIO);
				} else {
					documentacion.setId030TipDocSol(new Integer(
							valoresDocumento[2]));
				}
				if (valoresDocumento.length == 4) {
					// es otros
					documentacion.setDescOtros033(valoresDocumento[3]);
				}
				aa83b33t00Service.add(documentacion);
				aa83b33t00s.add(documentacion);
				//CAMBIAMOS EL CONTEXTO AL PROCESARLO
				Aa83bDocumentoDokusi documentoDokusi = new Aa83bDocumentoDokusi();
				documentoDokusi.setOid(documentacion.getOid033Papel0());
				// Uso la descripcion EU para pasar el numero de registro
				documentoDokusi.setDescripcionEu(aa83b25t00.getFecha025()
						.toString());
				
				String formato = Aa83BConstants.ES_PATTERN; 
				
				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
						.getLanguage())) {
					formato = Aa83BConstants.EU_PATTERN;
				}
				java.util.Date utilDate2 = new java.util.Date();
				Date date2 = new Date(utilDate2.getTime());
				String fechaD = (String) new SimpleDateFormat(formato).format(date2);
				
				documentoDokusi.setDescripcionEu(fechaD);

				// Uso la descripcion ES para pasar el numero de registro
				documentoDokusi.setDescripcionEs(aa83b25t00.getNumReg025());
				// Cambiamos el contexto en DOKUSI del documento
//				System.out.println("Cambiando contexto a: " + solicitud35.getOid035());
				Boolean docSubido = this.aa83bDokusiService
						.tramitateDocument(documentoDokusi,daSeries);
				logger.info("Contexto de: " + documentacion.getOid033Papel0() + " cambiado "
						+ docSubido);
			}
		}
		if (StringUtils.isNotEmpty(aa83b25t00.getDocumentosNoPresentados())) {
			String[] documentosNoPresentados = aa83b25t00
					.getDocumentosNoPresentados().split("#");
			for (int i = 0; i < documentosNoPresentados.length; i++) {
				documentacion = new Aa83b33t00();
				documentacion.setId011HistoTram(aa83b11t00.getId011());
				documentacion.setId025NumSol(idSolicitud);
				documentacion.setIdAno025(anyoSolicitud);
				// recogemos cada documento
				documentacion.setOid033Papel0(Aa83BConstants.OID_VACIO);
				documentacion.setId030TipDocSol(new Integer(
						documentosNoPresentados[i]));
				aa83b33t00Service.add(documentacion);
				aa83b33t00s.add(documentacion);
			}
		}
		// pasamos la solicitud a aceptada
		Aa83b34t00 aa83b34t00 = new Aa83b34t00();
		aa83b34t00.setCodsolic034(aa83b25t00.getCodSolicitud034());
		aa83b34t00Service.aceptarSolicitud(aa83b34t00);
		aa83b25t00New.setAccion(Aa83BConstants.ACC_SOL_ALTA);
		
		return aa83b25t00New;
	
	}

	/**
	 * Updates a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b25t00 update(Aa83b25t00 aa83b25t00) {

		if (StringUtils.isEmpty(aa83b25t00.getF1Empadron025())) {
			aa83b25t00.setF1Empadron025(null);
		}
		if (StringUtils.isEmpty(aa83b25t00.getFNac025())) {
			aa83b25t00.setFNac025(null);
		}
		if (StringUtils.isEmpty(aa83b25t00.getfEmpActual025())) {
			aa83b25t00.setfEmpActual025(null);
		}
		if (StringUtils.isEmpty(aa83b25t00.getfEntradaEsp025())) {
			aa83b25t00.setfEntradaEsp025(null);
		}
		Aa83b29t00 aa83b29t00 = new Aa83b29t00();
		aa83b29t00.setId025NumSol(aa83b25t00.getId025());
		aa83b29t00.setIdAno025(aa83b25t00.getIdAno025());
		//List<Aa83b29t00> aa83b29t00List = new ArrayList<Aa83b29t00>();
		List<Aa83b29t00> aa83b29t00ListNew = new ArrayList<Aa83b29t00>();
		// Meto los datos de reagrupados en el objeto a modificar:
		// Borramos la lista de ragrupados y la volvemos a insertar
		// Sacamos la lista de reagrupados a borrar:
		//aa83b29t00List = aa83b29t00Service.findAllLike(aa83b29t00, null, false);
		//for (int b = 0; b < aa83b29t00List.size(); b++) {
			aa83b29t00Service.removePorSolicitud(aa83b29t00);
			
		//}
		// Inserto Vinculos Familiares:
		Aa83b29t00 aa83b29t001 = new Aa83b29t00();
		Aa83b29t00 aa83b29t002 = new Aa83b29t00();
		Aa83b29t00 aa83b29t003 = new Aa83b29t00();
		Aa83b29t00 aa83b29t004 = new Aa83b29t00();
		Aa83b29t00 aa83b29t005 = new Aa83b29t00();

		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente1())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente1())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente1())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden1()))
		{
		aa83b29t001.setDniNie029(aa83b25t00.getdNINIEResidente1());
		aa83b29t001.setId025NumSol(aa83b25t00.getId025());
		aa83b29t001.setIdAno025(aa83b25t00.getIdAno025());
		aa83b29t001.setNombre029(aa83b25t00.getNombreResidente1());
		aa83b29t001.setParentensco029(aa83b25t00.getParentescoResidente1());
		aa83b29t001.setResidencia029(aa83b25t00.getLugResiden1());
		aa83b29t001 = aa83b29t00Service.add(aa83b29t001);
		aa83b29t00ListNew.add(aa83b29t001);
		}
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente2())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente2())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente2())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden2()))
		{
		aa83b29t002.setId025NumSol(aa83b25t00.getId025());
		aa83b29t002.setIdAno025(aa83b25t00.getIdAno025());
		aa83b29t002.setDniNie029(aa83b25t00.getdNINIEResidente2());
		aa83b29t002.setNombre029(aa83b25t00.getNombreResidente2());
		aa83b29t002.setParentensco029(aa83b25t00.getParentescoResidente2());
		aa83b29t002.setResidencia029(aa83b25t00.getLugResiden2());
		aa83b29t002 = aa83b29t00Service.add(aa83b29t002);
		aa83b29t00ListNew.add(aa83b29t002);
		}
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente3())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente3())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente3())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden3()))
		{
		aa83b29t003.setId025NumSol(aa83b25t00.getId025());
		aa83b29t003.setIdAno025(aa83b25t00.getIdAno025());
		aa83b29t003.setDniNie029(aa83b25t00.getdNINIEResidente3());
		aa83b29t003.setNombre029(aa83b25t00.getNombreResidente3());
		aa83b29t003.setParentensco029(aa83b25t00.getParentescoResidente3());
		aa83b29t003.setResidencia029(aa83b25t00.getLugResiden3());
		aa83b29t003 = aa83b29t00Service.add(aa83b29t003);
		aa83b29t00ListNew.add(aa83b29t003);
		}
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente4())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente4())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente4())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden4()))
		{
		aa83b29t004.setId025NumSol(aa83b25t00.getId025());
		aa83b29t004.setIdAno025(aa83b25t00.getIdAno025());
		aa83b29t004.setDniNie029(aa83b25t00.getdNINIEResidente4());
		aa83b29t004.setNombre029(aa83b25t00.getNombreResidente4());
		aa83b29t004.setParentensco029(aa83b25t00.getParentescoResidente4());
		aa83b29t004.setResidencia029(aa83b25t00.getLugResiden4());
		aa83b29t004 = aa83b29t00Service.add(aa83b29t004);
		aa83b29t00ListNew.add(aa83b29t004);
		}
		if(StringUtils.isNotEmpty(aa83b25t00.getdNINIEResidente5())||StringUtils.isNotEmpty(aa83b25t00.getNombreResidente5())
				||StringUtils.isNotEmpty(aa83b25t00.getParentescoResidente5())||StringUtils.isNotEmpty(aa83b25t00.getLugResiden5()))
		{
		aa83b29t005.setId025NumSol(aa83b25t00.getId025());
		aa83b29t005.setIdAno025(aa83b25t00.getIdAno025());
		aa83b29t005.setDniNie029(aa83b25t00.getdNINIEResidente5());
		aa83b29t005.setNombre029(aa83b25t00.getNombreResidente5());
		aa83b29t005.setParentensco029(aa83b25t00.getParentescoResidente5());
		aa83b29t005.setResidencia029(aa83b25t00.getLugResiden5());
		aa83b29t005 = aa83b29t00Service.add(aa83b29t005);
		aa83b29t00ListNew.add(aa83b29t005);
		}
		aa83b25t00.setAa83b29t00s(aa83b29t00ListNew);
		// primero los borramos y los volvemos a insertar
		String documento = "";
		String[] valoresDocumento;
		Aa83b33t00 documentacion = new Aa83b33t00();
		documentacion.setId025NumSol(aa83b25t00.getId025());
		documentacion.setIdAno025(aa83b25t00.getIdAno025());
		List<Aa83b33t00> aa83b33t00sBorrar = new ArrayList<Aa83b33t00>();
		aa83b33t00sBorrar = aa83b33t00Service.findAllLike(documentacion, null, false);
		List<Aa83b33t00> docsEntregados = new ArrayList<Aa83b33t00>();
		for (int b = 0; b < aa83b33t00sBorrar.size(); b++) {
			Aa83b33t00 borrar = aa83b33t00sBorrar.get(b);
			// Guardar la info de los documentos entregados para recuperarla ms abajo
			if (borrar.getTipoAportacion033() != null && borrar.getTipoAportacion033().equals("E")) {
				docsEntregados.add(borrar);
			}
			aa83b33t00Service.remove(borrar);
		}
		List<Aa83b33t00> aa83b33t00s = new ArrayList<Aa83b33t00>();
		// buscamos la tramitacion
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		aa83b11t00.setId025NumSol(aa83b25t00.getId025());
		aa83b11t00.setIdAnoSol025(aa83b25t00.getIdAno025());
		aa83b11t00 = (aa83b11t00Service.findAll(aa83b11t00, null)).get(0);
		
		if (StringUtils.isNotEmpty(aa83b25t00.getDocumentosString())) {
			String[] documentos = aa83b25t00.getDocumentosString().trim().split("#");
			for (int i = 0; i < documentos.length; i++) {
				documentacion = new Aa83b33t00();
			//	documentacion.setId011HistoTram(aa83b11t00.getId011());
				documentacion.setId025NumSol(aa83b25t00.getId025());
				documentacion.setIdAno025(aa83b25t00.getIdAno025());
				// recogemos cada documento
				documento = documentos[i];
				valoresDocumento = documento.split("-");
				String tipoAportacion = "";
				String idHistTramit="";
				documentacion.setId033(Integer.parseInt(valoresDocumento[0]));
				if (valoresDocumento.length == 5) {
					tipoAportacion = valoresDocumento[3];
					idHistTramit= valoresDocumento[4];
				} else if (valoresDocumento.length == 6) {
					// es otros
					documentacion.setDescOtros033(valoresDocumento[3]);
					tipoAportacion = valoresDocumento[4];
					idHistTramit= valoresDocumento[5];
				}
				documentacion.setId011HistoTram(Integer.valueOf(idHistTramit));
				if (tipoAportacion.equals("A")) {
					documentacion.setOid033Papel0(valoresDocumento[1]);
					documentacion.setTipoAportacion033("A");
				} else if (tipoAportacion.equals("E")) {
					documentacion.setOid033Papel0(Aa83BConstants.OID_VACIO);
					documentacion.setTipoAportacion033("E");
					// Buscar la info del documento entregado que no cambia y no viene en la peticin
					for (Aa83b33t00 docEntregado : docsEntregados) {
						if (docEntregado.getId033() == Integer.parseInt(valoresDocumento[0])) {
							documentacion.setOrgDocEntregado033(docEntregado.getOrgDocEntregado033());
							documentacion.setNomDocEntregado033(docEntregado.getNomDocEntregado033());
							documentacion.setFecDocEntregado033(docEntregado.getFecDocEntregado033());
						}
					}
					logger.info("MODIF DOCUMENTO SIN OID");
				}
				if (Aa83BConstants.VALOR_VACIO.equals(valoresDocumento[2])) {
					documentacion.setId030TipDocSol(Aa83BConstants.TIPO_DOC_VACIO);
				} else {
					documentacion.setId030TipDocSol(new Integer(valoresDocumento[2]));
				}
				aa83b33t00Service.add(documentacion);
				aa83b33t00s.add(documentacion);
			}
		}
		
		if (StringUtils.isNotEmpty(aa83b25t00.getDocumentosNoPresentados())) {
			String[] documentosNoPresentados = aa83b25t00
					.getDocumentosNoPresentados().split("#");
			for (int i = 0; i < documentosNoPresentados.length; i++) {
				documentacion = new Aa83b33t00();
			//	documentacion.setId011HistoTram(aa83b11t00.getId011());
				documentacion.setId025NumSol(aa83b25t00.getId025());
				documentacion.setIdAno025(aa83b25t00.getIdAno025());
				// recogemos cada documento
				documentacion.setOid033Papel0(Aa83BConstants.OID_VACIO);
				documentacion.setId030TipDocSol(new Integer(
						documentosNoPresentados[i]));
				aa83b33t00Service.add(documentacion);
				aa83b33t00s.add(documentacion);
			}
		}

		aa83b25t00.setAa83b33t00s(aa83b33t00s);
		aa83b25t00 = aa83b25t00Service.update(aa83b25t00);
		// ** START ACCESO
		// Registramos el actor:
		// Guardamos el acceso:
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(
				aa83b25t00, Aa83BConstants.ACCESOS_MODIF, "N"));
		
		
		
		/*Aa83b08t00 aa83b08t00 = new Aa83b08t00();
		// Fecha
		java.util.Date utilDate = new java.util.Date();
		Date date = new Date(utilDate.getTime());
		String fecha = "";
		if (Aa83BConstants.ES.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			fecha = date.toString().replaceAll("-", "/");
			fecha = fecha.substring(8, 10) + "/" + fecha.substring(5, 7) + "/"
					+ fecha.substring(0, 4);
		} else {
			fecha = date.toString().replaceAll("-", "/");
		}
		aa83b08t00.setfActu008(fecha);
		// Usuario
		aa83b08t00.setUsuModif008("PDTE COOKIE");
		// TipoModif
		aa83b08t00.setTipoModif038(Aa83BConstants.ACCESOS_MODIF);
		// Tipo de Solicitud
		aa83b08t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
		// Numero de Solicitud
		aa83b08t00.setId025NumSol(aa83b25t00.getId025());
		aa83b08t00.setIdAno025(aa83b25t00.getIdAno025());

		// Grabamos el acceso
		aa83b08t00 = aa83b08t00Service.add(aa83b08t00);*/
		// ** FIN ACCESO*/
		return aa83b25t00;
	
	}

	

	/**
	 * Deletes a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83b25t00 aa83b25t00) {
		this.aa83b25t00Dao.remove(aa83b25t00);
	}

	

	

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa83b25t00 table.
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa83b25t00 filterAa83b25t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa83b25t00Dao.removeMultiple(filterAa83b25t00, jqGridRequestDto,
				startsWith);
	}

	}
