package com.ejie.aa83b.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;


import com.ejie.aa83b.dao.Aa83b21t00Dao;
import com.ejie.aa83b.exception.Aa83bErrorGenericoException;
import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b18t00;
import com.ejie.aa83b.model.Aa83b20t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b33t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83bBusquedaComunicaciones;
import com.ejie.aa83b.model.Aa83bDocumentoDokusi;
import com.ejie.aa83b.model.Aa83bTipoDocumento;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bMessageParser;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;
import com.ejie.aa83b.util.tramita.Aa83bUtilNotificacion;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.aa19b.DocumentoWebServiceImpl;
import com.ejie.aa83b.webservice.client.dokusi.T65BFSDWSClasePort;
import com.ejie.aa83b.webservice.client.r02.Q99DSRTFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.shf.Q99VDigitalSignatureFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.tramitacion.Q99MServiceIfzFacadeWSSoap;
import com.ejie.aa83b.webservice.client.x43.nshf.EjgvDocumentType;
import com.ejie.aa83b.webservice.client.x43.nshf.X43FNSHF;
import com.ejie.schemas.t65b.T65BDocumentIDType;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
/**
 * Aa83b21t00ServiceImpl generated by UDA, 28-dic-2015 17:45:22.
 * 
 * @author UDA
 */

@Service(value = "Aa83bADEService")
public class Aa83bADEServiceImpl implements Aa83bADEService {

	@Autowired
	private Aa83b21t00Dao aa83b21t00Dao;
	@Autowired()
	private Aa83b18t00Service aa83b18t00Service;
	@Autowired()
	private Aa83b31t00Service aa83b31t00Service;
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;
	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	@Autowired()
	private Aa83b06t00Service aa83b06t00Service;
	@Autowired()
	private Aa83b04t00Service aa83b04t00Service;
	@Autowired()
	private Aa83b20t00Service aa83b20t00Service;
	@Autowired()
	private Aa83bDokusiService aa83bDokusiService;
	@Autowired()
	private Q99MServiceIfzFacadeWSSoap q99mServiceIfzFacadeWS;
	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;
	@Autowired()
	private Q99DSRTFacadeWSSoap q99DSRTFacadeWSSoap;
	@Autowired()
	private Q99VDigitalSignatureFacadeWSSoap q99VDigitalSignatureFacadeWSSoap;
	@Autowired()
	private DocumentoWebServiceImpl documentoWebServiceImpl;
	@Autowired
	private T65BFSDWSClasePort t65bService;
	@Autowired()
	private X43FNSHF x43fnshf;
	@Autowired
	private Properties appConfiguration;
	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bADEServiceImpl.class);
	/**
	 * Inserts a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b21t00 add(Aa83b21t00 aa83b21t00, String daSeries) {
		Aa83b21t00 aa83b21t00New = new Aa83b21t00();
		
		aa83b21t00.setPasarvivienda021("N");
		aa83b21t00.setSolicerrada021("N");
		aa83b21t00New = aa83b21t00Service.add(aa83b21t00);
		// Inserto los reagrupados:
		int idSolicitud = aa83b21t00New.getId021();
		Long anyoSolicitud = aa83b21t00New.getIdAno021();

		Aa83b18t00 aa83b18t00 = new Aa83b18t00();
		aa83b18t00.setId021NumSol(aa83b21t00New.getId021());
		aa83b18t00.setIdAno021(aa83b21t00New.getIdAno021());

		if ((aa83b21t00.getNumPersReagrupar021() != null)) {
			for (int k = 1; k <= aa83b21t00.getNumPersReagrupar021(); k++) {

				if (k == 1) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0180());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0180());
					aa83b18t00.setApel018(aa83b21t00.getApel0180());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0180());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam0());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 2) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0181());
					aa83b18t00.setApel018(aa83b21t00.getApel0181());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0181());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam1());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 3) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0182());
					aa83b18t00.setApel018(aa83b21t00.getApel0182());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0182());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam2());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 4) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0183());
					aa83b18t00.setApel018(aa83b21t00.getApel0183());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0183());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam3());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 5) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0184());
					aa83b18t00.setApel018(aa83b21t00.getApel0184());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0184());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam4());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 6) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0185());
					aa83b18t00.setApel018(aa83b21t00.getApel0185());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0185());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam5());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 7) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0186());
					aa83b18t00.setApel018(aa83b21t00.getApel0186());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0186());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam6());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 8) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0187());
					aa83b18t00.setApel018(aa83b21t00.getApel0187());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0187());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam7());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 9) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0188());
					aa83b18t00.setApel018(aa83b21t00.getApel0188());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0188());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam8());
						aa83b18t00Service.add(aa83b18t00);
					
				}
				if (k == 10) {
					aa83b18t00.setNombre018(aa83b21t00.getNombre0189());
					aa83b18t00.setApel018(aa83b21t00.getApel0189());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0189());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam9());
						aa83b18t00Service.add(aa83b18t00);
					
				}
			}
		}

		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		// ** START ACCESO
		aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(
				aa83b21t00New, Aa83BConstants.ACCESOS_ALTA, "N"));
		// ** START HISTO
		Aa83b09t00 aa83b09t00 = aa83b09t00Service.add(aa83bSolicitudesUtil
				.guardarHistoADE(aa83b21t00New, Aa83BConstants.COD_FASE_1,
						Aa83BConstants.COD_TRAM_1, "N"));

		// insertar documentos
		String documento = "";
		String[] valoresDocumento;
		Aa83b31t00 documentacion = new Aa83b31t00();
		List<Aa83b31t00> aa83b31t00s = new ArrayList<Aa83b31t00>();
		if (StringUtils.isNotEmpty(aa83b21t00.getDocumentosString())) {
			String[] documentos = aa83b21t00.getDocumentosString().split("#");
			for (int i = 0; i < documentos.length; i++) {
				documentacion = new Aa83b31t00();
				documentacion.setId009HistoTram(aa83b09t00.getId009());
				documentacion.setId021NumSol(idSolicitud);
				documentacion.setIdAno021(anyoSolicitud);
				// recogemos cada documento
				documento = documentos[i];
				valoresDocumento = documento.split("-");
				documentacion.setOid031Papel0(valoresDocumento[1]);
				if (Aa83BConstants.VALOR_VACIO.equals(valoresDocumento[2])) {
					documentacion
							.setId030TipDocSol(Aa83BConstants.TIPO_DOC_VACIO);
				} else {
					documentacion.setId030TipDocSol(new Integer(
							valoresDocumento[2]));
				}
				if (valoresDocumento.length == 4) {
					// es otros
					documentacion.setDescOtros031(valoresDocumento[3]);
				}
				aa83b31t00Service.add(documentacion);
				aa83b31t00s.add(documentacion);
								
				//CAMBIAMOS EL CONTEXTO AL PROCESARLO
				Aa83bDocumentoDokusi documentoDokusi = new Aa83bDocumentoDokusi();
				documentoDokusi.setOid(documentacion.getOid031Papel0());
				// Uso la descripcion EU para pasar el numero de registro
				documentoDokusi.setDescripcionEu(aa83b21t00.getFecha021()
						.toString());
				String formato = Aa83BConstants.ES_PATTERN; 
				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
						.getLanguage())) {
					formato = Aa83BConstants.EU_PATTERN;
				}
				java.util.Date utilDate2 = new java.util.Date();
				Date date2 = new Date(utilDate2.getTime());
				String fechaD = (String) new SimpleDateFormat(formato).format(date2);
				documentoDokusi.setDescripcionEu(fechaD);
				// Uso la descripcion ES para pasar el numero de registro
				documentoDokusi.setDescripcionEs(aa83b21t00.getNumReg021());
				// Cambiamos el contexto en DOKUSI del documento
				Boolean docSubido = this.aa83bDokusiService
						.tramitateDocument(documentoDokusi, daSeries);
				logger.info("Contexto de: " + documentacion.getOid031Papel0() + " cambiado "
						+ docSubido);
				
			}
		}
		if (StringUtils.isNotEmpty(aa83b21t00.getDocumentosNoPresentados())) {
			String[] documentosNoPresentados = aa83b21t00
					.getDocumentosNoPresentados().split("#");
			for (int i = 0; i < documentosNoPresentados.length; i++) {
				documentacion = new Aa83b31t00();
				documentacion.setId009HistoTram(aa83b09t00.getId009());
				documentacion.setId021NumSol(idSolicitud);
				documentacion.setIdAno021(anyoSolicitud);
				// recogemos cada documento
				documentacion.setOid031Papel0(Aa83BConstants.OID_VACIO);
				documentacion.setId030TipDocSol(new Integer(
						documentosNoPresentados[i]));
				logger.info("setId030TipDocSol 2222----> " + documentacion.getId030TipDocSol());
				aa83b31t00Service.add(documentacion);
				aa83b31t00s.add(documentacion);
				//CAMBIAMOS EL CONTEXTO AL PROCESARLO
				Aa83bDocumentoDokusi documentoDokusi = new Aa83bDocumentoDokusi();
				documentoDokusi.setOid(documentacion.getOid031Papel0());
				// Uso la descripcion EU para pasar el numero de registro
				documentoDokusi.setDescripcionEu(aa83b21t00.getFecha021()
						.toString());
				String formato = Aa83BConstants.ES_PATTERN; 
				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
						.getLanguage())) {
					formato = Aa83BConstants.EU_PATTERN;
				}
				java.util.Date utilDate2 = new java.util.Date();
				Date date2 = new Date(utilDate2.getTime());
				String fechaD = (String) new SimpleDateFormat(formato).format(date2);
				documentoDokusi.setDescripcionEu(fechaD);
				// Uso la descripcion ES para pasar el numero de registro
				documentoDokusi.setDescripcionEs(aa83b21t00.getNumReg021());
				// Cambiamos el contexto en DOKUSI del documento
				Boolean docSubido = this.aa83bDokusiService
						.tramitateDocument(documentoDokusi, daSeries);
				logger.info("Contexto de: " + documentacion.getOid031Papel0() + " cambiado "
						+ docSubido);
				
				
			}
		}
		// pasamos la solicitud a aceptada
		Aa83b34t00 aa83b34t00 = new Aa83b34t00();
		aa83b34t00.setCodsolic034(aa83b21t00.getCodSolicitud034());
		aa83b34t00Service.aceptarSolicitud(aa83b34t00);
		// ** FIN HISTO*/
		aa83b21t00New.setAccion(Aa83BConstants.ACC_SOL_ALTA);
		//model.addAttribute(aa83b21t00New);
		return aa83b21t00New;
	}

	/**
	 * Updates a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b21t00 update(Aa83b21t00 aa83b21t00,MultipartFile infResolucion, String daSeries) {
		Aa83b18t00 aa83b18t00 = new Aa83b18t00();
		aa83b18t00.setId021NumSol(aa83b21t00.getId021());
		aa83b18t00.setIdAno021(aa83b21t00.getIdAno021());
		List<Aa83b18t00> aa83b18t00List = new ArrayList<Aa83b18t00>();
		// Meto los datos de reagrupados en el objeto a modificar:
		// Borramos la lista de ragrupados y la volvemos a insertar
		// Sacamos la lista de reagrupados a borrar:
		aa83b18t00List = aa83b18t00Service.findAllLike(aa83b18t00, null, false);
		//System.out.println("Modificamos findAllLike: " + aa83b18t00List.size());
		for (int b = 0; b < aa83b18t00List.size(); b++) {

			aa83b18t00Service.remove(aa83b18t00List.get(b));
		}

		// La volvemos a insertar
		if ((aa83b21t00.getNumPersReagrupar021() != null)) {
			for (int k = 1; k <= aa83b21t00.getNumPersReagrupar021(); k++) {

				if (k == 1) {
					aa83b18t00.setId018(aa83b21t00.getId0180());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0180());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0180());
					aa83b18t00.setApel018(aa83b21t00.getApel0180());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0180());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam0());

				}
				if (k == 2) {
					aa83b18t00.setId018(aa83b21t00.getId0181());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0181());
					aa83b18t00.setApel018(aa83b21t00.getApel0181());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0181());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam1());

				}
				if (k == 3) {
					aa83b18t00.setId018(aa83b21t00.getId0182());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0182());
					aa83b18t00.setApel018(aa83b21t00.getApel0182());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0182());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam2());

				}
				if (k == 4) {
					aa83b18t00.setId018(aa83b21t00.getId0183());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0183());
					aa83b18t00.setApel018(aa83b21t00.getApel0183());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0183());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam3());

				}
				if (k == 5) {
					aa83b18t00.setId018(aa83b21t00.getId0184());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0184());
					aa83b18t00.setApel018(aa83b21t00.getApel0184());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0184());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam4());

				}
				if (k == 6) {
					aa83b18t00.setId018(aa83b21t00.getId0185());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0185());
					aa83b18t00.setApel018(aa83b21t00.getApel0185());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0185());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam5());

				}
				if (k == 7) {
					aa83b18t00.setId018(aa83b21t00.getId0186());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0186());
					aa83b18t00.setApel018(aa83b21t00.getApel0186());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0186());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam6());

				}
				if (k == 8) {
					aa83b18t00.setId018(aa83b21t00.getId0187());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0187());
					aa83b18t00.setApel018(aa83b21t00.getApel0187());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0187());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam7());
				}
				if (k == 9) {
					aa83b18t00.setId018(aa83b21t00.getId0188());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0188());
					aa83b18t00.setApel018(aa83b21t00.getApel0188());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0188());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam8());

				}
				if (k == 10) {
					aa83b18t00.setId018(aa83b21t00.getId0189());
					aa83b18t00.setNombre018(aa83b21t00.getNombre0189());
					aa83b18t00.setApel018(aa83b21t00.getApel0189());
					aa83b18t00.setEdad018(aa83b21t00.getEdad0189());
					aa83b18t00.setId013VinculosFam(aa83b21t00
							.getId013VinculosFam9());
				}
				aa83b18t00List.add(aa83b18t00);
				try {
					aa83b18t00 = aa83b18t00Service.add(aa83b18t00);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			aa83b21t00.setAa83b18t00s(aa83b18t00List);
		}
		
		
		
		// insertar documentos
		// primero los borramos y los volvemos a insertar

		String documento = "";
		String[] valoresDocumento;
		Aa83b31t00 documentacion = new Aa83b31t00();
		documentacion.setId021NumSol(aa83b21t00.getId021());
		documentacion.setIdAno021(aa83b21t00.getIdAno021());
		List<Aa83b31t00> aa83b31t00sBorrar = new ArrayList<Aa83b31t00>();
		aa83b31t00sBorrar = aa83b31t00Service.findAllLike(documentacion, null, false);
		List<Aa83b31t00> docsEntregados = new ArrayList<Aa83b31t00>();
		for (int b = 0; b < aa83b31t00sBorrar.size(); b++) {
			Aa83b31t00 borrar = aa83b31t00sBorrar.get(b);
			// Guardar la info de los documentos entregados para recuperarla ms abajo
			if (borrar.getTipoAportacion031() != null && borrar.getTipoAportacion031().equals("E")) {
				docsEntregados.add(borrar);
			}
			aa83b31t00Service.remove(borrar);
		}

		List<Aa83b31t00> aa83b31t00s = new ArrayList<Aa83b31t00>();
		// buscamos la tramitacion
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		aa83b09t00.setId021NumSol(aa83b21t00.getId021());
		aa83b09t00.setIdAno021(aa83b21t00.getIdAno021());
		aa83b09t00 = (aa83b09t00Service.findAll(aa83b09t00, null)).get(0);
		
		if (StringUtils.isNotEmpty(aa83b21t00.getDocumentosString())) {
			String[] documentos = aa83b21t00.getDocumentosString().trim().split("#");
			for (int i = 0; i < documentos.length; i++) {
				documentacion = new Aa83b31t00();
				//documentacion.setId009HistoTram(aa83b09t00.getId009());
				documentacion.setId021NumSol(aa83b21t00.getId021());
				documentacion.setIdAno021(aa83b21t00.getIdAno021());
				// recogemos cada documento
				documento = documentos[i];
				valoresDocumento = documento.split("-");
				String tipoAportacion = "";
				String idHistTramit="";
				documentacion.setId031(Integer.parseInt(valoresDocumento[0]));
				if (valoresDocumento.length == 5) {
					tipoAportacion = valoresDocumento[3];
					idHistTramit= valoresDocumento[4];
				} else if (valoresDocumento.length == 6) {
					// es otros
					documentacion.setDescOtros031(valoresDocumento[3]);
					tipoAportacion = valoresDocumento[4];
					idHistTramit= valoresDocumento[5];
				}
				documentacion.setId009HistoTram(Integer.valueOf(idHistTramit));
				if (tipoAportacion.equals("A")) {
					documentacion.setOid031Papel0(valoresDocumento[1]);
					documentacion.setTipoAportacion031("A");
				} else if (tipoAportacion.equals("E")) {
					documentacion.setOid031Papel0(Aa83BConstants.OID_VACIO);
					documentacion.setTipoAportacion031("E");
					// Buscar la info del documento entregado que no cambia y no viene en la peticin
					for (Aa83b31t00 docEntregado : docsEntregados) {
						if (docEntregado.getId031() == Integer.parseInt(valoresDocumento[0])) {
							documentacion.setOrgDocEntregado031(docEntregado.getOrgDocEntregado031());
							documentacion.setNomDocEntregado031(docEntregado.getNomDocEntregado031());
							documentacion.setFecDocEntregado031(docEntregado.getFecDocEntregado031());
						}
					}
				}
				if (Aa83BConstants.VALOR_VACIO.equals(valoresDocumento[2])) {
					documentacion.setId030TipDocSol(Aa83BConstants.TIPO_DOC_VACIO);
				} else {
					documentacion.setId030TipDocSol(new Integer(valoresDocumento[2]));
				}
				aa83b31t00Service.add(documentacion);
				aa83b31t00s.add(documentacion);
			}
		}
		
		if (StringUtils.isNotEmpty(aa83b21t00.getDocumentosNoPresentados())) {
			String[] documentosNoPresentados = aa83b21t00.getDocumentosNoPresentados().split("#");
			for (int i = 0; i < documentosNoPresentados.length; i++) {
				documentacion = new Aa83b31t00();
				//documentacion.setId009HistoTram(aa83b09t00.getId009());
				documentacion.setId021NumSol(aa83b21t00.getId021());
				documentacion.setIdAno021(aa83b21t00.getIdAno021());
				// recogemos cada documento
				documentacion.setOid031Papel0(Aa83BConstants.OID_VACIO);
				documentacion.setId030TipDocSol(new Integer(
						documentosNoPresentados[i]));
				aa83b31t00Service.add(documentacion);
				aa83b31t00s.add(documentacion);
			}
		}
		// ** START ACCESO
		// Registramos el acceso:

		// ** START ACCESO
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(aa83b21t00,
				Aa83BConstants.ACCESOS_MODIF, "N"));

		;

		aa83b21t00.setAa83b31t00s(aa83b31t00s);
		aa83b21t00 = aa83b21t00Service.update(aa83b21t00);
		
		// Tratamos el informe de resolcion
		String oidInfResol = "";
		if (infResolucion != null) {
			byte[] bytes = new byte[Integer.parseInt(String
					.valueOf(infResolucion.getSize()))];
			try {
				bytes = infResolucion.getBytes();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			String resultado = "";
			Aa83b20t00 aa83b20t00 = new Aa83b20t00();
			Aa83b04t00 aa83b04t00 = new Aa83b04t00();

			String nombreFichero = infResolucion.getOriginalFilename().split("\\.")[0];
			String extension = infResolucion.getOriginalFilename().split("\\.")[1];
			String cotentType =infResolucion.getContentType(); 
			
			
			// Lo guardo en DOKUSI
			try {
				// Primero lo subo a PIF:
				//logger.info("Guardamos informe en PIF.......++++++");
				Y31JanoService service = Y31JanoServiceAbstractFactory
						.getInstance();

				DocumentBuilderFactory factory = DocumentBuilderFactory
						.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();

				// DESARROLLO
				String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
//				Aa83bAltaSolicitudADEController.logger
//						.info("[Aa83bAltaSolicitudADEController] : sesionToken="
//								+ sesionToken);

				// LOCAL
				// Document xmlDocument = null;
				// xmlDocument = (Document) builder.parse("Tokenaa83b.xml");

				// DESARROLLO
				Document xmlDocument = builder.parse(new ByteArrayInputStream(
						sesionToken.getBytes("UTF-8")));// NOPMD

				String to = "/t65e/aa83b/" + nombreFichero + "."+extension;

				//System.out.println("to:::" + to);
				Long expirationSecs = new Long(60 * 60 * 24 * 15);
				InputStream fichero = new ByteArrayInputStream(bytes);
				Y31AttachmentBean resul = service.put(xmlDocument, fichero, to,
						expirationSecs);
				String ruta = resul.getFilePath();

				// llamada a WS nueva
				Aa83bDocumentoDokusi documentoSubir = new Aa83bDocumentoDokusi();

				documentoSubir.setTamanyo(bytes.length);

				//documentoSubir.setContentType("PDF");
				documentoSubir.setRutaPif(ruta);

				Aa83bTipoDocumento tipoDocumento = new Aa83bTipoDocumento();

				String tipoDocumental = "ejgv_d_archivo";
				tipoDocumento.setTipoDocumental(tipoDocumental);
				documentoSubir.setTipoDocumento(tipoDocumento);
				documentoSubir.setContentType(cotentType);
				

				Aa83bDocumentoDokusi docSubido = this.aa83bDokusiService
						.storeDocument(documentoSubir,daSeries);
				// this.aa83bDokusiService
				// .retrieveDocument(documentoDescargar);

				oidInfResol = docSubido.getOid();

			} catch (Exception ex) {
				//Aa83bAltaSolicitudADEController.logger.error ("[Aa83b12t00Controller Exception]"+ex.getMessage());
			}

			// Lo guardo en Doc Generada T20

			List<Aa83b04t00> aa83b04t00List = new ArrayList<Aa83b04t00>();
			aa83b04t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));

			aa83b04t00.setIdfase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b04t00
					.setId002Tram(Integer.parseInt(Aa83BConstants.COD_TRAM_1));

			//System.out.println("aa83b04t00 BUSQUEDA::" + aa83b04t00.toString());
			aa83b04t00List = aa83b04t00Service.findAllLike(aa83b04t00, null,
					false);
			//System.out.println("aa83b04t00::" + aa83b04t00List.size());

			aa83b20t00.setId021SolAde(aa83b21t00.getId021());
			aa83b20t00.setIdAno021(aa83b21t00.getIdAno021());

			aa83b20t00.setId004TipoDocG(aa83b04t00List.get(0).getId004());
			aa83b20t00.setOid020(oidInfResol);
			aa83b20t00.setId009HistoTram(aa83b09t00.getId009());

			// Modificamos el estado de Tramitacion

			// ** START HISTO
			aa83b09t00 = aa83b09t00Service.add(aa83bSolicitudesUtil
					.guardarHistoADE(aa83b21t00, Aa83BConstants.COD_FASE_2,
							Aa83BConstants.COD_TRAM_1, "N"));

			// Guardo el DOC Generado ahora que tengo el correlativo de
			// Tramitacion:
			aa83b20t00.setId009HistoTram(aa83b09t00.getId009());

//			System.out.println("Guardo el DOC en la 20:: "
//					+ aa83b20t00.toString());

			aa83b20t00 = aa83b20t00Service.add(aa83b20t00);
			
		}
		
		// return new ModelAndView("verSolADE", "Aa83b21t00", aa83b21t00);
		aa83b21t00.setAccion(Aa83BConstants.ACC_SOL_EDIT);
		// return new ModelAndView("altaSolADE", "Aa83b21t00", aa83b21t00nueva);
		
		return aa83b21t00;
	}

	

	/**
	 * Deletes a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83b21t00 aa83b21t00) {
		this.aa83b21t00Dao.remove(aa83b21t00);
	}

	

	

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa83b21t00 filterAa83b21t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa83b21t00Dao.removeMultiple(filterAa83b21t00, jqGridRequestDto,
				startsWith);
	}

	}
