package com.ejie.aa83b.service;

import com.ejie.aa83b.dao.Aa83b25t00Dao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.util.Aa83bUtilidades;

/**
 * Aa83b25t00ServiceImpl generated by UDA, 28-dic-2015 17:45:22.
 * 
 * @author UDA
 */

@Service(value = "aa83b25t00Service")
public class Aa83b25t00ServiceImpl implements Aa83b25t00Service {

	@Autowired
	private Aa83b25t00Dao aa83b25t00Dao;

	@Autowired
	private Aa83bNoraService aa83bNoraService;

	/**
	 * Inserts a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b25t00 add(Aa83b25t00 aa83b25t00) {
		return this.aa83b25t00Dao.add(aa83b25t00);
	}

	/**
	 * Updates a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b25t00 update(Aa83b25t00 aa83b25t00) {
		return this.aa83b25t00Dao.update(aa83b25t00);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void updateResolFavorable(Aa83b25t00 aa83b25t00) {
		this.aa83b25t00Dao.updateResolFavorable(aa83b25t00);
	}

	/**
	 * Finds a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	public Aa83b25t00 find(Aa83b25t00 aa83b25t00) {

		aa83b25t00 = this.aa83b25t00Dao.find(aa83b25t00);
		return (aa83b25t00);
	}
	/**
	 * Finds a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	public Aa83b25t00 findResolucion(Aa83b25t00 aa83b25t00) {

		aa83b25t00 = this.aa83b25t00Dao.find(aa83b25t00);
		aa83b25t00 = findIdsNora(aa83b25t00);

		return (aa83b25t00);
	}
	public Aa83b25t00 findIdsNora(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub
		A83bMunicipio a83bMunicipio = new A83bMunicipio();
		Aa83bCalle aa83bCalle = new Aa83bCalle();
		
		if (null!=aa83b25t00.getMunicipComunic025())
			if (!aa83b25t00.getMunicipComunic025().equals("")) {
				if (null!=aa83b25t00.getProvinciaComunic025()) {
					if (!aa83b25t00.getProvinciaComunic025().equals("")) {
						a83bMunicipio.setId(aa83b25t00.getMunicipComunic025());
						a83bMunicipio.setProvincia_id(aa83b25t00
								.getProvinciaComunic025());
						a83bMunicipio = (A83bMunicipio) aa83bNoraService
								.findMunicipiosId(a83bMunicipio);
						aa83b25t00.setMunicipComunic025DescEs025(a83bMunicipio
								.getDs_o());
						aa83b25t00.setMunicipComunic025DescEu025(a83bMunicipio
								.getDs_o());
					}
				}
			}
		if (null!=aa83b25t00.getMunicipioEmpadron025())
			if (!aa83b25t00.getMunicipioEmpadron025().equals("")) {
				if (null!=aa83b25t00.getProvinciaEmpadron025()) {
					if (!aa83b25t00.getProvinciaEmpadron025().equals("")) {
						a83bMunicipio.setDs_o("");
						a83bMunicipio.setId(aa83b25t00
								.getMunicipioEmpadron025());
						a83bMunicipio.setProvincia_id(aa83b25t00
								.getProvinciaEmpadron025());
						a83bMunicipio = (A83bMunicipio) aa83bNoraService
								.findMunicipiosId(a83bMunicipio);
						aa83b25t00
								.setMunicipioEmpadron025DescEs025(a83bMunicipio
										.getDs_o());
						aa83b25t00
								.setMunicipioEmpadron025DescEu025(a83bMunicipio
										.getDs_o());

					}
				}
			}

		if (null!=aa83b25t00.getProvEmp025())
			if (!aa83b25t00.getProvEmp025().equals("")) {
				a83bMunicipio.setDs_o("");
				A83bProvincia a83bProvincia = new A83bProvincia();
				a83bProvincia.setId(aa83b25t00.getProvEmp025());
				a83bProvincia = aa83bNoraService
						.findProvinciasId(a83bProvincia);
				aa83b25t00.setProvEmp025DescEs025(a83bProvincia.getDs_o());
				aa83b25t00.setProvEmp025DescEu025(a83bProvincia.getDs_o());
			}
		if (null!=aa83b25t00.getProvinciaComunic025())
			if (!aa83b25t00.getProvinciaComunic025().equals("")) {
				A83bProvincia a83bProvincia = new A83bProvincia();
				a83bProvincia.setId(aa83b25t00.getProvinciaComunic025());
				a83bProvincia = aa83bNoraService
						.findProvinciasId(a83bProvincia);
				aa83b25t00.setProvinciaComunic025DescEs025(a83bProvincia
						.getDs_o());
				aa83b25t00.setProvinciaComunic025DescEu025(a83bProvincia
						.getDs_o());
			}
		if (null!=aa83b25t00.getProvinciaEmpadron025())
			if (!aa83b25t00.getProvinciaEmpadron025().equals("")) {
				A83bProvincia a83bProvincia = new A83bProvincia();
				a83bProvincia.setId(aa83b25t00.getProvinciaEmpadron025());
				a83bProvincia = aa83bNoraService
						.findProvinciasId(a83bProvincia);
				aa83b25t00.setProvinciaEmpadron025DescEs025(a83bProvincia
						.getDs_o());
				aa83b25t00.setProvinciaEmpadron025DescEu025(a83bProvincia
						.getDs_o());
			}
		
		if (null!=aa83b25t00.getCalleComunic025())
			if (!aa83b25t00.getCalleComunic025().equals("")
					&& Aa83bUtilidades.isNumeric(aa83b25t00.getCalleComunic025())) {
				aa83bCalle.setDs_o("");
				aa83bCalle.setCalle_cod(aa83b25t00.getCalleComunic025());
				// System.out.println("busco 2:: " + a83bMunicipio.toString());
				aa83bCalle = (Aa83bCalle) aa83bNoraService.findCalle(aa83bCalle, null);
				aa83b25t00.setCalleComunicDescEs025(aa83bCalle.getDs_o());
				aa83b25t00.setCalleComunicDescEu025(aa83bCalle.getDs_o());
			}
		// Descripciones para los informes
		return aa83b25t00;
	}

	/**
	 * Deletes a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83b25t00 aa83b25t00) {
		this.aa83b25t00Dao.remove(aa83b25t00);
	}

	/**
	 * Finds a list of rows in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b25t00>
	 */
	public List<Aa83b25t00> findAll(Aa83b25t00 aa83b25t00,
			JQGridRequestDto jqGridRequestDto) {

		List<Aa83b25t00> listaRetorno = this.aa83b25t00Dao.findAll(aa83b25t00,
				jqGridRequestDto);

//		for (int i = 0; i < listaRetorno.size(); i++) {
//			listaRetorno.set(i, findIdsNora(listaRetorno.get(i)));
//		}

		return listaRetorno;
	}

	/**
	 * Finds rows in the Aa83b25t00 table using like.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b25t00>
	 */
	public List<Aa83b25t00> findAllLike(Aa83b25t00 aa83b25t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		List<Aa83b25t00> listaRetorno = this.aa83b25t00Dao.findAllLike(
				aa83b25t00, jqGridRequestDto, startsWith);

//		for (int i = 0; i < listaRetorno.size(); i++) {
//			listaRetorno.set(i, findIdsNora(listaRetorno.get(i)));
//		}

		return listaRetorno;
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa83b25t00 table.
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa83b25t00 filterAa83b25t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa83b25t00Dao.removeMultiple(filterAa83b25t00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa83b25t00 table.
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa83b25t00>
	 */
	public JQGridResponseDto<Aa83b25t00> filter(Aa83b25t00 filterAa83b25t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa83b25t00> listaAa83b25t00 = this.aa83b25t00Dao.findAllLike(filterAa83b25t00, jqGridRequestDto, false);
		Long recordNum = this.aa83b25t00Dao.findAllLikeCount(filterAa83b25t00 != null ? filterAa83b25t00 : new Aa83b25t00(),false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa83b25t00>> reorderSelection = this.aa83b25t00Dao.reorderSelection(filterAa83b25t00, jqGridRequestDto,startsWith);
			return new JQGridResponseDto<Aa83b25t00>(jqGridRequestDto,recordNum, listaAa83b25t00, reorderSelection);
		}
		return new JQGridResponseDto<Aa83b25t00>(jqGridRequestDto, recordNum,listaAa83b25t00);
	}

	/**
	 * Searches rows in the Aa83b25t00 table.
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param searchAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b25t00>>
	 */
	public List<TableRowDto<Aa83b25t00>> search(Aa83b25t00 filterAa83b25t00,
			Aa83b25t00 searchAa83b25t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa83b25t00Dao.search(filterAa83b25t00, searchAa83b25t00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa83b25t00 table.
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa83b25t00 filterAa83b25t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa83b25t00Dao.reorderSelection(filterAa83b25t00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa83b25t00 table.
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b25t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b25t00>> jerarquia(
			Aa83b25t00 filterAa83b25t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa83b25t00>> listaAa83b25t00 = this.aa83b25t00Dao
				.findAllLikeJerarquia(filterAa83b25t00, jqGridRequestDto);
		Long recordNum = this.aa83b25t00Dao.findAllLikeCountJerarquia(
				filterAa83b25t00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa83b25t00>>(
				jqGridRequestDto, recordNum, listaAa83b25t00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa83b25t00 table.
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b25t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b25t00>> jerarquiaChildren(
			Aa83b25t00 filterAa83b25t00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa83b25t00>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa83b25t00>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa83b25t00Dao.findAllChild(filterAa83b25t00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public Aa83b25t00 validarSolicitud(Aa83b25t00 aa83b25t00) {
		return this.aa83b25t00Dao.validarSolicitud(aa83b25t00);
	}

	@Override
	public Aa83b25t00 marcarNotifLeida(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub
		return this.aa83b25t00Dao.marcarNotifLeida(aa83b25t00);
	}

	@Override
	public Aa83b25t00 cerrarExp(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub
		return this.aa83b25t00Dao.cerrarExp(aa83b25t00);
	}

	@Override
	public Aa83b25t00 cerrarExpReq(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub
		return this.aa83b25t00Dao.cerrarExpReq(aa83b25t00);
	}

	@Override
	public Aa83b25t00 marcarReqSubsanaLeido025(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub
		return this.aa83b25t00Dao.marcarReqSubsanaLeido025(aa83b25t00);
	}

}
