package com.ejie.aa83b.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.aa83b.dao.Aa83b23t00Dao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.util.Aa83bUtilidades;

/**
 * Aa83b23t00ServiceImpl generated by UDA, 28-dic-2015 17:33:46.
 * 
 * @author UDA
 */

@Service(value = "aa83b23t00Service")
public class Aa83b23t00ServiceImpl implements Aa83b23t00Service {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83b23t00ServiceImpl.class);

	@Autowired
	private Aa83b23t00Dao aa83b23t00Dao;

	@Autowired
	private Aa83bNoraService aa83bNoraService;

	/**
	 * Inserts a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Aa83b23t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b23t00 add(Aa83b23t00 aa83b23t00) {
		return this.aa83b23t00Dao.add(aa83b23t00);
	}

	/**
	 * Updates a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Aa83b23t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b23t00 update(Aa83b23t00 aa83b23t00) {
		return this.aa83b23t00Dao.update(aa83b23t00);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void updateResolFavorable(Aa83b23t00 aa83b23t00) {
		this.aa83b23t00Dao.updateResolFavorable(aa83b23t00);
	}

	/**
	 * Finds a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Aa83b23t00
	 */
	public Aa83b23t00 find(Aa83b23t00 aa83b23t00) {
		aa83b23t00 = this.aa83b23t00Dao.find(aa83b23t00);
		return aa83b23t00;
	}
	/**
	 * Finds a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Aa83b23t00
	 */
	public Aa83b23t00 findResolucion(Aa83b23t00 aa83b23t00) {
		aa83b23t00 = this.aa83b23t00Dao.find(aa83b23t00);
		aa83b23t00 = findIdsNora(aa83b23t00);
		return aa83b23t00;
	}
	/**
	 * Deletes a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83b23t00 aa83b23t00) {
		this.aa83b23t00Dao.remove(aa83b23t00);
	}

	/**
	 * Finds a list of rows in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b23t00>
	 */
	public List<Aa83b23t00> findAll(Aa83b23t00 aa83b23t00,
			JQGridRequestDto jqGridRequestDto) {

		List<Aa83b23t00> listaRetorno = this.aa83b23t00Dao.findAll(aa83b23t00,
				jqGridRequestDto);

//		for (int i = 0; i < listaRetorno.size(); i++) {
//			listaRetorno.set(i, findIdsNora(listaRetorno.get(i)));
//		}

		return listaRetorno;

		// return (List<Aa83b23t00>) this.aa83b23t00Dao.findAll(aa83b23t00,
		// jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa83b23t00 table using like.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b23t00>
	 */
	public List<Aa83b23t00> findAllLike(Aa83b23t00 aa83b23t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		List<Aa83b23t00> listaRetorno = this.aa83b23t00Dao.findAllLike(
				aa83b23t00, jqGridRequestDto, startsWith);

//		for (int i = 0; i < listaRetorno.size(); i++) {
//			listaRetorno.set(i, findIdsNora(listaRetorno.get(i)));
//		}
		return listaRetorno;
		// return (List<Aa83b23t00>) this.aa83b23t00Dao.findAllLike(aa83b23t00,
		// jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa83b23t00 table.
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa83b23t00 filterAa83b23t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa83b23t00Dao.removeMultiple(filterAa83b23t00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa83b23t00 table.
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa83b23t00>
	 */
	public JQGridResponseDto<Aa83b23t00> filter(Aa83b23t00 filterAa83b23t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa83b23t00> listaAa83b23t00 = this.aa83b23t00Dao.findAllLike(
				filterAa83b23t00, jqGridRequestDto, false);
		Long recordNum = this.aa83b23t00Dao.findAllLikeCount(
				filterAa83b23t00 != null ? filterAa83b23t00 : new Aa83b23t00(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa83b23t00>> reorderSelection = this.aa83b23t00Dao
					.reorderSelection(filterAa83b23t00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa83b23t00>(jqGridRequestDto,
					recordNum, listaAa83b23t00, reorderSelection);
		}
		return new JQGridResponseDto<Aa83b23t00>(jqGridRequestDto, recordNum,
				listaAa83b23t00);
	}

	/**
	 * Searches rows in the Aa83b23t00 table.
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param searchAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b23t00>>
	 */
	public List<TableRowDto<Aa83b23t00>> search(Aa83b23t00 filterAa83b23t00,
			Aa83b23t00 searchAa83b23t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa83b23t00Dao.search(filterAa83b23t00, searchAa83b23t00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa83b23t00 table.
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa83b23t00 filterAa83b23t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa83b23t00Dao.reorderSelection(filterAa83b23t00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa83b23t00 table.
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b23t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b23t00>> jerarquia(
			Aa83b23t00 filterAa83b23t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa83b23t00>> listaAa83b23t00 = this.aa83b23t00Dao
				.findAllLikeJerarquia(filterAa83b23t00, jqGridRequestDto);
		Long recordNum = this.aa83b23t00Dao.findAllLikeCountJerarquia(
				filterAa83b23t00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa83b23t00>>(
				jqGridRequestDto, recordNum, listaAa83b23t00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa83b23t00 table.
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b23t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b23t00>> jerarquiaChildren(
			Aa83b23t00 filterAa83b23t00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa83b23t00>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa83b23t00>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa83b23t00Dao.findAllChild(filterAa83b23t00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public Aa83b23t00 validarSolicitud(Aa83b23t00 aa83b23t00) {
		return this.aa83b23t00Dao.validarSolicitud(aa83b23t00);
	}

	@Override
	public Aa83b23t00 marcarNotifLeida(Aa83b23t00 aa83b23t00) {
		// TODO Auto-generated method stub
		return this.aa83b23t00Dao.marcarNotifLeida(aa83b23t00);
	}

	public Aa83b23t00 findIdsNora(Aa83b23t00 aa83b23t00) {
		// TODO Auto-generated method stub
		// System.out.println("Entro en findIdsNora ID023:: "
		// + aa83b23t00.getId023());
		logger.info("aa83b23t00.getMunicipioEmpadron023():"
				+ aa83b23t00.getMunicipioEmpadron023());
		A83bMunicipio a83bMunicipio = new A83bMunicipio();
		Aa83bCalle aa83bCalle = new Aa83bCalle();
		if (null!=aa83b23t00.getMunicipioEmpadron023())
			if (!aa83b23t00.getMunicipioEmpadron023().equals("")
					&& !aa83b23t00.getMunicipioEmpadron023().equals("0")) {
				a83bMunicipio.setId(aa83b23t00.getMunicipioEmpadron023());
				a83bMunicipio.setProvincia_id(aa83b23t00
						.getProvinciaEmpadron023());
				// System.out.println("busco 1:: " + a83bMunicipio.toString());
				a83bMunicipio = (A83bMunicipio) aa83bNoraService
						.findMunicipiosId(a83bMunicipio);
				aa83b23t00.setMunicipioEmpadronDescEs023(a83bMunicipio
						.getDs_o());
				aa83b23t00.setMunicipioEmpadronDescEu023(a83bMunicipio
						.getDs_o());
				// System.out.println("getMunicipioEmpadronDescEs023:: "
				// + aa83b23t00.getMunicipioEmpadronDescEs023());
			}
		logger.info("aa83b23t00.getMunicipComunic023():"
				+ aa83b23t00.getMunicipComunic023());
		if (null!=aa83b23t00.getMunicipComunic023())
			if (!aa83b23t00.getMunicipComunic023().equals("")
					&& !aa83b23t00.getMunicipComunic023().equals("0")) {
				a83bMunicipio.setDs_o("");
				a83bMunicipio.setId(aa83b23t00.getMunicipComunic023());
				a83bMunicipio.setProvincia_id(aa83b23t00
						.getProvinciaComunic023());
				// System.out.println("busco 2:: " + a83bMunicipio.toString());
				a83bMunicipio = (A83bMunicipio) aa83bNoraService
						.findMunicipiosId(a83bMunicipio);
				aa83b23t00.setMunicipComunicDescEs023(a83bMunicipio.getDs_o());
				aa83b23t00.setMunicipComunicDescEu23(a83bMunicipio.getDs_o());
				// System.out.println("getMunicipComunicDescEu23:: "
				// + aa83b23t00.getMunicipComunicDescEu23());
			}
		// System.out.println("getLocalidadEmp023:: "
		// + aa83b23t00.getLocalidadEmp023());
		// logger.info("aa83b23t00.getLocalidadEmp023():"
		// + aa83b23t00.getLocalidadEmp023());
		// if (aa83b23t00.getLocalidadEmp023() != null)
		// if (!aa83b23t00.getLocalidadEmp023().equals("")
		// && !aa83b23t00.getLocalidadEmp023().equals("0")) {
		// logger.info("aa83b23t00.getProvinciaEmpadron023() IN:"
		// + aa83b23t00.getProvinciaEmpadron023());
		// if (aa83b23t00.getProvinciaEmpadron023() != null) {
		// if (!aa83b23t00.getProvinciaEmpadron023().equals("")
		// && !aa83b23t00.getProvinciaEmpadron023()
		// .equals("0")) {
		// a83bMunicipio.setDs_o("");
		// a83bMunicipio.setId(aa83b23t00.getLocalidadEmp023());
		// a83bMunicipio.setProvincia_id(aa83b23t00
		// .getProvinciaEmpadron023());
		// // System.out.println("busco 3:: " +
		// // a83bMunicipio.toString());
		// a83bMunicipio = (A83bMunicipio) aa83bNoraService
		// .findMunicipiosId(a83bMunicipio);
		// aa83b23t00.setLocalidadEmp023(a83bMunicipio.getDs_o());
		// aa83b23t00.setLocalidadEmp023(a83bMunicipio.getDs_o());
		// // System.out.println("getLocalidadEmp023:: "
		// // + aa83b23t00.getLocalidadEmp023());
		// }
		// }
		// }
		logger.info("aa83b23t00.getProvEmp023():" + aa83b23t00.getProvEmp023());
		if (null!=aa83b23t00.getProvEmp023()) {
			if (!aa83b23t00.getProvEmp023().equals("")
					&& !aa83b23t00.getProvEmp023().equals("0")) {
				A83bProvincia a83bProvincia = new A83bProvincia();
				a83bProvincia.setId(aa83b23t00.getProvEmp023());
				// System.out.println("busco 4:: " + a83bProvincia.toString());
				a83bProvincia = aa83bNoraService
						.findProvinciasId(a83bProvincia);
				aa83b23t00.setProvEmpDescEs023(a83bProvincia.getDs_o());
				aa83b23t00.setProvEmpDescEu023(a83bProvincia.getDs_o());
				// System.out.println("getProvEmpDescEu023:: "
				// + aa83b23t00.getProvEmpDescEu023());
			}
		}
		logger.info("aa83b23t00.getProvinciaEmpadron023():"
				+ aa83b23t00.getProvinciaEmpadron023());
		if (null!=aa83b23t00.getProvinciaEmpadron023())
			if (!aa83b23t00.getProvinciaEmpadron023().equals("")
					&& !aa83b23t00.getProvinciaEmpadron023().equals("0")) {
				A83bProvincia a83bProvincia = new A83bProvincia();
				a83bProvincia.setId(aa83b23t00.getProvinciaEmpadron023());
				// System.out.println("busco 5:: " + a83bProvincia.toString());
				a83bProvincia = aa83bNoraService
						.findProvinciasId(a83bProvincia);
				aa83b23t00.setProvinciaEmpadronDescEs023(a83bProvincia
						.getDs_o());
				aa83b23t00.setProvinciaEmpadronDescEu023(a83bProvincia
						.getDs_o());
				// System.out.println("getProvinciaEmpadronDescEu023:: "
				// + aa83b23t00.getProvinciaEmpadronDescEu023());
			}
		logger.info("aa83b23t00.getProvinciaComunic023():"
				+ aa83b23t00.getProvinciaComunic023());
		if (null!=aa83b23t00.getProvinciaComunic023())
			if (!aa83b23t00.getProvinciaComunic023().equals("")
					&& !aa83b23t00.getProvinciaComunic023().equals("0")) {
				A83bProvincia a83bProvincia = new A83bProvincia();
				a83bProvincia.setId(aa83b23t00.getProvinciaComunic023());
				// System.out.println("busco 6:: " + a83bProvincia.toString());
				a83bProvincia = aa83bNoraService
						.findProvinciasId(a83bProvincia);
				aa83b23t00
						.setProvinciaComunicDescEs023(a83bProvincia.getDs_o());
				aa83b23t00
						.setProvinciaComunicDescEu023(a83bProvincia.getDs_o());
				// System.out.println("getProvinciaComunicDescEu023:: "
				// + aa83b23t00.getProvinciaComunicDescEu023());
			}
		logger.info("aa83b23t00.getProvEmp023():" + aa83b23t00.getProvEmp023());
		if (null!=aa83b23t00.getProvEmp023())
			if (!aa83b23t00.getProvEmp023().equals("")
					&& !aa83b23t00.getProvEmp023().equals("0")) {
				A83bProvincia a83bProvincia = new A83bProvincia();
				a83bProvincia.setId(aa83b23t00.getProvEmp023());
				// System.out.println("busco 7:: " + a83bProvincia.toString());
				a83bProvincia = aa83bNoraService
						.findProvinciasId(a83bProvincia);
				aa83b23t00.setProvEmpDescEs023(a83bProvincia.getDs_o());
				aa83b23t00.setProvEmpDescEu023(a83bProvincia.getDs_o());
				// System.out.println("getProvEmpDescEu023:: "
				// + aa83b23t00.getProvEmpDescEu023());
			}
		
		
		logger.info("aa83b23t00.getMunicipComunic023():"
				+ aa83b23t00.getCalleComunic023());
		if (null!=aa83b23t00.getCalleComunic023())
			if (!aa83b23t00.getCalleComunic023().equals("")
					&& Aa83bUtilidades.isNumeric(aa83b23t00.getCalleComunic023())) {
				aa83bCalle.setDs_o("");
				aa83bCalle.setCalle_cod(aa83b23t00.getCalleComunic023());
				// System.out.println("busco 2:: " + a83bMunicipio.toString());
				aa83bCalle = (Aa83bCalle) aa83bNoraService.findCalle(aa83bCalle, null);
				aa83b23t00.setCalleComunicDescEs023(aa83bCalle.getDs_o());
				aa83b23t00.setCalleComunicDescEu023(aa83bCalle.getDs_o());
			}
		
		
		// Descripciones para los informes
		return aa83b23t00;
	}

	@Override
	public Aa83b23t00 cerrarExp(Aa83b23t00 aa83b23t00) {
		// TODO Auto-generated method stub
		return this.aa83b23t00Dao.cerrarExp(aa83b23t00);
	}

	@Override
	public Aa83b23t00 cerrarExpReq(Aa83b23t00 solicitudESF) {
		// TODO Auto-generated method stub
		return this.aa83b23t00Dao.cerrarExpReq(solicitudESF);
	}

	@Override
	public Aa83b23t00 marcarReqSubsanaLeido023(Aa83b23t00 solicitudESF) {
		// TODO Auto-generated method stub
		return this.aa83b23t00Dao.marcarReqSubsanaLeido023(solicitudESF);
	}
}
