package com.ejie.aa83b.service;

import com.ejie.aa83b.dao.Aa83b21t00Dao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b21v00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.util.Aa83bUtilidades;

/**
 * Aa83b21t00ServiceImpl generated by UDA, 28-dic-2015 17:45:22.
 * 
 * @author UDA
 */

@Service(value = "aa83b21t00Service")
public class Aa83b21t00ServiceImpl implements Aa83b21t00Service {

	
	private static final Logger logger = LoggerFactory
	.getLogger(Aa83b23t00ServiceImpl.class);
	
	@Autowired
	private Aa83b21t00Dao aa83b21t00Dao;

	@Autowired
	private Aa83bNoraService aa83bNoraService;
	
	/**
	 * Inserts a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b21t00 add(Aa83b21t00 aa83b21t00) {
		return this.aa83b21t00Dao.add(aa83b21t00);
	}

	/**
	 * Updates a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b21t00 update(Aa83b21t00 aa83b21t00) {
		return this.aa83b21t00Dao.update(aa83b21t00);
	}

	/**
	 * Finds a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	public Aa83b21t00 find(Aa83b21t00 aa83b21t00) {
		return (Aa83b21t00) this.aa83b21t00Dao.find(aa83b21t00);
	}
	
	/**
	 * Finds a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	public Aa83b21v00 findFicha(Aa83b21v00 aa83b21v00) {
		return (Aa83b21v00) this.aa83b21t00Dao.findFicha(aa83b21v00);
	}

	/**
	 * Finds a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Aa83b23t00
	 */
	public Aa83b21t00 findResolucion(Aa83b21t00 aa83b21t00) {
		aa83b21t00 = this.aa83b21t00Dao.find(aa83b21t00);
		aa83b21t00 = findIdsNora(aa83b21t00);
		return aa83b21t00;
	}
	
	/**
	 * Deletes a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83b21t00 aa83b21t00) {
		this.aa83b21t00Dao.remove(aa83b21t00);
	}

	/**
	 * Finds a list of rows in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b21t00>
	 */
	public List<Aa83b21t00> findAll(Aa83b21t00 aa83b21t00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa83b21t00>) this.aa83b21t00Dao.findAll(aa83b21t00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa83b21t00 table using like.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b21t00>
	 */
	public List<Aa83b21t00> findAllLike(Aa83b21t00 aa83b21t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa83b21t00>) this.aa83b21t00Dao.findAllLike(aa83b21t00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa83b21t00 filterAa83b21t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa83b21t00Dao.removeMultiple(filterAa83b21t00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa83b21t00>
	 */
	public JQGridResponseDto<Aa83b21t00> filter(Aa83b21t00 filterAa83b21t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa83b21t00> listaAa83b21t00 = this.aa83b21t00Dao.findAllLike(
				filterAa83b21t00, jqGridRequestDto, false);
		Long recordNum = this.aa83b21t00Dao.findAllLikeCount(
				filterAa83b21t00 != null ? filterAa83b21t00 : new Aa83b21t00(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa83b21t00>> reorderSelection = this.aa83b21t00Dao
					.reorderSelection(filterAa83b21t00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa83b21t00>(jqGridRequestDto,
					recordNum, listaAa83b21t00, reorderSelection);
		}
		return new JQGridResponseDto<Aa83b21t00>(jqGridRequestDto, recordNum,
				listaAa83b21t00);
	}

	/**
	 * Searches rows in the Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param searchAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b21t00>>
	 */
	public List<TableRowDto<Aa83b21t00>> search(Aa83b21t00 filterAa83b21t00,
			Aa83b21t00 searchAa83b21t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa83b21t00Dao.search(filterAa83b21t00, searchAa83b21t00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa83b21t00 filterAa83b21t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa83b21t00Dao.reorderSelection(filterAa83b21t00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b21t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b21t00>> jerarquia(
			Aa83b21t00 filterAa83b21t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa83b21t00>> listaAa83b21t00 = this.aa83b21t00Dao
				.findAllLikeJerarquia(filterAa83b21t00, jqGridRequestDto);
		Long recordNum = this.aa83b21t00Dao.findAllLikeCountJerarquia(
				filterAa83b21t00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa83b21t00>>(
				jqGridRequestDto, recordNum, listaAa83b21t00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b21t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b21t00>> jerarquiaChildren(
			Aa83b21t00 filterAa83b21t00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa83b21t00>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa83b21t00>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa83b21t00Dao.findAllChild(filterAa83b21t00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}
	
	public Aa83b21t00 findIdsNora(Aa83b21t00 aa83b21t00) {
		// TODO Auto-generated method stub
		// System.out.println("Entro en findIdsNora ID023:: "
		// + aa83b23t00.getId023());
		A83bMunicipio a83bMunicipio = new A83bMunicipio();
		Aa83bCalle aa83bCalle = new Aa83bCalle();
		logger.info("aa83b21t00.getMunicipComunic021():"
				+ aa83b21t00.getMunicipComunic021());
		if (null!=aa83b21t00.getMunicipComunic021())
			if (!aa83b21t00.getMunicipComunic021().equals("")
					&& !aa83b21t00.getMunicipComunic021().equals("0")) {
				a83bMunicipio.setDs_o("");
				a83bMunicipio.setId(aa83b21t00.getMunicipComunic021());
				a83bMunicipio.setProvincia_id(aa83b21t00.getProvinciaComunic021());
				// System.out.println("busco 2:: " + a83bMunicipio.toString());
				a83bMunicipio = (A83bMunicipio) aa83bNoraService.findMunicipiosId(a83bMunicipio);
				aa83b21t00.setMunicipComunicDescEs021(a83bMunicipio.getDs_o());
				aa83b21t00.setMunicipComunicDescEu021(a83bMunicipio.getDs_o());
			}
		logger.info("aa83b21t00.getProvinciaComunic021():"
				+ aa83b21t00.getProvinciaComunic021());
		if (null!=aa83b21t00.getProvinciaComunic021())
			if (!aa83b21t00.getProvinciaComunic021().equals("")
					&& !aa83b21t00.getProvinciaComunic021().equals("0")) {
				A83bProvincia a83bProvincia = new A83bProvincia();
				a83bProvincia.setId(aa83b21t00.getProvinciaComunic021());
				// System.out.println("busco 6:: " + a83bProvincia.toString());
				a83bProvincia = aa83bNoraService.findProvinciasId(a83bProvincia);
				aa83b21t00.setProvinciaComunicDescEs021(a83bProvincia.getDs_o());
				aa83b21t00.setProvinciaComunicDescEu021(a83bProvincia.getDs_o());
				// System.out.println("getProvinciaComunicDescEu023:: "
				// + aa83b23t00.getProvinciaComunicDescEu023());
			}
		
		logger.info("aa83b21t00.getMunicipComunic023():"
				+ aa83b21t00.getCalleComunic021());
		if (null!=aa83b21t00.getCalleComunic021())
			if (!aa83b21t00.getCalleComunic021().equals("")
					&& Aa83bUtilidades.isNumeric(aa83b21t00.getCalleComunic021())) {
				aa83bCalle.setDs_o("");
				aa83bCalle.setCalle_cod(aa83b21t00.getCalleComunic021());
				// System.out.println("busco 2:: " + a83bMunicipio.toString());
				aa83bCalle = (Aa83bCalle) aa83bNoraService.findCalle(aa83bCalle, null);
				aa83b21t00.setCalleComunicDescEs021(aa83bCalle.getDs_o());
				aa83b21t00.setCalleComunicDescEu021(aa83bCalle.getDs_o());
			}
		
		
		// Descripciones para los informes
		return aa83b21t00;
	}
	

	public Aa83b21t00 validarSolicitud(Aa83b21t00 aa83b21t00) {
		return this.aa83b21t00Dao.validarSolicitud(aa83b21t00);
	}

	@Override
	public Aa83b21t00 enviarVivienda(Aa83b21t00 aa83b21t00) {
		// TODO Auto-generated method stub
		return this.aa83b21t00Dao.enviarVivienda(aa83b21t00);
	}

	@Override
	public Aa83b21t00 marcarNotifLeida(Aa83b21t00 aa83b21t00) {
		// TODO Auto-generated method stub
		return this.aa83b21t00Dao.marcarNotifLeida(aa83b21t00);
	}

	@Override
	public Aa83b21t00 cerrarExp(Aa83b21t00 solicitudADE) {
		// TODO Auto-generated method stub
		return this.aa83b21t00Dao.cerrarExp(solicitudADE);
	}

	@Override
	public Aa83b21t00 cerrarExpReq(Aa83b21t00 solicitudADE) {
		// TODO Auto-generated method stub
		return this.aa83b21t00Dao.cerrarExpReq(solicitudADE);
	}

	@Override
	public Aa83b21t00 marcarReqSubsanaLeido021(Aa83b21t00 solicitudADE) {
		// TODO Auto-generated method stub
		return this.aa83b21t00Dao.marcarReqSubsanaLeido021(solicitudADE);
	}

}
