package com.ejie.aa83b.service;

import com.ejie.aa83b.dao.Aa83b11t00Dao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b01t00;
import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Aa83b11t00ServiceImpl generated by UDA, 08-feb-2016 13:26:33.
 * 
 * @author UDA
 */

@Service(value = "aa83b11t00Service")
public class Aa83b11t00ServiceImpl implements Aa83b11t00Service {

	@Autowired
	private Aa83b11t00Dao aa83b11t00Dao;

	@Autowired
	private Aa83b01t00Service aa83b01t00Service;

	@Autowired
	private Aa83b02t00Service aa83b02t00Service;

	/**
	 * Inserts a single row in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @return Aa83b11t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b11t00 add(Aa83b11t00 aa83b11t00) {
		return this.aa83b11t00Dao.add(aa83b11t00);
	}

	/**
	 * Updates a single row in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @return Aa83b11t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b11t00 update(Aa83b11t00 aa83b11t00) {
		return this.aa83b11t00Dao.update(aa83b11t00);
	}

	/**
	 * Finds a single row in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @return Aa83b11t00
	 */
	public Aa83b11t00 find(Aa83b11t00 aa83b11t00) {
		return (Aa83b11t00) this.aa83b11t00Dao.find(aa83b11t00);
	}

	/**
	 * Deletes a single row in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83b11t00 aa83b11t00) {
		this.aa83b11t00Dao.remove(aa83b11t00);
	}

	/**
	 * Finds a list of rows in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b11t00>
	 */
	public List<Aa83b11t00> findAll(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa83b11t00>) this.aa83b11t00Dao.findAll(aa83b11t00,
				jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b11t00>
	 */
	public List<Aa83b11t00> findEnviadas(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa83b11t00>) this.aa83b11t00Dao.findEnviadas(aa83b11t00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa83b11t00 table using like.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b11t00>
	 */
	public List<Aa83b11t00> findAllLike(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		List<Aa83b11t00> lista11Temp = this.aa83b11t00Dao.findAllLike(
				aa83b11t00, jqGridRequestDto, startsWith);

		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		Aa83b02t00 aa83b02t00 = new Aa83b02t00();
		for (int i = 0; i < lista11Temp.size(); i++) {
			aa83b01t00.setId001(lista11Temp.get(i).getId001Fase());
			aa83b01t00.setIdTipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
			aa83b01t00 = aa83b01t00Service.find(aa83b01t00);
			lista11Temp.get(i).setId001FaseStrEs(aa83b01t00.getDescEs001());
			lista11Temp.get(i).setId001FaseStrEu(aa83b01t00.getDescEu001());

			aa83b02t00.setId001Fase(lista11Temp.get(i).getId001Fase());
			aa83b02t00.setId002(lista11Temp.get(i).getId002Tram());
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
			lista11Temp.get(i).setId002TramStrEs(aa83b02t00.getDescEs002());
			lista11Temp.get(i).setId002TramStrEu(aa83b02t00.getDescEu002());
		}
		return (lista11Temp);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa83b11t00 table.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa83b11t00 filterAa83b11t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa83b11t00Dao.removeMultiple(filterAa83b11t00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa83b11t00 table.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa83b11t00>
	 */
	public JQGridResponseDto<Aa83b11t00> filter(Aa83b11t00 filterAa83b11t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa83b11t00> listaAa83b11t00 = this.aa83b11t00Dao.findAllLike(
				filterAa83b11t00, jqGridRequestDto, false);
		Long recordNum = this.aa83b11t00Dao.findAllLikeCount(
				filterAa83b11t00 != null ? filterAa83b11t00 : new Aa83b11t00(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa83b11t00>> reorderSelection = this.aa83b11t00Dao
					.reorderSelection(filterAa83b11t00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa83b11t00>(jqGridRequestDto,
					recordNum, listaAa83b11t00, reorderSelection);
		}
		return new JQGridResponseDto<Aa83b11t00>(jqGridRequestDto, recordNum,
				listaAa83b11t00);
	}

	/**
	 * Searches rows in the Aa83b11t00 table.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param searchAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b11t00>>
	 */
	public List<TableRowDto<Aa83b11t00>> search(Aa83b11t00 filterAa83b11t00,
			Aa83b11t00 searchAa83b11t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa83b11t00Dao.search(filterAa83b11t00, searchAa83b11t00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa83b11t00 table.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa83b11t00 filterAa83b11t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa83b11t00Dao.reorderSelection(filterAa83b11t00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa83b11t00 table.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b11t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b11t00>> jerarquia(
			Aa83b11t00 filterAa83b11t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa83b11t00>> listaAa83b11t00 = this.aa83b11t00Dao
				.findAllLikeJerarquia(filterAa83b11t00, jqGridRequestDto);
		Long recordNum = this.aa83b11t00Dao.findAllLikeCountJerarquia(
				filterAa83b11t00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa83b11t00>>(
				jqGridRequestDto, recordNum, listaAa83b11t00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa83b11t00 table.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b11t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b11t00>> jerarquiaChildren(
			Aa83b11t00 filterAa83b11t00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa83b11t00>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa83b11t00>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa83b11t00Dao.findAllChild(filterAa83b11t00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	@Override
	public Aa83b11t00 getLastRow(Aa83b11t00 aa83b11t00) {
		// TODO Auto-generated method stub

		Aa83b11t00 lista11Temp = this.aa83b11t00Dao.getLastRow(aa83b11t00);

		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		Aa83b02t00 aa83b02t00 = new Aa83b02t00();
		aa83b01t00.setId001(lista11Temp.getId001Fase());
		aa83b01t00.setIdTipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
		aa83b01t00 = aa83b01t00Service.find(aa83b01t00);
		lista11Temp.setId001FaseStrEs(aa83b01t00.getDescEs001());
		lista11Temp.setId001FaseStrEu(aa83b01t00.getDescEu001());
		aa83b02t00.setId001Fase(lista11Temp.getId001Fase());
		aa83b02t00.setId002(lista11Temp.getId002Tram());
		aa83b02t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
		aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
		lista11Temp.setId002TramStrEs(aa83b02t00.getDescEs002());
		lista11Temp.setId002TramStrEu(aa83b02t00.getDescEu002());
		return (lista11Temp);
	}

	@Override
	public List<Aa83b11t00> findAllLikeNotificacion(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto) {
		// TODO Auto-generated method stub
		return (List<Aa83b11t00>) this.aa83b11t00Dao.findAllLikeNotificacion(
				aa83b11t00, jqGridRequestDto);
	}
	@Override
	public List<Aa83b11t00> findAllLikeNotificacionIdColeccion(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto, String idColeccion) {
		// TODO Auto-generated method stub
		return (List<Aa83b11t00>) this.aa83b11t00Dao.findAllLikeNotificacionIdColeccion(
				aa83b11t00, jqGridRequestDto, idColeccion);
	}

	@Override
	public List<Aa83b11t00> findAllLikeNotificacionFechas(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta) {
		// TODO Auto-generated method stub
		return (List<Aa83b11t00>) this.aa83b11t00Dao
				.findAllLikeNotificacionFechas(aa83b11t00, jqGridRequestDto,
						fechaDesde, fechaHasta);
	}
	@Override
	public List<Aa83b11t00> findAllLikeNotificacionFechasIdColeccion(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta, String idColeccion) {
		// TODO Auto-generated method stub
		return (List<Aa83b11t00>) this.aa83b11t00Dao
				.findAllLikeNotificacionFechasIdColeccion(aa83b11t00, jqGridRequestDto,
						fechaDesde, fechaHasta, idColeccion);
	}

	@Override
	public List<Aa83b11t00> findEnviadosRequerimientosFechas(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta) {
		// TODO Auto-generated method stub
		return (List<Aa83b11t00>) this.aa83b11t00Dao
				.findEnviadosRequerimientosFechas(aa83b11t00, jqGridRequestDto,
						fechaDesde, fechaHasta);
	}
	@Override
	public List<Aa83b11t00> findEnviadosRequerimientosFechasIdColeccion(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta, String idColeccion) {
		// TODO Auto-generated method stub
		return (List<Aa83b11t00>) this.aa83b11t00Dao
				.findEnviadosRequerimientosFechasIdColeccion(aa83b11t00, jqGridRequestDto,
						fechaDesde, fechaHasta, idColeccion);
	}

}
