package com.ejie.aa83b.service;

import com.ejie.aa83b.dao.Aa83b09t00Dao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b01t00;
import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Aa83b09t00ServiceImpl generated by UDA, 29-dic-2015 12:23:29.
 * 
 * @author UDA
 */

@Service(value = "aa83b09t00Service")
public class Aa83b09t00ServiceImpl implements Aa83b09t00Service {

	@Autowired
	private Aa83b09t00Dao aa83b09t00Dao;

	@Autowired
	private Aa83b01t00Service aa83b01t00Service;

	@Autowired
	private Aa83b02t00Service aa83b02t00Service;

	/**
	 * Inserts a single row in the Aa83b09t00 table.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00
	 * @return Aa83b09t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b09t00 getLastRow(Aa83b09t00 aa83b09t00) {

		Aa83b09t00 aa83b09t00New = new Aa83b09t00();
		aa83b09t00New = this.aa83b09t00Dao.getLastRow(aa83b09t00);
		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		Aa83b02t00 aa83b02t00 = new Aa83b02t00();

		aa83b01t00.setId001(aa83b09t00New.getId001Fase());
		aa83b01t00.setIdTipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));

		aa83b01t00 = aa83b01t00Service.find(aa83b01t00);
		aa83b09t00New.setId001FaseStrEs(aa83b01t00.getDescEs001());
		aa83b09t00New.setId001FaseStrEu(aa83b01t00.getDescEu001());

		aa83b02t00.setId001Fase(aa83b09t00New.getId001Fase());
		aa83b02t00.setId002(aa83b09t00New.getId002Tram());
		aa83b02t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));

		aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
		aa83b09t00New.setId002TramStrEs(aa83b02t00.getDescEs002());
		aa83b09t00New.setId002TramStrEu(aa83b02t00.getDescEu002());
		return aa83b09t00New;
	}

	/**
	 * Inserts a single row in the Aa83b09t00 table.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00
	 * @return Aa83b09t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b09t00 add(Aa83b09t00 aa83b09t00) {
		return this.aa83b09t00Dao.add(aa83b09t00);
	}

	/**
	 * Updates a single row in the Aa83b09t00 table.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00
	 * @return Aa83b09t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa83b09t00 update(Aa83b09t00 aa83b09t00) {
		return this.aa83b09t00Dao.update(aa83b09t00);
	}

	/**
	 * Finds a single row in the Aa83b09t00 table.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00
	 * @return Aa83b09t00
	 */
	public Aa83b09t00 find(Aa83b09t00 aa83b09t00) {
		return (Aa83b09t00) this.aa83b09t00Dao.find(aa83b09t00);
	}

	/**
	 * Deletes a single row in the Aa83b09t00 table.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa83b09t00 aa83b09t00) {
		this.aa83b09t00Dao.remove(aa83b09t00);
	}

	/**
	 * Finds a list of rows in the Aa83b09t00 table.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b09t00>
	 */
	public List<Aa83b09t00> findAll(Aa83b09t00 aa83b09t00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa83b09t00>) this.aa83b09t00Dao.findAll(aa83b09t00,
				jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the Aa83b09t00 table.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b09t00>
	 */
	public List<Aa83b09t00> findEnviadas(Aa83b09t00 aa83b09t00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa83b09t00>) this.aa83b09t00Dao.findEnviadas(aa83b09t00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa83b09t00 table using like.
	 * 
	 * @param aa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b09t00>
	 */
	public List<Aa83b09t00> findAllLike(Aa83b09t00 aa83b09t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		List<Aa83b09t00> lista09Temp = this.aa83b09t00Dao.findAllLike(
				aa83b09t00, jqGridRequestDto, startsWith);
		Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		Aa83b02t00 aa83b02t00 = new Aa83b02t00();
		for (int i = 0; i < lista09Temp.size(); i++) {
			aa83b01t00.setId001(lista09Temp.get(i).getId001Fase());
			aa83b01t00.setIdTipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
			aa83b01t00 = aa83b01t00Service.find(aa83b01t00);
			lista09Temp.get(i).setId001FaseStrEs(aa83b01t00.getDescEs001());
			lista09Temp.get(i).setId001FaseStrEu(aa83b01t00.getDescEu001());

			aa83b02t00.setId001Fase(lista09Temp.get(i).getId001Fase());
			aa83b02t00.setId002(lista09Temp.get(i).getId002Tram());
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
			lista09Temp.get(i).setId002TramStrEs(aa83b02t00.getDescEs002());
			lista09Temp.get(i).setId002TramStrEu(aa83b02t00.getDescEu002());
		}
		return (lista09Temp);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa83b09t00 table.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa83b09t00 filterAa83b09t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa83b09t00Dao.removeMultiple(filterAa83b09t00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa83b09t00 table.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa83b09t00>
	 */
	public JQGridResponseDto<Aa83b09t00> filter(Aa83b09t00 filterAa83b09t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa83b09t00> listaAa83b09t00 = this.aa83b09t00Dao.findAllLike(
				filterAa83b09t00, jqGridRequestDto, false);
		Long recordNum = this.aa83b09t00Dao.findAllLikeCount(
				filterAa83b09t00 != null ? filterAa83b09t00 : new Aa83b09t00(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa83b09t00>> reorderSelection = this.aa83b09t00Dao
					.reorderSelection(filterAa83b09t00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa83b09t00>(jqGridRequestDto,
					recordNum, listaAa83b09t00, reorderSelection);
		}
		return new JQGridResponseDto<Aa83b09t00>(jqGridRequestDto, recordNum,
				listaAa83b09t00);
	}

	/**
	 * Searches rows in the Aa83b09t00 table.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00
	 * @param searchAa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b09t00>>
	 */
	public List<TableRowDto<Aa83b09t00>> search(Aa83b09t00 filterAa83b09t00,
			Aa83b09t00 searchAa83b09t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa83b09t00Dao.search(filterAa83b09t00, searchAa83b09t00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa83b09t00 table.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa83b09t00 filterAa83b09t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa83b09t00Dao.reorderSelection(filterAa83b09t00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa83b09t00 table.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b09t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b09t00>> jerarquia(
			Aa83b09t00 filterAa83b09t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa83b09t00>> listaAa83b09t00 = this.aa83b09t00Dao
				.findAllLikeJerarquia(filterAa83b09t00, jqGridRequestDto);
		Long recordNum = this.aa83b09t00Dao.findAllLikeCountJerarquia(
				filterAa83b09t00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa83b09t00>>(
				jqGridRequestDto, recordNum, listaAa83b09t00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa83b09t00 table.
	 * 
	 * @param filterAa83b09t00
	 *            Aa83b09t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b09t00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa83b09t00>> jerarquiaChildren(
			Aa83b09t00 filterAa83b09t00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa83b09t00>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa83b09t00>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa83b09t00Dao.findAllChild(filterAa83b09t00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	@Override
	public List<Aa83b09t00> findEnviadasNotificacion(Aa83b09t00 aa83b09t00,
			JQGridRequestDto jqGridRequestDto) {
		// TODO Auto-generated method stub
		return (List<Aa83b09t00>) this.aa83b09t00Dao.findEnviadasNotificacion(
				aa83b09t00, jqGridRequestDto);

	}
	@Override
	public List<Aa83b09t00> findEnviadasNotificacionIdColeccion(Aa83b09t00 aa83b09t00,
			JQGridRequestDto jqGridRequestDto, String idColeccion){
		return (List<Aa83b09t00>) this.aa83b09t00Dao.findEnviadasNotificacionIdColeccion(
				aa83b09t00, jqGridRequestDto, idColeccion);
	}

	@Override
	public List<Aa83b09t00> findEnviadosRequerimientosFechas(
			Aa83b09t00 aa83b09t00, JQGridRequestDto jqGridRequestDto,
			Date desde, Date hasta) {
		// TODO Auto-generated method stub
		return (List<Aa83b09t00>) this.aa83b09t00Dao
				.findEnviadosRequerimientosFechas(aa83b09t00, jqGridRequestDto,
						desde, hasta);

	}

	@Override
	public List<Aa83b09t00> findEnviadasNotificacionFechas(
			Aa83b09t00 aa83b09t00, JQGridRequestDto jqGridRequestDto,
			Date desde, Date hasta) {
		// TODO Auto-generated method stub
		return (List<Aa83b09t00>) this.aa83b09t00Dao
				.findEnviadasNotificacionFechas(aa83b09t00, jqGridRequestDto,
						desde, hasta);

	}
	@Override
	public List<Aa83b09t00> findEnviadosRequerimientosFechasIdColeccion(
			Aa83b09t00 aa83b09t00, JQGridRequestDto jqGridRequestDto,
			Date desde, Date hasta, String idColeccion){
		return (List<Aa83b09t00>) this.aa83b09t00Dao
		.findEnviadosRequerimientosFechasIdColeccion(aa83b09t00, jqGridRequestDto,
				desde, hasta, idColeccion);
	}

	@Override
	public List<Aa83b09t00> findEnviadasNotificacionFechasIdColeccion(
			Aa83b09t00 aa83b09t00, JQGridRequestDto jqGridRequestDto,
			Date desde, Date hasta, String idColeccion) {
		// TODO Auto-generated method stub
		return (List<Aa83b09t00>) this.aa83b09t00Dao
		.findEnviadasNotificacionFechasIdColeccion(aa83b09t00, jqGridRequestDto,
				desde, hasta, idColeccion);
	}
}
