package com.ejie.aa83b.model.tramitacion;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Modelo del evento de tramitación
 * 
 * @author DS
 * 
 */
@XmlRootElement(name = "eventoTramitacion")
@XmlAccessorType(XmlAccessType.FIELD)
public class Aa83bEventoTramitacion {

	@XmlElement(name = "folderId")
	private String folderId;
	@XmlElement(name = "fase")
	private String fase;
	@XmlElement(name = "tramite")
	private String tramite;
	@XmlElement(name = "accion")
	private String accion;
	@XmlElement(name = "monitor")
	private Aa83bInformacionMonitor monitor;

	@XmlElement(name = "parametro")
	private List<Aa83bParametroTramitacion> listaParametros;

	/**
	 * 
	 * @return String
	 */
	public String getFolderId() {
		return this.folderId;
	}

	/**
	 * 
	 * @param folderId
	 *            String
	 */
	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	/**
	 * 
	 * @return String
	 */
	public String getFase() {
		return this.fase;
	}

	/**
	 * 
	 * @param fase
	 *            String
	 */
	public void setFase(String fase) {
		this.fase = fase;
	}

	/**
	 * 
	 * @return String
	 */
	public String getTramite() {
		return tramite;
	}

	/**
	 * 
	 * @param tramite
	 *            String
	 */
	public void setTramite(String tramite) {
		this.tramite = tramite;
	}

	/**
	 * 
	 * @return String
	 */
	public String getAccion() {
		return this.accion;
	}

	/**
	 * 
	 * @param accion
	 *            String
	 */
	public void setAccion(String accion) {
		this.accion = accion;
	}

	/**
	 * 
	 * @return Aa71bInformacionMonitor
	 */
	public Aa83bInformacionMonitor getMonitor() {
		return this.monitor;
	}

	/**
	 * 
	 * @param monitor
	 *            Aa71bInformacionMonitor
	 */
	public void setMonitor(Aa83bInformacionMonitor monitor) {
		this.monitor = monitor;
	}

	/**
	 * 
	 * @return List<Aa71bParametroTramitacion>
	 */
	public List<Aa83bParametroTramitacion> getListaParametros() {
		return this.listaParametros;
	}

	/**
	 * 
	 * @param listaParametros
	 *            List<Aa71bParametroTramitacion>
	 */
	public void setListaParametros(
			List<Aa83bParametroTramitacion> listaParametros) {
		this.listaParametros = listaParametros;
	}

	/**
	 * Dado el nombre de un paramentro retorna su valor
	 * 
	 * @param key
	 *            Es nombre del parametro
	 * @return el valor del parametro
	 */
	public String getParametro(String key) {
		for (Aa83bParametroTramitacion parametro : this.listaParametros) {
			if (key.equals(parametro.getNombre())) {
				return parametro.getValor();
			}
		}
		return null;
	}

}
