package com.ejie.aa83b.model;

import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa83b.util.Aa83BConstants;

/**
 * TipoDocumento.
 * 
 * @author DS
 */
public class Aa83bTipoDocumento implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private Integer pkTipo;
	private String tipoDocumental;
	private String nombreEs;
	private String nombreEu;
	private String serie;
	private String baja;

	/**
	 * Method 'TipoDocumento'.
	 */
	public Aa83bTipoDocumento() {
		super();
	}

	/**
	 * Method 'TipoDocumento'.
	 * 
	 * @param pkTipo
	 *            Integer
	 */
	public Aa83bTipoDocumento(Integer pkTipo) {
		super();
		this.pkTipo = pkTipo;
	}

	/**
	 * Method 'TipoDocumento'.
	 * 
	 * @param pkTipo
	 *            Integer
	 * @param tipoDocumental
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param serie
	 *            String
	 * @param baja
	 *            String
	 */
	public Aa83bTipoDocumento(Integer pkTipo, String tipoDocumental,
			String nombreEs, String nombreEu, String serie, String baja) {
		super();
		this.pkTipo = pkTipo;
		this.tipoDocumental = tipoDocumental;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.serie = serie;
		this.baja = baja;
	}

	/**
	 * Method 'getPkTipo'.
	 * 
	 * @return Integer
	 */
	public Integer getPkTipo() {
		return this.pkTipo;
	}

	/**
	 * Method 'setPkTipo'.
	 * 
	 * @param pkTipo
	 *            Integer
	 */
	public void setPkTipo(Integer pkTipo) {
		this.pkTipo = pkTipo;
	}

	/**
	 * Method 'getTipoDocumental'.
	 * 
	 * @return String
	 */
	public String getTipoDocumental() {
		return this.tipoDocumental;
	}

	/**
	 * Method 'setTipoDocumental'.
	 * 
	 * @param tipoDocumental
	 *            String
	 * @return
	 */
	public void setTipoDocumental(String tipoDocumental) {
		this.tipoDocumental = tipoDocumental;
	}

	/**
	 * Method 'getNombreEs'.
	 * 
	 * @return String
	 */
	public String getNombreEs() {
		return this.nombreEs;
	}

	/**
	 * Method 'setNombreEs'.
	 * 
	 * @param nombreEs
	 *            String
	 * @return
	 */
	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * Method 'getNombreEu'.
	 * 
	 * @return String
	 */
	public String getNombreEu() {
		return this.nombreEu;
	}

	/**
	 * Method 'setNombreEu'.
	 * 
	 * @param nombreEu
	 *            String
	 * @return
	 */
	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * Method 'getNombre'.
	 * 
	 * @return String
	 */
	public String getNombre() {
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			return this.getNombreEu();
		}
		return this.getNombreEs();
	}

	/**
	 * Method 'getSerie'.
	 * 
	 * @return String
	 */
	public String getSerie() {
		return this.serie;
	}

	/**
	 * Method 'setSerie'.
	 * 
	 * @param serie
	 *            String
	 * @return
	 */
	public void setSerie(String serie) {
		this.serie = serie;
	}

	/**
	 * Method 'getBaja'.
	 * 
	 * @return String
	 */
	public String getBaja() {
		return this.baja;
	}

	/**
	 * Method 'setBaja'.
	 * 
	 * @param baja
	 *            String
	 * @return
	 */
	public void setBaja(String baja) {
		this.baja = baja;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ pkTipo: ").append(this.pkTipo).append(" ]");
		result.append(", [ tipoDocumental: ").append(this.tipoDocumental)
				.append(" ]");
		result.append(", [ nombreEs: ").append(this.nombreEs).append(" ]");
		result.append(", [ nombreEu: ").append(this.nombreEu).append(" ]");
		result.append(", [ serie: ").append(this.serie).append(" ]");
		result.append(", [ baja: ").append(this.baja).append(" ]");
		result.append("}");
		return result.toString();
	}
}