package com.ejie.aa83b.model;

import java.util.Calendar;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * Docs.
 * 
 * @author DS
 */
public class Aa83bDocumentoDokusi implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private Integer pkDocumento;
	private Integer codElemento;
	// private Aa83bTipoElementoDoc tipoElementoDoc;
	private Aa83bTipoDocumento tipoDocumento;
	private String descripcionEs;
	private String descripcionEu;
	private String extension;
	private String contentType;
	private Integer tamanyo;
	private String origen;
	private String oid;
	private String baja;
	private Date fchAlta;
	private Date fchBaja;
	private String usuAlta;
	private String usuBaja;
	private String content;

	// Campos no BBDD
	private String rutaPif;
	private Integer posPk;
	private String auditUserDB;

	// Campos Dokusi
	private String auditUserDokusi;

	public String getContent() {
		return this.content;
	}

	public void setContent(String bs) {
		this.content = bs;
	}

	/**
	 * Method 'DocsCuenca'.
	 */
	public Aa83bDocumentoDokusi() {
		super();
	}

	/**
	 * Method 'DocsCuenca'.
	 * 
	 * @param tipoElementoDoc
	 *            TipoElementoDoc
	 */
	// public Aa83bDocumentoDokusi(Aa83bTipoElementoDoc tipoElementoDoc) {
	// super();
	// this.tipoElementoDoc = tipoElementoDoc;
	// }

	/**
	 * Method 'DocsCuenca'.
	 * 
	 * @param pkDocumento
	 *            Integer
	 * @param tipoElementoDoc
	 *            TipoElementoDoc
	 */
	// public Aa83bDocumentoDokusi(Integer pkDocumento,
	// Aa83bTipoElementoDoc tipoElementoDoc) {
	// super();
	// this.pkDocumento = pkDocumento;
	// this.tipoElementoDoc = tipoElementoDoc;
	// }

	/**
	 * Method 'DocsCuenca'.
	 * 
	 * @param pkDocumento
	 *            Integer
	 * @param tipoElementoDoc
	 *            TipoElementoDoc
	 * @param codElemento
	 *            Integer
	 * @param descripcionEs
	 *            String
	 * @param descripcionEu
	 *            String
	 * @param extension
	 *            String
	 * @param contentType
	 *            String
	 * @param tamanyo
	 *            Integer
	 * @param origen
	 *            String
	 * @param oid
	 *            String
	 * @param baja
	 *            String
	 * @param fchAlta
	 *            Date
	 * @param fchBaja
	 *            Date
	 * @param usuAlta
	 *            String
	 * @param usuBaja
	 *            String
	 * @param tipoDocumento
	 *            TipoDocumento
	 */
	public Aa83bDocumentoDokusi(Integer pkDocumento, Integer codElemento,
			String descripcionEs, String descripcionEu, String extension,
			String contentType, Integer tamanyo, String origen, String oid,
			String baja, Date fchAlta, Date fchBaja, String usuAlta,
			String usuBaja, Aa83bTipoDocumento tipoDocumento) {
		super();
		this.pkDocumento = pkDocumento;
		// this.tipoElementoDoc = tipoElementoDoc;
		this.tipoDocumento = tipoDocumento;
		this.codElemento = codElemento;
		this.descripcionEs = descripcionEs;
		this.descripcionEu = descripcionEu;
		this.extension = extension;
		this.contentType = contentType;
		this.tamanyo = tamanyo;
		this.origen = origen;
		this.oid = oid;

		this.baja = baja;
		this.fchAlta = fchAlta;
		this.fchBaja = fchBaja;
		this.usuAlta = usuAlta;
		this.usuBaja = usuBaja;
	}

	/**
	 * Method 'getPkDocumento'.
	 * 
	 * @return Integer
	 */
	public Integer getPkDocumento() {
		return this.pkDocumento;
	}

	/**
	 * Method 'setPkDocumento'.
	 * 
	 * @param pkDocumento
	 *            Integer
	 * @return
	 */
	public void setPkDocumento(Integer pkDocumento) {
		this.pkDocumento = pkDocumento;
	}

	/**
	 * Method 'getTipoElementoDoc'.
	 * 
	 * @return TipoElementoDoc
	 */
	// public Aa83bTipoElementoDoc getTipoElementoDoc() {
	// return this.tipoElementoDoc;
	// }

	/**
	 * Method 'setTipoElementoDoc'.
	 * 
	 * @param tipoElementoDoc
	 *            TipoElementoDoc
	 */
	// public void setTipoElementoDoc(Aa83bTipoElementoDoc tipoElementoDoc) {
	// this.tipoElementoDoc = tipoElementoDoc;
	// }

	/**
	 * Method 'getNombreTabla'.
	 * 
	 * @return String
	 */
	// @JsonIgnore
	// public String getNombreTabla() {
	// if (this.getTipoElementoDoc() != null) {
	// return this.getTipoElementoDoc().getNombreTabla();
	// } else {
	// // Lanzar un error propio
	// throw new Aa83bErrorGenericoException(null,
	// "error.enum.tipoElementoDoc");
	// }
	// }

	/**
	 * Method 'getCodElemento'.
	 * 
	 * @return Integer
	 */
	public Integer getCodElemento() {
		return this.codElemento;
	}

	/**
	 * Method 'setCodElemento'.
	 * 
	 * @param codElemento
	 *            Integer
	 */
	public void setCodElemento(Integer codElemento) {
		this.codElemento = codElemento;
	}

	/**
	 * Method 'getTipoDocumento'.
	 * 
	 * @return TipoDocumento
	 */
	public Aa83bTipoDocumento getTipoDocumento() {
		return this.tipoDocumento;
	}

	/**
	 * Method 'setTipoDocumento'.
	 * 
	 * @param tipoDocumento
	 *            TipoDocumento
	 * @return
	 */
	public void setTipoDocumento(Aa83bTipoDocumento tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * Method 'getDescripcionEs'.
	 * 
	 * @return String
	 */
	public String getDescripcionEs() {
		return this.descripcionEs;
	}

	/**
	 * Method 'setDescripcionEs'.
	 * 
	 * @param descripcionEs
	 *            String
	 * @return
	 */
	public void setDescripcionEs(String descripcionEs) {
		this.descripcionEs = descripcionEs;
	}

	/**
	 * Method 'getDescripcionEu'.
	 * 
	 * @return String
	 */
	public String getDescripcionEu() {
		return this.descripcionEu;
	}

	/**
	 * Method 'setDescripcionEu'.
	 * 
	 * @param descripcionEu
	 *            String
	 * @return
	 */
	public void setDescripcionEu(String descripcionEu) {
		this.descripcionEu = descripcionEu;
	}

	/**
	 * Method 'getDescripcion'.
	 * 
	 * @return String
	 */
	public String getDescripcion() {
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			return this.getDescripcionEu();
		}
		return this.getDescripcionEs();
	}

	/**
	 * Method 'getExtension'.
	 * 
	 * @return String
	 */
	public String getExtension() {
		return this.extension;
	}

	/**
	 * Method 'setExtension'.
	 * 
	 * @param extension
	 *            String
	 * @return
	 */
	public void setExtension(String extension) {
		this.extension = extension;
	}

	/**
	 * Method 'getContentType'.
	 * 
	 * @return String
	 */
	public String getContentType() {
		return this.contentType;
	}

	/**
	 * Method 'setContentType'.
	 * 
	 * @param contentType
	 *            String
	 * @return
	 */
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	/**
	 * Method 'getTamanyo'.
	 * 
	 * @return Integer
	 */
	public Integer getTamanyo() {
		return this.tamanyo;
	}

	/**
	 * Method 'setTamanyo'.
	 * 
	 * @param tamanyo
	 *            Integer
	 */
	public void setTamanyo(Integer tamanyo) {
		this.tamanyo = tamanyo;
	}

	/**
	 * Method 'getOrigen'.
	 * 
	 * @return String
	 */
	public String getOrigen() {
		return this.origen;
	}

	/**
	 * Method 'setOrigen'.
	 * 
	 * @param origen
	 *            String
	 * @return
	 */
	public void setOrigen(String origen) {
		this.origen = origen;
	}

	/**
	 * Method 'getOid'.
	 * 
	 * @return String
	 */
	public String getOid() {
		return this.oid;
	}

	/**
	 * Method 'setOid'.
	 * 
	 * @param oid
	 *            String
	 */
	public void setOid(String oid) {
		this.oid = oid;
	}

	/**
	 * Method 'getFchAlta'.
	 * 
	 * @return java.util.Date
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFchAlta() {
		return this.fchAlta;
	}

	/**
	 * Method 'setFchAlta'.
	 * 
	 * @param fchAlta
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFchAlta(Date fchAlta) {
		this.fchAlta = fchAlta;
	}

	/**
	 * Method 'getFchBaja'.
	 * 
	 * @return java.util.Date
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFchBaja() {
		return this.fchBaja;
	}

	/**
	 * Method 'setFchBaja'.
	 * 
	 * @param fchBaja
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFchBaja(Date fchBaja) {
		this.fchBaja = fchBaja;
	}

	/**
	 * Method 'getUsuAlta'.
	 * 
	 * @return String
	 */
	public String getUsuAlta() {
		return this.usuAlta;
	}

	/**
	 * Method 'setUsuAlta'.
	 * 
	 * @param usuAlta
	 *            String
	 * @return
	 */
	public void setUsuAlta(String usuAlta) {
		this.usuAlta = usuAlta;
	}

	/**
	 * Method 'getUsuBaja'.
	 * 
	 * @return String
	 */
	public String getUsuBaja() {
		return this.usuBaja;
	}

	/**
	 * Method 'setUsuBaja'.
	 * 
	 * @param usuBaja
	 *            String
	 * @return
	 */
	public void setUsuBaja(String usuBaja) {
		this.usuBaja = usuBaja;
	}

	/**
	 * Method 'getBaja'.
	 * 
	 * @return String
	 */
	public String getBaja() {
		return this.baja;
	}

	/**
	 * Method 'setBaja'.
	 * 
	 * @param baja
	 *            String
	 * @return
	 */
	public void setBaja(String baja) {
		this.baja = baja;
	}

	/**
	 * Method 'getRutaPif'.
	 * 
	 * @return String
	 */
	public String getRutaPif() {
		return this.rutaPif;
	}

	/**
	 * Method 'setRutaPif'.
	 * 
	 * @param rutaPif
	 *            String
	 */
	public void setRutaPif(String rutaPif) {
		this.rutaPif = rutaPif;
	}

	/**
	 * Method 'getPosPk'.
	 * 
	 * @return Integer
	 */
	public Integer getPosPk() {
		return this.posPk;
	}

	/**
	 * Method 'setPosPk'.
	 * 
	 * @param posPk
	 *            Integer
	 */
	public void setPosPk(Integer posPk) {
		this.posPk = posPk;
	}

	/**
	 * Method 'getAuditUserDB'.
	 * 
	 * @return String
	 */
	public String getAuditUserDB() {
		return this.auditUserDB;
	}

	/**
	 * Method 'setAuditUserDB'.
	 * 
	 * @param auditUserDB
	 *            String
	 */
	public void setAuditUserDB(String auditUserDB) {
		this.auditUserDB = auditUserDB;
	}

	/**
	 * Method 'getAuditUserDokusi'.
	 * 
	 * @return String
	 */
	public String getAuditUserDokusi() {
		return this.auditUserDokusi;
	}

	/**
	 * Method 'setAuditUserDokusi'.
	 * 
	 * @param auditUserDokusi
	 *            String
	 */
	public void setAuditUserDokusi(String auditUserDokusi) {
		this.auditUserDokusi = auditUserDokusi;
	}

	/**
	 * Method 'setDatosAlta'.
	 * 
	 * Informa los datos comunes necesarios a la hora de dar de alta una entidad
	 */
	@JsonIgnore
	public void setDatosAlta() {
		Date fechaActual = Calendar.getInstance().getTime();
		this.fchAlta = fechaActual;
		this.usuAlta = this.getAuditUserDB();
		this.baja = Aa83BConstants.VALUE_NO;
	}

	/**
	 * Method 'setDatosBaja'.
	 * 
	 * Informa los datos comunes necesarios a la hora de dar de baja una entidad
	 */
	@JsonIgnore
	public void setDatosBaja() {
		Date fechaActual = Calendar.getInstance().getTime();
		this.fchBaja = fechaActual;
		this.usuBaja = this.getAuditUserDB();
		this.baja = Aa83BConstants.VALUE_SI;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Aa83bDocumentoDokusi [pkDocumento=")
				.append(pkDocumento).append(", codElemento=")
				.append(codElemento).append(", tipoDocumento=")
				.append(tipoDocumento).append(", descripcionEs=")
				.append(descripcionEs).append(", descripcionEu=")
				.append(descripcionEu).append(", extension=").append(extension)
				.append(", contentType=").append(contentType)
				.append(", tamanyo=").append(tamanyo).append(", origen=")
				.append(origen).append(", oid=").append(oid).append(", baja=")
				.append(baja).append(", fchAlta=").append(fchAlta)
				.append(", fchBaja=").append(fchBaja)
				.append(", usuAlta=")
				.append(usuAlta)
				.append(", usuBaja=")
				.append(usuBaja)
				// .append(", content=").append(Arrays.toString(content))
				.append(", content=").append(content).append(", rutaPif=")
				.append(rutaPif).append(", posPk=").append(posPk)
				.append(", auditUserDB=").append(auditUserDB)
				.append(", auditUserDokusi=").append(auditUserDokusi)
				.append("]");
		return builder.toString();
	}

}