package com.ejie.aa83b.exception;

/**
 * Excepcion al enviar mensajes JMS
 * 
 * @author DS
 * 
 */
public class Aa83bSendJmsMessageException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6326079174645414480L;

	/**
	 * Constructor
	 */
	public Aa83bSendJmsMessageException() {
		super("Error al enviar un mensaje JMS");

	}

	/**
	 * Constructor
	 * 
	 * @param message
	 *            String
	 * @param cause
	 *            Throwable
	 */
	public Aa83bSendJmsMessageException(String message, Throwable cause) {
		super("Error al enviar un mensaje JMS: " + message, cause);
	}

	/**
	 * Constructor
	 * 
	 * @param message
	 *            String
	 */
	public Aa83bSendJmsMessageException(String message) {
		super("Error al enviar un mensaje JMS: " + message);
	}

	/**
	 * Constructor
	 * 
	 * @param cause
	 *            Throwable
	 */
	public Aa83bSendJmsMessageException(Throwable cause) {
		super("Error al enviar un mensaje JMS", cause);

	}

}
