package com.ejie.aa83b.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilidades;

/**
 * Mensaje
 * 
 * @author DS
 */
public class Aa83bMensaje implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * key
	 */
	private String key = null;

	/**
	 * Indicativo si key ya es un valor traducido o si hace falta traducirlo
	 */
	private boolean traducido = false;

	/**
	 * Lista de parametros
	 */
	private List<Aa83bParametroKey> parametrosKey = null;

	/**
	 * Constructor para formar mensajes sin parametros y que debe recuperar el
	 * literal de BD
	 * 
	 * @param key
	 *            String
	 */
	public Aa83bMensaje(String key) {
		this.key = key;
		this.parametrosKey = null;
	}

	/**
	 * Constructor para formar mensajes con un parametro el cual se indica si se
	 * debe recueprar el parametro de BD
	 * 
	 * @param key
	 *            String
	 * @param param
	 *            String
	 * @param isKey
	 *            boolean
	 */
	public Aa83bMensaje(String key, String param, boolean isKey) {
		this.key = key;
		this.parametrosKey = new ArrayList<Aa83bParametroKey>();
		Aa83bParametroKey parametroKey = new Aa83bParametroKey(param, isKey);
		this.parametrosKey.add(parametroKey);
	}

	/**
	 * Constructor para formar mensajes con un parametro el cual se debe
	 * recuperar de BD
	 * 
	 * @param key
	 *            String
	 * @param param
	 *            String
	 */
	public Aa83bMensaje(String key, String param) {
		this.key = key;
		this.parametrosKey = new ArrayList<Aa83bParametroKey>();
		Aa83bParametroKey parametroKey = new Aa83bParametroKey(param, true);
		this.parametrosKey.add(parametroKey);
	}

	/**
	 * Constructor para formar mensajes con dos parametros los cuales se deben
	 * recuperar de BD
	 * 
	 * @param key
	 *            String
	 * @param param1
	 *            String
	 * @param param2
	 *            String
	 * @param isKey
	 *            boolean
	 */
	public Aa83bMensaje(String key, String param1, String param2, boolean isKey) {
		this.key = key;
		this.parametrosKey = new ArrayList<Aa83bParametroKey>();
		Aa83bParametroKey parametroKey1 = new Aa83bParametroKey(param1, isKey);
		Aa83bParametroKey parametroKey2 = new Aa83bParametroKey(param2, isKey);
		this.parametrosKey.add(parametroKey1);
		this.parametrosKey.add(parametroKey2);
	}

	/**
	 * Method 'getKey'.
	 * 
	 * @return String
	 */
	public String getKey() {
		return this.key;
	}

	/**
	 * Method 'setKey'.
	 * 
	 * @param key
	 *            String
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * Method 'getParametrosKey'.
	 * 
	 * @return List<ParametroKey>
	 */
	public List<Aa83bParametroKey> getParametrosKey() {
		return this.parametrosKey;
	}

	/**
	 * Method 'setParametrosKey'.
	 * 
	 * @param parametrosKey
	 *            List<ParametroKey>
	 */
	public void setParametrosKey(List<Aa83bParametroKey> parametrosKey) {
		this.parametrosKey = parametrosKey;
	}

	/**
	 * Method 'isTraducido'
	 * 
	 * @return boolean
	 * */
	public boolean isTraducido() {
		return this.traducido;
	}

	/**
	 * Method 'setTraducido'
	 * 
	 * @param traducido
	 *            boolean
	 */
	public void setTraducido(boolean traducido) {
		this.traducido = traducido;
	}

	/**
	 * Comprueba si el mensaje tiene parametros
	 * 
	 * @return boolean
	 */
	public boolean isParametrosKeyList() {
		return (this.parametrosKey != null && !this.parametrosKey.isEmpty());
	}

	/**
	 * Retorna los parametros seguidos por comas
	 * 
	 * @return String
	 */
	public String getParametrosKeyStr() {
		StringBuilder stb = new StringBuilder(
				Aa83BConstants.STRING_BUILDER_INIT);
		if (this.getParametrosKey() != null
				&& !this.getParametrosKey().isEmpty()) {
			Iterator<Aa83bParametroKey> itParametrosKey = this
					.getParametrosKey().iterator();
			boolean isPrimeraVez = true;
			while (itParametrosKey.hasNext()) {
				if (!isPrimeraVez) {
					stb.append(",");
				}
				stb.append(itParametrosKey.next().getValorParametro());
				isPrimeraVez = false;
			}
		}
		return stb.toString();
	}

	/**
	 * Retorna los parametros como Array de Object
	 * 
	 * @return Object[]
	 */
	public Object[] getParametrosKeyObject() {
		Object[] objs = null;
		if (!Aa83bUtilidades.isEmptyList(this.getParametrosKey())) {
			objs = new Object[this.getParametrosKey().size()];
			Iterator<Aa83bParametroKey> itParametrosKey = this
					.getParametrosKey().iterator();
			int i = 0;
			while (itParametrosKey.hasNext()) {
				objs[i] = itParametrosKey.next().getValorParametro();
				i++;
			}
		}
		return objs;
	}
}